// dear imgui: Renderer for modern OpenGL with shaders / programmatic pipeline
// - Desktop GL: 2.x 3.x 4.x
// - Embedded GL: ES 2.0 (WebGL 1.0), ES 3.0 (WebGL 2.0)
// This needs to be used along with a Platform Binding (e.g. GLFW, SDL, Win32, custom..)

// Implemented features:
//  [X] Renderer: User texture binding. Use 'GLuint' OpenGL texture identifier as void*/ImTextureID. Read the FAQ about ImTextureID!
//  [x] Renderer: Desktop GL only: Support for large meshes (64k+ vertices) with 16-bit indices.

// You can copy and use unmodified imgui_impl_* files in your project. See main.cpp for an example of using this.
// If you are new to dear imgui, read examples/README.txt and read the documentation at the top of imgui.cpp.
// https://github.com/ocornut/imgui

// About Desktop OpenGL function loaders:
//  Modern desktop OpenGL doesn't have a standard portable header file to load OpenGL function pointers.
//  Helper libraries are often used for this purpose! Here we are supporting a few common ones (gl3w, glew, glad).
//  You may use another loader/header of your choice (glext, glLoadGen, etc.), or chose to manually implement your own.

// About GLSL version:
//  The 'glsl_version' initialization parameter should be NULL (default) or a "#version XXX" string.
//  On computer platform the GLSL version default to "#version 130". On OpenGL ES 3 platform it defaults to "#version 300 es"
//  Only override if your GL version doesn't handle this GLSL version. See GLSL version table at the top of imgui_impl_opengl3.cpp.

#pragma once
#ifndef MANGOHUD_IMGUI_IMPL_OPENGL3_H
#define MANGOHUD_IMGUI_IMPL_OPENGL3_H

#include <glad/glad.h>

namespace MangoHud { namespace GL {

struct gl_context
{
    void *ctx;
    GLuint FontTexture = 0;
    GLuint ShaderHandle = 0, VertHandle = 0, FragHandle = 0;
    int AttribLocationTex = 0, AttribLocationProjMtx = 0;                                // Uniforms location
    int AttribLocationVtxPos = 0, AttribLocationVtxUV = 0, AttribLocationVtxColor = 0; // Vertex attributes location
    unsigned int VboHandle = 0, ElementsHandle = 0;
    bool swap_interval_set = false;
};


void GetOpenGLVersion(int& major, int& minor, bool& isGLES);

// Backend API
IMGUI_IMPL_API bool     ImGui_ImplOpenGL3_Init(gl_context* ctx, const char* glsl_version = nullptr);
IMGUI_IMPL_API void     ImGui_ImplOpenGL3_Shutdown(gl_context* ctx);
IMGUI_IMPL_API void     ImGui_ImplOpenGL3_NewFrame(gl_context* ctx);
IMGUI_IMPL_API void     ImGui_ImplOpenGL3_RenderDrawData(ImDrawData* draw_data);
IMGUI_IMPL_API bool     ImGui_ImplOpenGL3_CreateFontsTexture(gl_context* ctx);

// (Optional) Called by Init/NewFrame/Shutdown
//IMGUI_IMPL_API bool     ImGui_ImplOpenGL3_CreateFontsTexture();
//IMGUI_IMPL_API void     ImGui_ImplOpenGL3_DestroyFontsTexture();
//IMGUI_IMPL_API bool     ImGui_ImplOpenGL3_CreateDeviceObjects();
//IMGUI_IMPL_API void     ImGui_ImplOpenGL3_DestroyDeviceObjects();

}}

#endif //MANGOHUD_IMGUI_IMPL_OPENGL3_H
