<?php
require_once 'imageisthesame.php';

/**
 * Test class for Image_Text.
 * Generated by PHPUnit_Util_Skeleton on 2007-04-15 at 15:14:46.
 */
class imageisthesameTest extends PHPUnit_Framework_TestCase
{
    /**
     * directory with images for comparison
     *
     * @var
     */
    private $_dir;

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @return void
     */
    protected function setUp()
    {
        if (!extension_loaded('gd')) {
            $this->markTestSkipped("Requires the gd extension");
        }
        $this->_dir = dirname(__FILE__) . '/testimages/';
    }

    /**
     *
     */
    public function testSame()
    {
        //same image
        $this->assertTrue(
            imageisthesame(
                $this->_dir . '10x5-red.png',
                $this->_dir . '10x5-red.png'
            )
        );
        //same image
        $this->assertTrue(
            imageisthesame(
                imagecreatefrompng($this->_dir . '10x5-red.png'),
                imagecreatefrompng($this->_dir . '10x5-red.png')
            )
        );
    }


    public function testSize()
    {
        //wrong size
        $this->assertFalse(
            imageisthesame(
                $this->_dir . '10x5-red.png',
                $this->_dir . '5x10-red.png'
            )
        );
        $this->assertFalse(
            imageisthesame(
                imagecreatefrompng($this->_dir . '10x5-red.png'),
                imagecreatefrompng($this->_dir . '5x10-red.png')
            )
        );
    }

    public function testWrongColor()
    {
        //wrong color
        $this->assertFalse(
            imageisthesame(
                $this->_dir . '10x5-red.png',
                $this->_dir . '10x5-white.png'
            )
        );
    }

    public function testIndexed()
    {
        //same, but indexed
        $this->assertTrue(
            imageisthesame(
                $this->_dir . '10x5-white.png',
                $this->_dir . '10x5-white-index.png'
            )
        );

        //wrong color, but indexed
        $this->assertFalse(
            imageisthesame(
                $this->_dir . '10x5-red.png',
                $this->_dir . '10x5-white-index.png'
            )
        );
    }

    public function testGreyscale()
    {
        //same, but greyscale
        $this->assertTrue(
            imageisthesame(
                $this->_dir . '10x5-white.png',
                $this->_dir . '10x5-white-grey.png'
            )
        );
        //wrong color, greyscale
        $this->assertFalse(
            imageisthesame(
                $this->_dir . '10x5-red.png',
                $this->_dir . '10x5-white-grey.png'
            )
        );
    }

    public function testImagetypes()
    {
        $this->markTestSkipped("compression?!");

        //same color, different image type, one color
        $this->assertTrue(
            imageisthesame(
                $this->_dir . '5x10-red-254.jpg',
                $this->_dir . '5x10-red-254.png'
            )
        );
        //same color, different type, gradient
        $this->assertTrue(
            imageisthesame(
                $this->_dir . '5x10-gradient.jpg',
                $this->_dir . '5x10-gradient.png'
            )
        );
    }
}
