--- a/setup.py
+++ b/setup.py
@@ -8,6 +8,9 @@
 # ------------------------------
 from __future__ import annotations
 
+from sysconfig import get_platform
+host_platform = get_platform()
+
 import os
 import re
 import shutil
@@ -45,7 +48,7 @@ WEBP_ROOT = None
 ZLIB_ROOT = None
 FUZZING_BUILD = "LIB_FUZZING_ENGINE" in os.environ
 
-if sys.platform == "win32" and sys.version_info >= (3, 15):
+if host_platform == "win32" and sys.version_info >= (3, 15):
     import atexit
 
     atexit.register(
@@ -162,7 +165,7 @@ def _find_library_dirs_ldconfig() -> lis
     args: list[str]
     env: dict[str, str]
     expr: str
-    if sys.platform.startswith(("linux", "gnu")):
+    if host_platform.startswith(("linux", "gnu")):
         if struct.calcsize("l") == 4:
             machine = os.uname()[4] + "-32"
         else:
@@ -184,7 +187,7 @@ def _find_library_dirs_ldconfig() -> lis
         env["LC_ALL"] = "C"
         env["LANG"] = "C"
 
-    elif sys.platform.startswith("freebsd"):
+    elif host_platform.startswith("freebsd"):
         args = [ldconfig, "-r"]
         expr = r".* => (.*)"
         env = {}
@@ -574,7 +577,7 @@ class pil_build_ext(build_ext):
         if self.disable_platform_guessing:
             pass
 
-        elif sys.platform == "cygwin":
+        elif host_platform == "cygwin":
             # pythonX.Y.dll.a is in the /usr/lib/pythonX.Y/config directory
             self.compiler.shared_lib_extension = ".dll.a"
             _add_directory(
@@ -584,7 +587,7 @@ class pil_build_ext(build_ext):
                 ),
             )
 
-        elif sys.platform == "darwin":
+        elif host_platform == "darwin":
             # attempt to make sure we pick freetype2 over other versions
             _add_directory(include_dirs, "/sw/include/freetype2")
             _add_directory(include_dirs, "/sw/lib/freetype2/include")
@@ -636,7 +639,7 @@ class pil_build_ext(build_ext):
                 for extension in self.extensions:
                     extension.extra_compile_args = ["-Wno-nullability-completeness"]
 
-        elif sys.platform == "ios":
+        elif host_platform == "ios":
             # Add the iOS SDK path.
             sdk_path = self.get_ios_sdk_path()
 
@@ -647,10 +650,10 @@ class pil_build_ext(build_ext):
             for extension in self.extensions:
                 extension.extra_compile_args = ["-Wno-nullability-completeness"]
 
-        elif sys.platform.startswith(("linux", "gnu", "freebsd")):
+        elif host_platform.startswith(("linux", "gnu", "freebsd")):
             for dirname in _find_library_dirs_ldconfig():
                 _add_directory(library_dirs, dirname)
-            if sys.platform.startswith("linux") and os.environ.get("ANDROID_ROOT"):
+            if host_platform.startswith("linux") and os.environ.get("ANDROID_ROOT"):
                 # termux support for android.
                 # system libraries (zlib) are installed in /system/lib
                 # headers are at $PREFIX/include
@@ -663,11 +666,11 @@ class pil_build_ext(build_ext):
                     ),
                 )
 
-        elif sys.platform.startswith("netbsd"):
+        elif host_platform.startswith("netbsd"):
             _add_directory(library_dirs, "/usr/pkg/lib")
             _add_directory(include_dirs, "/usr/pkg/include")
 
-        elif sys.platform.startswith("sunos5"):
+        elif host_platform.startswith("sunos5"):
             _add_directory(library_dirs, "/opt/local/lib")
             _add_directory(include_dirs, "/opt/local/include")
 
@@ -683,7 +686,7 @@ class pil_build_ext(build_ext):
             # alpine, at least
             _add_directory(library_dirs, "/lib")
 
-        if sys.platform == "win32":
+        if host_platform == "win32":
             # on Windows, look for the OpenJPEG libraries in the location that
             # the official installer puts them
             program_files = os.environ.get("ProgramFiles", "")
@@ -718,9 +721,9 @@ class pil_build_ext(build_ext):
             if _find_include_file(self, "zlib.h"):
                 if _find_library_file(self, "z"):
                     feature.set("zlib", "z")
-                elif sys.platform == "win32" and _find_library_file(self, "zlib"):
+                elif host_platform == "win32" and _find_library_file(self, "zlib"):
                     feature.set("zlib", "zlib")  # alternative name
-                elif sys.platform == "win32" and _find_library_file(self, "zdll"):
+                elif host_platform == "win32" and _find_library_file(self, "zdll"):
                     feature.set("zlib", "zdll")  # dll import library
 
         if feature.want("jpeg"):
@@ -728,7 +731,7 @@ class pil_build_ext(build_ext):
             if _find_include_file(self, "jpeglib.h"):
                 if _find_library_file(self, "jpeg"):
                     feature.set("jpeg", "jpeg")
-                elif sys.platform == "win32" and _find_library_file(self, "libjpeg"):
+                elif host_platform == "win32" and _find_library_file(self, "libjpeg"):
                     feature.set("jpeg", "libjpeg")  # alternative name
 
         feature.set("openjpeg_version", None)
@@ -778,7 +781,7 @@ class pil_build_ext(build_ext):
         if feature.want("tiff"):
             _dbg("Looking for tiff")
             if _find_include_file(self, "tiff.h"):
-                if sys.platform in ["win32", "darwin"] and _find_library_file(
+                if host_platform in ["win32", "darwin"] and _find_library_file(
                     self, "libtiff"
                 ):
                     feature.set("tiff", "libtiff")
@@ -896,13 +899,13 @@ class pil_build_ext(build_ext):
         if feature.get("tiff"):
             libs.append(feature.get("tiff"))
             defs.append(("HAVE_LIBTIFF", None))
-            if sys.platform == "win32":
+            if host_platform == "win32":
                 # This define needs to be defined if-and-only-if it was defined
                 # when compiling LibTIFF. LibTIFF doesn't expose it in `tiffconf.h`,
                 # so we have to guess; by default it is defined in all Windows builds.
                 # See #4237, #5243, #5359 for more information.
                 defs.append(("USE_WIN32_FILEIO", None))
-            elif sys.platform == "ios":
+            elif host_platform == "ios":
                 # Ensure transitive dependencies are linked.
                 libs.append("lzma")
         if feature.get("jpeg"):
@@ -911,7 +914,7 @@ class pil_build_ext(build_ext):
         if feature.get("jpeg2000"):
             libs.append(feature.get("jpeg2000"))
             defs.append(("HAVE_OPENJPEG", None))
-            if sys.platform == "win32" and not PLATFORM_MINGW:
+            if host_platform == "win32" and not PLATFORM_MINGW:
                 defs.append(("OPJ_STATIC", None))
         if feature.get("zlib"):
             libs.append(feature.get("zlib"))
@@ -921,11 +924,11 @@ class pil_build_ext(build_ext):
             defs.append(("HAVE_LIBIMAGEQUANT", None))
         if feature.get("xcb"):
             libs.append(feature.get("xcb"))
-            if sys.platform == "ios":
+            if host_platform == "ios":
                 # Ensure transitive dependencies are linked.
                 libs.append("Xau")
             defs.append(("HAVE_XCB", None))
-        if sys.platform == "win32":
+        if host_platform == "win32":
             libs.extend(["kernel32", "user32", "gdi32"])
         if struct.unpack("h", b"\0\1")[0] == 1:
             defs.append(("WORDS_BIGENDIAN", None))
@@ -956,7 +959,7 @@ class pil_build_ext(build_ext):
                     else:  # building FriBiDi shim from src/thirdparty
                         srcs.append("src/thirdparty/fribidi-shim/fribidi.c")
 
-            if sys.platform == "ios":
+            if host_platform == "ios":
                 # Ensure transitive dependencies are linked.
                 libs.extend(["z", "bz2", "brotlicommon", "brotlidec", "png"])
 
@@ -967,7 +970,7 @@ class pil_build_ext(build_ext):
 
         if feature.get("lcms"):
             libs = [feature.get("lcms")]
-            if sys.platform == "win32":
+            if host_platform == "win32":
                 libs.extend(["user32", "gdi32"])
             self._update_extension("PIL._imagingcms", libs)
         else:
@@ -976,7 +979,7 @@ class pil_build_ext(build_ext):
         webp = feature.get("webp")
         if isinstance(webp, str):
             libs = [webp, webp + "mux", webp + "demux"]
-            if sys.platform == "ios":
+            if host_platform == "ios":
                 # Ensure transitive dependencies are linked.
                 libs.append("sharpyuv")
             self._update_extension("PIL._webp", libs)
@@ -985,13 +988,13 @@ class pil_build_ext(build_ext):
 
         if feature.get("avif"):
             libs = [feature.get("avif")]
-            if sys.platform == "win32":
+            if host_platform == "win32":
                 libs.extend(["ntdll", "userenv", "ws2_32", "bcrypt"])
             self._update_extension("PIL._avif", libs)
         else:
             self._remove_extension("PIL._avif")
 
-        tk_libs = ["psapi"] if sys.platform in ("win32", "cygwin") else []
+        tk_libs = ["psapi"] if host_platform in ("win32", "cygwin") else []
         self._update_extension("PIL._imagingtk", tk_libs)
 
         build_ext.build_extensions(self)
@@ -1007,7 +1010,7 @@ class pil_build_ext(build_ext):
         print("-" * 68)
         print(f"version      Pillow {PILLOW_VERSION}")
         version = sys.version.split("[")
-        print(f"platform     {sys.platform} {version[0].strip()}")
+        print(f"platform     {host_platform} {version[0].strip()}")
         for v in version[1:]:
             print(f"             [{v.strip()}")
         print("-" * 68)
