/*************************************************
*    The PMW Music Typesetter - 3rd incarnation  *
*************************************************/

/* Copyright (c) Philip Hazel, 1991 - 2020 */

/* Written by Philip Hazel, starting November 1991 */
/* This file last modified: August 2020 */

/* This is the header file for the output routines. */

/* These capandjoin values were actually used directly on the
Acorn screen, but are now interpreted for PostScript output. */

#define caj_butt           0x00000000
#define caj_round          0x00010100
#define caj_square         0x00020200

#define caj_mitre_join     0x00000000
#define caj_round_join     0x00000001
#define caj_bevel_join     0x00000002

/* Bar line types are the relevant characters in the music font */

#define bar_single '@'
#define bar_double 'A'
#define bar_thick  'B'
#define bar_dotted '['

/* Types for repeat marks are indexes into a table */

#define rep_right   0
#define rep_left   15
#define rep_dright 30
#define rep_dleft  45

/* Path types */

#define path_end   0
#define path_move  2
#define path_curve 6
#define path_line  8



/*************************************************
*               Enumerations                     *
*************************************************/

/* Characters in a virtual musical font. These are used to index the table
out_mftable_ps, which is defined in tables.c and must be kept in step. The
order is arbitrary. */

enum {
  mc_trebleclef,       mc_trebleTclef,    mc_trebleDclef,
  mc_bassclef,         mc_Cbassclef,      mc_Sbassclef,
  mc_cbaritoneclef,    mc_tenorclef,      mc_altoclef,
  mc_mezzoclef,        mc_sopranoclef,    mc_natural,
  mc_sharp,            mc_dsharp,         mc_flat,
  mc_dflat,            mc_rnatural,       mc_rsharp,
  mc_rdsharp,          mc_rflat,          mc_rdflat,
  mc_snatural,         mc_ssharp,         mc_sdsharp,
  mc_sflat,            mc_sdflat,         mc_common,
  mc_cut,              mc_longrest,       mc_trebleTBclef,
  mc_hclef,            mc_baritoneclef,   mc_deepbassclef,
  mc_oldbassclef,      mc_oldCbassclef,   mc_oldSbassclef,
  mc_oldcbaritoneclef, mc_oldtenorclef,   mc_oldaltoclef,
  mc_oldmezzoclef,     mc_oldsopranoclef, mc_oldbaritoneclef,
  mc_olddeepbassclef,  mc_hsharp1,        mc_hrsharp1,
  mc_hssharp1,         mc_hsharp2,        mc_hrsharp2,
  mc_hssharp2,         mc_hflat1,         mc_hrflat1,
  mc_hsflat1,          mc_hflat2,         mc_hrflat2,
  mc_hsflat2
};

/* Switch for join sign routine */

enum { join_barline, join_brace, join_bracket, join_thinbracket };

/* Note sizes */

enum { size_music, size_grace, size_cue, size_cuegrace };

/* Print configuration options */

enum { pc_a4sideways, pc_a4ona3, pc_a5ona4, pc_EPS };



/*************************************************
*               Global variables                 *
*************************************************/

extern contstr *bar_cont;             /* Cont structure when in bar */

extern b_notestr *beam_first;
extern b_notestr *beam_last;

extern uschar *beam_stemadjusts;

extern int    beam_accrit;            /* Accel. or Rit. beam */
extern BOOL   beam_continued;         /* True if beam continued into bar */
extern int    beam_count;             /* Count of notes in beam */
extern int    beam_firstmoff;         /* Moff of first note */
extern int    beam_firstpitch;        /* Pitch of first note */
extern int    beam_firstX;            /* Coordinate of first note */
extern int    beam_firstY;
extern int    beam_forceslope;        /* Forced slope */
extern int    beam_lastmoff;          /* Moff of last note */
extern int    beam_offset;            /* Vertical adjustment of beam */
extern int    beam_offsetadjust;      /* Forced adjustment */
extern int    beam_overbeam;          /* TRUE if going over bar line */
extern int    beam_seq;
extern int    beam_slope;             /* Slope of beam */
extern int    beam_splitOK;           /* OK to have notes on both sides */
extern int    beam_upflag;            /* Above or below first note */
extern int    beam_Xcorrection;       /* Correction for stem position */

extern BOOL   error_111;              /* Flag for coupling error */

/* The information for the current note remains there afterwards, for
use by things which follow (e.g. ties). */

extern int    n_acc;                  /* Current accidental */
extern int    n_accleft;              /* Current note's accleft value */
extern int    n_beamed;               /* Current note's beaming status */
extern int    n_cueadjust;            /* Horiz. adjustment for grace/cue */
extern int    n_chordcount;           /* Notes in current chord */
extern int    n_chordflags;           /* Flags for whole chord */
extern usint  n_chordacflags;         /* Ditto */
extern int    n_dotxadjust;           /* X adjustment for dot */
extern int    n_firstacc;             /* For first note in chord */
extern int    n_flags;                /* Current note */
extern usint  n_acflags;              /* Ditto */
extern int    n_fontsize;             /* Size of font for note */
extern int    n_gracecount;           /* Count of grace note run */
extern int    n_gracemoff;            /* Offset for grace notes */
extern BOOL   n_nhtied;               /* Tie at notehead end */
extern BOOL   n_invertleft;           /* True if left invert in chord */
extern BOOL   n_invertright;          /* Ditto right */
extern int    n_lastacc;              /* For last note in chord */
extern b_notestr *n_lastnote;         /* Last note set */
extern int    n_length;               /* Length of current note */
extern int    n_longrestmid;          /* Long rest mid point */
extern int    n_masq;                 /* Masquerade for current note */
extern int    n_maxaccleft;           /* Max accidental left in chord */
extern int    n_maxpitch;             /* Max pitch of current note/chord */
extern int    n_minpitch;             /* Min ditto */
extern b_tiestr *n_nexttie;           /* Outgoing tie */
extern int    n_notetype;             /* Type of current note */
extern int    n_orig_stemlength;      /* Value for first note of chord */
extern b_ornamentstr *n_ornament;     /* Ornament for current note */
extern int    n_pcorrection;          /* Pitch correction for grace etc. */
extern int    n_pitch;                /* Stave pitch of current note */
extern b_tiestr *n_prevtie;           /* Incoming tie */
extern int    n_restlevel;            /* Rest level adjustment for note */
extern int    n_stemlength;           /* Adjust for stem length for note */
extern int    n_upflag;               /* TRUE if stem direction is up */
extern int    n_upfactor;             /* (+1)/(-1) according to direction */
extern int    n_x;                    /* X coordinate of current note */

extern mfstr  *out_mftable_ps[];      /* Points to music font table */

extern int    out_acctable[];         /* Table of accidental chars */
extern int    *out_depthvector;       /* Vector for stave positions */

extern int    out_bar;                /* Current bar number */
extern int    out_barchar;            /* Barline character */
extern int    out_barlinex;           /* Current barline x position */
extern int    out_barx;               /* Coordinate of bar start */
extern int    out_bbox[];             /* Approximate bounding box */
extern BOOL   out_beaming;            /* Set when beaming */
extern contstr *out_cont;             /* Local cont structure */
extern int    out_dashgaplength;      /* Set dash gap length */
extern int    out_dashlength;         /* Set dash length */
extern int    out_deepybarend;        /* Full length bar depth */
extern int    out_downgap;            /* For coupled notes */
extern FILE  *out_drawfile;           /* For draw file writing */
extern b_drawstr  *out_drawqueue[];   /* Queue of pending draws */
extern int    out_drawqueueptr;
extern int    out_drawstackptr;       /* Draw stack pointer */
extern int    out_dynmovef[];         /* Dynamic bracket flags */
extern int    out_dynmovex[];         /* Dynamic moves */
extern int    out_dynmovey[];
extern BOOL   out_gracefound;         /* Found grace note for this note */
extern int    out_grace_fudge;        /* Fudge for grace/accidental */
extern BOOL   out_gracenotes;         /* Outputting gracenotes */
extern BOOL   out_hairpinhalf;        /* True when starting "half" hairpin */
extern int    out_joinxposition;      /* Coordinate for joining signs */
extern int    out_keycount;           /* Count for successive keys */
extern int    out_lastbarlinex;       /* Coordinate of previous bar line */
extern BOOL   out_lastbarwide;        /* Last barline was wide */
extern int    out_lastmoff;           /* Previous note's moff */
extern BOOL   out_lastnotebeamed;     /* Last note was beamed */
extern int    out_lastnotex;          /* Only valid if last thing was a note */
extern int    out_laststave;          /* Current max stave number */
extern uschar out_laststemup[];       /* Flags for each stave*/
extern BOOL   out_lineendflag;        /* TRUE if setting last bar on line */
extern BOOL   out_makedraw;           /* Making a draw file */
extern int    out_manyrest;           /* Set > 1 for multi-rest bars */
extern int    out_moff;               /* Current musical offset */
extern b_notestr *out_notelist[];     /* List of notes in chord */
extern int    out_notex;              /* Coordinate of previous note */
extern BOOL   out_omitbarline;        /* Used for repeats, etc. */
extern overdrawstr *out_overdraw;     /* For saving drawing till end of stave */
extern BOOL   out_passedreset;        /* Sic */
extern int    out_pden;               /* Plet denominator */
extern b_pletstr *out_plet;           /* Current plet */
extern int    out_plet_highest;       /* Max y during a plet */
extern int    out_plet_highest_head;  /* Highest notehead */
extern int    out_plet_lowest;        /* Min y during a plet */
extern int    out_plet_x;             /* Starting x */
extern int    out_pnum;               /* And numerator */
extern posstr *out_poslast;           /* Points to last entry in postable */
extern posstr *out_posptr;            /* Pointer in postable */
extern posstr *out_postable;          /* Points to postable */
extern int    out_posxRL;             /* RL value for this bar */
extern b_prevbarstr *out_prevbar;     /* For previous barline (omitempty bars) */
extern int    out_prevtieflag;        /* Tie flag for previous note */
extern BOOL   out_repeatonbarline;    /* Left repeat printed on bar line */
extern int    out_slurclx;            /* Slur control point adjustments */
extern int    out_slurcly;
extern int    out_slurcrx;
extern int    out_slurcry;
extern BOOL   out_slurstarted;        /* Force next note to set values */
extern BOOL   out_startlinebar;       /* TRUE at start of line */
extern int    out_stave;              /* Current stave */
extern uschar out_stavechar10[];      /* 100-point stave characters */
extern uschar out_stavechar1[];       /* 10-point stave characters */
extern int    out_stavelines;         /* Number of stave lines + old percussion flag */
extern int    out_stavebottom;        /* Bottom level of stave */
extern int    out_stavetop;           /* Top level of stave */
extern int    out_string_endx;        /* End x for a string */
extern int    out_string_endy;        /* End y for a string */
extern sysblock *out_sysblock;        /* Current system block */
extern int    out_textnextabove;      /* Position for next string above */
extern int    out_textnextbelow;      /* Position for next string below */
extern b_textstr *out_textqueue[];    /* Queue of pending text */
extern int    out_textqueueptr;
extern b_textXstr *out_textX;         /* Current extra block */
extern b_textXstr *out_textXqueue[];  /* Queue of extra blocks */
extern int    out_timecount;          /* Count for successive times */
extern b_tremolostr *out_tremolo;     /* Current tremolo */
extern BOOL   out_tremupflag;         /* Left-hand direction flag */
extern int    out_tremx;              /* Left-hand x for same */
extern int    out_tremy;              /* y value of left-hand note */
extern int    out_upgap;              /* For coupled notes */
extern int    out_Xadjustment;        /* Result of [move] */
extern int    out_Yadjustment;        /* Ditto */
extern int    out_ybarend;            /* Bottom of barline */
extern int    out_yposition;          /* Current system position */
extern int    out_ystave;             /* Ditto for stave */
extern int    out_zcopycount;         /* Count of stave zeros on this system */

extern int    output_copies;          /* Printing copies */
extern BOOL   output_duplex;
extern BOOL   output_incPMWfont;      /* Include music font(s) in output */
extern stave_list *output_pagelist;   /* List of pages being output */
extern BOOL   output_manualfeed;      /* Manualfeed flag */
extern BOOL   output_tumble;

extern int    print_xpageoffset;      /* Values for printing */
extern int    print_ypageoffset;

extern BOOL   rendering_drawfile;     /* True when rendering draw file */

extern FILE   *ps_file;               /* PostScript output file */
extern uschar *ps_header;             /* name of header file */


/*************************************************
*               Global procedures                *
*************************************************/

extern void  out_dodraw(tree_node *, drawitem *, BOOL);
extern void  out_dojoinsign(stave_list *, usint *, int, int, int, usint *);
extern void  out_drawhairpin(b_hairpinstr *, int);
extern int   out_drawnbar(BOOL, int);
extern void  out_extension(int, int, int, int);
extern int   out_findAoffset(int);
extern int   out_findGoffset(int, int);
extern int   out_findXoffset(int);
extern posstr *out_findTentry(int);
extern void  out_freenbar(void);
extern void  out_glissando(int, int);
extern void  out_hyphens(int, int, int, int, BOOL);
extern void  out_page(void);
extern void  out_repeatstring(int, int, int, BOOL, BOOL, int);
extern void  out_resetfont(void);
extern int   out_setbar(void);
extern void  out_setchordtie(b_notestr **, int, int, BOOL, int);
extern bstr *out_setnote(b_notestr *);
extern void  out_setnotetie(int, BOOL, int);
extern void  out_setother(bstr *);
extern void  out_setstarthairpin(b_hairpinstr *, int);
extern void  out_setstartnbar(b_nbarstr *, int, int);
extern BOOL  out_setupbeam(b_notestr *, int, BOOL, BOOL);
extern void  out_slur(int, int, int, int, int, int, int, int);
extern void  out_text(b_textstr *, BOOL);
extern void  out_shownote(void);
extern int   out_string(uschar *, int, int, int, int, int);
extern void  out_warnbar(void);

extern void  out_writeclef(int, int, int, int, BOOL);
extern void  out_writekey(int, int, int, int);
extern void  out_writerepeat(int, int, int);
extern void  out_writetime(int, int, int);

extern void  ps_abspath(int *, int *, int *, int);
extern void  ps_barline(int, int, int, int);
extern void  ps_beam(int, int, int, int);
extern void  ps_brace(int, int, int, int);
extern void  ps_bracket(int, int, int, int);
extern void  ps_grestore(void);
extern void  ps_gsave(void);
extern void  ps_headfoot(headstr *);
extern void  ps_line(int, int, int, int, int, int);
extern void  ps_lines(int *, int *, int, int);
extern void  ps_muschar(int, int, int, int);
extern void  ps_musstring(uschar *, int, int, int);
extern void  ps_newmovt(void);
extern void  ps_path(int *, int *, int *, int);
extern void  ps_pstext(uschar *, int, int);
extern void  ps_relmusstring(uschar *, int, int, int);
extern void  ps_rotate(double);
extern void  ps_setdash(int, int, BOOL);
extern void  ps_setgray(int);
extern void  ps_slur(int, int, int, int, int, int);
extern void  ps_startbar(int, int);
extern void  ps_stave(int, int, int, int);
extern void  ps_string(uschar *, int, int, int *, int *, BOOL);
extern void  ps_translate(int, int);
extern void  ps_wtext(uschar *, int, int, int, int, int);

/* End of outhdr.h */
