# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Iterable, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.arm_polling import ARMPolling

from .. import models as _models
from .._serialization import Serializer
from .._vendor import _convert_request, _format_url_section

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_list_by_replication_protection_containers_request(
    fabric_name: str,
    protection_container_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_request(
    fabric_name: str,
    protection_container_name: str,
    replicated_protected_item_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
        "replicatedProtectedItemName": _SERIALIZER.url(
            "replicated_protected_item_name", replicated_protected_item_name, "str"
        ),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_create_request(
    fabric_name: str,
    protection_container_name: str,
    replicated_protected_item_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
        "replicatedProtectedItemName": _SERIALIZER.url(
            "replicated_protected_item_name", replicated_protected_item_name, "str"
        ),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_purge_request(
    fabric_name: str,
    protection_container_name: str,
    replicated_protected_item_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
        "replicatedProtectedItemName": _SERIALIZER.url(
            "replicated_protected_item_name", replicated_protected_item_name, "str"
        ),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, **kwargs)


def build_update_request(
    fabric_name: str,
    protection_container_name: str,
    replicated_protected_item_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
        "replicatedProtectedItemName": _SERIALIZER.url(
            "replicated_protected_item_name", replicated_protected_item_name, "str"
        ),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_add_disks_request(
    fabric_name: str,
    protection_container_name: str,
    replicated_protected_item_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/addDisks",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
        "replicatedProtectedItemName": _SERIALIZER.url(
            "replicated_protected_item_name", replicated_protected_item_name, "str"
        ),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_apply_recovery_point_request(
    fabric_name: str,
    protection_container_name: str,
    replicated_protected_item_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/applyRecoveryPoint",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
        "replicatedProtectedItemName": _SERIALIZER.url(
            "replicated_protected_item_name", replicated_protected_item_name, "str"
        ),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_failover_cancel_request(
    fabric_name: str,
    protection_container_name: str,
    replicated_protected_item_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/failoverCancel",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
        "replicatedProtectedItemName": _SERIALIZER.url(
            "replicated_protected_item_name", replicated_protected_item_name, "str"
        ),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_failover_commit_request(
    fabric_name: str,
    protection_container_name: str,
    replicated_protected_item_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/failoverCommit",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
        "replicatedProtectedItemName": _SERIALIZER.url(
            "replicated_protected_item_name", replicated_protected_item_name, "str"
        ),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_planned_failover_request(
    fabric_name: str,
    protection_container_name: str,
    replicated_protected_item_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/plannedFailover",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
        "replicatedProtectedItemName": _SERIALIZER.url(
            "replicated_protected_item_name", replicated_protected_item_name, "str"
        ),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_request(
    fabric_name: str,
    protection_container_name: str,
    replicated_protected_item_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/remove",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
        "replicatedProtectedItemName": _SERIALIZER.url(
            "replicated_protected_item_name", replicated_protected_item_name, "str"
        ),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_remove_disks_request(
    fabric_name: str,
    protection_container_name: str,
    replicated_protected_item_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/removeDisks",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
        "replicatedProtectedItemName": _SERIALIZER.url(
            "replicated_protected_item_name", replicated_protected_item_name, "str"
        ),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_repair_replication_request(
    fabric_name: str,
    protection_container_name: str,
    replicated_protected_item_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/repairReplication",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
        "replicatedProtectedItemName": _SERIALIZER.url(
            "replicated_protected_item_name", replicated_protected_item_name, "str"
        ),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_reprotect_request(
    fabric_name: str,
    protection_container_name: str,
    replicated_protected_item_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/reProtect",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
        "replicatedProtectedItemName": _SERIALIZER.url(
            "replicated_protected_item_name", replicated_protected_item_name, "str"
        ),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_resolve_health_errors_request(
    fabric_name: str,
    protection_container_name: str,
    replicated_protected_item_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/resolveHealthErrors",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
        "replicatedProtectedItemName": _SERIALIZER.url(
            "replicated_protected_item_name", replicated_protected_item_name, "str"
        ),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_switch_provider_request(
    fabric_name: str,
    protection_container_name: str,
    replicated_protected_item_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/switchProvider",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
        "replicatedProtectedItemName": _SERIALIZER.url(
            "replicated_protected_item_name", replicated_protected_item_name, "str"
        ),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_test_failover_request(
    fabric_name: str,
    protection_container_name: str,
    replicated_protected_item_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/testFailover",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
        "replicatedProtectedItemName": _SERIALIZER.url(
            "replicated_protected_item_name", replicated_protected_item_name, "str"
        ),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_test_failover_cleanup_request(
    fabric_name: str,
    protection_container_name: str,
    replicated_protected_item_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/testFailoverCleanup",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
        "replicatedProtectedItemName": _SERIALIZER.url(
            "replicated_protected_item_name", replicated_protected_item_name, "str"
        ),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_unplanned_failover_request(
    fabric_name: str,
    protection_container_name: str,
    replicated_protected_item_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/unplannedFailover",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
        "replicatedProtectedItemName": _SERIALIZER.url(
            "replicated_protected_item_name", replicated_protected_item_name, "str"
        ),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_update_appliance_request(
    fabric_name: str,
    protection_container_name: str,
    replicated_protected_item_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/updateAppliance",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
        "replicatedProtectedItemName": _SERIALIZER.url(
            "replicated_protected_item_name", replicated_protected_item_name, "str"
        ),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_update_mobility_service_request(
    fabric_name: str,
    protection_container_name: str,
    replicated_protected_item_name: str,
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/updateMobilityService",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "fabricName": _SERIALIZER.url("fabric_name", fabric_name, "str"),
        "protectionContainerName": _SERIALIZER.url("protection_container_name", protection_container_name, "str"),
        "replicatedProtectedItemName": _SERIALIZER.url(
            "replicated_protected_item_name", replicated_protected_item_name, "str"
        ),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_request(
    resource_name: str,
    resource_group_name: str,
    subscription_id: str,
    *,
    skip_token: Optional[str] = None,
    filter: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationProtectedItems",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if skip_token is not None:
        _params["skipToken"] = _SERIALIZER.query("skip_token", skip_token, "str")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class ReplicationProtectedItemsOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.recoveryservicessiterecovery.SiteRecoveryManagementClient`'s
        :attr:`replication_protected_items` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_by_replication_protection_containers(
        self, fabric_name: str, protection_container_name: str, **kwargs: Any
    ) -> Iterable["_models.ReplicationProtectedItem"]:
        """Gets the list of Replication protected items.

        Gets the list of ASR replication protected items in the protection container.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        cls: ClsType[_models.ReplicationProtectedItemCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_replication_protection_containers_request(
                    fabric_name=fabric_name,
                    protection_container_name=protection_container_name,
                    resource_name=self._config.resource_name,
                    resource_group_name=self._config.resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_by_replication_protection_containers.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItemCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    list_by_replication_protection_containers.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems"
    }

    @distributed_trace
    def get(
        self, fabric_name: str, protection_container_name: str, replicated_protected_item_name: str, **kwargs: Any
    ) -> _models.ReplicationProtectedItem:
        """Gets the details of a Replication protected item.

        Gets the details of an ASR replication protected item.

        :param fabric_name: Fabric unique name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ReplicationProtectedItem or the result of cls(response)
        :rtype: ~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)

        request = build_get_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_name=self._config.resource_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}"
    }

    def _create_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        input: Union[_models.EnableProtectionInput, IO],
        **kwargs: Any
    ) -> Optional[_models.ReplicationProtectedItem]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.ReplicationProtectedItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(input, (IO, bytes)):
            _content = input
        else:
            _json = self._serialize.body(input, "EnableProtectionInput")

        request = build_create_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_name=self._config.resource_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._create_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _create_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}"
    }

    @overload
    def begin_create(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        input: _models.EnableProtectionInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Enables protection.

        The operation to create an ASR replication protected item (Enable replication).

        :param fabric_name: Name of the fabric. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: A name for the replication protected item. Required.
        :type replicated_protected_item_name: str
        :param input: Enable Protection Input. Required.
        :type input: ~azure.mgmt.recoveryservicessiterecovery.models.EnableProtectionInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_create(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        input: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Enables protection.

        The operation to create an ASR replication protected item (Enable replication).

        :param fabric_name: Name of the fabric. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: A name for the replication protected item. Required.
        :type replicated_protected_item_name: str
        :param input: Enable Protection Input. Required.
        :type input: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_create(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        input: Union[_models.EnableProtectionInput, IO],
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Enables protection.

        The operation to create an ASR replication protected item (Enable replication).

        :param fabric_name: Name of the fabric. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: A name for the replication protected item. Required.
        :type replicated_protected_item_name: str
        :param input: Enable Protection Input. Is either a model type or a IO type. Required.
        :type input: ~azure.mgmt.recoveryservicessiterecovery.models.EnableProtectionInput or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._create_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                input=input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_create.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}"
    }

    def _purge_initial(  # pylint: disable=inconsistent-return-statements
        self, fabric_name: str, protection_container_name: str, replicated_protected_item_name: str, **kwargs: Any
    ) -> None:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_purge_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_name=self._config.resource_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self._purge_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _purge_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}"
    }

    @distributed_trace
    def begin_purge(
        self, fabric_name: str, protection_container_name: str, replicated_protected_item_name: str, **kwargs: Any
    ) -> LROPoller[None]:
        """Purges protection.

        The operation to delete or purge a replication protected item. This operation will force delete
        the replication protected item. Use the remove operation on replication protected item to
        perform a clean disable replication for the item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._purge_initial(  # type: ignore
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_purge.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}"
    }

    def _update_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        update_protection_input: Union[_models.UpdateReplicationProtectedItemInput, IO],
        **kwargs: Any
    ) -> Optional[_models.ReplicationProtectedItem]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.ReplicationProtectedItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(update_protection_input, (IO, bytes)):
            _content = update_protection_input
        else:
            _json = self._serialize.body(update_protection_input, "UpdateReplicationProtectedItemInput")

        request = build_update_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_name=self._config.resource_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._update_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _update_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}"
    }

    @overload
    def begin_update(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        update_protection_input: _models.UpdateReplicationProtectedItemInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Updates the replication protected item settings.

        The operation to update the recovery settings of an ASR replication protected item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param update_protection_input: Update protection input. Required.
        :type update_protection_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.UpdateReplicationProtectedItemInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_update(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        update_protection_input: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Updates the replication protected item settings.

        The operation to update the recovery settings of an ASR replication protected item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param update_protection_input: Update protection input. Required.
        :type update_protection_input: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_update(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        update_protection_input: Union[_models.UpdateReplicationProtectedItemInput, IO],
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Updates the replication protected item settings.

        The operation to update the recovery settings of an ASR replication protected item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param update_protection_input: Update protection input. Is either a model type or a IO type.
         Required.
        :type update_protection_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.UpdateReplicationProtectedItemInput or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._update_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                update_protection_input=update_protection_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_update.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}"
    }

    def _add_disks_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        add_disks_input: Union[_models.AddDisksInput, IO],
        **kwargs: Any
    ) -> Optional[_models.ReplicationProtectedItem]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.ReplicationProtectedItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(add_disks_input, (IO, bytes)):
            _content = add_disks_input
        else:
            _json = self._serialize.body(add_disks_input, "AddDisksInput")

        request = build_add_disks_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_name=self._config.resource_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._add_disks_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _add_disks_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/addDisks"
    }

    @overload
    def begin_add_disks(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        add_disks_input: _models.AddDisksInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Add disk(s) for protection.

        Operation to add disks(s) to the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param add_disks_input: Add disks input. Required.
        :type add_disks_input: ~azure.mgmt.recoveryservicessiterecovery.models.AddDisksInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_add_disks(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        add_disks_input: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Add disk(s) for protection.

        Operation to add disks(s) to the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param add_disks_input: Add disks input. Required.
        :type add_disks_input: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_add_disks(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        add_disks_input: Union[_models.AddDisksInput, IO],
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Add disk(s) for protection.

        Operation to add disks(s) to the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param add_disks_input: Add disks input. Is either a model type or a IO type. Required.
        :type add_disks_input: ~azure.mgmt.recoveryservicessiterecovery.models.AddDisksInput or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._add_disks_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                add_disks_input=add_disks_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_add_disks.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/addDisks"
    }

    def _apply_recovery_point_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        apply_recovery_point_input: Union[_models.ApplyRecoveryPointInput, IO],
        **kwargs: Any
    ) -> Optional[_models.ReplicationProtectedItem]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.ReplicationProtectedItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(apply_recovery_point_input, (IO, bytes)):
            _content = apply_recovery_point_input
        else:
            _json = self._serialize.body(apply_recovery_point_input, "ApplyRecoveryPointInput")

        request = build_apply_recovery_point_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_name=self._config.resource_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._apply_recovery_point_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _apply_recovery_point_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/applyRecoveryPoint"
    }

    @overload
    def begin_apply_recovery_point(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        apply_recovery_point_input: _models.ApplyRecoveryPointInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Change or apply recovery point.

        The operation to change the recovery point of a failed over replication protected item.

        :param fabric_name: The ARM fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: The protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: The replicated protected item name. Required.
        :type replicated_protected_item_name: str
        :param apply_recovery_point_input: The ApplyRecoveryPointInput. Required.
        :type apply_recovery_point_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.ApplyRecoveryPointInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_apply_recovery_point(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        apply_recovery_point_input: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Change or apply recovery point.

        The operation to change the recovery point of a failed over replication protected item.

        :param fabric_name: The ARM fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: The protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: The replicated protected item name. Required.
        :type replicated_protected_item_name: str
        :param apply_recovery_point_input: The ApplyRecoveryPointInput. Required.
        :type apply_recovery_point_input: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_apply_recovery_point(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        apply_recovery_point_input: Union[_models.ApplyRecoveryPointInput, IO],
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Change or apply recovery point.

        The operation to change the recovery point of a failed over replication protected item.

        :param fabric_name: The ARM fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: The protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: The replicated protected item name. Required.
        :type replicated_protected_item_name: str
        :param apply_recovery_point_input: The ApplyRecoveryPointInput. Is either a model type or a IO
         type. Required.
        :type apply_recovery_point_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.ApplyRecoveryPointInput or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._apply_recovery_point_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                apply_recovery_point_input=apply_recovery_point_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_apply_recovery_point.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/applyRecoveryPoint"
    }

    def _failover_cancel_initial(
        self, fabric_name: str, protection_container_name: str, replicated_protected_item_name: str, **kwargs: Any
    ) -> Optional[_models.ReplicationProtectedItem]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        cls: ClsType[Optional[_models.ReplicationProtectedItem]] = kwargs.pop("cls", None)

        request = build_failover_cancel_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_name=self._config.resource_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self._failover_cancel_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _failover_cancel_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/failoverCancel"
    }

    @distributed_trace
    def begin_failover_cancel(
        self, fabric_name: str, protection_container_name: str, replicated_protected_item_name: str, **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Execute cancel failover.

        Operation to cancel the failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._failover_cancel_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_failover_cancel.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/failoverCancel"
    }

    def _failover_commit_initial(
        self, fabric_name: str, protection_container_name: str, replicated_protected_item_name: str, **kwargs: Any
    ) -> Optional[_models.ReplicationProtectedItem]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        cls: ClsType[Optional[_models.ReplicationProtectedItem]] = kwargs.pop("cls", None)

        request = build_failover_commit_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_name=self._config.resource_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self._failover_commit_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _failover_commit_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/failoverCommit"
    }

    @distributed_trace
    def begin_failover_commit(
        self, fabric_name: str, protection_container_name: str, replicated_protected_item_name: str, **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Execute commit failover.

        Operation to commit the failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._failover_commit_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_failover_commit.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/failoverCommit"
    }

    def _planned_failover_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        failover_input: Union[_models.PlannedFailoverInput, IO],
        **kwargs: Any
    ) -> Optional[_models.ReplicationProtectedItem]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.ReplicationProtectedItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(failover_input, (IO, bytes)):
            _content = failover_input
        else:
            _json = self._serialize.body(failover_input, "PlannedFailoverInput")

        request = build_planned_failover_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_name=self._config.resource_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._planned_failover_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _planned_failover_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/plannedFailover"
    }

    @overload
    def begin_planned_failover(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        failover_input: _models.PlannedFailoverInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Execute planned failover.

        Operation to initiate a planned failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param failover_input: Planned failover input. Required.
        :type failover_input: ~azure.mgmt.recoveryservicessiterecovery.models.PlannedFailoverInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_planned_failover(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        failover_input: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Execute planned failover.

        Operation to initiate a planned failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param failover_input: Planned failover input. Required.
        :type failover_input: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_planned_failover(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        failover_input: Union[_models.PlannedFailoverInput, IO],
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Execute planned failover.

        Operation to initiate a planned failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param failover_input: Planned failover input. Is either a model type or a IO type. Required.
        :type failover_input: ~azure.mgmt.recoveryservicessiterecovery.models.PlannedFailoverInput or
         IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._planned_failover_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                failover_input=failover_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_planned_failover.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/plannedFailover"
    }

    def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        disable_protection_input: Union[_models.DisableProtectionInput, IO],
        **kwargs: Any
    ) -> None:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(disable_protection_input, (IO, bytes)):
            _content = disable_protection_input
        else:
            _json = self._serialize.body(disable_protection_input, "DisableProtectionInput")

        request = build_delete_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_name=self._config.resource_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._delete_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _delete_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/remove"
    }

    @overload
    def begin_delete(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        disable_protection_input: _models.DisableProtectionInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[None]:
        """Disables protection.

        The operation to disable replication on a replication protected item. This will also remove the
        item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param disable_protection_input: Disable protection input. Required.
        :type disable_protection_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.DisableProtectionInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_delete(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        disable_protection_input: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[None]:
        """Disables protection.

        The operation to disable replication on a replication protected item. This will also remove the
        item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param disable_protection_input: Disable protection input. Required.
        :type disable_protection_input: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_delete(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        disable_protection_input: Union[_models.DisableProtectionInput, IO],
        **kwargs: Any
    ) -> LROPoller[None]:
        """Disables protection.

        The operation to disable replication on a replication protected item. This will also remove the
        item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param disable_protection_input: Disable protection input. Is either a model type or a IO type.
         Required.
        :type disable_protection_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.DisableProtectionInput or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._delete_initial(  # type: ignore
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                disable_protection_input=disable_protection_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_delete.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/remove"
    }

    def _remove_disks_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        remove_disks_input: Union[_models.RemoveDisksInput, IO],
        **kwargs: Any
    ) -> Optional[_models.ReplicationProtectedItem]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.ReplicationProtectedItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(remove_disks_input, (IO, bytes)):
            _content = remove_disks_input
        else:
            _json = self._serialize.body(remove_disks_input, "RemoveDisksInput")

        request = build_remove_disks_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_name=self._config.resource_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._remove_disks_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _remove_disks_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/removeDisks"
    }

    @overload
    def begin_remove_disks(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        remove_disks_input: _models.RemoveDisksInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Removes disk(s).

        Operation to remove disk(s) from the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param remove_disks_input: Remove disks input. Required.
        :type remove_disks_input: ~azure.mgmt.recoveryservicessiterecovery.models.RemoveDisksInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_remove_disks(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        remove_disks_input: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Removes disk(s).

        Operation to remove disk(s) from the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param remove_disks_input: Remove disks input. Required.
        :type remove_disks_input: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_remove_disks(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        remove_disks_input: Union[_models.RemoveDisksInput, IO],
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Removes disk(s).

        Operation to remove disk(s) from the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param remove_disks_input: Remove disks input. Is either a model type or a IO type. Required.
        :type remove_disks_input: ~azure.mgmt.recoveryservicessiterecovery.models.RemoveDisksInput or
         IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._remove_disks_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                remove_disks_input=remove_disks_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_remove_disks.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/removeDisks"
    }

    def _repair_replication_initial(
        self, fabric_name: str, protection_container_name: str, replicated_protected_item_name: str, **kwargs: Any
    ) -> Optional[_models.ReplicationProtectedItem]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        cls: ClsType[Optional[_models.ReplicationProtectedItem]] = kwargs.pop("cls", None)

        request = build_repair_replication_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_name=self._config.resource_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self._repair_replication_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _repair_replication_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/repairReplication"
    }

    @distributed_trace
    def begin_repair_replication(
        self, fabric_name: str, protection_container_name: str, replicated_protected_item_name: str, **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Resynchronize or repair replication.

        The operation to start resynchronize/repair replication for a replication protected item
        requiring resynchronization.

        :param fabric_name: The name of the fabric. Required.
        :type fabric_name: str
        :param protection_container_name: The name of the container. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: The name of the replication protected item. Required.
        :type replicated_protected_item_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._repair_replication_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_repair_replication.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/repairReplication"
    }

    def _reprotect_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        reprotect_input: Union[_models.ReverseReplicationInput, IO],
        **kwargs: Any
    ) -> Optional[_models.ReplicationProtectedItem]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.ReplicationProtectedItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(reprotect_input, (IO, bytes)):
            _content = reprotect_input
        else:
            _json = self._serialize.body(reprotect_input, "ReverseReplicationInput")

        request = build_reprotect_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_name=self._config.resource_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._reprotect_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _reprotect_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/reProtect"
    }

    @overload
    def begin_reprotect(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        reprotect_input: _models.ReverseReplicationInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Execute Reverse Replication\Reprotect.

        Operation to reprotect or reverse replicate a failed over replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param reprotect_input: Reverse replication input. Required.
        :type reprotect_input: ~azure.mgmt.recoveryservicessiterecovery.models.ReverseReplicationInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_reprotect(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        reprotect_input: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Execute Reverse Replication\Reprotect.

        Operation to reprotect or reverse replicate a failed over replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param reprotect_input: Reverse replication input. Required.
        :type reprotect_input: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_reprotect(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        reprotect_input: Union[_models.ReverseReplicationInput, IO],
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Execute Reverse Replication\Reprotect.

        Operation to reprotect or reverse replicate a failed over replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param reprotect_input: Reverse replication input. Is either a model type or a IO type.
         Required.
        :type reprotect_input: ~azure.mgmt.recoveryservicessiterecovery.models.ReverseReplicationInput
         or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._reprotect_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                reprotect_input=reprotect_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_reprotect.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/reProtect"
    }

    def _resolve_health_errors_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        resolve_health_input: Union[_models.ResolveHealthInput, IO],
        **kwargs: Any
    ) -> Optional[_models.ReplicationProtectedItem]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.ReplicationProtectedItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(resolve_health_input, (IO, bytes)):
            _content = resolve_health_input
        else:
            _json = self._serialize.body(resolve_health_input, "ResolveHealthInput")

        request = build_resolve_health_errors_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_name=self._config.resource_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._resolve_health_errors_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _resolve_health_errors_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/resolveHealthErrors"
    }

    @overload
    def begin_resolve_health_errors(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        resolve_health_input: _models.ResolveHealthInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Resolve health errors.

        Operation to resolve health issues of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param resolve_health_input: Health issue input object. Required.
        :type resolve_health_input: ~azure.mgmt.recoveryservicessiterecovery.models.ResolveHealthInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_resolve_health_errors(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        resolve_health_input: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Resolve health errors.

        Operation to resolve health issues of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param resolve_health_input: Health issue input object. Required.
        :type resolve_health_input: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_resolve_health_errors(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        resolve_health_input: Union[_models.ResolveHealthInput, IO],
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Resolve health errors.

        Operation to resolve health issues of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param resolve_health_input: Health issue input object. Is either a model type or a IO type.
         Required.
        :type resolve_health_input: ~azure.mgmt.recoveryservicessiterecovery.models.ResolveHealthInput
         or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._resolve_health_errors_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                resolve_health_input=resolve_health_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_resolve_health_errors.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/resolveHealthErrors"
    }

    def _switch_provider_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        switch_provider_input: Union[_models.SwitchProviderInput, IO],
        **kwargs: Any
    ) -> Optional[_models.ReplicationProtectedItem]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.ReplicationProtectedItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(switch_provider_input, (IO, bytes)):
            _content = switch_provider_input
        else:
            _json = self._serialize.body(switch_provider_input, "SwitchProviderInput")

        request = build_switch_provider_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_name=self._config.resource_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._switch_provider_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _switch_provider_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/switchProvider"
    }

    @overload
    def begin_switch_provider(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        switch_provider_input: _models.SwitchProviderInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Execute switch provider.

        Operation to initiate a switch provider of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param switch_provider_input: Switch provider input. Required.
        :type switch_provider_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.SwitchProviderInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_switch_provider(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        switch_provider_input: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Execute switch provider.

        Operation to initiate a switch provider of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param switch_provider_input: Switch provider input. Required.
        :type switch_provider_input: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_switch_provider(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        switch_provider_input: Union[_models.SwitchProviderInput, IO],
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Execute switch provider.

        Operation to initiate a switch provider of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param switch_provider_input: Switch provider input. Is either a model type or a IO type.
         Required.
        :type switch_provider_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.SwitchProviderInput or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._switch_provider_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                switch_provider_input=switch_provider_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, ARMPolling(lro_delay, lro_options={"final-state-via": "azure-async-operation"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_switch_provider.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/switchProvider"
    }

    def _test_failover_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        testfailover_input: Union[_models.TestFailoverInput, IO],
        **kwargs: Any
    ) -> Optional[_models.ReplicationProtectedItem]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.ReplicationProtectedItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(testfailover_input, (IO, bytes)):
            _content = testfailover_input
        else:
            _json = self._serialize.body(testfailover_input, "TestFailoverInput")

        request = build_test_failover_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_name=self._config.resource_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._test_failover_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _test_failover_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/testFailover"
    }

    @overload
    def begin_test_failover(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        testfailover_input: _models.TestFailoverInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Execute test failover.

        Operation to perform a test failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param testfailover_input: Test failover input. Required.
        :type testfailover_input: ~azure.mgmt.recoveryservicessiterecovery.models.TestFailoverInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_test_failover(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        testfailover_input: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Execute test failover.

        Operation to perform a test failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param testfailover_input: Test failover input. Required.
        :type testfailover_input: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_test_failover(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        testfailover_input: Union[_models.TestFailoverInput, IO],
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Execute test failover.

        Operation to perform a test failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param testfailover_input: Test failover input. Is either a model type or a IO type. Required.
        :type testfailover_input: ~azure.mgmt.recoveryservicessiterecovery.models.TestFailoverInput or
         IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._test_failover_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                testfailover_input=testfailover_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_test_failover.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/testFailover"
    }

    def _test_failover_cleanup_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        cleanup_input: Union[_models.TestFailoverCleanupInput, IO],
        **kwargs: Any
    ) -> Optional[_models.ReplicationProtectedItem]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.ReplicationProtectedItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(cleanup_input, (IO, bytes)):
            _content = cleanup_input
        else:
            _json = self._serialize.body(cleanup_input, "TestFailoverCleanupInput")

        request = build_test_failover_cleanup_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_name=self._config.resource_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._test_failover_cleanup_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _test_failover_cleanup_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/testFailoverCleanup"
    }

    @overload
    def begin_test_failover_cleanup(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        cleanup_input: _models.TestFailoverCleanupInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Execute test failover cleanup.

        Operation to clean up the test failover of a replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param cleanup_input: Test failover cleanup input. Required.
        :type cleanup_input: ~azure.mgmt.recoveryservicessiterecovery.models.TestFailoverCleanupInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_test_failover_cleanup(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        cleanup_input: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Execute test failover cleanup.

        Operation to clean up the test failover of a replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param cleanup_input: Test failover cleanup input. Required.
        :type cleanup_input: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_test_failover_cleanup(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        cleanup_input: Union[_models.TestFailoverCleanupInput, IO],
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Execute test failover cleanup.

        Operation to clean up the test failover of a replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param cleanup_input: Test failover cleanup input. Is either a model type or a IO type.
         Required.
        :type cleanup_input: ~azure.mgmt.recoveryservicessiterecovery.models.TestFailoverCleanupInput
         or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._test_failover_cleanup_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                cleanup_input=cleanup_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_test_failover_cleanup.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/testFailoverCleanup"
    }

    def _unplanned_failover_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        failover_input: Union[_models.UnplannedFailoverInput, IO],
        **kwargs: Any
    ) -> Optional[_models.ReplicationProtectedItem]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.ReplicationProtectedItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(failover_input, (IO, bytes)):
            _content = failover_input
        else:
            _json = self._serialize.body(failover_input, "UnplannedFailoverInput")

        request = build_unplanned_failover_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_name=self._config.resource_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._unplanned_failover_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _unplanned_failover_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/unplannedFailover"
    }

    @overload
    def begin_unplanned_failover(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        failover_input: _models.UnplannedFailoverInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Execute unplanned failover.

        Operation to initiate a failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param failover_input: Failover input. Required.
        :type failover_input: ~azure.mgmt.recoveryservicessiterecovery.models.UnplannedFailoverInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_unplanned_failover(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        failover_input: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Execute unplanned failover.

        Operation to initiate a failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param failover_input: Failover input. Required.
        :type failover_input: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_unplanned_failover(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        failover_input: Union[_models.UnplannedFailoverInput, IO],
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Execute unplanned failover.

        Operation to initiate a failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param failover_input: Failover input. Is either a model type or a IO type. Required.
        :type failover_input: ~azure.mgmt.recoveryservicessiterecovery.models.UnplannedFailoverInput or
         IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._unplanned_failover_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                failover_input=failover_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_unplanned_failover.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/unplannedFailover"
    }

    def _update_appliance_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        appliance_update_input: Union[_models.UpdateApplianceForReplicationProtectedItemInput, IO],
        **kwargs: Any
    ) -> Optional[_models.ReplicationProtectedItem]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.ReplicationProtectedItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(appliance_update_input, (IO, bytes)):
            _content = appliance_update_input
        else:
            _json = self._serialize.body(appliance_update_input, "UpdateApplianceForReplicationProtectedItemInput")

        request = build_update_appliance_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_name=self._config.resource_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._update_appliance_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _update_appliance_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/updateAppliance"
    }

    @overload
    def begin_update_appliance(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        appliance_update_input: _models.UpdateApplianceForReplicationProtectedItemInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Updates appliance for replication protected Item.

        The operation to update appliance of an ASR replication protected item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param appliance_update_input: Appliance update protection input. Required.
        :type appliance_update_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.UpdateApplianceForReplicationProtectedItemInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_update_appliance(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        appliance_update_input: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Updates appliance for replication protected Item.

        The operation to update appliance of an ASR replication protected item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param appliance_update_input: Appliance update protection input. Required.
        :type appliance_update_input: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_update_appliance(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        appliance_update_input: Union[_models.UpdateApplianceForReplicationProtectedItemInput, IO],
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Updates appliance for replication protected Item.

        The operation to update appliance of an ASR replication protected item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param appliance_update_input: Appliance update protection input. Is either a model type or a
         IO type. Required.
        :type appliance_update_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.UpdateApplianceForReplicationProtectedItemInput
         or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._update_appliance_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                appliance_update_input=appliance_update_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_update_appliance.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/updateAppliance"
    }

    def _update_mobility_service_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        update_mobility_service_request: Union[_models.UpdateMobilityServiceRequest, IO],
        **kwargs: Any
    ) -> Optional[_models.ReplicationProtectedItem]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.ReplicationProtectedItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(update_mobility_service_request, (IO, bytes)):
            _content = update_mobility_service_request
        else:
            _json = self._serialize.body(update_mobility_service_request, "UpdateMobilityServiceRequest")

        request = build_update_mobility_service_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_name=self._config.resource_name,
            resource_group_name=self._config.resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._update_mobility_service_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)

        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    _update_mobility_service_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/updateMobilityService"
    }

    @overload
    def begin_update_mobility_service(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        update_mobility_service_request: _models.UpdateMobilityServiceRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Update the mobility service on a protected item.

        The operation to update(push update) the installed mobility service software on a replication
        protected item to the latest available version.

        :param fabric_name: The name of the fabric containing the protected item. Required.
        :type fabric_name: str
        :param protection_container_name: The name of the container containing the protected item.
         Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: The name of the protected item on which the agent is to
         be updated. Required.
        :type replicated_protected_item_name: str
        :param update_mobility_service_request: Request to update the mobility service on the protected
         item. Required.
        :type update_mobility_service_request:
         ~azure.mgmt.recoveryservicessiterecovery.models.UpdateMobilityServiceRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_update_mobility_service(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        update_mobility_service_request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Update the mobility service on a protected item.

        The operation to update(push update) the installed mobility service software on a replication
        protected item to the latest available version.

        :param fabric_name: The name of the fabric containing the protected item. Required.
        :type fabric_name: str
        :param protection_container_name: The name of the container containing the protected item.
         Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: The name of the protected item on which the agent is to
         be updated. Required.
        :type replicated_protected_item_name: str
        :param update_mobility_service_request: Request to update the mobility service on the protected
         item. Required.
        :type update_mobility_service_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_update_mobility_service(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        update_mobility_service_request: Union[_models.UpdateMobilityServiceRequest, IO],
        **kwargs: Any
    ) -> LROPoller[_models.ReplicationProtectedItem]:
        """Update the mobility service on a protected item.

        The operation to update(push update) the installed mobility service software on a replication
        protected item to the latest available version.

        :param fabric_name: The name of the fabric containing the protected item. Required.
        :type fabric_name: str
        :param protection_container_name: The name of the container containing the protected item.
         Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: The name of the protected item on which the agent is to
         be updated. Required.
        :type replicated_protected_item_name: str
        :param update_mobility_service_request: Request to update the mobility service on the protected
         item. Is either a model type or a IO type. Required.
        :type update_mobility_service_request:
         ~azure.mgmt.recoveryservicessiterecovery.models.UpdateMobilityServiceRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._update_mobility_service_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                update_mobility_service_request=update_mobility_service_request,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, ARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_update_mobility_service.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/updateMobilityService"
    }

    @distributed_trace
    def list(
        self, skip_token: Optional[str] = None, filter: Optional[str] = None, **kwargs: Any
    ) -> Iterable["_models.ReplicationProtectedItem"]:
        """Gets the list of replication protected items.

        Gets the list of ASR replication protected items in the vault.

        :param skip_token: The pagination token. Possible values: "FabricId" or "FabricId_CloudId" or
         null. Default value is None.
        :type skip_token: str
        :param filter: OData filter options. Default value is None.
        :type filter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        cls: ClsType[_models.ReplicationProtectedItemCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_request(
                    resource_name=self._config.resource_name,
                    resource_group_name=self._config.resource_group_name,
                    subscription_id=self._config.subscription_id,
                    skip_token=skip_token,
                    filter=filter,
                    api_version=api_version,
                    template_url=self.list.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItemCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    list.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationProtectedItems"
    }
