# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.kubernetesconfiguration.extensiontypes import KubernetesConfigurationExtensionTypesMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestKubernetesConfigurationExtensionTypesMgmtExtensionTypesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(KubernetesConfigurationExtensionTypesMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_extension_types_location_list(self, resource_group):
        response = self.client.extension_types.location_list(
            location="str",
            api_version="2024-11-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_extension_types_location_get(self, resource_group):
        response = self.client.extension_types.location_get(
            location="str",
            extension_type_name="str",
            api_version="2024-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_extension_types_list_versions(self, resource_group):
        response = self.client.extension_types.list_versions(
            location="str",
            extension_type_name="str",
            api_version="2024-11-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_extension_types_get_version(self, resource_group):
        response = self.client.extension_types.get_version(
            location="str",
            extension_type_name="str",
            version_number="str",
            api_version="2024-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_extension_types_list(self, resource_group):
        response = self.client.extension_types.list(
            resource_group_name=resource_group.name,
            cluster_rp="str",
            cluster_resource_name="str",
            cluster_name="str",
            api_version="2024-11-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_extension_types_get(self, resource_group):
        response = self.client.extension_types.get(
            resource_group_name=resource_group.name,
            cluster_rp="str",
            cluster_resource_name="str",
            cluster_name="str",
            extension_type_name="str",
            api_version="2024-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_extension_types_cluster_list_versions(self, resource_group):
        response = self.client.extension_types.cluster_list_versions(
            resource_group_name=resource_group.name,
            cluster_rp="str",
            cluster_resource_name="str",
            cluster_name="str",
            extension_type_name="str",
            api_version="2024-11-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_extension_types_cluster_get_version(self, resource_group):
        response = self.client.extension_types.cluster_get_version(
            resource_group_name=resource_group.name,
            cluster_rp="str",
            cluster_resource_name="str",
            cluster_name="str",
            extension_type_name="str",
            version_number="str",
            api_version="2024-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...
