# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class BatchLoggingLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Log verbosity for batch inferencing.
    Increasing verbosity order for logging is : Warning, Info and Debug.
    The default value is Info.
    """

    INFO = "Info"
    WARNING = "Warning"
    DEBUG = "Debug"

class BatchOutputAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine how batch inferencing will handle output
    """

    SUMMARY_ONLY = "SummaryOnly"
    APPEND_ROW = "AppendRow"

class ClassificationModels(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum for all classification models supported by AutoML.
    """

    #: Logistic regression is a fundamental classification technique.
    #: It belongs to the group of linear classifiers and is somewhat similar to polynomial and linear
    #: regression.
    #: Logistic regression is fast and relatively uncomplicated, and it's convenient for you to
    #: interpret the results.
    #: Although it's essentially a method for binary classification, it can also be applied to
    #: multiclass problems.
    LOGISTIC_REGRESSION = "LogisticRegression"
    #: SGD: Stochastic gradient descent is an optimization algorithm often used in machine learning
    #: applications
    #: to find the model parameters that correspond to the best fit between predicted and actual
    #: outputs.
    SGD = "SGD"
    #: The multinomial Naive Bayes classifier is suitable for classification with discrete features
    #: (e.g., word counts for text classification).
    #: The multinomial distribution normally requires integer feature counts. However, in practice,
    #: fractional counts such as tf-idf may also work.
    MULTINOMIAL_NAIVE_BAYES = "MultinomialNaiveBayes"
    #: Naive Bayes classifier for multivariate Bernoulli models.
    BERNOULLI_NAIVE_BAYES = "BernoulliNaiveBayes"
    #: A support vector machine (SVM) is a supervised machine learning model that uses classification
    #: algorithms for two-group classification problems.
    #: After giving an SVM model sets of labeled training data for each category, they're able to
    #: categorize new text.
    SVM = "SVM"
    #: A support vector machine (SVM) is a supervised machine learning model that uses classification
    #: algorithms for two-group classification problems.
    #: After giving an SVM model sets of labeled training data for each category, they're able to
    #: categorize new text.
    #: Linear SVM performs best when input data is linear, i.e., data can be easily classified by
    #: drawing the straight line between classified values on a plotted graph.
    LINEAR_SVM = "LinearSVM"
    #: K-nearest neighbors (KNN) algorithm uses 'feature similarity' to predict the values of new
    #: datapoints
    #: which further means that the new data point will be assigned a value based on how closely it
    #: matches the points in the training set.
    KNN = "KNN"
    #: Decision Trees are a non-parametric supervised learning method used for both classification and
    #: regression tasks.
    #: The goal is to create a model that predicts the value of a target variable by learning simple
    #: decision rules inferred from the data features.
    DECISION_TREE = "DecisionTree"
    #: Random forest is a supervised learning algorithm.
    #: The "forest" it builds, is an ensemble of decision trees, usually trained with the “bagging”
    #: method.
    #: The general idea of the bagging method is that a combination of learning models increases the
    #: overall result.
    RANDOM_FOREST = "RandomForest"
    #: Extreme Trees is an ensemble machine learning algorithm that combines the predictions from many
    #: decision trees. It is related to the widely used random forest algorithm.
    EXTREME_RANDOM_TREES = "ExtremeRandomTrees"
    #: LightGBM is a gradient boosting framework that uses tree based learning algorithms.
    LIGHT_GBM = "LightGBM"
    #: The technique of transiting week learners into a strong learner is called Boosting. The
    #: gradient boosting algorithm process works on this theory of execution.
    GRADIENT_BOOSTING = "GradientBoosting"
    #: XGBoost: Extreme Gradient Boosting Algorithm. This algorithm is used for structured data where
    #: target column values can be divided into distinct class values.
    XG_BOOST_CLASSIFIER = "XGBoostClassifier"

class ClassificationMultilabelPrimaryMetrics(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Primary metrics for classification multilabel tasks.
    """

    #: AUC is the Area under the curve.
    #: This metric represents arithmetic mean of the score for each class,
    #: weighted by the number of true instances in each class.
    AUC_WEIGHTED = "AUCWeighted"
    #: Accuracy is the ratio of predictions that exactly match the true class labels.
    ACCURACY = "Accuracy"
    #: Normalized macro recall is recall macro-averaged and normalized, so that random
    #: performance has a score of 0, and perfect performance has a score of 1.
    NORM_MACRO_RECALL = "NormMacroRecall"
    #: The arithmetic mean of the average precision score for each class, weighted by
    #: the number of true instances in each class.
    AVERAGE_PRECISION_SCORE_WEIGHTED = "AveragePrecisionScoreWeighted"
    #: The arithmetic mean of precision for each class, weighted by number of true instances in each
    #: class.
    PRECISION_SCORE_WEIGHTED = "PrecisionScoreWeighted"
    #: Intersection Over Union. Intersection of predictions divided by union of predictions.
    IOU = "IOU"

class ClassificationPrimaryMetrics(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Primary metrics for classification tasks.
    """

    #: AUC is the Area under the curve.
    #: This metric represents arithmetic mean of the score for each class,
    #: weighted by the number of true instances in each class.
    AUC_WEIGHTED = "AUCWeighted"
    #: Accuracy is the ratio of predictions that exactly match the true class labels.
    ACCURACY = "Accuracy"
    #: Normalized macro recall is recall macro-averaged and normalized, so that random
    #: performance has a score of 0, and perfect performance has a score of 1.
    NORM_MACRO_RECALL = "NormMacroRecall"
    #: The arithmetic mean of the average precision score for each class, weighted by
    #: the number of true instances in each class.
    AVERAGE_PRECISION_SCORE_WEIGHTED = "AveragePrecisionScoreWeighted"
    #: The arithmetic mean of precision for each class, weighted by number of true instances in each
    #: class.
    PRECISION_SCORE_WEIGHTED = "PrecisionScoreWeighted"

class ContainerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    STORAGE_INITIALIZER = "StorageInitializer"
    INFERENCE_SERVER = "InferenceServer"

class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class CredentialsType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the datastore credentials type.
    """

    ACCOUNT_KEY = "AccountKey"
    CERTIFICATE = "Certificate"
    NONE = "None"
    SAS = "Sas"
    SERVICE_PRINCIPAL = "ServicePrincipal"
    KERBEROS_KEYTAB = "KerberosKeytab"
    KERBEROS_PASSWORD = "KerberosPassword"

class DatastoreType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the datastore contents type.
    """

    AZURE_BLOB = "AzureBlob"
    AZURE_DATA_LAKE_GEN1 = "AzureDataLakeGen1"
    AZURE_DATA_LAKE_GEN2 = "AzureDataLakeGen2"
    AZURE_FILE = "AzureFile"
    HDFS = "Hdfs"

class DataType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the type of data.
    """

    URI_FILE = "UriFile"
    URI_FOLDER = "UriFolder"
    ML_TABLE = "MLTable"

class DeploymentProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible values for DeploymentProvisioningState.
    """

    CREATING = "Creating"
    DELETING = "Deleting"
    SCALING = "Scaling"
    UPDATING = "Updating"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"

class DistributionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the job distribution type.
    """

    PY_TORCH = "PyTorch"
    TENSOR_FLOW = "TensorFlow"
    MPI = "Mpi"

class EarlyTerminationPolicyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    BANDIT = "Bandit"
    MEDIAN_STOPPING = "MedianStopping"
    TRUNCATION_SELECTION = "TruncationSelection"

class EgressPublicNetworkAccessType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine whether PublicNetworkAccess is Enabled or Disabled for egress of a
    deployment.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class EndpointAuthMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine endpoint authentication mode.
    """

    AML_TOKEN = "AMLToken"
    KEY = "Key"
    AAD_TOKEN = "AADToken"

class EndpointComputeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine endpoint compute type.
    """

    MANAGED = "Managed"
    KUBERNETES = "Kubernetes"
    AZURE_ML_COMPUTE = "AzureMLCompute"

class EndpointProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of endpoint provisioning.
    """

    CREATING = "Creating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    UPDATING = "Updating"
    CANCELED = "Canceled"

class EnvironmentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Environment type is either user created or curated by Azure ML service
    """

    CURATED = "Curated"
    USER_CREATED = "UserCreated"

class FeatureLags(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Flag for generating lags for the numeric features.
    """

    #: No feature lags generated.
    NONE = "None"
    #: System auto-generates feature lags.
    AUTO = "Auto"

class FeaturizationMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Featurization mode - determines data featurization mode.
    """

    #: Auto mode, system performs featurization without any custom featurization inputs.
    AUTO = "Auto"
    #: Custom featurization.
    CUSTOM = "Custom"
    #: Featurization off. 'Forecasting' task cannot use this value.
    OFF = "Off"

class ForecastHorizonMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine forecast horizon selection mode.
    """

    #: Forecast horizon to be determined automatically.
    AUTO = "Auto"
    #: Use the custom forecast horizon.
    CUSTOM = "Custom"

class ForecastingModels(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum for all forecasting models supported by AutoML.
    """

    #: Auto-Autoregressive Integrated Moving Average (ARIMA) model uses time-series data and
    #: statistical analysis to interpret the data and make future predictions.
    #: This model aims to explain data by using time series data on its past values and uses linear
    #: regression to make predictions.
    AUTO_ARIMA = "AutoArima"
    #: Prophet is a procedure for forecasting time series data based on an additive model where
    #: non-linear trends are fit with yearly, weekly, and daily seasonality, plus holiday effects.
    #: It works best with time series that have strong seasonal effects and several seasons of
    #: historical data. Prophet is robust to missing data and shifts in the trend, and typically
    #: handles outliers well.
    PROPHET = "Prophet"
    #: The Naive forecasting model makes predictions by carrying forward the latest target value for
    #: each time-series in the training data.
    NAIVE = "Naive"
    #: The Seasonal Naive forecasting model makes predictions by carrying forward the latest season of
    #: target values for each time-series in the training data.
    SEASONAL_NAIVE = "SeasonalNaive"
    #: The Average forecasting model makes predictions by carrying forward the average of the target
    #: values for each time-series in the training data.
    AVERAGE = "Average"
    #: The Seasonal Average forecasting model makes predictions by carrying forward the average value
    #: of the latest season of data for each time-series in the training data.
    SEASONAL_AVERAGE = "SeasonalAverage"
    #: Exponential smoothing is a time series forecasting method for univariate data that can be
    #: extended to support data with a systematic trend or seasonal component.
    EXPONENTIAL_SMOOTHING = "ExponentialSmoothing"
    #: An Autoregressive Integrated Moving Average with Explanatory Variable (ARIMAX) model can be
    #: viewed as a multiple regression model with one or more autoregressive (AR) terms and/or one or
    #: more moving average (MA) terms.
    #: This method is suitable for forecasting when data is stationary/non stationary, and
    #: multivariate with any type of data pattern, i.e., level/trend /seasonality/cyclicity.
    ARIMAX = "Arimax"
    #: TCNForecaster: Temporal Convolutional Networks Forecaster. //TODO: Ask forecasting team for
    #: brief intro.
    TCN_FORECASTER = "TCNForecaster"
    #: Elastic net is a popular type of regularized linear regression that combines two popular
    #: penalties, specifically the L1 and L2 penalty functions.
    ELASTIC_NET = "ElasticNet"
    #: The technique of transiting week learners into a strong learner is called Boosting. The
    #: gradient boosting algorithm process works on this theory of execution.
    GRADIENT_BOOSTING = "GradientBoosting"
    #: Decision Trees are a non-parametric supervised learning method used for both classification and
    #: regression tasks.
    #: The goal is to create a model that predicts the value of a target variable by learning simple
    #: decision rules inferred from the data features.
    DECISION_TREE = "DecisionTree"
    #: K-nearest neighbors (KNN) algorithm uses 'feature similarity' to predict the values of new
    #: datapoints
    #: which further means that the new data point will be assigned a value based on how closely it
    #: matches the points in the training set.
    KNN = "KNN"
    #: Lasso model fit with Least Angle Regression a.k.a. Lars. It is a Linear Model trained with an
    #: L1 prior as regularizer.
    LASSO_LARS = "LassoLars"
    #: SGD: Stochastic gradient descent is an optimization algorithm often used in machine learning
    #: applications
    #: to find the model parameters that correspond to the best fit between predicted and actual
    #: outputs.
    #: It's an inexact but powerful technique.
    SGD = "SGD"
    #: Random forest is a supervised learning algorithm.
    #: The "forest"\\   it builds, is an ensemble of decision trees, usually trained with the
    #: “bagging”\\   method.
    #: The general idea of the bagging method is that a combination of learning models increases the
    #: overall result.
    RANDOM_FOREST = "RandomForest"
    #: Extreme Trees is an ensemble machine learning algorithm that combines the predictions from many
    #: decision trees. It is related to the widely used random forest algorithm.
    EXTREME_RANDOM_TREES = "ExtremeRandomTrees"
    #: LightGBM is a gradient boosting framework that uses tree based learning algorithms.
    LIGHT_GBM = "LightGBM"
    #: XGBoostRegressor: Extreme Gradient Boosting Regressor is a supervised machine learning model
    #: using ensemble of base learners.
    XG_BOOST_REGRESSOR = "XGBoostRegressor"

class ForecastingPrimaryMetrics(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Primary metrics for Forecasting task.
    """

    #: The Spearman's rank coefficient of correlation is a non-parametric measure of rank correlation.
    SPEARMAN_CORRELATION = "SpearmanCorrelation"
    #: The Normalized Root Mean Squared Error (NRMSE) the RMSE facilitates the comparison between
    #: models with different scales.
    NORMALIZED_ROOT_MEAN_SQUARED_ERROR = "NormalizedRootMeanSquaredError"
    #: The R2 score is one of the performance evaluation measures for forecasting-based machine
    #: learning models.
    R2_SCORE = "R2Score"
    #: The Normalized Mean Absolute Error (NMAE) is a validation metric to compare the Mean Absolute
    #: Error (MAE) of (time) series with different scales.
    NORMALIZED_MEAN_ABSOLUTE_ERROR = "NormalizedMeanAbsoluteError"

class Goal(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines supported metric goals for hyperparameter tuning
    """

    MINIMIZE = "Minimize"
    MAXIMIZE = "Maximize"

class IdentityConfigurationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine identity framework.
    """

    MANAGED = "Managed"
    AML_TOKEN = "AMLToken"
    USER_IDENTITY = "UserIdentity"

class InputDeliveryMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the input data delivery mode.
    """

    READ_ONLY_MOUNT = "ReadOnlyMount"
    READ_WRITE_MOUNT = "ReadWriteMount"
    DOWNLOAD = "Download"
    DIRECT = "Direct"
    EVAL_MOUNT = "EvalMount"
    EVAL_DOWNLOAD = "EvalDownload"

class InstanceSegmentationPrimaryMetrics(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Primary metrics for InstanceSegmentation tasks.
    """

    #: Mean Average Precision (MAP) is the average of AP (Average Precision).
    #: AP is calculated for each class and averaged to get the MAP.
    MEAN_AVERAGE_PRECISION = "MeanAveragePrecision"

class JobInputType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the Job Input Type.
    """

    LITERAL = "Literal"
    URI_FILE = "UriFile"
    URI_FOLDER = "UriFolder"
    ML_TABLE = "MLTable"
    CUSTOM_MODEL = "CustomModel"
    ML_FLOW_MODEL = "MLFlowModel"
    TRITON_MODEL = "TritonModel"

class JobLimitsType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    COMMAND = "Command"
    SWEEP = "Sweep"

class JobOutputType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the Job Output Type.
    """

    URI_FILE = "UriFile"
    URI_FOLDER = "UriFolder"
    ML_TABLE = "MLTable"
    CUSTOM_MODEL = "CustomModel"
    ML_FLOW_MODEL = "MLFlowModel"
    TRITON_MODEL = "TritonModel"

class JobStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of a job.
    """

    #: Run hasn't started yet.
    NOT_STARTED = "NotStarted"
    #: Run has started. The user has a run ID.
    STARTING = "Starting"
    #: (Not used currently) It will be used if ES is creating the compute target.
    PROVISIONING = "Provisioning"
    #: The run environment is being prepared.
    PREPARING = "Preparing"
    #: The job is queued in the compute target. For example, in BatchAI the job is in queued state,
    #: while waiting for all required nodes to be ready.
    QUEUED = "Queued"
    #: The job started to run in the compute target.
    RUNNING = "Running"
    #: Job is completed in the target. It is in output collection state now.
    FINALIZING = "Finalizing"
    #: Cancellation has been requested for the job.
    CANCEL_REQUESTED = "CancelRequested"
    #: Job completed successfully. This reflects that both the job itself and output collection states
    #: completed successfully.
    COMPLETED = "Completed"
    #: Job failed.
    FAILED = "Failed"
    #: Following cancellation request, the job is now successfully canceled.
    CANCELED = "Canceled"
    #: When heartbeat is enabled, if the run isn't updating any information to RunHistory then the run
    #: goes to NotResponding state.
    #: NotResponding is the only state that is exempt from strict transition orders. A run can go from
    #: NotResponding to any of the previous states.
    NOT_RESPONDING = "NotResponding"
    #: The job is paused by users. Some adjustment to labeling jobs can be made only in paused state.
    PAUSED = "Paused"
    #: Default job status if not mapped to all other statuses.
    UNKNOWN = "Unknown"
    #: The job is in a scheduled state. Job is not in any active state.
    SCHEDULED = "Scheduled"

class JobType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the type of job.
    """

    AUTO_ML = "AutoML"
    COMMAND = "Command"
    SWEEP = "Sweep"
    PIPELINE = "Pipeline"

class KeyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    PRIMARY = "Primary"
    SECONDARY = "Secondary"

class LearningRateScheduler(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Learning rate scheduler enum.
    """

    #: No learning rate scheduler selected.
    NONE = "None"
    #: Cosine Annealing With Warmup.
    WARMUP_COSINE = "WarmupCosine"
    #: Step learning rate scheduler.
    STEP = "Step"

class ListViewType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    ACTIVE_ONLY = "ActiveOnly"
    ARCHIVED_ONLY = "ArchivedOnly"
    ALL = "All"

class LogVerbosity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum for setting log verbosity.
    """

    #: No logs emitted.
    NOT_SET = "NotSet"
    #: Debug and above log statements logged.
    DEBUG = "Debug"
    #: Info and above log statements logged.
    INFO = "Info"
    #: Warning and above log statements logged.
    WARNING = "Warning"
    #: Error and above log statements logged.
    ERROR = "Error"
    #: Only critical statements logged.
    CRITICAL = "Critical"

class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"

class ModelSize(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Image model size.
    """

    #: No value selected.
    NONE = "None"
    #: Small size.
    SMALL = "Small"
    #: Medium size.
    MEDIUM = "Medium"
    #: Large size.
    LARGE = "Large"
    #: Extra large size.
    EXTRA_LARGE = "ExtraLarge"

class ModelType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The async operation state.
    """

    CUSTOM_MODEL = "CustomModel"
    ML_FLOW_MODEL = "MLFlowModel"
    TRITON_MODEL = "TritonModel"

class NCrossValidationsMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Determines how N-Cross validations value is determined.
    """

    #: Determine N-Cross validations value automatically. Supported only for 'Forecasting' AutoML
    #: task.
    AUTO = "Auto"
    #: Use custom N-Cross validations value.
    CUSTOM = "Custom"

class ObjectDetectionPrimaryMetrics(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Primary metrics for Image ObjectDetection task.
    """

    #: Mean Average Precision (MAP) is the average of AP (Average Precision).
    #: AP is calculated for each class and averaged to get the MAP.
    MEAN_AVERAGE_PRECISION = "MeanAveragePrecision"

class OperatingSystemType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of operating system.
    """

    LINUX = "Linux"
    WINDOWS = "Windows"

class OrderString(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    CREATED_AT_DESC = "CreatedAtDesc"
    CREATED_AT_ASC = "CreatedAtAsc"
    UPDATED_AT_DESC = "UpdatedAtDesc"
    UPDATED_AT_ASC = "UpdatedAtAsc"

class OutputDeliveryMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Output data delivery mode enums.
    """

    READ_WRITE_MOUNT = "ReadWriteMount"
    UPLOAD = "Upload"

class PublicNetworkAccessType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine whether PublicNetworkAccess is Enabled or Disabled.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class RandomSamplingAlgorithmRule(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The specific type of random algorithm
    """

    RANDOM = "Random"
    SOBOL = "Sobol"

class RecurrenceFrequency(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to describe the frequency of a recurrence schedule
    """

    #: Minute frequency.
    MINUTE = "Minute"
    #: Hour frequency.
    HOUR = "Hour"
    #: Day frequency.
    DAY = "Day"
    #: Week frequency.
    WEEK = "Week"
    #: Month frequency.
    MONTH = "Month"

class ReferenceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine which reference method to use for an asset.
    """

    ID = "Id"
    DATA_PATH = "DataPath"
    OUTPUT_PATH = "OutputPath"

class RegressionModels(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum for all Regression models supported by AutoML.
    """

    #: Elastic net is a popular type of regularized linear regression that combines two popular
    #: penalties, specifically the L1 and L2 penalty functions.
    ELASTIC_NET = "ElasticNet"
    #: The technique of transiting week learners into a strong learner is called Boosting. The
    #: gradient boosting algorithm process works on this theory of execution.
    GRADIENT_BOOSTING = "GradientBoosting"
    #: Decision Trees are a non-parametric supervised learning method used for both classification and
    #: regression tasks.
    #: The goal is to create a model that predicts the value of a target variable by learning simple
    #: decision rules inferred from the data features.
    DECISION_TREE = "DecisionTree"
    #: K-nearest neighbors (KNN) algorithm uses 'feature similarity' to predict the values of new
    #: datapoints
    #: which further means that the new data point will be assigned a value based on how closely it
    #: matches the points in the training set.
    KNN = "KNN"
    #: Lasso model fit with Least Angle Regression a.k.a. Lars. It is a Linear Model trained with an
    #: L1 prior as regularizer.
    LASSO_LARS = "LassoLars"
    #: SGD: Stochastic gradient descent is an optimization algorithm often used in machine learning
    #: applications
    #: to find the model parameters that correspond to the best fit between predicted and actual
    #: outputs.
    #: It's an inexact but powerful technique.
    SGD = "SGD"
    #: Random forest is a supervised learning algorithm.
    #: The "forest"\\   it builds, is an ensemble of decision trees, usually trained with the
    #: “bagging”\\   method.
    #: The general idea of the bagging method is that a combination of learning models increases the
    #: overall result.
    RANDOM_FOREST = "RandomForest"
    #: Extreme Trees is an ensemble machine learning algorithm that combines the predictions from many
    #: decision trees. It is related to the widely used random forest algorithm.
    EXTREME_RANDOM_TREES = "ExtremeRandomTrees"
    #: LightGBM is a gradient boosting framework that uses tree based learning algorithms.
    LIGHT_GBM = "LightGBM"
    #: XGBoostRegressor: Extreme Gradient Boosting Regressor is a supervised machine learning model
    #: using ensemble of base learners.
    XG_BOOST_REGRESSOR = "XGBoostRegressor"

class RegressionPrimaryMetrics(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Primary metrics for Regression task.
    """

    #: The Spearman's rank coefficient of correlation is a nonparametric measure of rank correlation.
    SPEARMAN_CORRELATION = "SpearmanCorrelation"
    #: The Normalized Root Mean Squared Error (NRMSE) the RMSE facilitates the comparison between
    #: models with different scales.
    NORMALIZED_ROOT_MEAN_SQUARED_ERROR = "NormalizedRootMeanSquaredError"
    #: The R2 score is one of the performance evaluation measures for forecasting-based machine
    #: learning models.
    R2_SCORE = "R2Score"
    #: The Normalized Mean Absolute Error (NMAE) is a validation metric to compare the Mean Absolute
    #: Error (MAE) of (time) series with different scales.
    NORMALIZED_MEAN_ABSOLUTE_ERROR = "NormalizedMeanAbsoluteError"

class SamplingAlgorithmType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    GRID = "Grid"
    RANDOM = "Random"
    BAYESIAN = "Bayesian"

class ScaleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    DEFAULT = "Default"
    TARGET_UTILIZATION = "TargetUtilization"

class ScheduleStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to describe status of schedule
    """

    #: Schedule is enabled.
    ENABLED = "Enabled"
    #: Schedule is disabled.
    DISABLED = "Disabled"

class ScheduleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to describe type of schedule
    """

    #: Cron schedule type.
    CRON = "Cron"
    #: Recurrence schedule type.
    RECURRENCE = "Recurrence"

class SeasonalityMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Forecasting seasonality mode.
    """

    #: Seasonality to be determined automatically.
    AUTO = "Auto"
    #: Use the custom seasonality value.
    CUSTOM = "Custom"

class SecretsType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the datastore secrets type.
    """

    ACCOUNT_KEY = "AccountKey"
    CERTIFICATE = "Certificate"
    SAS = "Sas"
    SERVICE_PRINCIPAL = "ServicePrincipal"
    KERBEROS_PASSWORD = "KerberosPassword"
    KERBEROS_KEYTAB = "KerberosKeytab"

class ServiceDataAccessAuthIdentity(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: Do not use any identity for service data access.
    NONE = "None"
    #: Use the system assigned managed identity of the Workspace to authenticate service data access.
    WORKSPACE_SYSTEM_ASSIGNED_IDENTITY = "WorkspaceSystemAssignedIdentity"
    #: Use the user assigned managed identity of the Workspace to authenticate service data access.
    WORKSPACE_USER_ASSIGNED_IDENTITY = "WorkspaceUserAssignedIdentity"

class ShortSeriesHandlingConfiguration(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The parameter defining how if AutoML should handle short time series.
    """

    #: Represents no/null value.
    NONE = "None"
    #: Short series will be padded if there are no long series, otherwise short series will be
    #: dropped.
    AUTO = "Auto"
    #: All the short series will be padded.
    PAD = "Pad"
    #: All the short series will be dropped.
    DROP = "Drop"

class SkuScaleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Node scaling setting for the compute sku.
    """

    #: Automatically scales node count.
    AUTOMATIC = "Automatic"
    #: Node count scaled upon user request.
    MANUAL = "Manual"
    #: Fixed set of nodes.
    NONE = "None"

class SkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This field is required to be implemented by the Resource Provider if the service has more than
    one tier, but is not required on a PUT.
    """

    FREE = "Free"
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"

class StackMetaLearnerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The meta-learner is a model trained on the output of the individual heterogeneous models.
    Default meta-learners are LogisticRegression for classification tasks (or LogisticRegressionCV
    if cross-validation is enabled) and ElasticNet for regression/forecasting tasks (or
    ElasticNetCV if cross-validation is enabled).
    This parameter can be one of the following strings: LogisticRegression, LogisticRegressionCV,
    LightGBMClassifier, ElasticNet, ElasticNetCV, LightGBMRegressor, or LinearRegression
    """

    NONE = "None"
    #: Default meta-learners are LogisticRegression for classification tasks.
    LOGISTIC_REGRESSION = "LogisticRegression"
    #: Default meta-learners are LogisticRegression for classification task when CV is on.
    LOGISTIC_REGRESSION_CV = "LogisticRegressionCV"
    LIGHT_GBM_CLASSIFIER = "LightGBMClassifier"
    #: Default meta-learners are LogisticRegression for regression task.
    ELASTIC_NET = "ElasticNet"
    #: Default meta-learners are LogisticRegression for regression task when CV is on.
    ELASTIC_NET_CV = "ElasticNetCV"
    LIGHT_GBM_REGRESSOR = "LightGBMRegressor"
    LINEAR_REGRESSION = "LinearRegression"

class StochasticOptimizer(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Stochastic optimizer for image models.
    """

    #: No optimizer selected.
    NONE = "None"
    #: Stochastic Gradient Descent optimizer.
    SGD = "Sgd"
    #: Adam is algorithm the optimizes stochastic objective functions based on adaptive estimates of
    #: moments.
    ADAM = "Adam"
    #: AdamW is a variant of the optimizer Adam that has an improved implementation of weight decay.
    ADAMW = "Adamw"

class TargetAggregationFunction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Target aggregate function.
    """

    #: Represent no value set.
    NONE = "None"
    SUM = "Sum"
    MAX = "Max"
    MIN = "Min"
    MEAN = "Mean"

class TargetLagsMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Target lags selection modes.
    """

    #: Target lags to be determined automatically.
    AUTO = "Auto"
    #: Use the custom target lags.
    CUSTOM = "Custom"

class TargetRollingWindowSizeMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Target rolling windows size mode.
    """

    #: Determine rolling windows size automatically.
    AUTO = "Auto"
    #: Use the specified rolling window size.
    CUSTOM = "Custom"

class TaskType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AutoMLJob Task type.
    """

    #: Classification in machine learning and statistics is a supervised learning approach in which
    #: the computer program learns from the data given to it and make new observations or
    #: classifications.
    CLASSIFICATION = "Classification"
    #: Regression means to predict the value using the input data. Regression models are used to
    #: predict a continuous value.
    REGRESSION = "Regression"
    #: Forecasting is a special kind of regression task that deals with time-series data and creates
    #: forecasting model
    #: that can be used to predict the near future values based on the inputs.
    FORECASTING = "Forecasting"
    #: Image Classification. Multi-class image classification is used when an image is classified with
    #: only a single label
    #: from a set of classes - e.g. each image is classified as either an image of a 'cat' or a 'dog'
    #: or a 'duck'.
    IMAGE_CLASSIFICATION = "ImageClassification"
    #: Image Classification Multilabel. Multi-label image classification is used when an image could
    #: have one or more labels
    #: from a set of labels - e.g. an image could be labeled with both 'cat' and 'dog'.
    IMAGE_CLASSIFICATION_MULTILABEL = "ImageClassificationMultilabel"
    #: Image Object Detection. Object detection is used to identify objects in an image and locate
    #: each object with a
    #: bounding box e.g. locate all dogs and cats in an image and draw a bounding box around each.
    IMAGE_OBJECT_DETECTION = "ImageObjectDetection"
    #: Image Instance Segmentation. Instance segmentation is used to identify objects in an image at
    #: the pixel level,
    #: drawing a polygon around each object in the image.
    IMAGE_INSTANCE_SEGMENTATION = "ImageInstanceSegmentation"
    #: Text classification (also known as text tagging or text categorization) is the process of
    #: sorting texts into categories.
    #: Categories are mutually exclusive.
    TEXT_CLASSIFICATION = "TextClassification"
    #: Multilabel classification task assigns each sample to a group (zero or more) of target labels.
    TEXT_CLASSIFICATION_MULTILABEL = "TextClassificationMultilabel"
    #: Text Named Entity Recognition a.k.a. TextNER.
    #: Named Entity Recognition (NER) is the ability to take free-form text and identify the
    #: occurrences of entities such as people, locations, organizations, and more.
    TEXT_NER = "TextNER"

class UseStl(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Configure STL Decomposition of the time-series target column.
    """

    #: No stl decomposition.
    NONE = "None"
    SEASON = "Season"
    SEASON_TREND = "SeasonTrend"

class ValidationMetricType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Metric computation method to use for validation metrics in image tasks.
    """

    #: No metric.
    NONE = "None"
    #: Coco metric.
    COCO = "Coco"
    #: Voc metric.
    VOC = "Voc"
    #: CocoVoc metric.
    COCO_VOC = "CocoVoc"

class Weekday(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum of weekdays
    """

    #: Monday weekday.
    MONDAY = "Monday"
    #: Tuesday weekday.
    TUESDAY = "Tuesday"
    #: Wednesday weekday.
    WEDNESDAY = "Wednesday"
    #: Thursday weekday.
    THURSDAY = "Thursday"
    #: Friday weekday.
    FRIDAY = "Friday"
    #: Saturday weekday.
    SATURDAY = "Saturday"
    #: Sunday weekday.
    SUNDAY = "Sunday"
