# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

from typing import Any, Mapping, Optional, TYPE_CHECKING, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class ConfidentialLedgerError(_Model):
    """An error response from Confidential Ledger.

    :ivar error: An error response from Confidential Ledger.
    :vartype error: ~azure.confidentialledger.certificate.models.ConfidentialLedgerErrorBody
    """

    error: Optional["_models.ConfidentialLedgerErrorBody"] = rest_field(visibility=["read"])
    """An error response from Confidential Ledger."""


class ConfidentialLedgerErrorBody(_Model):
    """An error response from Confidential Ledger.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""


class LedgerIdentityInformation(_Model):
    """Contains the information about a Confidential Ledger.

    :ivar ledger_id: Id for the ledger.
    :vartype ledger_id: str
    :ivar ledger_tls_certificate: PEM-encoded certificate used for TLS by the Confidential Ledger.
     Required.
    :vartype ledger_tls_certificate: str
    """

    ledger_id: Optional[str] = rest_field(name="ledgerId", visibility=["read"])
    """Id for the ledger."""
    ledger_tls_certificate: str = rest_field(
        name="ledgerTlsCertificate", visibility=["read", "create", "update", "delete", "query"]
    )
    """PEM-encoded certificate used for TLS by the Confidential Ledger. Required."""

    @overload
    def __init__(
        self,
        *,
        ledger_tls_certificate: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
