# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AgreementType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The agreement type."""

    NOT_SPECIFIED = "NotSpecified"
    AS2 = "AS2"
    X12 = "X12"
    EDIFACT = "Edifact"


class ApiDeploymentParameterVisibility(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Api deployment parameter visibility."""

    NOT_SPECIFIED = "NotSpecified"
    DEFAULT = "Default"
    INTERNAL = "Internal"


class ApiTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Api tier."""

    NOT_SPECIFIED = "NotSpecified"
    ENTERPRISE = "Enterprise"
    STANDARD = "Standard"
    PREMIUM = "Premium"


class ApiType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ApiType."""

    NOT_SPECIFIED = "NotSpecified"
    REST = "Rest"
    SOAP = "Soap"


class AzureAsyncOperationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Azure async operation state."""

    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    PENDING = "Pending"
    CANCELED = "Canceled"


class DayOfWeek(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The day of the week."""

    SUNDAY = "Sunday"
    MONDAY = "Monday"
    TUESDAY = "Tuesday"
    WEDNESDAY = "Wednesday"
    THURSDAY = "Thursday"
    FRIDAY = "Friday"
    SATURDAY = "Saturday"


class DaysOfWeek(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DaysOfWeek."""

    SUNDAY = "Sunday"
    MONDAY = "Monday"
    TUESDAY = "Tuesday"
    WEDNESDAY = "Wednesday"
    THURSDAY = "Thursday"
    FRIDAY = "Friday"
    SATURDAY = "Saturday"


class EdifactCharacterSet(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The edifact character set."""

    NOT_SPECIFIED = "NotSpecified"
    UNOB = "UNOB"
    UNOA = "UNOA"
    UNOC = "UNOC"
    UNOD = "UNOD"
    UNOE = "UNOE"
    UNOF = "UNOF"
    UNOG = "UNOG"
    UNOH = "UNOH"
    UNOI = "UNOI"
    UNOJ = "UNOJ"
    UNOK = "UNOK"
    UNOX = "UNOX"
    UNOY = "UNOY"
    KECA = "KECA"


class EdifactDecimalIndicator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The edifact decimal indicator."""

    NOT_SPECIFIED = "NotSpecified"
    COMMA = "Comma"
    DECIMAL = "Decimal"


class EncryptionAlgorithm(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The encryption algorithm."""

    NOT_SPECIFIED = "NotSpecified"
    NONE = "None"
    DES3 = "DES3"
    RC2 = "RC2"
    AES128 = "AES128"
    AES192 = "AES192"
    AES256 = "AES256"


class ErrorResponseCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The error response code."""

    NOT_SPECIFIED = "NotSpecified"
    INTEGRATION_SERVICE_ENVIRONMENT_NOT_FOUND = "IntegrationServiceEnvironmentNotFound"
    INTERNAL_SERVER_ERROR = "InternalServerError"
    INVALID_OPERATION_ID = "InvalidOperationId"


class EventLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The event level."""

    LOG_ALWAYS = "LogAlways"
    CRITICAL = "Critical"
    ERROR = "Error"
    WARNING = "Warning"
    INFORMATIONAL = "Informational"
    VERBOSE = "Verbose"


class HashingAlgorithm(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The signing or hashing algorithm."""

    NOT_SPECIFIED = "NotSpecified"
    NONE = "None"
    MD5 = "MD5"
    SHA1 = "SHA1"
    SHA2256 = "SHA2256"
    SHA2384 = "SHA2384"
    SHA2512 = "SHA2512"


class IntegrationAccountSkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The integration account sku name."""

    NOT_SPECIFIED = "NotSpecified"
    FREE = "Free"
    BASIC = "Basic"
    STANDARD = "Standard"


class IntegrationServiceEnvironmentAccessEndpointType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The integration service environment access endpoint type."""

    NOT_SPECIFIED = "NotSpecified"
    EXTERNAL = "External"
    INTERNAL = "Internal"


class IntegrationServiceEnvironmentNetworkDependencyCategoryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The integration service environment network dependency category type."""

    NOT_SPECIFIED = "NotSpecified"
    AZURE_STORAGE = "AzureStorage"
    AZURE_MANAGEMENT = "AzureManagement"
    AZURE_ACTIVE_DIRECTORY = "AzureActiveDirectory"
    SSL_CERTIFICATE_VERIFICATION = "SSLCertificateVerification"
    DIAGNOSTIC_LOGS_AND_METRICS = "DiagnosticLogsAndMetrics"
    INTEGRATION_SERVICE_ENVIRONMENT_CONNECTORS = "IntegrationServiceEnvironmentConnectors"
    REDIS_CACHE = "RedisCache"
    ACCESS_ENDPOINTS = "AccessEndpoints"
    RECOVERY_SERVICE = "RecoveryService"
    SQL = "SQL"
    REGIONAL_SERVICE = "RegionalService"


class IntegrationServiceEnvironmentNetworkDependencyHealthState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The integration service environment network dependency health state."""

    NOT_SPECIFIED = "NotSpecified"
    HEALTHY = "Healthy"
    UNHEALTHY = "Unhealthy"
    UNKNOWN = "Unknown"


class IntegrationServiceEnvironmentNetworkEndPointAccessibilityState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The integration service environment network endpoint accessibility state."""

    NOT_SPECIFIED = "NotSpecified"
    UNKNOWN = "Unknown"
    AVAILABLE = "Available"
    NOT_AVAILABLE = "NotAvailable"


class IntegrationServiceEnvironmentSkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The integration service environment sku name."""

    NOT_SPECIFIED = "NotSpecified"
    PREMIUM = "Premium"
    DEVELOPER = "Developer"


class IntegrationServiceEnvironmentSkuScaleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The integration service environment sku scale type."""

    MANUAL = "Manual"
    AUTOMATIC = "Automatic"
    NONE = "None"


class KeyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The key type."""

    NOT_SPECIFIED = "NotSpecified"
    PRIMARY = "Primary"
    SECONDARY = "Secondary"


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity. The type 'SystemAssigned' includes an implicitly created
    identity. The type 'None' will remove any identities from the resource.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    NONE = "None"


class MapType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The map type."""

    NOT_SPECIFIED = "NotSpecified"
    XSLT = "Xslt"
    XSLT20 = "Xslt20"
    XSLT30 = "Xslt30"
    LIQUID = "Liquid"


class MessageFilterType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The message filter type."""

    NOT_SPECIFIED = "NotSpecified"
    INCLUDE = "Include"
    EXCLUDE = "Exclude"


class OpenAuthenticationProviderType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Open authentication policy provider type."""

    AAD = "AAD"


class ParameterType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The parameter type."""

    NOT_SPECIFIED = "NotSpecified"
    STRING = "String"
    SECURE_STRING = "SecureString"
    INT = "Int"
    FLOAT = "Float"
    BOOL = "Bool"
    ARRAY = "Array"
    OBJECT = "Object"
    SECURE_OBJECT = "SecureObject"


class PartnerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The partner type."""

    NOT_SPECIFIED = "NotSpecified"
    B2_B = "B2B"


class RecurrenceFrequency(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The recurrence frequency."""

    NOT_SPECIFIED = "NotSpecified"
    SECOND = "Second"
    MINUTE = "Minute"
    HOUR = "Hour"
    DAY = "Day"
    WEEK = "Week"
    MONTH = "Month"
    YEAR = "Year"


class SchemaType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The schema type."""

    NOT_SPECIFIED = "NotSpecified"
    XML = "Xml"


class SegmentTerminatorSuffix(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The segment terminator suffix."""

    NOT_SPECIFIED = "NotSpecified"
    NONE = "None"
    CR = "CR"
    LF = "LF"
    CRLF = "CRLF"


class SigningAlgorithm(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The signing or hashing algorithm."""

    NOT_SPECIFIED = "NotSpecified"
    DEFAULT = "Default"
    SHA1 = "SHA1"
    SHA2256 = "SHA2256"
    SHA2384 = "SHA2384"
    SHA2512 = "SHA2512"


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The sku name."""

    NOT_SPECIFIED = "NotSpecified"
    FREE = "Free"
    SHARED = "Shared"
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"


class StatusAnnotation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status annotation."""

    NOT_SPECIFIED = "NotSpecified"
    PREVIEW = "Preview"
    PRODUCTION = "Production"


class SwaggerSchemaType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The swagger schema type."""

    STRING = "String"
    NUMBER = "Number"
    INTEGER = "Integer"
    BOOLEAN = "Boolean"
    ARRAY = "Array"
    FILE = "File"
    OBJECT = "Object"
    NULL = "Null"


class TrackEventsOperationOptions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The track events operation options."""

    NONE = "None"
    DISABLE_SOURCE_INFO_ENRICH = "DisableSourceInfoEnrich"


class TrackingRecordType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The tracking record type."""

    NOT_SPECIFIED = "NotSpecified"
    CUSTOM = "Custom"
    AS2_MESSAGE = "AS2Message"
    AS2_MDN = "AS2MDN"
    X12_INTERCHANGE = "X12Interchange"
    X12_FUNCTIONAL_GROUP = "X12FunctionalGroup"
    X12_TRANSACTION_SET = "X12TransactionSet"
    X12_INTERCHANGE_ACKNOWLEDGMENT = "X12InterchangeAcknowledgment"
    X12_FUNCTIONAL_GROUP_ACKNOWLEDGMENT = "X12FunctionalGroupAcknowledgment"
    X12_TRANSACTION_SET_ACKNOWLEDGMENT = "X12TransactionSetAcknowledgment"
    EDIFACT_INTERCHANGE = "EdifactInterchange"
    EDIFACT_FUNCTIONAL_GROUP = "EdifactFunctionalGroup"
    EDIFACT_TRANSACTION_SET = "EdifactTransactionSet"
    EDIFACT_INTERCHANGE_ACKNOWLEDGMENT = "EdifactInterchangeAcknowledgment"
    EDIFACT_FUNCTIONAL_GROUP_ACKNOWLEDGMENT = "EdifactFunctionalGroupAcknowledgment"
    EDIFACT_TRANSACTION_SET_ACKNOWLEDGMENT = "EdifactTransactionSetAcknowledgment"


class TrailingSeparatorPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The trailing separator policy."""

    NOT_SPECIFIED = "NotSpecified"
    NOT_ALLOWED = "NotAllowed"
    OPTIONAL = "Optional"
    MANDATORY = "Mandatory"


class UsageIndicator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The usage indicator."""

    NOT_SPECIFIED = "NotSpecified"
    TEST = "Test"
    INFORMATION = "Information"
    PRODUCTION = "Production"


class WorkflowProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The workflow provisioning state."""

    NOT_SPECIFIED = "NotSpecified"
    ACCEPTED = "Accepted"
    RUNNING = "Running"
    READY = "Ready"
    CREATING = "Creating"
    CREATED = "Created"
    DELETING = "Deleting"
    DELETED = "Deleted"
    CANCELED = "Canceled"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    MOVING = "Moving"
    UPDATING = "Updating"
    REGISTERING = "Registering"
    REGISTERED = "Registered"
    UNREGISTERING = "Unregistering"
    UNREGISTERED = "Unregistered"
    COMPLETED = "Completed"
    RENEWING = "Renewing"
    PENDING = "Pending"
    WAITING = "Waiting"
    IN_PROGRESS = "InProgress"


class WorkflowState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The workflow state."""

    NOT_SPECIFIED = "NotSpecified"
    COMPLETED = "Completed"
    ENABLED = "Enabled"
    DISABLED = "Disabled"
    DELETED = "Deleted"
    SUSPENDED = "Suspended"


class WorkflowStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The workflow status."""

    NOT_SPECIFIED = "NotSpecified"
    PAUSED = "Paused"
    RUNNING = "Running"
    WAITING = "Waiting"
    SUCCEEDED = "Succeeded"
    SKIPPED = "Skipped"
    SUSPENDED = "Suspended"
    CANCELLED = "Cancelled"
    FAILED = "Failed"
    FAULTED = "Faulted"
    TIMED_OUT = "TimedOut"
    ABORTED = "Aborted"
    IGNORED = "Ignored"


class WorkflowTriggerProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The workflow trigger provisioning state."""

    NOT_SPECIFIED = "NotSpecified"
    ACCEPTED = "Accepted"
    RUNNING = "Running"
    READY = "Ready"
    CREATING = "Creating"
    CREATED = "Created"
    DELETING = "Deleting"
    DELETED = "Deleted"
    CANCELED = "Canceled"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    MOVING = "Moving"
    UPDATING = "Updating"
    REGISTERING = "Registering"
    REGISTERED = "Registered"
    UNREGISTERING = "Unregistering"
    UNREGISTERED = "Unregistered"
    COMPLETED = "Completed"


class WsdlImportMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The WSDL import method."""

    NOT_SPECIFIED = "NotSpecified"
    SOAP_TO_REST = "SoapToRest"
    SOAP_PASS_THROUGH = "SoapPassThrough"


class X12CharacterSet(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The X12 character set."""

    NOT_SPECIFIED = "NotSpecified"
    BASIC = "Basic"
    EXTENDED = "Extended"
    UTF8 = "UTF8"


class X12DateFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The x12 date format."""

    NOT_SPECIFIED = "NotSpecified"
    CCYYMMDD = "CCYYMMDD"
    YYMMDD = "YYMMDD"


class X12TimeFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The x12 time format."""

    NOT_SPECIFIED = "NotSpecified"
    HHMM = "HHMM"
    HHMMSS = "HHMMSS"
    HHMMS_SDD = "HHMMSSdd"
    HHMMS_SD = "HHMMSSd"
