# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class AgentStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Agent status."""

    REGISTERING = "Registering"
    OFFLINE = "Offline"
    ONLINE = "Online"
    EXECUTING = "Executing"
    REQUIRES_ATTENTION = "RequiresAttention"
    UNREGISTERING = "Unregistering"


class CopyMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Strategy to use for copy."""

    ADDITIVE = "Additive"
    MIRROR = "Mirror"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class CredentialType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Credentials type."""

    AZURE_KEY_VAULT_SMB = "AzureKeyVaultSmb"


class DayOfWeek(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The day of week."""

    MONDAY = "Monday"
    TUESDAY = "Tuesday"
    WEDNESDAY = "Wednesday"
    THURSDAY = "Thursday"
    FRIDAY = "Friday"
    SATURDAY = "Saturday"
    SUNDAY = "Sunday"


class EndpointType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Endpoint resource type."""

    AZURE_STORAGE_BLOB_CONTAINER = "AzureStorageBlobContainer"
    NFS_MOUNT = "NfsMount"
    AZURE_STORAGE_SMB_FILE_SHARE = "AzureStorageSmbFileShare"
    SMB_MOUNT = "SmbMount"
    AZURE_MULTI_CLOUD_CONNECTOR = "AzureMultiCloudConnector"
    AZURE_STORAGE_NFS_FILE_SHARE = "AzureStorageNfsFileShare"


class JobRunScanStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of Agent's scanning of source."""

    NOT_STARTED = "NotStarted"
    SCANNING = "Scanning"
    COMPLETED = "Completed"


class JobRunStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of the Job Run in a non-terminal state, if exists."""

    QUEUED = "Queued"
    STARTED = "Started"
    RUNNING = "Running"
    CANCEL_REQUESTED = "CancelRequested"
    CANCELING = "Canceling"
    CANCELED = "Canceled"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    PAUSED_BY_BANDWIDTH_MANAGEMENT = "PausedByBandwidthManagement"


class JobType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the Job."""

    ON_PREM_TO_CLOUD = "OnPremToCloud"
    CLOUD_TO_CLOUD = "CloudToCloud"


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    """No managed identity."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned managed identity."""
    USER_ASSIGNED = "UserAssigned"
    """User assigned managed identity."""
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"
    """System and user assigned managed identity."""


class Minute(int, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The minute element of the time. Allowed values are 0 and 30. If not specified, its value
    defaults to 0.
    """

    ZERO = 0
    THIRTY = 30


class NfsVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The NFS protocol version."""

    NF_SAUTO = "NFSauto"
    NF_SV3 = "NFSv3"
    NF_SV4 = "NFSv4"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of a resource."""

    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"
    DELETING = "Deleting"
