// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

#pragma once

#include "utils_global.h"

#include "icon.h"

namespace Utils {
namespace Icons {

QTCREATOR_UTILS_EXPORT std::optional<Icon> fromString(const QString &name);

QTCREATOR_UTILS_EXPORT extern const Icon HOME;
QTCREATOR_UTILS_EXPORT extern const Icon HOME_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon EDIT_CLEAR;
QTCREATOR_UTILS_EXPORT extern const Icon EDIT_CLEAR_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon LOCKED_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon LOCKED;
QTCREATOR_UTILS_EXPORT extern const Icon UNLOCKED_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon UNLOCKED;
QTCREATOR_UTILS_EXPORT extern const Icon PINNED;
QTCREATOR_UTILS_EXPORT extern const Icon PINNED_SMALL;
QTCREATOR_UTILS_EXPORT extern const Icon NEXT;
QTCREATOR_UTILS_EXPORT extern const Icon NEXT_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon PREV;
QTCREATOR_UTILS_EXPORT extern const Icon PREV_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon PROJECT;
QTCREATOR_UTILS_EXPORT extern const Icon ZOOM;
QTCREATOR_UTILS_EXPORT extern const Icon ZOOM_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon ZOOMIN_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon ZOOMOUT_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon FITTOVIEW_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon OK;
QTCREATOR_UTILS_EXPORT extern const Icon NOTLOADED;
QTCREATOR_UTILS_EXPORT extern const Icon BROKEN;
QTCREATOR_UTILS_EXPORT extern const Icon BOOKMARK;
QTCREATOR_UTILS_EXPORT extern const Icon BOOKMARK_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon BOOKMARK_TEXTEDITOR;
QTCREATOR_UTILS_EXPORT extern const Icon SNAPSHOT;
QTCREATOR_UTILS_EXPORT extern const Icon SNAPSHOT_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon NEWSEARCH_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon SETTINGS;
QTCREATOR_UTILS_EXPORT extern const Icon SETTINGS_TOOLBAR;

QTCREATOR_UTILS_EXPORT extern const Icon NEWFILE;
QTCREATOR_UTILS_EXPORT extern const Icon OPENFILE;
QTCREATOR_UTILS_EXPORT extern const Icon OPENFILE_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon SAVEFILE;
QTCREATOR_UTILS_EXPORT extern const Icon SAVEFILE_TOOLBAR;

QTCREATOR_UTILS_EXPORT extern const Icon EXPORTFILE_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon MULTIEXPORTFILE_TOOLBAR;

QTCREATOR_UTILS_EXPORT extern const Icon DIR;
QTCREATOR_UTILS_EXPORT extern const Icon HELP;
QTCREATOR_UTILS_EXPORT extern const Icon UNKNOWN_FILE;

QTCREATOR_UTILS_EXPORT extern const Icon UNDO;
QTCREATOR_UTILS_EXPORT extern const Icon UNDO_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon REDO;
QTCREATOR_UTILS_EXPORT extern const Icon REDO_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon COPY;
QTCREATOR_UTILS_EXPORT extern const Icon COPY_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon PASTE;
QTCREATOR_UTILS_EXPORT extern const Icon PASTE_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon CUT;
QTCREATOR_UTILS_EXPORT extern const Icon CUT_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon RESET;
QTCREATOR_UTILS_EXPORT extern const Icon RESET_TOOLBAR;

QTCREATOR_UTILS_EXPORT extern const Icon ARROW_UP;
QTCREATOR_UTILS_EXPORT extern const Icon ARROW_UP_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon ARROW_DOWN;
QTCREATOR_UTILS_EXPORT extern const Icon ARROW_DOWN_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon MINUS_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon MINUS;
QTCREATOR_UTILS_EXPORT extern const Icon PLUS_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon PLUS;
QTCREATOR_UTILS_EXPORT extern const Icon MAGNIFIER;
QTCREATOR_UTILS_EXPORT extern const Icon CLEAN;
QTCREATOR_UTILS_EXPORT extern const Icon CLEAN_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon RELOAD;
QTCREATOR_UTILS_EXPORT extern const Icon RELOAD_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon TOGGLE_LEFT_SIDEBAR;
QTCREATOR_UTILS_EXPORT extern const Icon TOGGLE_LEFT_SIDEBAR_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon TOGGLE_RIGHT_SIDEBAR;
QTCREATOR_UTILS_EXPORT extern const Icon TOGGLE_RIGHT_SIDEBAR_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon CLOSE_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon CLOSE_FOREGROUND;
QTCREATOR_UTILS_EXPORT extern const Icon CLOSE_BACKGROUND;
QTCREATOR_UTILS_EXPORT extern const Icon SPLIT_HORIZONTAL;
QTCREATOR_UTILS_EXPORT extern const Icon SPLIT_HORIZONTAL_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon SPLIT_VERTICAL;
QTCREATOR_UTILS_EXPORT extern const Icon SPLIT_VERTICAL_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon CLOSE_SPLIT_TOP;
QTCREATOR_UTILS_EXPORT extern const Icon CLOSE_SPLIT_BOTTOM;
QTCREATOR_UTILS_EXPORT extern const Icon CLOSE_SPLIT_LEFT;
QTCREATOR_UTILS_EXPORT extern const Icon CLOSE_SPLIT_RIGHT;
QTCREATOR_UTILS_EXPORT extern const Icon FILTER;
QTCREATOR_UTILS_EXPORT extern const Icon LINK;
QTCREATOR_UTILS_EXPORT extern const Icon LINK_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon SORT_ALPHABETICALLY_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon TOGGLE_PROGRESSDETAILS_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon ONLINE;
QTCREATOR_UTILS_EXPORT extern const Icon ONLINE_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon DOWNLOAD;

QTCREATOR_UTILS_EXPORT extern const Icon INFO;
QTCREATOR_UTILS_EXPORT extern const Icon INFO_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon WARNING;
QTCREATOR_UTILS_EXPORT extern const Icon WARNING_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon CRITICAL;
QTCREATOR_UTILS_EXPORT extern const Icon CRITICAL_TOOLBAR;

QTCREATOR_UTILS_EXPORT extern const Icon ERROR_TASKBAR;
QTCREATOR_UTILS_EXPORT extern const Icon EXPAND_ALL_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon TOOLBAR_EXTENSION;
QTCREATOR_UTILS_EXPORT extern const Icon RUN_SMALL;
QTCREATOR_UTILS_EXPORT extern const Icon RUN_SMALL_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon STOP_SMALL;
QTCREATOR_UTILS_EXPORT extern const Icon STOP_SMALL_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon INTERRUPT_SMALL;
QTCREATOR_UTILS_EXPORT extern const Icon INTERRUPT_SMALL_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon CONTINUE_SMALL;
QTCREATOR_UTILS_EXPORT extern const Icon CONTINUE_SMALL_TOOLBAR;

QTCREATOR_UTILS_EXPORT extern const Icon BOUNDING_RECT;
QTCREATOR_UTILS_EXPORT extern const Icon EYE_OPEN;
QTCREATOR_UTILS_EXPORT extern const Icon EYE_OPEN_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon EYE_CLOSED_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon REPLACE;
QTCREATOR_UTILS_EXPORT extern const Icon EXPAND;
QTCREATOR_UTILS_EXPORT extern const Icon EXPAND_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon CLOCK_BLACK;
QTCREATOR_UTILS_EXPORT extern const Icon COLLAPSE;
QTCREATOR_UTILS_EXPORT extern const Icon COLLAPSE_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon PAN_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon EMPTY14;
QTCREATOR_UTILS_EXPORT extern const Icon EMPTY16;
QTCREATOR_UTILS_EXPORT extern const Icon OVERLAY_ADD;
QTCREATOR_UTILS_EXPORT extern const Icon OVERLAY_WARNING;
QTCREATOR_UTILS_EXPORT extern const Icon OVERLAY_ERROR;
QTCREATOR_UTILS_EXPORT extern const Icon RUN_FILE;
QTCREATOR_UTILS_EXPORT extern const Icon RUN_FILE_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon RUN_SELECTED;
QTCREATOR_UTILS_EXPORT extern const Icon RUN_SELECTED_TOOLBAR;

QTCREATOR_UTILS_EXPORT extern const Icon CODEMODEL_ERROR;
QTCREATOR_UTILS_EXPORT extern const Icon CODEMODEL_WARNING;
QTCREATOR_UTILS_EXPORT extern const Icon CODEMODEL_DISABLED_ERROR;
QTCREATOR_UTILS_EXPORT extern const Icon CODEMODEL_DISABLED_WARNING;
QTCREATOR_UTILS_EXPORT extern const Icon CODEMODEL_FIXIT;

QTCREATOR_UTILS_EXPORT extern const Icon MACOS_TOUCHBAR_BOOKMARK;
QTCREATOR_UTILS_EXPORT extern const Icon MACOS_TOUCHBAR_CLEAR;

} // namespace Icons

namespace CodeModelIcon {

enum Type {
    Class = 0,
    Struct,
    Enum,
    Enumerator,
    FuncPublic,
    FuncProtected,
    FuncPrivate,
    FuncPublicStatic,
    FuncProtectedStatic,
    FuncPrivateStatic,
    Namespace,
    VarPublic,
    VarProtected,
    VarPrivate,
    VarPublicStatic,
    VarProtectedStatic,
    VarPrivateStatic,
    Signal,
    SlotPublic,
    SlotProtected,
    SlotPrivate,
    Keyword,
    Macro,
    Property,
    Unknown
};

QTCREATOR_UTILS_EXPORT QIcon iconForType(Type type);

} // namespace CodeModelIcon
} // namespace Utils
