#define XERR "cron"
#include "cron.ih"

// input:
//      RELOAD  - already received
//      passphrase
//      cronFile
// output:
//      NOK     - invalid passphrase
// or
//      OK
// or
//      errors in cronFile

    // by request.cc, see also sshcron/reload.cc

void Cron::reload()
{
    if (not verifyPassphrase())
        return;

    string cronFile;
    getline(*d_in, cronFile);

    if (not load(cronFile))
    {
        *d_out << "error(s) in " << cronFile << 
                ": currently no crontab requests" << endl;
        return;
    }

    *d_out << "OK" << endl;
    idmsg() << "reloading cron commands from " << cronFile << endl;

}
