---
myst:
  html_meta:
    keywords: LaTeX, tableaux, flottants, mise en forme des tableaux, faire tourner un tableau, 
              pivoter un tableau, pivoter une figure
---

# Comment modifier l'orientation de flottants ?

Si la présente question traite du cas général des flottants, une autre question traite 
le cas un peu plus spécifique des tableaux 
"[](/3_composition/tableaux/changer_l_orientation_d_un_tableau)".


## Avec l'extension <ctanpkg:rotating>

L'extension <ctanpkg:rotating> permet de réaliser ce genre de choses. Cependant, 
il est à noter que le format DVI ne supporte pas ces manipulations, 
qui se font au niveau du PS. Certains interpréteurs DVI montreront alors 
la figure dans son orientation normale.

Les environnement `sidewaystable` et `sidewaysfigure` permettent de changer 
l'orientation d'un flottant. Ils créent des flottants, qui seront nécessairement inclus 
sur une page à part, du fait du changement d'orientation. Il n'est donc pas possible 
d'indiquer des préférences quant à la position de ce flottant. 
La légende sera également automatiquement tournée.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{fancyhdr}
  \usepackage{rotating}

  \fancyfoot[C]{\iffloatpage{}{\thepage}}
  \fancyfoot[LO,RO]{}
  \fancyhead[LO,RO,C]{}
  \renewcommand\headrulewidth{0pt}

\begin{document}
L'activité physique régulière aide à garder en forme. Ce document
a été conçu pour vous préparer à bien attaquer votre journée. 

Préparez-vous, tout se passe en page suivante.

\begin{sidewaysfigure}
\framebox{\Huge exerçons vos cervicales avec cette belle rotation.}
\caption{Une figure renversante}
\end{sidewaysfigure}
\end{document}
```

Dans l'exemple ci-dessus, l'utilisation de l'extension <ctanpkg:fancyhdr> supprime 
le numéro des pages ne contenant que des flottants.