---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, styles,
              mode mathématique hors texte, équation hors texte, 
              mathématiques dans un paragraphe, mathématiques et lignes
---

# À quoi sert la commande `\displaystyle` ?

La commande `\displaystyle` permet de forcer LaTeX à placer les 
[indices et les exposants](/4_domaines_specialises/mathematiques/structures/indices/start) 
comme s'il était en 
[mode mathématique hors ligne](/4_domaines_specialises/mathematiques/styles/les_huit_styles_mathematiques). 
Cela peut alors induire une modification locale de l'interligne courant 
comme l'illustre cet exemple du comportement de LaTeX avec et sans 
`\displaystyle` :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Elle permet de forcer \LaTeX{} à gérer les indices et les exposants
comme s'il était en mode mathématique isolé $\displaystyle
\sum_{i=0}^n x_i$. Cela peut alors induire une modification locale de
l'interligne courant. Ce texte contient un exemple : le
changement d'interligne est bien visible.

Elle permet de forcer \LaTeX{} à gérer les indices et les exposants
comme s'il était en mode mathématique isolé
$\sum_{i=0}^n x_i$. Cela peut alors induire une modification locale de
l'interligne courant. Ce texte contient un exemple : le
changement d'interligne est bien visible.
\end{document}
```


:::{sources}
- [How can I process every inline math formulas in display math mode?](https://tex.stackexchange.com/q/323367), 
sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::