---
myst:
  html_meta:
    keywords: LaTeX, fichiers, TDS
---

# Comment installer temporarirement des fichiers (La)TeX ?

Les systèmes d'exploitation et les applications doivent savoir où trouver les fichiers : 
en effet, l'utilisateur ne sait pas nécessairement *où* ils se trouvent, 
mais il sait qu'il doit les demander. Le cas le plus courant, bien sûr, 
est celui de commandes dont vous tapez le nom dans un interpréteur de commandes :
de nombreuses commandes impliquent simplement le chargement et l'exécution d'un fichier, 
et la variable `PATH` ("chemin") indique à l'interpréteur dans quel répertoire 
trouver ces fichiers.

Les implémentations modernes de TeX sont livrées avec un certain nombre de répertoires 
de recherche intégrés. Dans la plupart des cas, ces répertoires sont suffisants, 
mais il est parfois nécessaire de les étendre pour trouver des fichiers 
dans des endroits étranges : par exemple, nous pouvons souhaiter essayer une nouvelle extension
avant même de l'installer "correctement" (voir la question "[](/5_fichiers/emplacements/installer_quelque_chose)").
Pour cela, nous devons modifier le lien vers le répertoire concerné afin d'utiliser ces fichiers de test. 
Cependant, nous ne voulons pas nous débarrasser des autres liens vers les répertoires intégrés de TeX 
(car TeX ne saurait plus comment traiter les autres demandes).

Pour *étendre* une liste de répertoire de recherche TeX, nous définissons une variable d'environnement 
du système d'exploitation en respectant le format du système, mais en laissant un espace 
que TeX remplira avec sa valeur intégrée des répertoires de recherche. 
En temps normal, nous voulons placer notre nouveau répertoire devant les autres, 
afin que nos fichiers de test soient choisis de préférence. 
Nous laissons donc notre "espace à remplir" à la fin de la variable d'environnement. 
La syntaxe est simple (bien qu'elle dépende de l'interpréteur de commandes que vous utilisez) : 
ainsi, sur un système de type Unix, en utilisant l'interpréteur de commandes `bash`, 
le travail pourrait être fait comme suit :

```console
$export TEXINPUTS=/tmp :
```

Dans un système Windows, en ligne de commande, ce serait :

```console
C:\>set TEXINPUTS=C:/temp;
```

Dans les deux cas, nous demandons à TeX de charger des fichiers à partir du répertoire 
de fichiers temporaires de la racine du disque. Dans le cas d'Unix, 
l'emplacement vide est désigné en plaçant le séparateur `:` 
seul à la fin de la ligne, tandis que dans le cas de Windows, 
la technique est la même, mais le séparateur est `;`.

Notez que, quel que soit le système, le changement n'affectera que les instances de TeX 
lancées à partir du shell où la variable d'environnement a été définie. 
Si vous lancez TeX à partir d'une autre fenêtre, il utilisera la liste usuelle de répertoire. 
Pour modifier cette liste pour toutes les fenêtres, définissez la variable d'environnement
dans votre script de connexion ou votre profil (ou autre) dans un système Unix, 
puis déconnectez-vous et reconnectez-vous, ou dans `autoexec.bat` dans un système Windows, 
et redémarrez le système.

Bien que tout ce qui précède concerne l'endroit où TeX trouve ses fichiers, 
cette mécanique s'applique à presque tous les types de fichiers que tout programme lié à TeX lit. 
Il existe beaucoup de liste de répertoires et de variables d'environnement correspondantes. 
Dans un système basé sur `web2c`, les nombreuses annotations du fichier de configuration 
du système `texmf.cnf` vous aident à savoir quelle liste de répertoire correspond 
à quel type de fichier.


:::{sources}
[Temporary installation of (La)TeX files](faquk:FAQ-tempinst)
:::
