/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import { CurrencySpecification, ExchangeListItem } from "@gnu-taler/taler-util";
import * as tests from "@gnu-taler/web-util/testing";
import { nullFunction } from "../../mui/handlers.js";
// import { TermsState } from "../../utils/index.js";
import { SuccessView, FinalStateOperation } from "./views.js";

export default {
  title: "withdraw",
};

const ageRestrictionOptions: Record<string, string> = "6:12:18"
  .split(":")
  .reduce((p, c) => ({ ...p, [c]: `under ${c}` }), {});

ageRestrictionOptions["0"] = "Not restricted";

const ageRestrictionSelectField = {
  list: ageRestrictionOptions,
  value: "0",
};

export const TermsOfServiceNotYetLoaded = tests.createExample(SuccessView, {
  error: undefined,
  status: "success",
  amount: {
    value: {
      currency: "USD",
      value: 2,
      fraction: 10000000,
    },
  },
  bankFee: {
    currency: "EUR",
    fraction: 0,
    value: 1,
  },

  doWithdrawal: { onClick: nullFunction },
  currentExchange: {
    exchangeBaseUrl: "https://exchange.demo.taler.net",
    tos: {},
  } as Partial<ExchangeListItem> as any,
  toBeSent: {
    currency: "USD",
    fraction: 10000000,
    value: 1,
  },
  doSelectExchange: {},
  toBeReceived: {
    currency: "USD",
    fraction: 0,
    value: 1,
  },
  chooseCurrencies: [],
});

export const AlreadyAborted = tests.createExample(FinalStateOperation, {
  error: undefined,
  status: "already-completed",
  operationState: "aborted",
});
export const AlreadySelected = tests.createExample(FinalStateOperation, {
  error: undefined,
  status: "already-completed",
  operationState: "selected",
});
export const AlreadyConfirmed = tests.createExample(FinalStateOperation, {
  error: undefined,
  status: "already-completed",
  operationState: "confirmed",
});

export const WithSomeFee = tests.createExample(SuccessView, {
  error: undefined,
  status: "success",
  amount: {
    value: {
      currency: "USD",
      value: 2,
      fraction: 10000000,
    },
  },
  bankFee: {
    currency: "EUR",
    fraction: 0,
    value: 1,
  },

  doWithdrawal: { onClick: nullFunction },
  currentExchange: {
    exchangeBaseUrl: "https://exchange.demo.taler.net",
    tos: {},
  } as Partial<ExchangeListItem> as any,
  toBeSent: {
    currency: "USD",
    fraction: 10000000,
    value: 1,
  },
  toBeReceived: {
    currency: "USD",
    fraction: 0,
    value: 1,
  },
  doSelectExchange: {},
  chooseCurrencies: [],
});

export const WithoutFee = tests.createExample(SuccessView, {
  error: undefined,
  status: "success",
  amount: {
    value: {
      currency: "USD",
      value: 2,
      fraction: 0,
    },
  },
  bankFee: {
    currency: "EUR",
    fraction: 0,
    value: 1,
  },

  doWithdrawal: { onClick: nullFunction },
  currentExchange: {
    exchangeBaseUrl: "https://exchange.demo.taler.net",
    tos: {},
  } as Partial<ExchangeListItem> as any,
  toBeSent: {
    currency: "USD",
    fraction: 0,
    value: 0,
  },
  doSelectExchange: {},
  toBeReceived: {
    currency: "USD",
    fraction: 0,
    value: 2,
  },
  chooseCurrencies: [],
});

export const EditExchangeUntouched = tests.createExample(SuccessView, {
  error: undefined,
  status: "success",
  amount: {
    value: {
      currency: "USD",
      value: 2,
      fraction: 10000000,
    },
  },
  bankFee: {
    currency: "EUR",
    fraction: 0,
    value: 1,
  },

  doWithdrawal: { onClick: nullFunction },
  currentExchange: {
    exchangeBaseUrl: "https://exchange.demo.taler.net",
    tos: {},
  } as Partial<ExchangeListItem> as any,
  toBeSent: {
    currency: "USD",
    fraction: 0,
    value: 0,
  },
  doSelectExchange: {},
  toBeReceived: {
    currency: "USD",
    fraction: 0,
    value: 2,
  },
  chooseCurrencies: [],
});

export const EditExchangeModified = tests.createExample(SuccessView, {
  error: undefined,
  status: "success",
  amount: {
    value: {
      currency: "USD",
      value: 2,
      fraction: 10000000,
    },
  },
  bankFee: {
    currency: "EUR",
    fraction: 0,
    value: 1,
  },

  doWithdrawal: { onClick: nullFunction },
  currentExchange: {
    exchangeBaseUrl: "https://exchange.demo.taler.net",
    tos: {},
  } as Partial<ExchangeListItem> as any,
  toBeSent: {
    currency: "USD",
    fraction: 0,
    value: 0,
  },
  doSelectExchange: {},
  toBeReceived: {
    currency: "USD",
    fraction: 0,
    value: 2,
  },
  chooseCurrencies: [],
});

export const WithAgeRestriction = tests.createExample(SuccessView, {
  error: undefined,
  status: "success",
  ageRestriction: ageRestrictionSelectField,
  amount: {
    value: {
      currency: "USD",
      value: 2,
      fraction: 10000000,
    },
  },
  bankFee: {
    currency: "EUR",
    fraction: 0,
    value: 1,
  },

  doSelectExchange: {},
  doWithdrawal: { onClick: nullFunction },
  currentExchange: {
    exchangeBaseUrl: "https://exchange.demo.taler.net",
    tos: {},
  } as Partial<ExchangeListItem> as any,
  toBeSent: {
    currency: "USD",
    fraction: 0,
    value: 0,
  },
  toBeReceived: {
    currency: "USD",
    fraction: 0,
    value: 2,
  },
  chooseCurrencies: [],
});

export const WithAlternateCurrenciesNETZBON = tests.createExample(SuccessView, {
  error: undefined,
  status: "success",
  amount: {
    value: {
      currency: "NETZBON",
      value: 2,
      fraction: 10000000,
    },
  },
  bankFee: {
    currency: "EUR",
    fraction: 0,
    value: 1,
  },

  chooseCurrencies: ["NETZBON", "EUR"],
  selectedCurrency: "NETZBON",
  doWithdrawal: { onClick: nullFunction },
  currentExchange: {
    exchangeBaseUrl: "https://exchange.netzbon.ch",
    tos: {},
  } as Partial<ExchangeListItem> as any,
  toBeSent: {
    currency: "NETZBON",
    fraction: 10000000,
    value: 1,
  },
  doSelectExchange: {},
  toBeReceived: {
    currency: "NETZBON",
    fraction: 0,
    value: 1,
  },
});

export const WithAlternateCurrenciesEURO = tests.createExample(SuccessView, {
  error: undefined,
  status: "success",
  amount: {
    value: {
      currency: "NETZBON",
      value: 2,
      fraction: 10000000,
    },
  },
  bankFee: {
    currency: "EUR",
    fraction: 0,
    value: 1,
  },

  chooseCurrencies: ["NETZBON", "EUR"],
  selectedCurrency: "EUR",
  changeCurrency: () => {},
  conversionInfo: {
    spec: {
      name: "EUR",
    } as CurrencySpecification,
    amount: {
      currency: "EUR",
      fraction: 10000000,
      value: 1,
    },
  },
  doWithdrawal: { onClick: nullFunction },
  currentExchange: {
    exchangeBaseUrl: "https://exchange.netzbon.ch",
    tos: {},
  } as Partial<ExchangeListItem> as any,
  toBeSent: {
    currency: "NETZBON",
    fraction: 10000000,
    value: 1,
  },
  doSelectExchange: {},
  toBeReceived: {
    currency: "NETZBON",
    fraction: 0,
    value: 1,
  },
});

export const WithAlternateCurrenciesEURO11 = tests.createExample(SuccessView, {
  error: undefined,
  status: "success",
  amount: {
    value: {
      currency: "NETZBON",
      value: 2,
      fraction: 10000000,
    },
  },
  chooseCurrencies: ["NETZBON", "EUR"],
  selectedCurrency: "EUR",
  changeCurrency: () => {},
  bankFee: {
    currency: "EUR",
    fraction: 0,
    value: 1,
  },
  conversionInfo: {
    spec: {
      name: "EUR",
    } as CurrencySpecification,
    amount: {
      currency: "EUR",
      fraction: 10000000,
      value: 2,
    },
  },
  doWithdrawal: { onClick: nullFunction },
  currentExchange: {
    exchangeBaseUrl: "https://exchange.netzbon.ch",
    tos: {},
  } as Partial<ExchangeListItem> as any,
  toBeSent: {
    currency: "NETZBON",
    fraction: 10000000,
    value: 1,
  },
  doSelectExchange: {},
  toBeReceived: {
    currency: "NETZBON",
    fraction: 0,
    value: 1,
  },
});
