/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.RateHelper;
import net.sf.mpxj.mpp.MPPUtility;

final class CostRateTableFactory {
    private final ProjectFile m_file;

    public CostRateTableFactory(ProjectFile file) {
        this.m_file = file;
    }

    public void process(Resource resource, int index, byte[] data) {
        ArrayList<CostRateTableEntry> entries = new ArrayList<CostRateTableEntry>();
        Calendar cal = DateHelper.popCalendar();
        if (data == null) {
            if (index == 0) {
                Rate standardRate = resource.getStandardRate() == null ? Rate.ZERO : (Rate)resource.getCachedValue(ResourceField.STANDARD_RATE);
                Rate overtimeRate = resource.getOvertimeRate() == null ? Rate.ZERO : (Rate)resource.getCachedValue(ResourceField.OVERTIME_RATE);
                Double costPerUse = resource.getCostPerUse() == null ? (Number)NumberHelper.DOUBLE_ZERO : (Number)((Number)resource.getCachedValue(ResourceField.COST_PER_USE));
                Date endDate = CostRateTableEntry.DEFAULT_ENTRY.getEndDate();
                entries.add(new CostRateTableEntry(null, endDate, costPerUse, standardRate, overtimeRate));
            } else {
                entries.add(CostRateTableEntry.DEFAULT_ENTRY);
            }
        } else {
            int i = 16;
            while (i + 44 <= data.length) {
                TimeUnit standardRateFormat = this.getFormat(MPPUtility.getShort(data, i + 8));
                Rate standardRate = RateHelper.convertFromHours(this.m_file, MPPUtility.getDouble(data, i), standardRateFormat);
                TimeUnit overtimeRateFormat = this.getFormat(MPPUtility.getShort(data, i + 24));
                Rate overtimeRate = RateHelper.convertFromHours(this.m_file, MPPUtility.getDouble(data, i + 16), overtimeRateFormat);
                Double costPerUse = NumberHelper.getDouble(MPPUtility.getDouble(data, i + 32) / 100.0);
                Date endDate = MPPUtility.getTimestampFromTenths(data, i + 40);
                if (endDate.getTime() > DateHelper.END_DATE_NA.getTime()) {
                    endDate = DateHelper.END_DATE_NA;
                } else {
                    cal.setTime(endDate);
                    int minutes = cal.get(12);
                    if (minutes % 5 == 0) {
                        cal.add(12, -1);
                        endDate = cal.getTime();
                    }
                }
                entries.add(new CostRateTableEntry(null, endDate, costPerUse, standardRate, overtimeRate));
                i += 44;
            }
        }
        Collections.sort(entries);
        CostRateTable result = new CostRateTable();
        for (int i = 0; i < entries.size(); ++i) {
            Date startDate;
            if (i == 0) {
                startDate = DateHelper.START_DATE_NA;
            } else {
                cal.setTime(((CostRateTableEntry)entries.get(i - 1)).getEndDate());
                cal.add(12, 1);
                startDate = cal.getTime();
            }
            CostRateTableEntry entry = (CostRateTableEntry)entries.get(i);
            result.add(new CostRateTableEntry(startDate, entry.getEndDate(), entry.getCostPerUse(), entry.getStandardRate(), entry.getOvertimeRate()));
        }
        resource.setCostRateTable(index, result);
    }

    private TimeUnit getFormat(int format) {
        TimeUnit result;
        if (format == 65535) {
            result = TimeUnit.HOURS;
        } else {
            result = MPPUtility.getWorkTimeUnits(format);
            if (result == TimeUnit.ELAPSED_MINUTES) {
                result = TimeUnit.HOURS;
            }
        }
        return result;
    }
}

