// SPDX-FileCopyrightText: Copyright (c) 2008-2013, NVIDIA Corporation. All rights reserved.
// SPDX-License-Identifier: Apache-2.0

#pragma once

#include <thrust/detail/config.h>

#if defined(_CCCL_IMPLICIT_SYSTEM_HEADER_GCC)
#  pragma GCC system_header
#elif defined(_CCCL_IMPLICIT_SYSTEM_HEADER_CLANG)
#  pragma clang system_header
#elif defined(_CCCL_IMPLICIT_SYSTEM_HEADER_MSVC)
#  pragma system_header
#endif // no system header

// this system inherits this algorithm
#include <thrust/system/cpp/detail/scan_by_key.h>

// Ensure OMP scan is available before using generic scan_by_key
#include <thrust/system/omp/detail/scan.h>

// use generic parallel implementation
#include <thrust/system/detail/generic/scan_by_key.h>
