/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.databricks;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericExecutionContext;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class DatabricksExecutionContext
extends GenericExecutionContext {
    private static final Log log = Log.getLog(DatabricksExecutionContext.class);
    @Nullable
    private String activeCatalogName;

    DatabricksExecutionContext(JDBCRemoteInstance instance, String purpose) {
        super(instance, purpose);
    }

    @Nullable
    public GenericCatalog getDefaultCatalog() {
        if (CommonUtils.isEmpty((String)this.activeCatalogName)) {
            return super.getDefaultCatalog();
        }
        return this.getDataSource().getCatalog(this.activeCatalogName);
    }

    public void setDefaultCatalog(@NotNull DBRProgressMonitor monitor, @NotNull GenericCatalog catalog, @Nullable GenericSchema schema) throws DBCException {
        try {
            super.setDefaultCatalog(monitor, catalog, schema);
            this.activeCatalogName = catalog.getName();
        }
        catch (DBCException e) {
            log.debug((Object)"Error setting default catalog for Databricks", (Throwable)e);
        }
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        boolean isRefreshed = super.refreshDefaults(monitor, useBootstrapSettings);
        try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.META, "Query current catalog");){
            try (JDBCStatement dbStat = session.createStatement();
                 JDBCResultSet dbResult = dbStat.executeQuery("SELECT CURRENT_CATALOG()");){
                String currentCatalog;
                if (dbResult != null && dbResult.next() && CommonUtils.isNotEmpty((String)(currentCatalog = dbResult.getString(1))) && !CommonUtils.equalObjects((Object)currentCatalog, (Object)this.activeCatalogName)) {
                    this.activeCatalogName = currentCatalog;
                    isRefreshed = true;
                }
            }
            catch (SQLException e) {
                log.debug((Object)"Failed to get current catalog", (Throwable)e);
            }
        }
        return isRefreshed;
    }
}

