/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.task;

import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.JavaCodeUnitAccess;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.task.ClassMatcher;
import org.freeplane.plugin.codeexplorer.task.GroupIdentifier;
import org.freeplane.plugin.codeexplorer.task.GroupMatcher;
import org.freeplane.plugin.codeexplorer.task.RmiMatcher;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;

class RmiMatcherFactory {
    private final GroupMatcher matcher;
    private final JavaClasses javaClasses;
    private final Graph<GroupIdentifier, DefaultEdge> componentGraph;
    private final Map<JavaClass, GroupIdentifier> rmiClasses;
    private final RmiMatcher rmiMatcher;
    private final ClassMatcher ignoredRmi;
    private final RmiMatcher.Mode mode;

    RmiMatcherFactory(GroupMatcher matcher, JavaClasses javaClasses, RmiMatcher.Mode mode, ClassMatcher ignoredRmi) {
        RmiMatcher rmiMatcher;
        this.matcher = matcher;
        this.javaClasses = javaClasses;
        this.mode = mode;
        this.ignoredRmi = ignoredRmi;
        this.componentGraph = new SimpleDirectedGraph(DefaultEdge.class);
        this.rmiClasses = new HashMap<JavaClass, GroupIdentifier>();
        this.fillComponentGraph();
        this.rmiMatcher = rmiMatcher = this.createMatcherFromGraph();
    }

    private void fillComponentGraph() {
        this.javaClasses.forEach(this::addComponentsToGraph);
    }

    private RmiMatcher createMatcherFromGraph() {
        HashMap<String, GroupIdentifier> bundledGroups = new HashMap<String, GroupIdentifier>();
        ConnectivityInspector inspector = new ConnectivityInspector(this.componentGraph);
        List componentGroups = inspector.connectedSets();
        for (Set group : componentGroups) {
            if (group.size() <= 1) continue;
            TreeSet<String> finalComponentNames = new TreeSet<String>();
            String id = null;
            for (GroupIdentifier componentIdentifier : group) {
                if (!this.componentGraph.outgoingEdgesOf((Object)componentIdentifier).isEmpty()) continue;
                finalComponentNames.add(componentIdentifier.getName());
                if (id != null) continue;
                id = componentIdentifier.getId();
            }
            String name = finalComponentNames.stream().collect(Collectors.joining(", "));
            GroupIdentifier groupIdentifier = new GroupIdentifier(id, "RMI server: " + name);
            for (GroupIdentifier vertex : group) {
                bundledGroups.put(vertex.getId(), groupIdentifier);
            }
        }
        RmiMatcher rmiMatcher = new RmiMatcher(this.matcher, bundledGroups, this.rmiClasses);
        return rmiMatcher;
    }

    GroupMatcher createMatcher() {
        return this.rmiMatcher;
    }

    private void addComponentsToGraph(JavaClass javaClass) {
        if (RmiMatcherFactory.isRemoteInterface(javaClass)) {
            this.addSubclassDependencies(Optional.empty(), null, javaClass);
        }
    }

    private void addSubclassDependencies(Optional<GroupIdentifier> dependingGroupIdentifier, JavaClass superClass, JavaClass javaClass) {
        JavaClass enclosingNamedClass = CodeNode.findEnclosingNamedClass(javaClass);
        if (!this.ignoredRmi.matches(enclosingNamedClass)) {
            Optional<GroupIdentifier> groupIdentifier = this.matcher.projectIdentifier(javaClass);
            groupIdentifier.ifPresent(gi -> {
                GroupIdentifier dgi;
                if (dependingGroupIdentifier.isPresent() && !(dgi = (GroupIdentifier)dependingGroupIdentifier.get()).equals(gi)) {
                    this.addRmiClass(superClass, dgi);
                    this.addRmiClass(javaClass, (GroupIdentifier)gi);
                    this.addEdge(dgi, (GroupIdentifier)gi);
                }
                if (this.mode == RmiMatcher.Mode.INSTANTIATIONS) {
                    Sets.union((Set)javaClass.getConstructorCallsToSelf(), (Set)javaClass.getConstructorReferencesToSelf()).forEach(access -> this.addConstructorDependencies((GroupIdentifier)gi, (JavaCodeUnitAccess<? extends AccessTarget.CodeUnitAccessTarget>)access));
                }
                Set subclasses = javaClass.getSubclasses();
                subclasses.forEach(x -> this.addSubclassDependencies(groupIdentifier, javaClass, (JavaClass)x));
            });
        }
    }

    private void addRmiClass(JavaClass javaClass, GroupIdentifier identifier) {
        this.rmiClasses.put(CodeNode.findEnclosingNamedClass(javaClass), identifier);
    }

    private void addConstructorDependencies(GroupIdentifier groupIdentifier, JavaCodeUnitAccess<? extends AccessTarget.CodeUnitAccessTarget> access) {
        JavaClass callingClass = access.getOriginOwner();
        Optional<GroupIdentifier> callingGroupIdentifier = this.matcher.projectIdentifier(callingClass);
        callingGroupIdentifier.ifPresent(cgi -> {
            if (!cgi.equals(groupIdentifier)) {
                this.addRmiClass(callingClass, (GroupIdentifier)cgi);
                this.addRmiClass(access.getTargetOwner(), groupIdentifier);
                this.addEdge(groupIdentifier, (GroupIdentifier)cgi);
            }
        });
    }

    private void addEdge(GroupIdentifier dependingGroupIdentifier, GroupIdentifier groupIdentifier) {
        this.componentGraph.addVertex((Object)dependingGroupIdentifier);
        this.componentGraph.addVertex((Object)groupIdentifier);
        this.componentGraph.addEdge((Object)dependingGroupIdentifier, (Object)groupIdentifier);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isRemoteInterface(JavaClass javaClass) {
        if (!javaClass.isInterface()) return false;
        if (!javaClass.getRawInterfaces().stream().map(HasName::getName).anyMatch(Remote.class.getName()::equals)) return false;
        return true;
    }
}

