/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Base64;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class NamespaceId
implements Serializable {
    private String namespace;
    private String name;

    /*
     * Enabled aggressive exception aggregation
     */
    public static NamespaceId decode(String encoding) {
        byte[] data = Base64.getDecoder().decode(encoding);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            NamespaceId namespaceId;
            try (DataInputStream dis = new DataInputStream(bais);){
                String namespace = dis.readUTF();
                String name = dis.readUTF();
                namespaceId = new NamespaceId(namespace, name);
            }
            return namespaceId;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed decoding namespace ID");
        }
    }

    public NamespaceId(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String encode() {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            String string;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                dos.writeUTF(this.namespace);
                dos.writeUTF(this.name);
                string = Base64.getEncoder().encodeToString(baos.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed encoding namespace ID '" + this.name + "'");
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        NamespaceId other = (NamespaceId)o;
        return other.getName().equals(this.name) && other.getNamespace().equals(this.namespace);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.namespace).append((Object)this.name).toHashCode();
    }
}

