#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.43.1
visibility:           public
id:                   hledger-1.43.1-H3nhzcTqWjY9A8WZjkhGAC
key:                  hledger-1.43.1-H3nhzcTqWjY9A8WZjkhGAC
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  9f8f13447d25cf367e034df6915c95af
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anchor Hledger.Cli.Anon
    Hledger.Cli.CliOptions Hledger.Cli.Commands
    Hledger.Cli.Commands.Accounts Hledger.Cli.Commands.Activity
    Hledger.Cli.Commands.Add Hledger.Cli.Commands.Aregister
    Hledger.Cli.Commands.Balance Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Run
    Hledger.Cli.Commands.Setup Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.Conf Hledger.Cli.DocFiles Hledger.Cli.Script
    Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.6.6/site-local/hledger-1.43.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hledger-1.43.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hledger-1.43.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.43.1-H3nhzcTqWjY9A8WZjkhGAC
depends:
    Decimal-0.5.2-IIe9wLiWUhH4Fx4Eysbzm9
    Diff-0.5-L7EMQ31ezbBFDqYO9yMkEp
    aeson-2.1.2.1-JZeWX2s1eQL7Ta3HF3w6fW
    ansi-terminal-1.0.2-3wM6DfsGeit89xAznbDC0C base-4.18.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-E2EkQI5shziHkHOdPiVHiM
    containers-0.6.7 data-default-0.7.1.3-EtVHsfbH5oIpJ9umzYHUz
    directory-1.3.8.5 extra-1.7.16-LWra3MmVE7hIjr4mBFp6lZ
    filepath-1.4.300.1 githash-0.1.6.3-1Ht0cPVU7ZGKXTqeGDFgaK
    hashable-1.4.7.0-L2Cc1YdcpYH9U2sZW5osde haskeline-0.8.2.1
    hledger-lib-1.43.1-LPNTL3wubGH4lZWao9RVsT
    http-client-0.7.19-B5USSZypF8s1UPWufciwbp
    http-types-0.12.4-Ab6499xPt6j7ocIybq2ygA
    lucid-2.11.20250303-BJeJa0SFmGhB7OczsClXHe
    math-functions-0.3.4.4-DHR0tTqnTrX13DRQxoWoDc
    megaparsec-9.7.0-I0qZdfD2x7QA5TPaNUjmTK
    microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    modern-uri-0.3.6.1-KZEw9KCS73hCRBtHcRP2Pk mtl-2.3.1
    process-1.6.19.0 regex-tdfa-1.3.2.5-qZoXOptISAJcpXFSPLOTl
    req-3.13.4-Gu7VgEDpgpBANxIzcCbNhP
    safe-0.3.21-EsRFO8M87PCEtDqVSuBNfo
    shakespeare-2.1.7-9GhatDl4bgQKJXbbqjeqzs
    split-0.2.5-LIo01L9HFTI75RwsLzYVkn
    tabular-0.2.2.8-Ly9fepE9sHFB2l1Bgv9bkV
    tasty-1.5.2-QJSnUao0iU3Q0YGBz8WKt
    temporary-1.3-D64vl65CCuJL1VfIJwvdvy text-2.0.2
    text-ansi-0.3.0.1-CgrUaWcQSs45TbkaA3ATvC time-1.12.2
    timeit-2.0-DwmItJuhuSm6aktMh1S1ZM transformers-0.6.1.0
    unordered-containers-0.2.20.1-8SON4238u8N3rDHPceHjHx
    utf8-string-1.0.2-2At7L47Qsbs4rlGLlJEQb1
    utility-ht-0.0.17.2-9uGhXuhesCw7Nh17hQxcvM
    wizards-1.0.3-EMndOhiYuHdGTEqrX5mo0v

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

