/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

An interface method to the modular ITKv4 registration framework.


This interface method class encapsulates typical registration usage by
incorporating all the necessary elements for performing a simple image
registration between two images. This method also allows for
multistage registration whereby each stage is characterized by
possibly different transforms and different image metrics. For
example, many users will want to perform a linear registration
followed by deformable registration where both stages are performed in
multiple levels. Each level can be characterized by:


the resolution of the virtual domain image (see below)

smoothing of the fixed and moving images
 Multiple stages are handled by linking multiple instantiations of
this class where the output transform is added to the optional
composite transform input.


See:
 itk::ImageRegistrationMethodv4

 itk::ImageToImageMetricv4

 itk::ObjectToObjectOptimizerBaseTemplate


C++ includes: sitkImageRegistrationMethod.h
*/
public class ImageRegistrationMethod extends ProcessObject {
  private transient long swigCPtr;

  protected ImageRegistrationMethod(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ImageRegistrationMethod_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ImageRegistrationMethod obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ImageRegistrationMethod obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
itk::simple::ImageRegistrationMethod::~ImageRegistrationMethod() override
*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ImageRegistrationMethod(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ImageRegistrationMethod::ImageRegistrationMethod()
*/
public  ImageRegistrationMethod() {
    this(SimpleITKJNI.new_ImageRegistrationMethod(), true);
  }

  /**
std::string itk::simple::ImageRegistrationMethod::GetName() const override

return user readable name for the filter

*/
public  String getName() {
    return SimpleITKJNI.ImageRegistrationMethod_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ImageRegistrationMethod::ToString() const override

Print the information about the object to a string.


If called when the process is being executed ( during a callback ),
the ITK Optimizer and Transform objects will be printed.

*/
public  String toString() {
    return SimpleITKJNI.ImageRegistrationMethod_toString(swigCPtr, this);
  }

  public InterpolatorEnum getInterpolator() {
    return InterpolatorEnum.swigToEnum(SimpleITKJNI.ImageRegistrationMethod_getInterpolator(swigCPtr, this));
  }

  public void setInterpolator(InterpolatorEnum Interpolator) {
    SimpleITKJNI.ImageRegistrationMethod_setInterpolator(swigCPtr, this, Interpolator.swigValue());
  }

  public void setInitialTransform(Transform transform, boolean inPlace) {
    SimpleITKJNI.ImageRegistrationMethod_setInitialTransform__SWIG_0(swigCPtr, this, Transform.getCPtr(transform), transform, inPlace);
  }

  public void setInitialTransform(Transform transform) {
    SimpleITKJNI.ImageRegistrationMethod_setInitialTransform__SWIG_1(swigCPtr, this, Transform.getCPtr(transform), transform);
  }

  public Transform getInitialTransform() {
    return new Transform(SimpleITKJNI.ImageRegistrationMethod_getInitialTransform(swigCPtr, this), true);
  }

  public boolean getInitialTransformInPlace() {
    return SimpleITKJNI.ImageRegistrationMethod_getInitialTransformInPlace(swigCPtr, this);
  }

  /**
void itk::simple::ImageRegistrationMethod::SetInitialTransformAsBSpline(BSplineTransform &amp;transform, bool inPlace=true, const
std::vector&lt; unsigned int &gt; &amp;scaleFactors=std::vector&lt;
unsigned int &gt;())

Set an initial BSpline transform to optimize.


A specialization of SetInitialTransform for BSplineTransforms which
can take an additional scaleFactors parameter. The scaleFactors
specifies the a isotropic scaling factor per level for the BSpline
transform mesh size with respect to the initial transform. For example
to double the BSpline mesh resolution at each of 3 levels the vector
[1,2,4] should be provided.

If a per level scale factor is 0 or omitted than no transform adapter
will be created for that level.


See:
 itk::BSplineTransformParametersAdaptor


*/
public  void setInitialTransformAsBSpline(BSplineTransform transform, boolean inPlace, VectorUInt32 scaleFactors) {
    SimpleITKJNI.ImageRegistrationMethod_setInitialTransformAsBSpline__SWIG_0(swigCPtr, this, BSplineTransform.getCPtr(transform), transform, inPlace, VectorUInt32.getCPtr(scaleFactors), scaleFactors);
  }

  /**
void itk::simple::ImageRegistrationMethod::SetInitialTransformAsBSpline(BSplineTransform &amp;transform, bool inPlace=true, const
std::vector&lt; unsigned int &gt; &amp;scaleFactors=std::vector&lt;
unsigned int &gt;())

Set an initial BSpline transform to optimize.


A specialization of SetInitialTransform for BSplineTransforms which
can take an additional scaleFactors parameter. The scaleFactors
specifies the a isotropic scaling factor per level for the BSpline
transform mesh size with respect to the initial transform. For example
to double the BSpline mesh resolution at each of 3 levels the vector
[1,2,4] should be provided.

If a per level scale factor is 0 or omitted than no transform adapter
will be created for that level.


See:
 itk::BSplineTransformParametersAdaptor


*/
public  void setInitialTransformAsBSpline(BSplineTransform transform, boolean inPlace) {
    SimpleITKJNI.ImageRegistrationMethod_setInitialTransformAsBSpline__SWIG_1(swigCPtr, this, BSplineTransform.getCPtr(transform), transform, inPlace);
  }

  /**
void itk::simple::ImageRegistrationMethod::SetInitialTransformAsBSpline(BSplineTransform &amp;transform, bool inPlace=true, const
std::vector&lt; unsigned int &gt; &amp;scaleFactors=std::vector&lt;
unsigned int &gt;())

Set an initial BSpline transform to optimize.


A specialization of SetInitialTransform for BSplineTransforms which
can take an additional scaleFactors parameter. The scaleFactors
specifies the a isotropic scaling factor per level for the BSpline
transform mesh size with respect to the initial transform. For example
to double the BSpline mesh resolution at each of 3 levels the vector
[1,2,4] should be provided.

If a per level scale factor is 0 or omitted than no transform adapter
will be created for that level.


See:
 itk::BSplineTransformParametersAdaptor


*/
public  void setInitialTransformAsBSpline(BSplineTransform transform) {
    SimpleITKJNI.ImageRegistrationMethod_setInitialTransformAsBSpline__SWIG_2(swigCPtr, this, BSplineTransform.getCPtr(transform), transform);
  }

  public void setMovingInitialTransform(Transform transform) {
    SimpleITKJNI.ImageRegistrationMethod_setMovingInitialTransform(swigCPtr, this, Transform.getCPtr(transform), transform);
  }

  public Transform getMovingInitialTransform() {
    return new Transform(SimpleITKJNI.ImageRegistrationMethod_getMovingInitialTransform(swigCPtr, this), true);
  }

  public void setFixedInitialTransform(Transform transform) {
    SimpleITKJNI.ImageRegistrationMethod_setFixedInitialTransform(swigCPtr, this, Transform.getCPtr(transform), transform);
  }

  public Transform getFixedInitialTransform() {
    return new Transform(SimpleITKJNI.ImageRegistrationMethod_getFixedInitialTransform(swigCPtr, this), true);
  }

  public void setVirtualDomain(VectorUInt32 virtualSize, VectorDouble virtualOrigin, VectorDouble virtualSpacing, VectorDouble virtualDirection) {
    SimpleITKJNI.ImageRegistrationMethod_setVirtualDomain(swigCPtr, this, VectorUInt32.getCPtr(virtualSize), virtualSize, VectorDouble.getCPtr(virtualOrigin), virtualOrigin, VectorDouble.getCPtr(virtualSpacing), virtualSpacing, VectorDouble.getCPtr(virtualDirection), virtualDirection);
  }

  public void setVirtualDomainFromImage(Image virtualImage) {
    SimpleITKJNI.ImageRegistrationMethod_setVirtualDomainFromImage(swigCPtr, this, Image.getCPtr(virtualImage), virtualImage);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetMetricAsANTSNeighborhoodCorrelation(unsigned int radius)

Use normalized cross correlation using a small neighborhood for each
voxel between two images, with speed optimizations for dense
registration.



See:
 itk::ANTSNeighborhoodCorrelationImageToImageMetricv4


*/
public  void setMetricAsANTSNeighborhoodCorrelation(long radius) {
    SimpleITKJNI.ImageRegistrationMethod_setMetricAsANTSNeighborhoodCorrelation(swigCPtr, this, radius);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetMetricAsCorrelation()

Use negative normalized cross correlation image metric.



See:
 itk::CorrelationImageToImageMetricv4


*/
public  void setMetricAsCorrelation() {
    SimpleITKJNI.ImageRegistrationMethod_setMetricAsCorrelation(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetMetricAsDemons(double intensityDifferenceThreshold=0.001)

Use demons image metric.



See:
 itk::DemonsImageToImageMetricv4


*/
public  void setMetricAsDemons(double intensityDifferenceThreshold) {
    SimpleITKJNI.ImageRegistrationMethod_setMetricAsDemons__SWIG_0(swigCPtr, this, intensityDifferenceThreshold);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetMetricAsDemons(double intensityDifferenceThreshold=0.001)

Use demons image metric.



See:
 itk::DemonsImageToImageMetricv4


*/
public  void setMetricAsDemons() {
    SimpleITKJNI.ImageRegistrationMethod_setMetricAsDemons__SWIG_1(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetMetricAsJointHistogramMutualInformation(unsigned int numberOfHistogramBins=20, double
varianceForJointPDFSmoothing=1.5)

Use mutual information between two images.



See:
 itk::JointHistogramMutualInformationImageToImageMetricv4


*/
public  void setMetricAsJointHistogramMutualInformation(long numberOfHistogramBins, double varianceForJointPDFSmoothing) {
    SimpleITKJNI.ImageRegistrationMethod_setMetricAsJointHistogramMutualInformation__SWIG_0(swigCPtr, this, numberOfHistogramBins, varianceForJointPDFSmoothing);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetMetricAsJointHistogramMutualInformation(unsigned int numberOfHistogramBins=20, double
varianceForJointPDFSmoothing=1.5)

Use mutual information between two images.



See:
 itk::JointHistogramMutualInformationImageToImageMetricv4


*/
public  void setMetricAsJointHistogramMutualInformation(long numberOfHistogramBins) {
    SimpleITKJNI.ImageRegistrationMethod_setMetricAsJointHistogramMutualInformation__SWIG_1(swigCPtr, this, numberOfHistogramBins);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetMetricAsJointHistogramMutualInformation(unsigned int numberOfHistogramBins=20, double
varianceForJointPDFSmoothing=1.5)

Use mutual information between two images.



See:
 itk::JointHistogramMutualInformationImageToImageMetricv4


*/
public  void setMetricAsJointHistogramMutualInformation() {
    SimpleITKJNI.ImageRegistrationMethod_setMetricAsJointHistogramMutualInformation__SWIG_2(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetMetricAsMeanSquares()

Use negative means squares image metric.



See:
 itk::MeanSquaresImageToImageMetricv4


*/
public  void setMetricAsMeanSquares() {
    SimpleITKJNI.ImageRegistrationMethod_setMetricAsMeanSquares(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetMetricAsMattesMutualInformation(unsigned int numberOfHistogramBins=50)

Use the mutual information between two images to be registered using
the method of Mattes et al.



See:
 itk::MattesMutualInformationImageToImageMetricv4


*/
public  void setMetricAsMattesMutualInformation(long numberOfHistogramBins) {
    SimpleITKJNI.ImageRegistrationMethod_setMetricAsMattesMutualInformation__SWIG_0(swigCPtr, this, numberOfHistogramBins);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetMetricAsMattesMutualInformation(unsigned int numberOfHistogramBins=50)

Use the mutual information between two images to be registered using
the method of Mattes et al.



See:
 itk::MattesMutualInformationImageToImageMetricv4


*/
public  void setMetricAsMattesMutualInformation() {
    SimpleITKJNI.ImageRegistrationMethod_setMetricAsMattesMutualInformation__SWIG_1(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsConjugateGradientLineSearch(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double
lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Conjugate gradient descent optimizer with a golden section line search
for nonlinear optimization.



See:
 itk::ConjugateGradientLineSearchOptimizerv4Template


*/
public  void setOptimizerAsConjugateGradientLineSearch(double learningRate, long numberOfIterations, double convergenceMinimumValue, long convergenceWindowSize, double lineSearchLowerLimit, double lineSearchUpperLimit, double lineSearchEpsilon, long lineSearchMaximumIterations, ImageRegistrationMethod.EstimateLearningRateType estimateLearningRate, double maximumStepSizeInPhysicalUnits) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsConjugateGradientLineSearch__SWIG_0(swigCPtr, this, learningRate, numberOfIterations, convergenceMinimumValue, convergenceWindowSize, lineSearchLowerLimit, lineSearchUpperLimit, lineSearchEpsilon, lineSearchMaximumIterations, estimateLearningRate.swigValue(), maximumStepSizeInPhysicalUnits);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsConjugateGradientLineSearch(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double
lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Conjugate gradient descent optimizer with a golden section line search
for nonlinear optimization.



See:
 itk::ConjugateGradientLineSearchOptimizerv4Template


*/
public  void setOptimizerAsConjugateGradientLineSearch(double learningRate, long numberOfIterations, double convergenceMinimumValue, long convergenceWindowSize, double lineSearchLowerLimit, double lineSearchUpperLimit, double lineSearchEpsilon, long lineSearchMaximumIterations, ImageRegistrationMethod.EstimateLearningRateType estimateLearningRate) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsConjugateGradientLineSearch__SWIG_1(swigCPtr, this, learningRate, numberOfIterations, convergenceMinimumValue, convergenceWindowSize, lineSearchLowerLimit, lineSearchUpperLimit, lineSearchEpsilon, lineSearchMaximumIterations, estimateLearningRate.swigValue());
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsConjugateGradientLineSearch(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double
lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Conjugate gradient descent optimizer with a golden section line search
for nonlinear optimization.



See:
 itk::ConjugateGradientLineSearchOptimizerv4Template


*/
public  void setOptimizerAsConjugateGradientLineSearch(double learningRate, long numberOfIterations, double convergenceMinimumValue, long convergenceWindowSize, double lineSearchLowerLimit, double lineSearchUpperLimit, double lineSearchEpsilon, long lineSearchMaximumIterations) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsConjugateGradientLineSearch__SWIG_2(swigCPtr, this, learningRate, numberOfIterations, convergenceMinimumValue, convergenceWindowSize, lineSearchLowerLimit, lineSearchUpperLimit, lineSearchEpsilon, lineSearchMaximumIterations);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsConjugateGradientLineSearch(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double
lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Conjugate gradient descent optimizer with a golden section line search
for nonlinear optimization.



See:
 itk::ConjugateGradientLineSearchOptimizerv4Template


*/
public  void setOptimizerAsConjugateGradientLineSearch(double learningRate, long numberOfIterations, double convergenceMinimumValue, long convergenceWindowSize, double lineSearchLowerLimit, double lineSearchUpperLimit, double lineSearchEpsilon) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsConjugateGradientLineSearch__SWIG_3(swigCPtr, this, learningRate, numberOfIterations, convergenceMinimumValue, convergenceWindowSize, lineSearchLowerLimit, lineSearchUpperLimit, lineSearchEpsilon);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsConjugateGradientLineSearch(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double
lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Conjugate gradient descent optimizer with a golden section line search
for nonlinear optimization.



See:
 itk::ConjugateGradientLineSearchOptimizerv4Template


*/
public  void setOptimizerAsConjugateGradientLineSearch(double learningRate, long numberOfIterations, double convergenceMinimumValue, long convergenceWindowSize, double lineSearchLowerLimit, double lineSearchUpperLimit) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsConjugateGradientLineSearch__SWIG_4(swigCPtr, this, learningRate, numberOfIterations, convergenceMinimumValue, convergenceWindowSize, lineSearchLowerLimit, lineSearchUpperLimit);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsConjugateGradientLineSearch(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double
lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Conjugate gradient descent optimizer with a golden section line search
for nonlinear optimization.



See:
 itk::ConjugateGradientLineSearchOptimizerv4Template


*/
public  void setOptimizerAsConjugateGradientLineSearch(double learningRate, long numberOfIterations, double convergenceMinimumValue, long convergenceWindowSize, double lineSearchLowerLimit) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsConjugateGradientLineSearch__SWIG_5(swigCPtr, this, learningRate, numberOfIterations, convergenceMinimumValue, convergenceWindowSize, lineSearchLowerLimit);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsConjugateGradientLineSearch(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double
lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Conjugate gradient descent optimizer with a golden section line search
for nonlinear optimization.



See:
 itk::ConjugateGradientLineSearchOptimizerv4Template


*/
public  void setOptimizerAsConjugateGradientLineSearch(double learningRate, long numberOfIterations, double convergenceMinimumValue, long convergenceWindowSize) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsConjugateGradientLineSearch__SWIG_6(swigCPtr, this, learningRate, numberOfIterations, convergenceMinimumValue, convergenceWindowSize);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsConjugateGradientLineSearch(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double
lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Conjugate gradient descent optimizer with a golden section line search
for nonlinear optimization.



See:
 itk::ConjugateGradientLineSearchOptimizerv4Template


*/
public  void setOptimizerAsConjugateGradientLineSearch(double learningRate, long numberOfIterations, double convergenceMinimumValue) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsConjugateGradientLineSearch__SWIG_7(swigCPtr, this, learningRate, numberOfIterations, convergenceMinimumValue);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsConjugateGradientLineSearch(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double
lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Conjugate gradient descent optimizer with a golden section line search
for nonlinear optimization.



See:
 itk::ConjugateGradientLineSearchOptimizerv4Template


*/
public  void setOptimizerAsConjugateGradientLineSearch(double learningRate, long numberOfIterations) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsConjugateGradientLineSearch__SWIG_8(swigCPtr, this, learningRate, numberOfIterations);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsRegularStepGradientDescent(double learningRate, double minStep, unsigned int numberOfIterations,
double relaxationFactor=0.5, double gradientMagnitudeTolerance=1e-4,
EstimateLearningRateType estimateLearningRate=Never, double
maximumStepSizeInPhysicalUnits=0.0)

Regular Step Gradient descent optimizer.



See:
 itk::RegularStepGradientDescentOptimizerv4


*/
public  void setOptimizerAsRegularStepGradientDescent(double learningRate, double minStep, long numberOfIterations, double relaxationFactor, double gradientMagnitudeTolerance, ImageRegistrationMethod.EstimateLearningRateType estimateLearningRate, double maximumStepSizeInPhysicalUnits) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsRegularStepGradientDescent__SWIG_0(swigCPtr, this, learningRate, minStep, numberOfIterations, relaxationFactor, gradientMagnitudeTolerance, estimateLearningRate.swigValue(), maximumStepSizeInPhysicalUnits);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsRegularStepGradientDescent(double learningRate, double minStep, unsigned int numberOfIterations,
double relaxationFactor=0.5, double gradientMagnitudeTolerance=1e-4,
EstimateLearningRateType estimateLearningRate=Never, double
maximumStepSizeInPhysicalUnits=0.0)

Regular Step Gradient descent optimizer.



See:
 itk::RegularStepGradientDescentOptimizerv4


*/
public  void setOptimizerAsRegularStepGradientDescent(double learningRate, double minStep, long numberOfIterations, double relaxationFactor, double gradientMagnitudeTolerance, ImageRegistrationMethod.EstimateLearningRateType estimateLearningRate) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsRegularStepGradientDescent__SWIG_1(swigCPtr, this, learningRate, minStep, numberOfIterations, relaxationFactor, gradientMagnitudeTolerance, estimateLearningRate.swigValue());
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsRegularStepGradientDescent(double learningRate, double minStep, unsigned int numberOfIterations,
double relaxationFactor=0.5, double gradientMagnitudeTolerance=1e-4,
EstimateLearningRateType estimateLearningRate=Never, double
maximumStepSizeInPhysicalUnits=0.0)

Regular Step Gradient descent optimizer.



See:
 itk::RegularStepGradientDescentOptimizerv4


*/
public  void setOptimizerAsRegularStepGradientDescent(double learningRate, double minStep, long numberOfIterations, double relaxationFactor, double gradientMagnitudeTolerance) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsRegularStepGradientDescent__SWIG_2(swigCPtr, this, learningRate, minStep, numberOfIterations, relaxationFactor, gradientMagnitudeTolerance);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsRegularStepGradientDescent(double learningRate, double minStep, unsigned int numberOfIterations,
double relaxationFactor=0.5, double gradientMagnitudeTolerance=1e-4,
EstimateLearningRateType estimateLearningRate=Never, double
maximumStepSizeInPhysicalUnits=0.0)

Regular Step Gradient descent optimizer.



See:
 itk::RegularStepGradientDescentOptimizerv4


*/
public  void setOptimizerAsRegularStepGradientDescent(double learningRate, double minStep, long numberOfIterations, double relaxationFactor) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsRegularStepGradientDescent__SWIG_3(swigCPtr, this, learningRate, minStep, numberOfIterations, relaxationFactor);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsRegularStepGradientDescent(double learningRate, double minStep, unsigned int numberOfIterations,
double relaxationFactor=0.5, double gradientMagnitudeTolerance=1e-4,
EstimateLearningRateType estimateLearningRate=Never, double
maximumStepSizeInPhysicalUnits=0.0)

Regular Step Gradient descent optimizer.



See:
 itk::RegularStepGradientDescentOptimizerv4


*/
public  void setOptimizerAsRegularStepGradientDescent(double learningRate, double minStep, long numberOfIterations) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsRegularStepGradientDescent__SWIG_4(swigCPtr, this, learningRate, minStep, numberOfIterations);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsGradientDescent(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Gradient descent optimizer.



See:
 itk::GradientDescentOptimizerv4Template


*/
public  void setOptimizerAsGradientDescent(double learningRate, long numberOfIterations, double convergenceMinimumValue, long convergenceWindowSize, ImageRegistrationMethod.EstimateLearningRateType estimateLearningRate, double maximumStepSizeInPhysicalUnits) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsGradientDescent__SWIG_0(swigCPtr, this, learningRate, numberOfIterations, convergenceMinimumValue, convergenceWindowSize, estimateLearningRate.swigValue(), maximumStepSizeInPhysicalUnits);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsGradientDescent(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Gradient descent optimizer.



See:
 itk::GradientDescentOptimizerv4Template


*/
public  void setOptimizerAsGradientDescent(double learningRate, long numberOfIterations, double convergenceMinimumValue, long convergenceWindowSize, ImageRegistrationMethod.EstimateLearningRateType estimateLearningRate) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsGradientDescent__SWIG_1(swigCPtr, this, learningRate, numberOfIterations, convergenceMinimumValue, convergenceWindowSize, estimateLearningRate.swigValue());
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsGradientDescent(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Gradient descent optimizer.



See:
 itk::GradientDescentOptimizerv4Template


*/
public  void setOptimizerAsGradientDescent(double learningRate, long numberOfIterations, double convergenceMinimumValue, long convergenceWindowSize) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsGradientDescent__SWIG_2(swigCPtr, this, learningRate, numberOfIterations, convergenceMinimumValue, convergenceWindowSize);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsGradientDescent(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Gradient descent optimizer.



See:
 itk::GradientDescentOptimizerv4Template


*/
public  void setOptimizerAsGradientDescent(double learningRate, long numberOfIterations, double convergenceMinimumValue) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsGradientDescent__SWIG_3(swigCPtr, this, learningRate, numberOfIterations, convergenceMinimumValue);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsGradientDescent(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Gradient descent optimizer.



See:
 itk::GradientDescentOptimizerv4Template


*/
public  void setOptimizerAsGradientDescent(double learningRate, long numberOfIterations) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsGradientDescent__SWIG_4(swigCPtr, this, learningRate, numberOfIterations);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsGradientDescentLineSearch(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double
lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Gradient descent optimizer with a golden section line search.



See:
 itk::GradientDescentLineSearchOptimizerv4Template


*/
public  void setOptimizerAsGradientDescentLineSearch(double learningRate, long numberOfIterations, double convergenceMinimumValue, long convergenceWindowSize, double lineSearchLowerLimit, double lineSearchUpperLimit, double lineSearchEpsilon, long lineSearchMaximumIterations, ImageRegistrationMethod.EstimateLearningRateType estimateLearningRate, double maximumStepSizeInPhysicalUnits) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsGradientDescentLineSearch__SWIG_0(swigCPtr, this, learningRate, numberOfIterations, convergenceMinimumValue, convergenceWindowSize, lineSearchLowerLimit, lineSearchUpperLimit, lineSearchEpsilon, lineSearchMaximumIterations, estimateLearningRate.swigValue(), maximumStepSizeInPhysicalUnits);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsGradientDescentLineSearch(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double
lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Gradient descent optimizer with a golden section line search.



See:
 itk::GradientDescentLineSearchOptimizerv4Template


*/
public  void setOptimizerAsGradientDescentLineSearch(double learningRate, long numberOfIterations, double convergenceMinimumValue, long convergenceWindowSize, double lineSearchLowerLimit, double lineSearchUpperLimit, double lineSearchEpsilon, long lineSearchMaximumIterations, ImageRegistrationMethod.EstimateLearningRateType estimateLearningRate) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsGradientDescentLineSearch__SWIG_1(swigCPtr, this, learningRate, numberOfIterations, convergenceMinimumValue, convergenceWindowSize, lineSearchLowerLimit, lineSearchUpperLimit, lineSearchEpsilon, lineSearchMaximumIterations, estimateLearningRate.swigValue());
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsGradientDescentLineSearch(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double
lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Gradient descent optimizer with a golden section line search.



See:
 itk::GradientDescentLineSearchOptimizerv4Template


*/
public  void setOptimizerAsGradientDescentLineSearch(double learningRate, long numberOfIterations, double convergenceMinimumValue, long convergenceWindowSize, double lineSearchLowerLimit, double lineSearchUpperLimit, double lineSearchEpsilon, long lineSearchMaximumIterations) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsGradientDescentLineSearch__SWIG_2(swigCPtr, this, learningRate, numberOfIterations, convergenceMinimumValue, convergenceWindowSize, lineSearchLowerLimit, lineSearchUpperLimit, lineSearchEpsilon, lineSearchMaximumIterations);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsGradientDescentLineSearch(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double
lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Gradient descent optimizer with a golden section line search.



See:
 itk::GradientDescentLineSearchOptimizerv4Template


*/
public  void setOptimizerAsGradientDescentLineSearch(double learningRate, long numberOfIterations, double convergenceMinimumValue, long convergenceWindowSize, double lineSearchLowerLimit, double lineSearchUpperLimit, double lineSearchEpsilon) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsGradientDescentLineSearch__SWIG_3(swigCPtr, this, learningRate, numberOfIterations, convergenceMinimumValue, convergenceWindowSize, lineSearchLowerLimit, lineSearchUpperLimit, lineSearchEpsilon);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsGradientDescentLineSearch(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double
lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Gradient descent optimizer with a golden section line search.



See:
 itk::GradientDescentLineSearchOptimizerv4Template


*/
public  void setOptimizerAsGradientDescentLineSearch(double learningRate, long numberOfIterations, double convergenceMinimumValue, long convergenceWindowSize, double lineSearchLowerLimit, double lineSearchUpperLimit) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsGradientDescentLineSearch__SWIG_4(swigCPtr, this, learningRate, numberOfIterations, convergenceMinimumValue, convergenceWindowSize, lineSearchLowerLimit, lineSearchUpperLimit);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsGradientDescentLineSearch(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double
lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Gradient descent optimizer with a golden section line search.



See:
 itk::GradientDescentLineSearchOptimizerv4Template


*/
public  void setOptimizerAsGradientDescentLineSearch(double learningRate, long numberOfIterations, double convergenceMinimumValue, long convergenceWindowSize, double lineSearchLowerLimit) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsGradientDescentLineSearch__SWIG_5(swigCPtr, this, learningRate, numberOfIterations, convergenceMinimumValue, convergenceWindowSize, lineSearchLowerLimit);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsGradientDescentLineSearch(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double
lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Gradient descent optimizer with a golden section line search.



See:
 itk::GradientDescentLineSearchOptimizerv4Template


*/
public  void setOptimizerAsGradientDescentLineSearch(double learningRate, long numberOfIterations, double convergenceMinimumValue, long convergenceWindowSize) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsGradientDescentLineSearch__SWIG_6(swigCPtr, this, learningRate, numberOfIterations, convergenceMinimumValue, convergenceWindowSize);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsGradientDescentLineSearch(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double
lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Gradient descent optimizer with a golden section line search.



See:
 itk::GradientDescentLineSearchOptimizerv4Template


*/
public  void setOptimizerAsGradientDescentLineSearch(double learningRate, long numberOfIterations, double convergenceMinimumValue) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsGradientDescentLineSearch__SWIG_7(swigCPtr, this, learningRate, numberOfIterations, convergenceMinimumValue);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsGradientDescentLineSearch(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double
lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Gradient descent optimizer with a golden section line search.



See:
 itk::GradientDescentLineSearchOptimizerv4Template


*/
public  void setOptimizerAsGradientDescentLineSearch(double learningRate, long numberOfIterations) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsGradientDescentLineSearch__SWIG_8(swigCPtr, this, learningRate, numberOfIterations);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGSB(double gradientConvergenceTolerance=1e-5, unsigned int
numberOfIterations=500, unsigned int maximumNumberOfCorrections=5,
unsigned int maximumNumberOfFunctionEvaluations=2000, double
costFunctionConvergenceFactor=1e+7, double
lowerBound=std::numeric_limits&lt; double &gt;::min(), double
upperBound=std::numeric_limits&lt; double &gt;::max(), bool
trace=false)

Limited memory Broyden Fletcher Goldfarb Shannon minimization with
simple bounds.


The default parameters utilize LBFGSB in unbounded mode.


See:
 itk::LBFGSBOptimizerv4


*/
public  void setOptimizerAsLBFGSB(double gradientConvergenceTolerance, long numberOfIterations, long maximumNumberOfCorrections, long maximumNumberOfFunctionEvaluations, double costFunctionConvergenceFactor, double lowerBound, double upperBound, boolean trace) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsLBFGSB__SWIG_0(swigCPtr, this, gradientConvergenceTolerance, numberOfIterations, maximumNumberOfCorrections, maximumNumberOfFunctionEvaluations, costFunctionConvergenceFactor, lowerBound, upperBound, trace);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGSB(double gradientConvergenceTolerance=1e-5, unsigned int
numberOfIterations=500, unsigned int maximumNumberOfCorrections=5,
unsigned int maximumNumberOfFunctionEvaluations=2000, double
costFunctionConvergenceFactor=1e+7, double
lowerBound=std::numeric_limits&lt; double &gt;::min(), double
upperBound=std::numeric_limits&lt; double &gt;::max(), bool
trace=false)

Limited memory Broyden Fletcher Goldfarb Shannon minimization with
simple bounds.


The default parameters utilize LBFGSB in unbounded mode.


See:
 itk::LBFGSBOptimizerv4


*/
public  void setOptimizerAsLBFGSB(double gradientConvergenceTolerance, long numberOfIterations, long maximumNumberOfCorrections, long maximumNumberOfFunctionEvaluations, double costFunctionConvergenceFactor, double lowerBound, double upperBound) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsLBFGSB__SWIG_1(swigCPtr, this, gradientConvergenceTolerance, numberOfIterations, maximumNumberOfCorrections, maximumNumberOfFunctionEvaluations, costFunctionConvergenceFactor, lowerBound, upperBound);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGSB(double gradientConvergenceTolerance=1e-5, unsigned int
numberOfIterations=500, unsigned int maximumNumberOfCorrections=5,
unsigned int maximumNumberOfFunctionEvaluations=2000, double
costFunctionConvergenceFactor=1e+7, double
lowerBound=std::numeric_limits&lt; double &gt;::min(), double
upperBound=std::numeric_limits&lt; double &gt;::max(), bool
trace=false)

Limited memory Broyden Fletcher Goldfarb Shannon minimization with
simple bounds.


The default parameters utilize LBFGSB in unbounded mode.


See:
 itk::LBFGSBOptimizerv4


*/
public  void setOptimizerAsLBFGSB(double gradientConvergenceTolerance, long numberOfIterations, long maximumNumberOfCorrections, long maximumNumberOfFunctionEvaluations, double costFunctionConvergenceFactor, double lowerBound) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsLBFGSB__SWIG_2(swigCPtr, this, gradientConvergenceTolerance, numberOfIterations, maximumNumberOfCorrections, maximumNumberOfFunctionEvaluations, costFunctionConvergenceFactor, lowerBound);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGSB(double gradientConvergenceTolerance=1e-5, unsigned int
numberOfIterations=500, unsigned int maximumNumberOfCorrections=5,
unsigned int maximumNumberOfFunctionEvaluations=2000, double
costFunctionConvergenceFactor=1e+7, double
lowerBound=std::numeric_limits&lt; double &gt;::min(), double
upperBound=std::numeric_limits&lt; double &gt;::max(), bool
trace=false)

Limited memory Broyden Fletcher Goldfarb Shannon minimization with
simple bounds.


The default parameters utilize LBFGSB in unbounded mode.


See:
 itk::LBFGSBOptimizerv4


*/
public  void setOptimizerAsLBFGSB(double gradientConvergenceTolerance, long numberOfIterations, long maximumNumberOfCorrections, long maximumNumberOfFunctionEvaluations, double costFunctionConvergenceFactor) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsLBFGSB__SWIG_3(swigCPtr, this, gradientConvergenceTolerance, numberOfIterations, maximumNumberOfCorrections, maximumNumberOfFunctionEvaluations, costFunctionConvergenceFactor);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGSB(double gradientConvergenceTolerance=1e-5, unsigned int
numberOfIterations=500, unsigned int maximumNumberOfCorrections=5,
unsigned int maximumNumberOfFunctionEvaluations=2000, double
costFunctionConvergenceFactor=1e+7, double
lowerBound=std::numeric_limits&lt; double &gt;::min(), double
upperBound=std::numeric_limits&lt; double &gt;::max(), bool
trace=false)

Limited memory Broyden Fletcher Goldfarb Shannon minimization with
simple bounds.


The default parameters utilize LBFGSB in unbounded mode.


See:
 itk::LBFGSBOptimizerv4


*/
public  void setOptimizerAsLBFGSB(double gradientConvergenceTolerance, long numberOfIterations, long maximumNumberOfCorrections, long maximumNumberOfFunctionEvaluations) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsLBFGSB__SWIG_4(swigCPtr, this, gradientConvergenceTolerance, numberOfIterations, maximumNumberOfCorrections, maximumNumberOfFunctionEvaluations);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGSB(double gradientConvergenceTolerance=1e-5, unsigned int
numberOfIterations=500, unsigned int maximumNumberOfCorrections=5,
unsigned int maximumNumberOfFunctionEvaluations=2000, double
costFunctionConvergenceFactor=1e+7, double
lowerBound=std::numeric_limits&lt; double &gt;::min(), double
upperBound=std::numeric_limits&lt; double &gt;::max(), bool
trace=false)

Limited memory Broyden Fletcher Goldfarb Shannon minimization with
simple bounds.


The default parameters utilize LBFGSB in unbounded mode.


See:
 itk::LBFGSBOptimizerv4


*/
public  void setOptimizerAsLBFGSB(double gradientConvergenceTolerance, long numberOfIterations, long maximumNumberOfCorrections) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsLBFGSB__SWIG_5(swigCPtr, this, gradientConvergenceTolerance, numberOfIterations, maximumNumberOfCorrections);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGSB(double gradientConvergenceTolerance=1e-5, unsigned int
numberOfIterations=500, unsigned int maximumNumberOfCorrections=5,
unsigned int maximumNumberOfFunctionEvaluations=2000, double
costFunctionConvergenceFactor=1e+7, double
lowerBound=std::numeric_limits&lt; double &gt;::min(), double
upperBound=std::numeric_limits&lt; double &gt;::max(), bool
trace=false)

Limited memory Broyden Fletcher Goldfarb Shannon minimization with
simple bounds.


The default parameters utilize LBFGSB in unbounded mode.


See:
 itk::LBFGSBOptimizerv4


*/
public  void setOptimizerAsLBFGSB(double gradientConvergenceTolerance, long numberOfIterations) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsLBFGSB__SWIG_6(swigCPtr, this, gradientConvergenceTolerance, numberOfIterations);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGSB(double gradientConvergenceTolerance=1e-5, unsigned int
numberOfIterations=500, unsigned int maximumNumberOfCorrections=5,
unsigned int maximumNumberOfFunctionEvaluations=2000, double
costFunctionConvergenceFactor=1e+7, double
lowerBound=std::numeric_limits&lt; double &gt;::min(), double
upperBound=std::numeric_limits&lt; double &gt;::max(), bool
trace=false)

Limited memory Broyden Fletcher Goldfarb Shannon minimization with
simple bounds.


The default parameters utilize LBFGSB in unbounded mode.


See:
 itk::LBFGSBOptimizerv4


*/
public  void setOptimizerAsLBFGSB(double gradientConvergenceTolerance) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsLBFGSB__SWIG_7(swigCPtr, this, gradientConvergenceTolerance);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGSB(double gradientConvergenceTolerance=1e-5, unsigned int
numberOfIterations=500, unsigned int maximumNumberOfCorrections=5,
unsigned int maximumNumberOfFunctionEvaluations=2000, double
costFunctionConvergenceFactor=1e+7, double
lowerBound=std::numeric_limits&lt; double &gt;::min(), double
upperBound=std::numeric_limits&lt; double &gt;::max(), bool
trace=false)

Limited memory Broyden Fletcher Goldfarb Shannon minimization with
simple bounds.


The default parameters utilize LBFGSB in unbounded mode.


See:
 itk::LBFGSBOptimizerv4


*/
public  void setOptimizerAsLBFGSB() {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsLBFGSB__SWIG_8(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGS2(double solutionAccuracy=1e-5, unsigned int numberOfIterations=0,
unsigned int hessianApproximateAccuracy=6, unsigned int
deltaConvergenceDistance=0, double deltaConvergenceTolerance=1e-5,
unsigned int lineSearchMaximumEvaluations=40, double
lineSearchMinimumStep=1e-20, double lineSearchMaximumStep=1e20, double
lineSearchAccuracy=1e-4)

Limited memory Broyden Fletcher Goldfarb Shannon minimization without
bounds.


The default parameters utilize LBFGSB in unbounded mode. This version
is from LibLBFGS.

There are upto 3 stopping criteria:
the solution accuracy which is the magnitude of the gradient

the delta convergence which ensures the decrease of the metric

maximum number of iterations



See:
 itk::LBFGS2Optimizerv4


*/
public  void setOptimizerAsLBFGS2(double solutionAccuracy, long numberOfIterations, long hessianApproximateAccuracy, long deltaConvergenceDistance, double deltaConvergenceTolerance, long lineSearchMaximumEvaluations, double lineSearchMinimumStep, double lineSearchMaximumStep, double lineSearchAccuracy) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsLBFGS2__SWIG_0(swigCPtr, this, solutionAccuracy, numberOfIterations, hessianApproximateAccuracy, deltaConvergenceDistance, deltaConvergenceTolerance, lineSearchMaximumEvaluations, lineSearchMinimumStep, lineSearchMaximumStep, lineSearchAccuracy);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGS2(double solutionAccuracy=1e-5, unsigned int numberOfIterations=0,
unsigned int hessianApproximateAccuracy=6, unsigned int
deltaConvergenceDistance=0, double deltaConvergenceTolerance=1e-5,
unsigned int lineSearchMaximumEvaluations=40, double
lineSearchMinimumStep=1e-20, double lineSearchMaximumStep=1e20, double
lineSearchAccuracy=1e-4)

Limited memory Broyden Fletcher Goldfarb Shannon minimization without
bounds.


The default parameters utilize LBFGSB in unbounded mode. This version
is from LibLBFGS.

There are upto 3 stopping criteria:
the solution accuracy which is the magnitude of the gradient

the delta convergence which ensures the decrease of the metric

maximum number of iterations



See:
 itk::LBFGS2Optimizerv4


*/
public  void setOptimizerAsLBFGS2(double solutionAccuracy, long numberOfIterations, long hessianApproximateAccuracy, long deltaConvergenceDistance, double deltaConvergenceTolerance, long lineSearchMaximumEvaluations, double lineSearchMinimumStep, double lineSearchMaximumStep) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsLBFGS2__SWIG_1(swigCPtr, this, solutionAccuracy, numberOfIterations, hessianApproximateAccuracy, deltaConvergenceDistance, deltaConvergenceTolerance, lineSearchMaximumEvaluations, lineSearchMinimumStep, lineSearchMaximumStep);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGS2(double solutionAccuracy=1e-5, unsigned int numberOfIterations=0,
unsigned int hessianApproximateAccuracy=6, unsigned int
deltaConvergenceDistance=0, double deltaConvergenceTolerance=1e-5,
unsigned int lineSearchMaximumEvaluations=40, double
lineSearchMinimumStep=1e-20, double lineSearchMaximumStep=1e20, double
lineSearchAccuracy=1e-4)

Limited memory Broyden Fletcher Goldfarb Shannon minimization without
bounds.


The default parameters utilize LBFGSB in unbounded mode. This version
is from LibLBFGS.

There are upto 3 stopping criteria:
the solution accuracy which is the magnitude of the gradient

the delta convergence which ensures the decrease of the metric

maximum number of iterations



See:
 itk::LBFGS2Optimizerv4


*/
public  void setOptimizerAsLBFGS2(double solutionAccuracy, long numberOfIterations, long hessianApproximateAccuracy, long deltaConvergenceDistance, double deltaConvergenceTolerance, long lineSearchMaximumEvaluations, double lineSearchMinimumStep) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsLBFGS2__SWIG_2(swigCPtr, this, solutionAccuracy, numberOfIterations, hessianApproximateAccuracy, deltaConvergenceDistance, deltaConvergenceTolerance, lineSearchMaximumEvaluations, lineSearchMinimumStep);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGS2(double solutionAccuracy=1e-5, unsigned int numberOfIterations=0,
unsigned int hessianApproximateAccuracy=6, unsigned int
deltaConvergenceDistance=0, double deltaConvergenceTolerance=1e-5,
unsigned int lineSearchMaximumEvaluations=40, double
lineSearchMinimumStep=1e-20, double lineSearchMaximumStep=1e20, double
lineSearchAccuracy=1e-4)

Limited memory Broyden Fletcher Goldfarb Shannon minimization without
bounds.


The default parameters utilize LBFGSB in unbounded mode. This version
is from LibLBFGS.

There are upto 3 stopping criteria:
the solution accuracy which is the magnitude of the gradient

the delta convergence which ensures the decrease of the metric

maximum number of iterations



See:
 itk::LBFGS2Optimizerv4


*/
public  void setOptimizerAsLBFGS2(double solutionAccuracy, long numberOfIterations, long hessianApproximateAccuracy, long deltaConvergenceDistance, double deltaConvergenceTolerance, long lineSearchMaximumEvaluations) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsLBFGS2__SWIG_3(swigCPtr, this, solutionAccuracy, numberOfIterations, hessianApproximateAccuracy, deltaConvergenceDistance, deltaConvergenceTolerance, lineSearchMaximumEvaluations);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGS2(double solutionAccuracy=1e-5, unsigned int numberOfIterations=0,
unsigned int hessianApproximateAccuracy=6, unsigned int
deltaConvergenceDistance=0, double deltaConvergenceTolerance=1e-5,
unsigned int lineSearchMaximumEvaluations=40, double
lineSearchMinimumStep=1e-20, double lineSearchMaximumStep=1e20, double
lineSearchAccuracy=1e-4)

Limited memory Broyden Fletcher Goldfarb Shannon minimization without
bounds.


The default parameters utilize LBFGSB in unbounded mode. This version
is from LibLBFGS.

There are upto 3 stopping criteria:
the solution accuracy which is the magnitude of the gradient

the delta convergence which ensures the decrease of the metric

maximum number of iterations



See:
 itk::LBFGS2Optimizerv4


*/
public  void setOptimizerAsLBFGS2(double solutionAccuracy, long numberOfIterations, long hessianApproximateAccuracy, long deltaConvergenceDistance, double deltaConvergenceTolerance) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsLBFGS2__SWIG_4(swigCPtr, this, solutionAccuracy, numberOfIterations, hessianApproximateAccuracy, deltaConvergenceDistance, deltaConvergenceTolerance);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGS2(double solutionAccuracy=1e-5, unsigned int numberOfIterations=0,
unsigned int hessianApproximateAccuracy=6, unsigned int
deltaConvergenceDistance=0, double deltaConvergenceTolerance=1e-5,
unsigned int lineSearchMaximumEvaluations=40, double
lineSearchMinimumStep=1e-20, double lineSearchMaximumStep=1e20, double
lineSearchAccuracy=1e-4)

Limited memory Broyden Fletcher Goldfarb Shannon minimization without
bounds.


The default parameters utilize LBFGSB in unbounded mode. This version
is from LibLBFGS.

There are upto 3 stopping criteria:
the solution accuracy which is the magnitude of the gradient

the delta convergence which ensures the decrease of the metric

maximum number of iterations



See:
 itk::LBFGS2Optimizerv4


*/
public  void setOptimizerAsLBFGS2(double solutionAccuracy, long numberOfIterations, long hessianApproximateAccuracy, long deltaConvergenceDistance) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsLBFGS2__SWIG_5(swigCPtr, this, solutionAccuracy, numberOfIterations, hessianApproximateAccuracy, deltaConvergenceDistance);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGS2(double solutionAccuracy=1e-5, unsigned int numberOfIterations=0,
unsigned int hessianApproximateAccuracy=6, unsigned int
deltaConvergenceDistance=0, double deltaConvergenceTolerance=1e-5,
unsigned int lineSearchMaximumEvaluations=40, double
lineSearchMinimumStep=1e-20, double lineSearchMaximumStep=1e20, double
lineSearchAccuracy=1e-4)

Limited memory Broyden Fletcher Goldfarb Shannon minimization without
bounds.


The default parameters utilize LBFGSB in unbounded mode. This version
is from LibLBFGS.

There are upto 3 stopping criteria:
the solution accuracy which is the magnitude of the gradient

the delta convergence which ensures the decrease of the metric

maximum number of iterations



See:
 itk::LBFGS2Optimizerv4


*/
public  void setOptimizerAsLBFGS2(double solutionAccuracy, long numberOfIterations, long hessianApproximateAccuracy) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsLBFGS2__SWIG_6(swigCPtr, this, solutionAccuracy, numberOfIterations, hessianApproximateAccuracy);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGS2(double solutionAccuracy=1e-5, unsigned int numberOfIterations=0,
unsigned int hessianApproximateAccuracy=6, unsigned int
deltaConvergenceDistance=0, double deltaConvergenceTolerance=1e-5,
unsigned int lineSearchMaximumEvaluations=40, double
lineSearchMinimumStep=1e-20, double lineSearchMaximumStep=1e20, double
lineSearchAccuracy=1e-4)

Limited memory Broyden Fletcher Goldfarb Shannon minimization without
bounds.


The default parameters utilize LBFGSB in unbounded mode. This version
is from LibLBFGS.

There are upto 3 stopping criteria:
the solution accuracy which is the magnitude of the gradient

the delta convergence which ensures the decrease of the metric

maximum number of iterations



See:
 itk::LBFGS2Optimizerv4


*/
public  void setOptimizerAsLBFGS2(double solutionAccuracy, long numberOfIterations) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsLBFGS2__SWIG_7(swigCPtr, this, solutionAccuracy, numberOfIterations);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGS2(double solutionAccuracy=1e-5, unsigned int numberOfIterations=0,
unsigned int hessianApproximateAccuracy=6, unsigned int
deltaConvergenceDistance=0, double deltaConvergenceTolerance=1e-5,
unsigned int lineSearchMaximumEvaluations=40, double
lineSearchMinimumStep=1e-20, double lineSearchMaximumStep=1e20, double
lineSearchAccuracy=1e-4)

Limited memory Broyden Fletcher Goldfarb Shannon minimization without
bounds.


The default parameters utilize LBFGSB in unbounded mode. This version
is from LibLBFGS.

There are upto 3 stopping criteria:
the solution accuracy which is the magnitude of the gradient

the delta convergence which ensures the decrease of the metric

maximum number of iterations



See:
 itk::LBFGS2Optimizerv4


*/
public  void setOptimizerAsLBFGS2(double solutionAccuracy) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsLBFGS2__SWIG_8(swigCPtr, this, solutionAccuracy);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGS2(double solutionAccuracy=1e-5, unsigned int numberOfIterations=0,
unsigned int hessianApproximateAccuracy=6, unsigned int
deltaConvergenceDistance=0, double deltaConvergenceTolerance=1e-5,
unsigned int lineSearchMaximumEvaluations=40, double
lineSearchMinimumStep=1e-20, double lineSearchMaximumStep=1e20, double
lineSearchAccuracy=1e-4)

Limited memory Broyden Fletcher Goldfarb Shannon minimization without
bounds.


The default parameters utilize LBFGSB in unbounded mode. This version
is from LibLBFGS.

There are upto 3 stopping criteria:
the solution accuracy which is the magnitude of the gradient

the delta convergence which ensures the decrease of the metric

maximum number of iterations



See:
 itk::LBFGS2Optimizerv4


*/
public  void setOptimizerAsLBFGS2() {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsLBFGS2__SWIG_9(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsExhaustive(const std::vector&lt; unsigned int &gt; &amp;numberOfSteps, double
stepLength=1.0)

Set the optimizer to sample the metric at regular steps.


At each iteration the GetOptimizerIteration, can be used to index into
the sampling grid along with the GetCurrentMetricValue.

The resulting transform and value at the end of execution is the best
location.

The OptimizerScales can be used to perform anisotropic sampling.


This optimizer is not suitable for use in conjunction with the
multiple scales.

See:
 itk::ExhaustiveOptimizerv4


*/
public  void setOptimizerAsExhaustive(VectorUInt32 numberOfSteps, double stepLength) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsExhaustive__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(numberOfSteps), numberOfSteps, stepLength);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsExhaustive(const std::vector&lt; unsigned int &gt; &amp;numberOfSteps, double
stepLength=1.0)

Set the optimizer to sample the metric at regular steps.


At each iteration the GetOptimizerIteration, can be used to index into
the sampling grid along with the GetCurrentMetricValue.

The resulting transform and value at the end of execution is the best
location.

The OptimizerScales can be used to perform anisotropic sampling.


This optimizer is not suitable for use in conjunction with the
multiple scales.

See:
 itk::ExhaustiveOptimizerv4


*/
public  void setOptimizerAsExhaustive(VectorUInt32 numberOfSteps) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsExhaustive__SWIG_1(swigCPtr, this, VectorUInt32.getCPtr(numberOfSteps), numberOfSteps);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsAmoeba(double simplexDelta, unsigned int numberOfIterations, double
parametersConvergenceTolerance=1e-8, double
functionConvergenceTolerance=1e-4, bool withRestarts=false)

Set optimizer to Nelder-Mead downhill simplex algorithm.


The simplexDelta is the value that is added and subtracted to the
initial parameters to create the initial simplex. The simplexDelta can
be indirectly set per parameter by the optimizer parameter scaling
either manually or by using an estimator.


See:
 ImageRegistrationMethod::SetOptimizerScales

 itk::AmoebaOptimizerv4


*/
public  void setOptimizerAsAmoeba(double simplexDelta, long numberOfIterations, double parametersConvergenceTolerance, double functionConvergenceTolerance, boolean withRestarts) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsAmoeba__SWIG_0(swigCPtr, this, simplexDelta, numberOfIterations, parametersConvergenceTolerance, functionConvergenceTolerance, withRestarts);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsAmoeba(double simplexDelta, unsigned int numberOfIterations, double
parametersConvergenceTolerance=1e-8, double
functionConvergenceTolerance=1e-4, bool withRestarts=false)

Set optimizer to Nelder-Mead downhill simplex algorithm.


The simplexDelta is the value that is added and subtracted to the
initial parameters to create the initial simplex. The simplexDelta can
be indirectly set per parameter by the optimizer parameter scaling
either manually or by using an estimator.


See:
 ImageRegistrationMethod::SetOptimizerScales

 itk::AmoebaOptimizerv4


*/
public  void setOptimizerAsAmoeba(double simplexDelta, long numberOfIterations, double parametersConvergenceTolerance, double functionConvergenceTolerance) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsAmoeba__SWIG_1(swigCPtr, this, simplexDelta, numberOfIterations, parametersConvergenceTolerance, functionConvergenceTolerance);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsAmoeba(double simplexDelta, unsigned int numberOfIterations, double
parametersConvergenceTolerance=1e-8, double
functionConvergenceTolerance=1e-4, bool withRestarts=false)

Set optimizer to Nelder-Mead downhill simplex algorithm.


The simplexDelta is the value that is added and subtracted to the
initial parameters to create the initial simplex. The simplexDelta can
be indirectly set per parameter by the optimizer parameter scaling
either manually or by using an estimator.


See:
 ImageRegistrationMethod::SetOptimizerScales

 itk::AmoebaOptimizerv4


*/
public  void setOptimizerAsAmoeba(double simplexDelta, long numberOfIterations, double parametersConvergenceTolerance) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsAmoeba__SWIG_2(swigCPtr, this, simplexDelta, numberOfIterations, parametersConvergenceTolerance);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsAmoeba(double simplexDelta, unsigned int numberOfIterations, double
parametersConvergenceTolerance=1e-8, double
functionConvergenceTolerance=1e-4, bool withRestarts=false)

Set optimizer to Nelder-Mead downhill simplex algorithm.


The simplexDelta is the value that is added and subtracted to the
initial parameters to create the initial simplex. The simplexDelta can
be indirectly set per parameter by the optimizer parameter scaling
either manually or by using an estimator.


See:
 ImageRegistrationMethod::SetOptimizerScales

 itk::AmoebaOptimizerv4


*/
public  void setOptimizerAsAmoeba(double simplexDelta, long numberOfIterations) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsAmoeba__SWIG_3(swigCPtr, this, simplexDelta, numberOfIterations);
  }

  public void setOptimizerWeights(VectorDouble weights) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerWeights(swigCPtr, this, VectorDouble.getCPtr(weights), weights);
  }

  public VectorDouble getOptimizerWeights() {
    return new VectorDouble(SimpleITKJNI.ImageRegistrationMethod_getOptimizerWeights(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsPowell(unsigned int numberOfIterations=100, unsigned int
maximumLineIterations=100, double stepLength=1, double
stepTolerance=1e-6, double valueTolerance=1e-6)

Powell optimization using Brent line search.



See:
 itk::PowellOptimizerv4


*/
public  void setOptimizerAsPowell(long numberOfIterations, long maximumLineIterations, double stepLength, double stepTolerance, double valueTolerance) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsPowell__SWIG_0(swigCPtr, this, numberOfIterations, maximumLineIterations, stepLength, stepTolerance, valueTolerance);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsPowell(unsigned int numberOfIterations=100, unsigned int
maximumLineIterations=100, double stepLength=1, double
stepTolerance=1e-6, double valueTolerance=1e-6)

Powell optimization using Brent line search.



See:
 itk::PowellOptimizerv4


*/
public  void setOptimizerAsPowell(long numberOfIterations, long maximumLineIterations, double stepLength, double stepTolerance) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsPowell__SWIG_1(swigCPtr, this, numberOfIterations, maximumLineIterations, stepLength, stepTolerance);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsPowell(unsigned int numberOfIterations=100, unsigned int
maximumLineIterations=100, double stepLength=1, double
stepTolerance=1e-6, double valueTolerance=1e-6)

Powell optimization using Brent line search.



See:
 itk::PowellOptimizerv4


*/
public  void setOptimizerAsPowell(long numberOfIterations, long maximumLineIterations, double stepLength) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsPowell__SWIG_2(swigCPtr, this, numberOfIterations, maximumLineIterations, stepLength);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsPowell(unsigned int numberOfIterations=100, unsigned int
maximumLineIterations=100, double stepLength=1, double
stepTolerance=1e-6, double valueTolerance=1e-6)

Powell optimization using Brent line search.



See:
 itk::PowellOptimizerv4


*/
public  void setOptimizerAsPowell(long numberOfIterations, long maximumLineIterations) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsPowell__SWIG_3(swigCPtr, this, numberOfIterations, maximumLineIterations);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsPowell(unsigned int numberOfIterations=100, unsigned int
maximumLineIterations=100, double stepLength=1, double
stepTolerance=1e-6, double valueTolerance=1e-6)

Powell optimization using Brent line search.



See:
 itk::PowellOptimizerv4


*/
public  void setOptimizerAsPowell(long numberOfIterations) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsPowell__SWIG_4(swigCPtr, this, numberOfIterations);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsPowell(unsigned int numberOfIterations=100, unsigned int
maximumLineIterations=100, double stepLength=1, double
stepTolerance=1e-6, double valueTolerance=1e-6)

Powell optimization using Brent line search.



See:
 itk::PowellOptimizerv4


*/
public  void setOptimizerAsPowell() {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsPowell__SWIG_5(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsOnePlusOneEvolutionary(unsigned int numberOfIterations=100, double epsilon=1.5e-4, double
initialRadius=1.01, double growthFactor=-1.0, double
shrinkFactor=-1.0, unsigned int seed=sitkWallClock)

1+1 evolutionary optimizer strategy.


The seed parameter is used to seed the pseudo-random number generator.
If the seed parameter is 0, then the wall clock is used to seed,
otherwise the fixed seed is used for reproducible behavior.


See:
 itk::OnePlusOneEvolutionaryOptimizerv4


*/
public  void setOptimizerAsOnePlusOneEvolutionary(long numberOfIterations, double epsilon, double initialRadius, double growthFactor, double shrinkFactor, long seed) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsOnePlusOneEvolutionary__SWIG_0(swigCPtr, this, numberOfIterations, epsilon, initialRadius, growthFactor, shrinkFactor, seed);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsOnePlusOneEvolutionary(unsigned int numberOfIterations=100, double epsilon=1.5e-4, double
initialRadius=1.01, double growthFactor=-1.0, double
shrinkFactor=-1.0, unsigned int seed=sitkWallClock)

1+1 evolutionary optimizer strategy.


The seed parameter is used to seed the pseudo-random number generator.
If the seed parameter is 0, then the wall clock is used to seed,
otherwise the fixed seed is used for reproducible behavior.


See:
 itk::OnePlusOneEvolutionaryOptimizerv4


*/
public  void setOptimizerAsOnePlusOneEvolutionary(long numberOfIterations, double epsilon, double initialRadius, double growthFactor, double shrinkFactor) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsOnePlusOneEvolutionary__SWIG_1(swigCPtr, this, numberOfIterations, epsilon, initialRadius, growthFactor, shrinkFactor);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsOnePlusOneEvolutionary(unsigned int numberOfIterations=100, double epsilon=1.5e-4, double
initialRadius=1.01, double growthFactor=-1.0, double
shrinkFactor=-1.0, unsigned int seed=sitkWallClock)

1+1 evolutionary optimizer strategy.


The seed parameter is used to seed the pseudo-random number generator.
If the seed parameter is 0, then the wall clock is used to seed,
otherwise the fixed seed is used for reproducible behavior.


See:
 itk::OnePlusOneEvolutionaryOptimizerv4


*/
public  void setOptimizerAsOnePlusOneEvolutionary(long numberOfIterations, double epsilon, double initialRadius, double growthFactor) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsOnePlusOneEvolutionary__SWIG_2(swigCPtr, this, numberOfIterations, epsilon, initialRadius, growthFactor);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsOnePlusOneEvolutionary(unsigned int numberOfIterations=100, double epsilon=1.5e-4, double
initialRadius=1.01, double growthFactor=-1.0, double
shrinkFactor=-1.0, unsigned int seed=sitkWallClock)

1+1 evolutionary optimizer strategy.


The seed parameter is used to seed the pseudo-random number generator.
If the seed parameter is 0, then the wall clock is used to seed,
otherwise the fixed seed is used for reproducible behavior.


See:
 itk::OnePlusOneEvolutionaryOptimizerv4


*/
public  void setOptimizerAsOnePlusOneEvolutionary(long numberOfIterations, double epsilon, double initialRadius) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsOnePlusOneEvolutionary__SWIG_3(swigCPtr, this, numberOfIterations, epsilon, initialRadius);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsOnePlusOneEvolutionary(unsigned int numberOfIterations=100, double epsilon=1.5e-4, double
initialRadius=1.01, double growthFactor=-1.0, double
shrinkFactor=-1.0, unsigned int seed=sitkWallClock)

1+1 evolutionary optimizer strategy.


The seed parameter is used to seed the pseudo-random number generator.
If the seed parameter is 0, then the wall clock is used to seed,
otherwise the fixed seed is used for reproducible behavior.


See:
 itk::OnePlusOneEvolutionaryOptimizerv4


*/
public  void setOptimizerAsOnePlusOneEvolutionary(long numberOfIterations, double epsilon) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsOnePlusOneEvolutionary__SWIG_4(swigCPtr, this, numberOfIterations, epsilon);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsOnePlusOneEvolutionary(unsigned int numberOfIterations=100, double epsilon=1.5e-4, double
initialRadius=1.01, double growthFactor=-1.0, double
shrinkFactor=-1.0, unsigned int seed=sitkWallClock)

1+1 evolutionary optimizer strategy.


The seed parameter is used to seed the pseudo-random number generator.
If the seed parameter is 0, then the wall clock is used to seed,
otherwise the fixed seed is used for reproducible behavior.


See:
 itk::OnePlusOneEvolutionaryOptimizerv4


*/
public  void setOptimizerAsOnePlusOneEvolutionary(long numberOfIterations) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsOnePlusOneEvolutionary__SWIG_5(swigCPtr, this, numberOfIterations);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerAsOnePlusOneEvolutionary(unsigned int numberOfIterations=100, double epsilon=1.5e-4, double
initialRadius=1.01, double growthFactor=-1.0, double
shrinkFactor=-1.0, unsigned int seed=sitkWallClock)

1+1 evolutionary optimizer strategy.


The seed parameter is used to seed the pseudo-random number generator.
If the seed parameter is 0, then the wall clock is used to seed,
otherwise the fixed seed is used for reproducible behavior.


See:
 itk::OnePlusOneEvolutionaryOptimizerv4


*/
public  void setOptimizerAsOnePlusOneEvolutionary() {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerAsOnePlusOneEvolutionary__SWIG_6(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerScales(const std::vector&lt; double &gt; &amp;scales)

Manually set per parameter weighting for the transform parameters.

*/
public  void setOptimizerScales(VectorDouble scales) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerScales(swigCPtr, this, VectorDouble.getCPtr(scales), scales);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerScalesFromJacobian(unsigned int centralRegionRadius=5)

Estimate scales from Jacobian norms.


This scales estimator works well with versor based transforms.


See:
 itk::RegistrationParameterScalesFromJacobian


*/
public  void setOptimizerScalesFromJacobian(long centralRegionRadius) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerScalesFromJacobian__SWIG_0(swigCPtr, this, centralRegionRadius);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerScalesFromJacobian(unsigned int centralRegionRadius=5)

Estimate scales from Jacobian norms.


This scales estimator works well with versor based transforms.


See:
 itk::RegistrationParameterScalesFromJacobian


*/
public  void setOptimizerScalesFromJacobian() {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerScalesFromJacobian__SWIG_1(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerScalesFromIndexShift(unsigned int centralRegionRadius=5, double
smallParameterVariation=0.01)

Estimate scales from maximum voxel shift in index space cause by
parameter change.



See:
 itk::RegistrationParameterScalesFromIndexShift


*/
public  void setOptimizerScalesFromIndexShift(long centralRegionRadius, double smallParameterVariation) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerScalesFromIndexShift__SWIG_0(swigCPtr, this, centralRegionRadius, smallParameterVariation);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerScalesFromIndexShift(unsigned int centralRegionRadius=5, double
smallParameterVariation=0.01)

Estimate scales from maximum voxel shift in index space cause by
parameter change.



See:
 itk::RegistrationParameterScalesFromIndexShift


*/
public  void setOptimizerScalesFromIndexShift(long centralRegionRadius) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerScalesFromIndexShift__SWIG_1(swigCPtr, this, centralRegionRadius);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerScalesFromIndexShift(unsigned int centralRegionRadius=5, double
smallParameterVariation=0.01)

Estimate scales from maximum voxel shift in index space cause by
parameter change.



See:
 itk::RegistrationParameterScalesFromIndexShift


*/
public  void setOptimizerScalesFromIndexShift() {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerScalesFromIndexShift__SWIG_2(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerScalesFromPhysicalShift(unsigned int centralRegionRadius=5, double
smallParameterVariation=0.01)

Estimating scales of transform parameters a step sizes, from the
maximum voxel shift in physical space caused by a parameter change.



See:
 itk::RegistrationParameterScalesFromPhysicalShift


*/
public  void setOptimizerScalesFromPhysicalShift(long centralRegionRadius, double smallParameterVariation) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerScalesFromPhysicalShift__SWIG_0(swigCPtr, this, centralRegionRadius, smallParameterVariation);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerScalesFromPhysicalShift(unsigned int centralRegionRadius=5, double
smallParameterVariation=0.01)

Estimating scales of transform parameters a step sizes, from the
maximum voxel shift in physical space caused by a parameter change.



See:
 itk::RegistrationParameterScalesFromPhysicalShift


*/
public  void setOptimizerScalesFromPhysicalShift(long centralRegionRadius) {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerScalesFromPhysicalShift__SWIG_1(swigCPtr, this, centralRegionRadius);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetOptimizerScalesFromPhysicalShift(unsigned int centralRegionRadius=5, double
smallParameterVariation=0.01)

Estimating scales of transform parameters a step sizes, from the
maximum voxel shift in physical space caused by a parameter change.



See:
 itk::RegistrationParameterScalesFromPhysicalShift


*/
public  void setOptimizerScalesFromPhysicalShift() {
    SimpleITKJNI.ImageRegistrationMethod_setOptimizerScalesFromPhysicalShift__SWIG_2(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetMetricFixedMask(const Image &amp;binaryMask)

Set an image mask in order to restrict the sampled points for the
metric.


The image is expected to be in the same physical space as the
FixedImage, and if the pixel type is not UInt8 than the image will
base cast.


See:
 itk::ImageToImageMetricv4::SetFixedImageMask


*/
public  void setMetricFixedMask(Image binaryMask) {
    SimpleITKJNI.ImageRegistrationMethod_setMetricFixedMask(swigCPtr, this, Image.getCPtr(binaryMask), binaryMask);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetMetricMovingMask(const Image &amp;binaryMask)

Set an image mask in order to restrict the sampled points for the
metric in the moving image space.


The image is expected to be in the same physical space as the
MovingImage, and if the pixel type is not UInt8 than the image will
base cast.


See:
 itk::ImageToImageMetricv4::SetMovingImageMask


*/
public  void setMetricMovingMask(Image binaryMask) {
    SimpleITKJNI.ImageRegistrationMethod_setMetricMovingMask(swigCPtr, this, Image.getCPtr(binaryMask), binaryMask);
  }

  public void setMetricSamplingPercentage(double percentage, long seed) {
    SimpleITKJNI.ImageRegistrationMethod_setMetricSamplingPercentage__SWIG_0(swigCPtr, this, percentage, seed);
  }

  public void setMetricSamplingPercentage(double percentage) {
    SimpleITKJNI.ImageRegistrationMethod_setMetricSamplingPercentage__SWIG_1(swigCPtr, this, percentage);
  }

  public void setMetricSamplingPercentagePerLevel(VectorDouble percentage, long seed) {
    SimpleITKJNI.ImageRegistrationMethod_setMetricSamplingPercentagePerLevel__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(percentage), percentage, seed);
  }

  public void setMetricSamplingPercentagePerLevel(VectorDouble percentage) {
    SimpleITKJNI.ImageRegistrationMethod_setMetricSamplingPercentagePerLevel__SWIG_1(swigCPtr, this, VectorDouble.getCPtr(percentage), percentage);
  }

  /**
const std::vector&lt;double&gt;&amp; itk::simple::ImageRegistrationMethod::GetMetricSamplingPercentagePerLevel() const

Get the percentage of pixels used for metric evaluation.

*/
public  VectorDouble getMetricSamplingPercentagePerLevel() {
    return new VectorDouble(SimpleITKJNI.ImageRegistrationMethod_getMetricSamplingPercentagePerLevel(swigCPtr, this), false);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetMetricSamplingStrategy(MetricSamplingStrategyType strategy)

Set sampling strategy for sample generation.



See:
 itk::ImageRegistrationMethodv4::SetMetricSamplingStrategy


*/
public  void setMetricSamplingStrategy(ImageRegistrationMethod.MetricSamplingStrategyType strategy) {
    SimpleITKJNI.ImageRegistrationMethod_setMetricSamplingStrategy(swigCPtr, this, strategy.swigValue());
  }

  public void setMetricUseFixedImageGradientFilter(boolean arg0) {
    SimpleITKJNI.ImageRegistrationMethod_setMetricUseFixedImageGradientFilter(swigCPtr, this, arg0);
  }

  public void metricUseFixedImageGradientFilterOn() {
    SimpleITKJNI.ImageRegistrationMethod_metricUseFixedImageGradientFilterOn(swigCPtr, this);
  }

  public void metricUseFixedImageGradientFilterOff() {
    SimpleITKJNI.ImageRegistrationMethod_metricUseFixedImageGradientFilterOff(swigCPtr, this);
  }

  public void setMetricUseMovingImageGradientFilter(boolean arg0) {
    SimpleITKJNI.ImageRegistrationMethod_setMetricUseMovingImageGradientFilter(swigCPtr, this, arg0);
  }

  public void metricUseMovingImageGradientFilterOn() {
    SimpleITKJNI.ImageRegistrationMethod_metricUseMovingImageGradientFilterOn(swigCPtr, this);
  }

  public void metricUseMovingImageGradientFilterOff() {
    SimpleITKJNI.ImageRegistrationMethod_metricUseMovingImageGradientFilterOff(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetShrinkFactorsPerLevel(const std::vector&lt; unsigned int &gt; &amp;shrinkFactors)

Set the isotropic shrink factors for each level.


The virtual domain image is shrunk by this factor relative to the full
size of the original virtual domain.


See:
 itk::ImageRegistrationMethodv4::SetShrinkFactorsPerLevel


*/
public  void setShrinkFactorsPerLevel(VectorUInt32 shrinkFactors) {
    SimpleITKJNI.ImageRegistrationMethod_setShrinkFactorsPerLevel(swigCPtr, this, VectorUInt32.getCPtr(shrinkFactors), shrinkFactors);
  }

  /**
Self&amp; itk::simple::ImageRegistrationMethod::SetSmoothingSigmasPerLevel(const std::vector&lt; double &gt; &amp;smoothingSigmas)

Set the sigmas of Gaussian used for smoothing.


The smoothing is applied to both the fixed and the moving images at
each level. The number of smoothing sigmas must match the number of
shrink factors.


See:
 itk::ImageRegistrationMethodv4::SetSmoothingSigmasPerLevel


*/
public  void setSmoothingSigmasPerLevel(VectorDouble smoothingSigmas) {
    SimpleITKJNI.ImageRegistrationMethod_setSmoothingSigmasPerLevel(swigCPtr, this, VectorDouble.getCPtr(smoothingSigmas), smoothingSigmas);
  }

  public void setSmoothingSigmasAreSpecifiedInPhysicalUnits(boolean arg) {
    SimpleITKJNI.ImageRegistrationMethod_setSmoothingSigmasAreSpecifiedInPhysicalUnits(swigCPtr, this, arg);
  }

  public void smoothingSigmasAreSpecifiedInPhysicalUnitsOn() {
    SimpleITKJNI.ImageRegistrationMethod_smoothingSigmasAreSpecifiedInPhysicalUnitsOn(swigCPtr, this);
  }

  public void smoothingSigmasAreSpecifiedInPhysicalUnitsOff() {
    SimpleITKJNI.ImageRegistrationMethod_smoothingSigmasAreSpecifiedInPhysicalUnitsOff(swigCPtr, this);
  }

  /**
Transform itk::simple::ImageRegistrationMethod::Execute(const Image &amp;fixed, const Image &amp;moving)

Optimize the configured registration problem.

*/
public  Transform execute(Image fixed, Image moving) {
    return new Transform(SimpleITKJNI.ImageRegistrationMethod_execute(swigCPtr, this, Image.getCPtr(fixed), fixed, Image.getCPtr(moving), moving), true);
  }

  /**
double itk::simple::ImageRegistrationMethod::MetricEvaluate(const Image &amp;fixed, const Image &amp;moving)

Get the value of the metric given the state of the method.


Passing a fixed and moving image, this method constructs and
configures a metric object to obtain the value. This will take into
consideration the current transforms, metric, interpolator, and image
masks. It does not take into consideration the sampling strategy,
smoothing sigmas, or the shrink factors.

*/
public  double metricEvaluate(Image fixed, Image moving) {
    return SimpleITKJNI.ImageRegistrationMethod_metricEvaluate(swigCPtr, this, Image.getCPtr(fixed), fixed, Image.getCPtr(moving), moving);
  }

  /**
unsigned int itk::simple::ImageRegistrationMethod::GetOptimizerIteration() const

Active measurements which can be obtained during call backs.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  long getOptimizerIteration() {
    return SimpleITKJNI.ImageRegistrationMethod_getOptimizerIteration(swigCPtr, this);
  }

  /**
std::vector&lt;double&gt; itk::simple::ImageRegistrationMethod::GetOptimizerPosition() const
*/
public  VectorDouble getOptimizerPosition() {
    return new VectorDouble(SimpleITKJNI.ImageRegistrationMethod_getOptimizerPosition(swigCPtr, this), true);
  }

  /**
double itk::simple::ImageRegistrationMethod::GetOptimizerLearningRate() const
*/
public  double getOptimizerLearningRate() {
    return SimpleITKJNI.ImageRegistrationMethod_getOptimizerLearningRate(swigCPtr, this);
  }

  /**
double itk::simple::ImageRegistrationMethod::GetOptimizerConvergenceValue() const
*/
public  double getOptimizerConvergenceValue() {
    return SimpleITKJNI.ImageRegistrationMethod_getOptimizerConvergenceValue(swigCPtr, this);
  }

  /**
double itk::simple::ImageRegistrationMethod::GetMetricValue() const
*/
public  double getMetricValue() {
    return SimpleITKJNI.ImageRegistrationMethod_getMetricValue(swigCPtr, this);
  }

  /**
uint64_t itk::simple::ImageRegistrationMethod::GetMetricNumberOfValidPoints() const

Current number of points used of metric evaluation

This is a active measurement connected to the registration processes
during registration. This number is number of point in the virtual
domain which overlap the fixed image and the moving image. It is valid
for sparse or dense sampling. After execution of registration this
will contain the last value.

*/
public  java.math.BigInteger getMetricNumberOfValidPoints() {
    return SimpleITKJNI.ImageRegistrationMethod_getMetricNumberOfValidPoints(swigCPtr, this);
  }

  /**
unsigned int itk::simple::ImageRegistrationMethod::GetCurrentLevel() const
*/
public  long getCurrentLevel() {
    return SimpleITKJNI.ImageRegistrationMethod_getCurrentLevel(swigCPtr, this);
  }

  /**
std::vector&lt;double&gt; itk::simple::ImageRegistrationMethod::GetOptimizerScales() const

Get the OptimizerScales.


If the scales are explicitly set then this method returns those
values. If an estimator is used then this is an active measurement
returning the scales estimated by the estimator and is only available
during execution.

*/
public  VectorDouble getOptimizerScales() {
    return new VectorDouble(SimpleITKJNI.ImageRegistrationMethod_getOptimizerScales(swigCPtr, this), true);
  }

  /**
std::string itk::simple::ImageRegistrationMethod::GetOptimizerStopConditionDescription() const

Measurement updated at the end of execution.

*/
public  String getOptimizerStopConditionDescription() {
    return SimpleITKJNI.ImageRegistrationMethod_getOptimizerStopConditionDescription(swigCPtr, this);
  }

  /**
bool itk::simple::ImageRegistrationMethod::StopRegistration()

Stop Registration if actively running.

This is an active method which can be called during a callback.
Invoking this method will halt the registration at the current
iteration, if supported by the optimizer. The LBFGSB, LBFGS2, and the
Amoeba optimizers do not support user stopping.

If user stopping is not supported or the optimizer is available ( not
executed ), then false will be returned.

*/
public  boolean stopRegistration() {
    return SimpleITKJNI.ImageRegistrationMethod_stopRegistration(swigCPtr, this);
  }

  public final static class EstimateLearningRateType {
    public final static ImageRegistrationMethod.EstimateLearningRateType Never = new ImageRegistrationMethod.EstimateLearningRateType("Never");
    public final static ImageRegistrationMethod.EstimateLearningRateType Once = new ImageRegistrationMethod.EstimateLearningRateType("Once");
    public final static ImageRegistrationMethod.EstimateLearningRateType EachIteration = new ImageRegistrationMethod.EstimateLearningRateType("EachIteration");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static EstimateLearningRateType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + EstimateLearningRateType.class + " with value " + swigValue);
    }

    private EstimateLearningRateType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private EstimateLearningRateType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private EstimateLearningRateType(String swigName, EstimateLearningRateType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static EstimateLearningRateType[] swigValues = { Never, Once, EachIteration };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

  public final static class MetricSamplingStrategyType {
    public final static ImageRegistrationMethod.MetricSamplingStrategyType NONE = new ImageRegistrationMethod.MetricSamplingStrategyType("NONE");
    public final static ImageRegistrationMethod.MetricSamplingStrategyType REGULAR = new ImageRegistrationMethod.MetricSamplingStrategyType("REGULAR");
    public final static ImageRegistrationMethod.MetricSamplingStrategyType RANDOM = new ImageRegistrationMethod.MetricSamplingStrategyType("RANDOM");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static MetricSamplingStrategyType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + MetricSamplingStrategyType.class + " with value " + swigValue);
    }

    private MetricSamplingStrategyType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private MetricSamplingStrategyType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private MetricSamplingStrategyType(String swigName, MetricSamplingStrategyType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static MetricSamplingStrategyType[] swigValues = { NONE, REGULAR, RANDOM };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
