/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.io.PrintStream;
import java.util.List;
import java.util.function.Supplier;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class RenderBenchmarkCollector {
    public void renderStart(double circum) {
    }

    public boolean renderSort() {
        return true;
    }

    public boolean renderDraw(List<StyledMapRenderer.StyleRecord> allStyleElems) {
        return true;
    }

    public void renderDone() {
    }

    public static long getCurrentTimeMilliseconds() {
        return System.nanoTime() / 1000000L;
    }

    public static Supplier<RenderBenchmarkCollector> defaultBenchmarkSupplier() {
        return () -> Logging.isTraceEnabled() || Config.getPref().getBoolean("mappaint.render.benchmark", false) ? new LoggingBenchmark() : new RenderBenchmarkCollector();
    }

    public static class LoggingBenchmark
    extends CapturingBenchmark {
        private static final PrintStream outStream = System.err;
        private double circum;

        @Override
        public void renderStart(double circum) {
            this.circum = circum;
            super.renderStart(circum);
            outStream.print("BENCHMARK: rendering ");
        }

        @Override
        public boolean renderDraw(List<StyledMapRenderer.StyleRecord> allStyleElems) {
            boolean res = super.renderDraw(allStyleElems);
            outStream.print("phase 1 (calculate styles): " + Utils.getDurationString(this.timeSortingDone - this.timeStart));
            return res;
        }

        @Override
        public void renderDone() {
            super.renderDone();
            outStream.println("; phase 2 (draw): " + Utils.getDurationString(this.timeFinished - this.timeGenerateDone) + "; total: " + Utils.getDurationString(this.timeFinished - this.timeStart) + " (scale: " + this.circum + " zoom level: " + Selector.GeneralSelector.scale2level(this.circum) + ")");
        }
    }

    public static class CapturingBenchmark
    extends RenderBenchmarkCollector {
        protected long timeStart;
        protected long timeGenerateDone;
        protected long timeSortingDone;
        protected long timeFinished;

        @Override
        public void renderStart(double circum) {
            this.timeStart = CapturingBenchmark.getCurrentTimeMilliseconds();
            super.renderStart(circum);
        }

        @Override
        public boolean renderSort() {
            this.timeGenerateDone = CapturingBenchmark.getCurrentTimeMilliseconds();
            return super.renderSort();
        }

        @Override
        public boolean renderDraw(List<StyledMapRenderer.StyleRecord> allStyleElems) {
            this.timeSortingDone = CapturingBenchmark.getCurrentTimeMilliseconds();
            return super.renderDraw(allStyleElems);
        }

        public long getGenerateTime() {
            return this.timeGenerateDone - this.timeStart;
        }

        public long getSortTime() {
            return this.timeSortingDone - this.timeGenerateDone;
        }

        @Override
        public void renderDone() {
            this.timeFinished = CapturingBenchmark.getCurrentTimeMilliseconds();
            super.renderDone();
        }

        public long getDrawTime() {
            return this.timeFinished - this.timeGenerateDone;
        }
    }
}

