/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.IUrls;

public final class JosmUrls
implements IUrls {
    private static final String JOSM_WEBSITE = "https://josm.openstreetmap.de";
    private static final String OSM_WEBSITE = "https://www.openstreetmap.org";
    private static final String OSM_WIKI = "https://wiki.openstreetmap.org";
    private static final String DEFAULT_API_URL = "https://api.openstreetmap.org/api";

    private JosmUrls() {
    }

    public static JosmUrls getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public String getOSMWebsiteDependingOnSelectedApi() {
        String api = OsmApi.getOsmApi().getServerUrl();
        if (DEFAULT_API_URL.equals(api)) {
            return this.getOSMWebsite();
        }
        return api.replaceAll("/api$", "");
    }

    @Override
    public String getBaseBrowseUrl() {
        if (Config.getPref() != null) {
            return Config.getPref().get("osm-browse.url", this.getOSMWebsiteDependingOnSelectedApi());
        }
        return this.getOSMWebsiteDependingOnSelectedApi();
    }

    @Override
    public String getBaseUserUrl() {
        if (Config.getPref() != null) {
            return Config.getPref().get("osm-user.url", this.getOSMWebsiteDependingOnSelectedApi() + "/user");
        }
        return this.getOSMWebsiteDependingOnSelectedApi() + "/user";
    }

    @Override
    public String getJOSMWebsite() {
        if (Config.getPref() != null) {
            return Config.getPref().get("josm.url", JOSM_WEBSITE);
        }
        return JOSM_WEBSITE;
    }

    @Override
    public String getXMLBase() {
        return "http://josm.openstreetmap.de";
    }

    @Override
    public String getOSMWebsite() {
        if (Config.getPref() != null) {
            return Config.getPref().get("osm.url", OSM_WEBSITE);
        }
        return OSM_WEBSITE;
    }

    @Override
    public String getOSMWiki() {
        if (Config.getPref() != null) {
            return Config.getPref().get("url.openstreetmap-wiki", OSM_WIKI);
        }
        return OSM_WIKI;
    }

    @Override
    public String getDefaultOsmApiUrl() {
        return DEFAULT_API_URL;
    }

    private static final class InstanceHolder {
        static final JosmUrls INSTANCE = new JosmUrls();

        private InstanceHolder() {
        }
    }
}

