/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util;

import jakarta.persistence.LockModeType;
import org.hibernate.LockMode;

public final class LockModeConverter {
    private LockModeConverter() {
    }

    public static LockModeType convertToLockModeType(LockMode lockMode) {
        return switch (lockMode) {
            default -> throw new IncompatibleClassChangeError();
            case LockMode.NONE, LockMode.READ -> LockModeType.NONE;
            case LockMode.OPTIMISTIC -> LockModeType.OPTIMISTIC;
            case LockMode.OPTIMISTIC_FORCE_INCREMENT -> LockModeType.OPTIMISTIC_FORCE_INCREMENT;
            case LockMode.PESSIMISTIC_READ -> LockModeType.PESSIMISTIC_READ;
            case LockMode.PESSIMISTIC_WRITE, LockMode.UPGRADE_NOWAIT, LockMode.UPGRADE_SKIPLOCKED -> LockModeType.PESSIMISTIC_WRITE;
            case LockMode.WRITE, LockMode.PESSIMISTIC_FORCE_INCREMENT -> LockModeType.PESSIMISTIC_FORCE_INCREMENT;
        };
    }

    public static LockMode convertToLockMode(LockModeType lockModeType) {
        return switch (lockModeType) {
            default -> throw new IncompatibleClassChangeError();
            case LockModeType.NONE -> LockMode.NONE;
            case LockModeType.READ, LockModeType.OPTIMISTIC -> LockMode.OPTIMISTIC;
            case LockModeType.WRITE, LockModeType.OPTIMISTIC_FORCE_INCREMENT -> LockMode.OPTIMISTIC_FORCE_INCREMENT;
            case LockModeType.PESSIMISTIC_READ -> LockMode.PESSIMISTIC_READ;
            case LockModeType.PESSIMISTIC_WRITE -> LockMode.PESSIMISTIC_WRITE;
            case LockModeType.PESSIMISTIC_FORCE_INCREMENT -> LockMode.PESSIMISTIC_FORCE_INCREMENT;
        };
    }
}

