/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import org.hibernate.sql.ast.spi.AggregateFunctionChecker;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;

public final class SqlAstTreeHelper {
    private SqlAstTreeHelper() {
    }

    public static Predicate combinePredicates(Predicate baseRestriction, Predicate incomingRestriction) {
        Junction junction;
        Junction secondJunction;
        Junction combinedPredicate;
        if (baseRestriction == null) {
            return incomingRestriction;
        }
        if (incomingRestriction == null) {
            return baseRestriction;
        }
        if (baseRestriction instanceof Junction) {
            Junction junction2 = (Junction)baseRestriction;
            if (junction2.isEmpty()) {
                return incomingRestriction;
            }
            if (junction2.getNature() == Junction.Nature.CONJUNCTION) {
                combinedPredicate = junction2;
            } else {
                combinedPredicate = new Junction(Junction.Nature.CONJUNCTION);
                combinedPredicate.add(baseRestriction);
            }
        } else {
            combinedPredicate = new Junction(Junction.Nature.CONJUNCTION);
            combinedPredicate.add(baseRestriction);
        }
        if (incomingRestriction instanceof Junction && (secondJunction = (junction = (Junction)incomingRestriction)).getNature() == Junction.Nature.CONJUNCTION) {
            for (Predicate predicate : secondJunction.getPredicates()) {
                combinedPredicate.add(predicate);
            }
        } else {
            combinedPredicate.add(incomingRestriction);
        }
        return combinedPredicate;
    }

    public static boolean hasAggregateFunctions(QuerySpec querySpec) {
        return AggregateFunctionChecker.hasAggregateFunctions(querySpec);
    }
}

