/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import liquibase.exception.CustomChangeException;
import liquibase.statement.core.InsertStatement;
import liquibase.structure.core.Table;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.utils.KeycloakModelUtils;

public class ExtractRealmKeysFromRealmTable
extends CustomKeycloakTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        try {
            try (PreparedStatement statement = this.jdbcConnection.prepareStatement("select ID, PRIVATE_KEY, CERTIFICATE from " + this.getTableName("REALM"));
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String realmId = resultSet.getString(1);
                    String privateKeyPem = resultSet.getString(2);
                    String certificatePem = resultSet.getString(3);
                    String componentId = KeycloakModelUtils.generateId();
                    InsertStatement insertComponent = new InsertStatement(null, null, this.database.correctObjectName("COMPONENT", Table.class)).addColumnValue("ID", (Object)componentId).addColumnValue("REALM_ID", (Object)realmId).addColumnValue("PARENT_ID", (Object)realmId).addColumnValue("NAME", (Object)"rsa").addColumnValue("PROVIDER_ID", (Object)"rsa").addColumnValue("PROVIDER_TYPE", (Object)KeyProvider.class.getName());
                    this.statements.add(insertComponent);
                    this.statements.add(this.componentConfigStatement(componentId, "priority", "100"));
                    this.statements.add(this.componentConfigStatement(componentId, "privateKey", privateKeyPem));
                    this.statements.add(this.componentConfigStatement(componentId, "certificate", certificatePem));
                }
            }
            this.confirmationMessage.append("Updated " + this.statements.size() + " records in USER_FEDERATION_PROVIDER table");
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when updating data from previous version", (Throwable)e);
        }
    }

    private InsertStatement componentConfigStatement(String componentId, String name, String value) {
        return new InsertStatement(null, null, this.database.correctObjectName("COMPONENT_CONFIG", Table.class)).addColumnValue("ID", (Object)KeycloakModelUtils.generateId()).addColumnValue("COMPONENT_ID", (Object)componentId).addColumnValue("NAME", (Object)name).addColumnValue("VALUE", (Object)value);
    }

    @Override
    protected String getTaskId() {
        return "Update 2.3.0.Final";
    }
}

