/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.util;

import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keycloak.dom.saml.v1.assertion.SAML11ActionType;
import org.keycloak.dom.saml.v1.assertion.SAML11AttributeStatementType;
import org.keycloak.dom.saml.v1.assertion.SAML11AttributeType;
import org.keycloak.dom.saml.v1.assertion.SAML11AudienceRestrictionCondition;
import org.keycloak.dom.saml.v1.assertion.SAML11AuthenticationStatementType;
import org.keycloak.dom.saml.v1.assertion.SAML11AuthorityBindingType;
import org.keycloak.dom.saml.v1.assertion.SAML11AuthorizationDecisionStatementType;
import org.keycloak.dom.saml.v1.assertion.SAML11ConditionAbstractType;
import org.keycloak.dom.saml.v1.assertion.SAML11ConditionsType;
import org.keycloak.dom.saml.v1.assertion.SAML11DecisionType;
import org.keycloak.dom.saml.v1.assertion.SAML11SubjectConfirmationType;
import org.keycloak.dom.saml.v1.assertion.SAML11SubjectLocalityType;
import org.keycloak.dom.saml.v1.assertion.SAML11SubjectStatementType;
import org.keycloak.dom.saml.v1.assertion.SAML11SubjectType;
import org.keycloak.dom.saml.v1.protocol.SAML11AttributeQueryType;
import org.keycloak.dom.saml.v1.protocol.SAML11AuthenticationQueryType;
import org.keycloak.dom.saml.v1.protocol.SAML11AuthorizationDecisionQueryType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationDataType;
import org.keycloak.dom.xmlsec.w3.xmldsig.DSAKeyValueType;
import org.keycloak.dom.xmlsec.w3.xmldsig.KeyInfoType;
import org.keycloak.dom.xmlsec.w3.xmldsig.RSAKeyValueType;
import org.keycloak.dom.xmlsec.w3.xmldsig.X509CertificateType;
import org.keycloak.dom.xmlsec.w3.xmldsig.X509DataType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.GeneralConstants;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.SAML11SubjectParser;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAML11ParserUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static SAML11AuthenticationStatementType parseAuthenticationStatement(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, "AuthenticationStatement");
        Attribute authMethod = startElement.getAttributeByName(new QName("AuthenticationMethod"));
        if (authMethod == null) {
            throw logger.parserRequiredAttribute("AuthenticationMethod");
        }
        Attribute authInstant = startElement.getAttributeByName(new QName("AuthenticationInstant"));
        if (authInstant == null) {
            throw logger.parserRequiredAttribute("AuthenticationInstant");
        }
        SAML11AuthenticationStatementType authStat = new SAML11AuthenticationStatementType(URI.create(StaxParserUtil.getAttributeValue(authMethod)), XMLTimeUtil.parse(StaxParserUtil.getAttributeValue(authInstant)));
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek(xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                xmlEvent = StaxParserUtil.getNextEvent(xmlEventReader);
                EndElement endElement = (EndElement)xmlEvent;
                String endElementTag = StaxParserUtil.getElementName(endElement);
                if (endElementTag.equals("AuthenticationStatement")) break;
                throw logger.parserUnknownEndElement(endElementTag, xmlEvent.getLocation());
            }
            startElement = null;
            startElement = xmlEvent instanceof StartElement ? (StartElement)xmlEvent : StaxParserUtil.peekNextStartElement(xmlEventReader);
            if (startElement == null) break;
            String tag = StaxParserUtil.getElementName(startElement);
            if (JBossSAMLConstants.SUBJECT.get().equalsIgnoreCase(tag)) {
                SAML11SubjectParser subjectParser = new SAML11SubjectParser();
                SAML11SubjectType subject = (SAML11SubjectType)subjectParser.parse(xmlEventReader);
                SAML11SubjectStatementType subStat = new SAML11SubjectStatementType();
                subStat.setSubject(subject);
                authStat.setSubject(subject);
                continue;
            }
            if (JBossSAMLConstants.SUBJECT_LOCALITY.get().equals(tag)) {
                Attribute dns;
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                SAML11SubjectLocalityType subjectLocalityType = new SAML11SubjectLocalityType();
                Attribute address = startElement.getAttributeByName(new QName("IPAddress"));
                if (address != null) {
                    subjectLocalityType.setIpAddress(StaxParserUtil.getAttributeValue(address));
                }
                if ((dns = startElement.getAttributeByName(new QName("DNSAddress"))) != null) {
                    subjectLocalityType.setDnsAddress(StaxParserUtil.getAttributeValue(dns));
                }
                authStat.setSubjectLocality(subjectLocalityType);
                StaxParserUtil.validate(StaxParserUtil.getNextEndElement(xmlEventReader), JBossSAMLConstants.SUBJECT_LOCALITY.get());
                continue;
            }
            if ("AuthorityBinding".equals(tag)) {
                Attribute authorityKindAttr = startElement.getAttributeByName(new QName("AuthorityKind"));
                if (authorityKindAttr == null) {
                    throw logger.parserRequiredAttribute("AuthorityKind");
                }
                Attribute locationAttr = startElement.getAttributeByName(new QName("Location"));
                if (locationAttr == null) {
                    throw logger.parserRequiredAttribute("Location");
                }
                URI location = URI.create(StaxParserUtil.getAttributeValue(locationAttr));
                Attribute bindingAttr = startElement.getAttributeByName(new QName("Binding"));
                if (bindingAttr == null) {
                    throw logger.parserRequiredAttribute("Binding");
                }
                URI binding = URI.create(StaxParserUtil.getAttributeValue(bindingAttr));
                QName authorityKind = QName.valueOf(StaxParserUtil.getAttributeValue(authorityKindAttr));
                SAML11AuthorityBindingType authorityBinding = new SAML11AuthorityBindingType(authorityKind, location, binding);
                authStat.add(authorityBinding);
                continue;
            }
            throw logger.parserUnknownTag("", startElement.getLocation());
        }
        return authStat;
    }

    public static SAML11SubjectConfirmationType parseSAML11SubjectConfirmation(XMLEventReader xmlEventReader) throws ParsingException {
        SAML11SubjectConfirmationType subjectConfirmationType = new SAML11SubjectConfirmationType();
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, JBossSAMLConstants.SUBJECT_CONFIRMATION.get());
                break;
            }
            if (!(xmlEvent instanceof StartElement)) continue;
            startElement = (StartElement)xmlEvent;
            String startTag = StaxParserUtil.getElementName(startElement);
            if (startTag.equals("ConfirmationMethod")) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                String method = StaxParserUtil.getElementText(xmlEventReader);
                subjectConfirmationType.addConfirmationMethod(URI.create(method));
                continue;
            }
            if (startTag.equals(JBossSAMLConstants.SUBJECT_CONFIRMATION_DATA.get())) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                SubjectConfirmationDataType subjectConfirmationData = SAML11ParserUtil.parseSubjectConfirmationData(xmlEventReader);
                subjectConfirmationType.setSubjectConfirmationData((Object)subjectConfirmationData);
                continue;
            }
            if (startTag.equals(JBossSAMLConstants.KEY_INFO.get())) {
                Element keyInfo = StaxParserUtil.getDOMElement(xmlEventReader);
                subjectConfirmationType.setKeyInfo(keyInfo);
                continue;
            }
            throw logger.parserUnknownTag(startTag, startElement.getLocation());
        }
        return subjectConfirmationType;
    }

    public static SubjectConfirmationDataType parseSubjectConfirmationData(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        Attribute address;
        Attribute recipient;
        Attribute notOnOrAfter;
        Attribute notBefore;
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.SUBJECT_CONFIRMATION_DATA.get());
        SubjectConfirmationDataType subjectConfirmationData = new SubjectConfirmationDataType();
        Attribute inResponseTo = startElement.getAttributeByName(new QName(JBossSAMLConstants.IN_RESPONSE_TO.get()));
        if (inResponseTo != null) {
            subjectConfirmationData.setInResponseTo(StaxParserUtil.getAttributeValue(inResponseTo));
        }
        if ((notBefore = startElement.getAttributeByName(new QName(JBossSAMLConstants.NOT_BEFORE.get()))) != null) {
            subjectConfirmationData.setNotBefore(XMLTimeUtil.parse(StaxParserUtil.getAttributeValue(notBefore)));
        }
        if ((notOnOrAfter = startElement.getAttributeByName(new QName(JBossSAMLConstants.NOT_ON_OR_AFTER.get()))) != null) {
            subjectConfirmationData.setNotOnOrAfter(XMLTimeUtil.parse(StaxParserUtil.getAttributeValue(notOnOrAfter)));
        }
        if ((recipient = startElement.getAttributeByName(new QName(JBossSAMLConstants.RECIPIENT.get()))) != null) {
            subjectConfirmationData.setRecipient(StaxParserUtil.getAttributeValue(recipient));
        }
        if ((address = startElement.getAttributeByName(new QName(JBossSAMLConstants.ADDRESS.get()))) != null) {
            subjectConfirmationData.setAddress(StaxParserUtil.getAttributeValue(address));
        }
        if (!((xmlEvent = StaxParserUtil.peek(xmlEventReader)) instanceof EndElement)) {
            startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
            String tag = StaxParserUtil.getElementName(startElement);
            if (tag.equals("KeyInfo")) {
                KeyInfoType keyInfo = SAML11ParserUtil.parseKeyInfo(xmlEventReader);
                subjectConfirmationData.setAnyType((Object)keyInfo);
            } else if (tag.equals("EncryptedKey")) {
                subjectConfirmationData.setAnyType((Object)StaxParserUtil.getDOMElement(xmlEventReader));
            } else {
                throw logger.parserUnknownTag(tag, startElement.getLocation());
            }
        }
        EndElement endElement = (EndElement)StaxParserUtil.getNextEvent(xmlEventReader);
        StaxParserUtil.matches(endElement, JBossSAMLConstants.SUBJECT_CONFIRMATION_DATA.get());
        return subjectConfirmationData;
    }

    public static SAML11AttributeStatementType parseSAML11AttributeStatement(XMLEventReader xmlEventReader) throws ParsingException {
        SAML11AttributeStatementType attributeStatementType = new SAML11AttributeStatementType();
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        String ATTRIBSTATEMT = JBossSAMLConstants.ATTRIBUTE_STATEMENT.get();
        StaxParserUtil.validate(startElement, ATTRIBSTATEMT);
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, JBossSAMLConstants.ATTRIBUTE_STATEMENT.get());
                break;
            }
            startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
            String tag = startElement.getName().getLocalPart();
            if (JBossSAMLConstants.ATTRIBUTE.get().equals(tag)) {
                SAML11AttributeType attribute = SAML11ParserUtil.parseSAML11Attribute(xmlEventReader);
                attributeStatementType.add(attribute);
                continue;
            }
            if (JBossSAMLConstants.SUBJECT.get().equals(tag)) {
                SAML11SubjectParser parser = new SAML11SubjectParser();
                SAML11SubjectType subject = (SAML11SubjectType)parser.parse(xmlEventReader);
                attributeStatementType.setSubject(subject);
                continue;
            }
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
        return attributeStatementType;
    }

    public static SAML11AttributeType parseSAML11Attribute(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.ATTRIBUTE.get());
        SAML11AttributeType attributeType = null;
        Attribute name = startElement.getAttributeByName(new QName("AttributeName"));
        if (name == null) {
            throw logger.parserRequiredAttribute("Name");
        }
        String attribName = StaxParserUtil.getAttributeValue(name);
        Attribute namesp = startElement.getAttributeByName(new QName("AttributeNamespace"));
        if (namesp == null) {
            throw logger.parserRequiredAttribute("Namespace");
        }
        String attribNamespace = StaxParserUtil.getAttributeValue(namesp);
        attributeType = new SAML11AttributeType(attribName, URI.create(attribNamespace));
        attributeType.add(SAML11ParserUtil.parseAttributeValue(xmlEventReader));
        SAML11ParserUtil.parseAttributeType(xmlEventReader, startElement, JBossSAMLConstants.ATTRIBUTE.get(), attributeType);
        return attributeType;
    }

    public static void parseAttributeType(XMLEventReader xmlEventReader, StartElement startElement, String rootTag, SAML11AttributeType attributeType) throws ParsingException {
        EndElement end;
        XMLEvent xmlEvent;
        while (!(!xmlEventReader.hasNext() || (xmlEvent = StaxParserUtil.peek(xmlEventReader)) instanceof EndElement && StaxParserUtil.matches(end = StaxParserUtil.getNextEndElement(xmlEventReader), rootTag) || (startElement = StaxParserUtil.peekNextStartElement(xmlEventReader)) == null)) {
            String tag = StaxParserUtil.getElementName(startElement);
            if (JBossSAMLConstants.ATTRIBUTE.get().equals(tag)) break;
            if (JBossSAMLConstants.ATTRIBUTE_VALUE.get().equals(tag)) {
                Object attributeValue = SAML11ParserUtil.parseAttributeValue(xmlEventReader);
                attributeType.add(attributeValue);
                continue;
            }
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
    }

    public static Object parseAttributeValue(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.ATTRIBUTE_VALUE.get());
        Attribute type = startElement.getAttributeByName(new QName(JBossSAMLURIConstants.XSI_NSURI.get(), "type", "xsi"));
        if (type == null) {
            return StaxParserUtil.getElementText(xmlEventReader);
        }
        String typeValue = StaxParserUtil.getAttributeValue(type);
        if (typeValue.contains(":string")) {
            return StaxParserUtil.getElementText(xmlEventReader);
        }
        throw logger.parserUnknownXSI(typeValue);
    }

    public static SAML11AuthorizationDecisionStatementType parseSAML11AuthorizationDecisionStatement(XMLEventReader xmlEventReader) throws ParsingException {
        EndElement end;
        XMLEvent xmlEvent;
        SAML11AuthorizationDecisionStatementType authzDecision = null;
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, "AuthorizationDecisionStatement");
        Attribute decision = startElement.getAttributeByName(new QName("Decision"));
        if (decision == null) {
            throw logger.parserRequiredAttribute("Decision");
        }
        String decisionValue = StaxParserUtil.getAttributeValue(decision);
        Attribute resource = startElement.getAttributeByName(new QName("Resource"));
        if (resource == null) {
            throw logger.parserRequiredAttribute("Namespace");
        }
        String resValue = StaxParserUtil.getAttributeValue(resource);
        authzDecision = new SAML11AuthorizationDecisionStatementType(URI.create(resValue), SAML11DecisionType.valueOf((String)decisionValue));
        while (!(!xmlEventReader.hasNext() || (xmlEvent = StaxParserUtil.peek(xmlEventReader)) instanceof EndElement && StaxParserUtil.matches(end = StaxParserUtil.getNextEndElement(xmlEventReader), "AuthorizationDecisionStatement") || (startElement = StaxParserUtil.peekNextStartElement(xmlEventReader)) == null)) {
            String tag = StaxParserUtil.getElementName(startElement);
            if ("Action".equals(tag)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                SAML11ActionType samlAction = new SAML11ActionType();
                Attribute namespaceAttr = startElement.getAttributeByName(new QName("Namespace"));
                if (namespaceAttr != null) {
                    samlAction.setNamespace(StaxParserUtil.getAttributeValue(namespaceAttr));
                }
                samlAction.setValue(StaxParserUtil.getElementText(xmlEventReader));
                authzDecision.addAction(samlAction);
                continue;
            }
            if (JBossSAMLConstants.SUBJECT.get().equals(tag)) {
                SAML11SubjectParser parser = new SAML11SubjectParser();
                authzDecision.setSubject((SAML11SubjectType)parser.parse(xmlEventReader));
                continue;
            }
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
        return authzDecision;
    }

    public static SAML11ConditionsType parseSAML11Conditions(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement;
        EndElement end;
        XMLEvent xmlEvent;
        Attribute notAfterAttribute;
        SAML11ConditionsType conditions = new SAML11ConditionsType();
        StartElement conditionsElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(conditionsElement, JBossSAMLConstants.CONDITIONS.get());
        String assertionNS = "urn:oasis:names:tc:SAML:1.0:assertion";
        QName notBeforeQName = new QName("", JBossSAMLConstants.NOT_BEFORE.get());
        QName notBeforeQNameWithNS = new QName(assertionNS, JBossSAMLConstants.NOT_BEFORE.get());
        QName notAfterQName = new QName("", JBossSAMLConstants.NOT_ON_OR_AFTER.get());
        QName notAfterQNameWithNS = new QName(assertionNS, JBossSAMLConstants.NOT_ON_OR_AFTER.get());
        Attribute notBeforeAttribute = conditionsElement.getAttributeByName(notBeforeQName);
        if (notBeforeAttribute == null) {
            notBeforeAttribute = conditionsElement.getAttributeByName(notBeforeQNameWithNS);
        }
        if ((notAfterAttribute = conditionsElement.getAttributeByName(notAfterQName)) == null) {
            notAfterAttribute = conditionsElement.getAttributeByName(notAfterQNameWithNS);
        }
        if (notBeforeAttribute != null) {
            String notBeforeValue = StaxParserUtil.getAttributeValue(notBeforeAttribute);
            conditions.setNotBefore(XMLTimeUtil.parse(notBeforeValue));
        }
        if (notAfterAttribute != null) {
            String notAfterValue = StaxParserUtil.getAttributeValue(notAfterAttribute);
            conditions.setNotOnOrAfter(XMLTimeUtil.parse(notAfterValue));
        }
        while (!(!xmlEventReader.hasNext() || (xmlEvent = StaxParserUtil.peek(xmlEventReader)) instanceof EndElement && StaxParserUtil.matches(end = StaxParserUtil.getNextEndElement(xmlEventReader), JBossSAMLConstants.CONDITIONS.get()) || (startElement = StaxParserUtil.peekNextStartElement(xmlEventReader)) == null)) {
            String tag = StaxParserUtil.getElementName(startElement);
            if ("AudienceRestrictionCondition".equals(tag)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                SAML11AudienceRestrictionCondition restrictCond = new SAML11AudienceRestrictionCondition();
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                if (StaxParserUtil.getElementName(startElement).equals(JBossSAMLConstants.AUDIENCE.get())) {
                    restrictCond.add(URI.create(StaxParserUtil.getElementText(xmlEventReader)));
                }
                EndElement theEndElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(theEndElement, "AudienceRestrictionCondition");
                conditions.add((SAML11ConditionAbstractType)restrictCond);
                continue;
            }
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
        return conditions;
    }

    public static KeyInfoType parseKeyInfo(XMLEventReader xmlEventReader) throws ParsingException {
        KeyInfoType keyInfo = new KeyInfoType();
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, "KeyInfo");
        XMLEvent xmlEvent = null;
        String tag = null;
        while (xmlEventReader.hasNext()) {
            xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                tag = StaxParserUtil.getElementName((EndElement)xmlEvent);
                if (tag.equals("KeyInfo")) {
                    StaxParserUtil.getNextEndElement(xmlEventReader);
                    break;
                }
                throw logger.parserUnknownEndElement(tag, xmlEvent.getLocation());
            }
            startElement = (StartElement)xmlEvent;
            tag = StaxParserUtil.getElementName(startElement);
            if (tag.equals("EncryptedKey")) {
                keyInfo.addContent((Object)StaxParserUtil.getDOMElement(xmlEventReader));
                continue;
            }
            if (tag.equals("X509Data")) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                X509DataType x509 = new X509DataType();
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                StaxParserUtil.validate(startElement, "X509Certificate");
                X509CertificateType cert = new X509CertificateType();
                String certValue = StaxParserUtil.getElementText(xmlEventReader);
                cert.setEncodedCertificate(certValue.getBytes(GeneralConstants.SAML_CHARSET));
                x509.add((Object)cert);
                EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, "X509Data");
                keyInfo.addContent((Object)x509);
                continue;
            }
            if (!tag.equals("KeyValue")) continue;
            startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
            RSAKeyValueType keyValue = null;
            startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
            tag = StaxParserUtil.getElementName(startElement);
            if (tag.equals("RSAKeyValue")) {
                keyValue = SAML11ParserUtil.parseRSAKeyValue(xmlEventReader);
            } else if (tag.equals("DSAKeyValue")) {
                keyValue = SAML11ParserUtil.parseDSAKeyValue(xmlEventReader);
            } else {
                throw logger.parserUnknownTag(tag, startElement.getLocation());
            }
            EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
            StaxParserUtil.validate(endElement, "KeyValue");
            keyInfo.addContent((Object)keyValue);
        }
        return keyInfo;
    }

    public static RSAKeyValueType parseRSAKeyValue(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, "RSAKeyValue");
        XMLEvent xmlEvent = null;
        String tag = null;
        RSAKeyValueType rsaKeyValue = new RSAKeyValueType();
        while (xmlEventReader.hasNext()) {
            String text;
            xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                tag = StaxParserUtil.getElementName((EndElement)xmlEvent);
                if (tag.equals("RSAKeyValue")) {
                    StaxParserUtil.getNextEndElement(xmlEventReader);
                    break;
                }
                throw logger.parserUnknownEndElement(tag, xmlEvent.getLocation());
            }
            startElement = (StartElement)xmlEvent;
            tag = StaxParserUtil.getElementName(startElement);
            if (tag.equals("Modulus")) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                text = StaxParserUtil.getElementText(xmlEventReader);
                rsaKeyValue.setModulus(text.getBytes(GeneralConstants.SAML_CHARSET));
                continue;
            }
            if (tag.equals("Exponent")) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                text = StaxParserUtil.getElementText(xmlEventReader);
                rsaKeyValue.setExponent(text.getBytes(GeneralConstants.SAML_CHARSET));
                continue;
            }
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
        return rsaKeyValue;
    }

    private static DSAKeyValueType parseDSAKeyValue(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, "DSAKeyValue");
        Element dsaElement = StaxParserUtil.getDOMElement(xmlEventReader);
        return SAML11ParserUtil.getDSAKeyValue(dsaElement);
    }

    private static DSAKeyValueType getDSAKeyValue(Element element) throws ParsingException {
        DSAKeyValueType dsa = new DSAKeyValueType();
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String tag = childElement.getLocalName();
            byte[] text = childElement.getTextContent().getBytes(GeneralConstants.SAML_CHARSET);
            if ("P".equals(tag)) {
                dsa.setP(text);
                continue;
            }
            if ("Q".equals(tag)) {
                dsa.setQ(text);
                continue;
            }
            if ("G".equals(tag)) {
                dsa.setG(text);
                continue;
            }
            if ("Y".equals(tag)) {
                dsa.setY(text);
                continue;
            }
            if ("Seed".equals(tag)) {
                dsa.setSeed(text);
                continue;
            }
            if (!"PgenCounter".equals(tag)) continue;
            dsa.setPgenCounter(text);
        }
        return dsa;
    }

    public static SAML11AttributeQueryType parseSAML11AttributeQuery(XMLEventReader xmlEventReader) throws ParsingException {
        SAML11AttributeQueryType query = new SAML11AttributeQueryType();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                if (StaxParserUtil.matches(endElement, "AttributeQuery")) break;
                throw logger.parserUnknownEndElement(StaxParserUtil.getElementName(endElement), xmlEvent.getLocation());
            }
            if (!(xmlEvent instanceof StartElement)) continue;
            StartElement startElement = (StartElement)xmlEvent;
            String startTag = StaxParserUtil.getElementName(startElement);
            if (startTag.equals(JBossSAMLConstants.SUBJECT.get())) {
                SAML11SubjectParser parser = new SAML11SubjectParser();
                query.setSubject((SAML11SubjectType)parser.parse(xmlEventReader));
                continue;
            }
            throw logger.parserUnknownTag(startTag, startElement.getLocation());
        }
        return query;
    }

    public static SAML11AuthenticationQueryType parseSAML11AuthenticationQuery(XMLEventReader xmlEventReader) throws ParsingException {
        SAML11AuthenticationQueryType query = new SAML11AuthenticationQueryType();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                if (StaxParserUtil.matches(endElement, "AuthenticationQuery")) break;
                throw logger.parserUnknownEndElement(StaxParserUtil.getElementName(endElement), xmlEvent.getLocation());
            }
            if (!(xmlEvent instanceof StartElement)) continue;
            StartElement startElement = (StartElement)xmlEvent;
            String startTag = StaxParserUtil.getElementName(startElement);
            if (startTag.equals(JBossSAMLConstants.SUBJECT.get())) {
                SAML11SubjectParser parser = new SAML11SubjectParser();
                query.setSubject((SAML11SubjectType)parser.parse(xmlEventReader));
                continue;
            }
            throw logger.parserUnknownTag(startTag, startElement.getLocation());
        }
        return query;
    }

    public static SAML11AuthorizationDecisionQueryType parseSAML11AuthorizationDecisionQueryType(XMLEventReader xmlEventReader) throws ParsingException {
        SAML11AuthorizationDecisionQueryType query = new SAML11AuthorizationDecisionQueryType();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                if (StaxParserUtil.matches(endElement, "AuthorizationDecisionQuery")) break;
                throw logger.parserUnknownEndElement(StaxParserUtil.getElementName(endElement), xmlEvent.getLocation());
            }
            if (!(xmlEvent instanceof StartElement)) continue;
            StartElement startElement = (StartElement)xmlEvent;
            String startTag = StaxParserUtil.getElementName(startElement);
            if (startTag.equals(JBossSAMLConstants.SUBJECT.get())) {
                SAML11SubjectParser parser = new SAML11SubjectParser();
                query.setSubject((SAML11SubjectType)parser.parse(xmlEventReader));
                continue;
            }
            if (startTag.equals("Resource")) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                query.setResource(URI.create(StaxParserUtil.getElementText(xmlEventReader)));
                continue;
            }
            if (startTag.equals("Action")) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                SAML11ActionType action = new SAML11ActionType();
                Attribute nsAttr = startElement.getAttributeByName(new QName("Namespace"));
                if (nsAttr != null) {
                    action.setNamespace(StaxParserUtil.getAttributeValue(nsAttr));
                }
                action.setValue(StaxParserUtil.getElementText(xmlEventReader));
                query.add(action);
                continue;
            }
            throw logger.parserUnknownTag(startTag, startElement.getLocation());
        }
        return query;
    }
}

