/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.lang.ref.Cleaner;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class MatrixFromColumnsNode extends ImplicitNode {

	public MatrixFromColumnsNode(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Retrieves the input for the first column
	 *
	 * @return the input for the first column
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputA() throws Lib3MFException {
		Pointer bufferColumn0 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_matrixfromcolumnsnode_getinputa.invokeInt(new java.lang.Object[]{mHandle, bufferColumn0}));
		Pointer valueColumn0 = bufferColumn0.getPointer(0);
		ImplicitPort column0 = null;
		if (valueColumn0 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Column0 was a null pointer");
		}
		column0 = mWrapper.PolymorphicFactory(valueColumn0, ImplicitPort.class);
		return column0;
	}

	/**
	 * Retrieves the input for the second column
	 *
	 * @return the input for the second column
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputB() throws Lib3MFException {
		Pointer bufferColumn1 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_matrixfromcolumnsnode_getinputb.invokeInt(new java.lang.Object[]{mHandle, bufferColumn1}));
		Pointer valueColumn1 = bufferColumn1.getPointer(0);
		ImplicitPort column1 = null;
		if (valueColumn1 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Column1 was a null pointer");
		}
		column1 = mWrapper.PolymorphicFactory(valueColumn1, ImplicitPort.class);
		return column1;
	}

	/**
	 * Retrieves the input for the third column
	 *
	 * @return the input for the third column
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputC() throws Lib3MFException {
		Pointer bufferColumn2 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_matrixfromcolumnsnode_getinputc.invokeInt(new java.lang.Object[]{mHandle, bufferColumn2}));
		Pointer valueColumn2 = bufferColumn2.getPointer(0);
		ImplicitPort column2 = null;
		if (valueColumn2 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Column2 was a null pointer");
		}
		column2 = mWrapper.PolymorphicFactory(valueColumn2, ImplicitPort.class);
		return column2;
	}

	/**
	 * Retrieves the input for the fourth column
	 *
	 * @return the input for the fourth column
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputD() throws Lib3MFException {
		Pointer bufferColumn3 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_matrixfromcolumnsnode_getinputd.invokeInt(new java.lang.Object[]{mHandle, bufferColumn3}));
		Pointer valueColumn3 = bufferColumn3.getPointer(0);
		ImplicitPort column3 = null;
		if (valueColumn3 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Column3 was a null pointer");
		}
		column3 = mWrapper.PolymorphicFactory(valueColumn3, ImplicitPort.class);
		return column3;
	}

	/**
	 * Retrieves the output
	 *
	 * @return the output
	 * @throws Lib3MFException
	 */
	public ImplicitPort getOutputResult() throws Lib3MFException {
		Pointer bufferResult = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_matrixfromcolumnsnode_getoutputresult.invokeInt(new java.lang.Object[]{mHandle, bufferResult}));
		Pointer valueResult = bufferResult.getPointer(0);
		ImplicitPort result = null;
		if (valueResult == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Result was a null pointer");
		}
		result = mWrapper.PolymorphicFactory(valueResult, ImplicitPort.class);
		return result;
	}


}

