<?php

declare (strict_types=1);
namespace OCA\News\Vendor\FeedIo\Http;

use OCA\News\Vendor\FeedIo\FeedInterface;
use OCA\News\Vendor\FeedIo\FormatterInterface;
use OCA\News\Vendor\Nyholm\Psr7\Response;
use OCA\News\Vendor\Psr\Http\Message\ResponseInterface;
class ResponseBuilder
{
    /**
     * @param int $maxAge max-age in seconds
     * @param bool $public is the response public
     */
    public function __construct(protected int $maxAge = 600, protected bool $public = \true)
    {
    }
    /**
     * @param  string $mimeType
     * @param  FormatterInterface $formatter
     * @param  FeedInterface $feed
     * @return ResponseInterface
     */
    public function createResponse(string $mimeType, FormatterInterface $formatter, FeedInterface $feed): ResponseInterface
    {
        $headers = ['Content-Type' => $mimeType, 'Cache-Control' => ($this->public ? 'public' : 'private') . ", max-age={$this->maxAge}"];
        // Feed could have no items
        if ($feed->getLastModified() instanceof \DateTime) {
            $headers['Last-Modified'] = $feed->getLastModified()->format(\DateTime::RSS);
        }
        return new Response(200, $headers, $formatter->toString($feed));
    }
}
