/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import oracle.security.pki.internal.asn1.ASN1Constructed;
import oracle.security.pki.internal.asn1.ASN1Header;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1SetInputStream;
import oracle.security.pki.internal.asn1.ASN1TaggedObject;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.internal.asn1.CachedASN1Object;

public class ASN1Set
implements ASN1Constructed,
ASN1TaggedObject {
    public static final int a = 0;
    public static final int b = 1;
    public static final int c = 2;
    private ArrayList<ASN1Object> d = new ArrayList();
    private int e = 0;
    private ASN1Header f = null;
    private int g = 2;
    private ASN1Object[] h = null;

    public ASN1Set() {
    }

    public ASN1Set(ASN1Object aSN1Object) {
        this.a(aSN1Object);
    }

    public ASN1Set(List<? extends ASN1Object> list) {
        this.d = list == null ? null : new ArrayList<ASN1Object>(list);
        this.e = 0;
        int n = this.d.size();
        for (int i = 0; i < n; ++i) {
            this.e += this.d.get(i).length();
        }
    }

    public ASN1Set(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    @Override
    public ASN1Header a() {
        if (this.f == null) {
            this.f = new ASN1Header(17, 0, 1, this.e);
        }
        return this.f;
    }

    private ASN1Object[] g() {
        if (this.h == null) {
            this.h = ASN1Set.a(this.d, this.g);
        }
        return this.h;
    }

    @Override
    public ArrayList<ASN1Object> b() {
        return this.d;
    }

    @Override
    public int c() {
        return this.d.size();
    }

    @Override
    public ASN1Object a(int n) {
        return this.d.get(n);
    }

    public ASN1Object d() {
        return this.d.get(0);
    }

    public ASN1Object e() {
        return this.d.get(this.d.size() - 1);
    }

    public void a(ASN1Object aSN1Object) {
        this.d.add(aSN1Object);
        this.e += aSN1Object.length();
        this.f = null;
        this.h = null;
    }

    public void b(int n) {
        this.g = n;
        this.h = null;
    }

    public int f() {
        return this.g;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SET {");
        int n = this.d.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.d.get(i).toString());
            if (i == this.d.size() - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1SetInputStream aSN1SetInputStream = new ASN1SetInputStream(inputStream);
        this.d = new ArrayList();
        this.e = 0;
        while (aSN1SetInputStream.a()) {
            ASN1Object aSN1Object = ASN1Utils.a(aSN1SetInputStream);
            this.d.add(aSN1Object);
            this.e += aSN1Object.length();
        }
        aSN1SetInputStream.b();
        this.f = null;
        this.h = null;
    }

    @Override
    public int length() {
        return this.a().g();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.a().output(outputStream);
        if (this.g == 0) {
            int n = this.d.size();
            for (int i = 0; i < n; ++i) {
                this.d.get(i).output(outputStream);
            }
        } else {
            ASN1Object[] aSN1ObjectArray = this.g();
            int n = aSN1ObjectArray.length;
            for (int i = 0; i < n; ++i) {
                aSN1ObjectArray[i].output(outputStream);
            }
        }
    }

    static <S extends ASN1Object> ASN1Object[] a(ArrayList<S> arrayList, int n) {
        ASN1Object[] aSN1ObjectArray = new ASN1Object[arrayList.size()];
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            aSN1ObjectArray[i] = n == 2 ? new CachedASN1Object((ASN1Object)arrayList.get(i)) : (ASN1Object)arrayList.get(i);
        }
        if (n != 0) {
            Arrays.sort(aSN1ObjectArray, new ASN1ObjectComparator(n));
        }
        return aSN1ObjectArray;
    }

    private static class ASN1ObjectComparator
    implements Comparator<ASN1Object> {
        int a;

        public ASN1ObjectComparator(int n) {
            this.a = n;
        }

        public int a(ASN1Object aSN1Object, ASN1Object aSN1Object2) {
            int n;
            if (this.a == 1) {
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Object;
                ASN1TaggedObject aSN1TaggedObject2 = (ASN1TaggedObject)aSN1Object2;
                return aSN1TaggedObject.a().a() - aSN1TaggedObject2.a().a();
            }
            byte[] byArray = ((CachedASN1Object)aSN1Object).a();
            byte[] byArray2 = ((CachedASN1Object)aSN1Object2).a();
            int n2 = Math.min(byArray.length, byArray2.length);
            for (n = 0; n < n2 && byArray[n] == byArray2[n]; ++n) {
            }
            if (n == n2) {
                return byArray.length - byArray2.length;
            }
            return (byArray[n] & 0xFF) - (byArray2[n] & 0xFF);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((ASN1Object)object, (ASN1Object)object2);
        }
    }
}

