/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.io.IOException;
import org.jsmpp.session.GenericMessageReceiverListener;
import org.jsmpp.session.OutboundServerMessageReceiverListener;
import org.jsmpp.session.SMPPOutboundServerSession;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.connection.Connection;
import org.jsmpp.session.connection.ServerConnection;
import org.jsmpp.session.connection.ServerConnectionFactory;
import org.jsmpp.session.connection.socket.ServerSocketConnectionFactory;

public class OutboundSMPPServerSessionListener {
    private final int port;
    private final ServerConnection serverConn;
    private int initiationTimer = 5000;
    private int pduProcessorDegree = 3;
    private SessionStateListener sessionStateListener;
    private GenericMessageReceiverListener messageReceiverListener;
    private OutboundServerMessageReceiverListener outboundServerMessageReceiverListener;

    public OutboundSMPPServerSessionListener(int port) throws IOException {
        this(port, new ServerSocketConnectionFactory());
    }

    public OutboundSMPPServerSessionListener(int port, ServerConnectionFactory serverConnFactory) throws IOException {
        this.port = port;
        this.serverConn = serverConnFactory.listen(port);
    }

    public OutboundSMPPServerSessionListener(int port, int timeout, ServerConnectionFactory serverConnFactory) throws IOException {
        this.port = port;
        this.serverConn = serverConnFactory.listen(port, timeout);
    }

    public OutboundSMPPServerSessionListener(int port, int timeout, int backlog, ServerConnectionFactory serverConnFactory) throws IOException {
        this.port = port;
        this.serverConn = serverConnFactory.listen(port, timeout, backlog);
    }

    public int getTimeout(int timeout) throws IOException {
        return this.serverConn.getSoTimeout();
    }

    public void setTimeout(int timeout) throws IOException {
        this.serverConn.setSoTimeout(timeout);
    }

    public void setPduProcessorDegree(int pduProcessorDegree) {
        this.pduProcessorDegree = pduProcessorDegree;
    }

    public int getPduProcessorDegree() {
        return this.pduProcessorDegree;
    }

    public int getPort() {
        return this.port;
    }

    public int getInitiationTimer() {
        return this.initiationTimer;
    }

    public void setInitiationTimer(int initiationTimer) {
        this.initiationTimer = initiationTimer;
    }

    public SessionStateListener getSessionStateListener() {
        return this.sessionStateListener;
    }

    public void setSessionStateListener(SessionStateListener sessionStateListener) {
        this.sessionStateListener = sessionStateListener;
    }

    public GenericMessageReceiverListener getMessageReceiverListener() {
        return this.messageReceiverListener;
    }

    public void setMessageReceiverListener(GenericMessageReceiverListener messageReceiverListener) {
        this.messageReceiverListener = messageReceiverListener;
    }

    public OutboundServerMessageReceiverListener getOutboundServerMessageReceiverListener() {
        return this.outboundServerMessageReceiverListener;
    }

    public void setOutboundServerMessageReceiverListener(OutboundServerMessageReceiverListener outboundServerMessageReceiverListener) {
        this.outboundServerMessageReceiverListener = outboundServerMessageReceiverListener;
    }

    public SMPPOutboundServerSession accept() throws IOException {
        Connection conn = this.serverConn.accept();
        conn.setSoTimeout(this.initiationTimer);
        return new SMPPOutboundServerSession(conn, this.sessionStateListener, this.messageReceiverListener, this.outboundServerMessageReceiverListener, this.pduProcessorDegree);
    }

    public void close() throws IOException {
        this.serverConn.close();
    }
}

