/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.metrics.Avg;
import org.opensearch.search.aggregations.metrics.CompensatedSum;
import org.opensearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.opensearch.search.aggregations.metrics.InternalScriptedMetric;
import org.opensearch.search.aggregations.metrics.ScriptedAvg;

public class InternalAvg
extends InternalNumericMetricsAggregation.SingleValue
implements Avg {
    private final double sum;
    private final long count;

    public InternalAvg(String name, double sum, long count, DocValueFormat format, Map<String, Object> metadata) {
        super(name, metadata);
        this.sum = sum;
        this.count = count;
        this.format = format;
    }

    public InternalAvg(StreamInput in) throws IOException {
        super(in);
        this.format = (DocValueFormat)in.readNamedWriteable(DocValueFormat.class);
        this.sum = in.readDouble();
        this.count = in.readVLong();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.format);
        out.writeDouble(this.sum);
        out.writeVLong(this.count);
    }

    @Override
    public double value() {
        return this.getValue();
    }

    @Override
    public double getValue() {
        return this.sum / (double)this.count;
    }

    double getSum() {
        return this.sum;
    }

    long getCount() {
        return this.count;
    }

    DocValueFormat getFormatter() {
        return this.format;
    }

    public String getWriteableName() {
        return "avg";
    }

    @Override
    public InternalAvg reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        long count = 0L;
        for (InternalAggregation aggregation : aggregations) {
            if (aggregation instanceof InternalScriptedMetric) {
                List<Object> aggList = ((InternalScriptedMetric)aggregation).aggregationsList();
                for (Object value : aggList) {
                    if (value instanceof ScriptedAvg) {
                        ScriptedAvg scriptedAvg = (ScriptedAvg)value;
                        count += scriptedAvg.getCount();
                        kahanSummation.add(scriptedAvg.getSum());
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid ScriptedMetric result for [" + this.getName() + "] avg aggregation. Expected ScriptedAvg but received [" + (value == null ? "null" : value.getClass().getName()) + "]");
                }
                continue;
            }
            InternalAvg avg = (InternalAvg)aggregation;
            count += avg.count;
            kahanSummation.add(avg.sum);
        }
        return new InternalAvg(this.getName(), kahanSummation.value(), count, this.format, this.getMetadata());
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.count != 0L ? Double.valueOf(this.getValue()) : null);
        if (this.count != 0L && this.format != DocValueFormat.RAW) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(this.getValue()).toString());
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sum, this.count, this.format.getWriteableName());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalAvg other = (InternalAvg)obj;
        return Objects.equals(this.sum, other.sum) && Objects.equals(this.count, other.count) && Objects.equals(this.format.getWriteableName(), other.format.getWriteableName());
    }
}

