/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm.cancellation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.WorkloadGroup;
import org.opensearch.tasks.CancellableTask;
import org.opensearch.tasks.TaskCancellation;
import org.opensearch.wlm.MutableWorkloadGroupFragment;
import org.opensearch.wlm.ResourceType;
import org.opensearch.wlm.WlmMode;
import org.opensearch.wlm.WorkloadGroupLevelResourceUsageView;
import org.opensearch.wlm.WorkloadGroupTask;
import org.opensearch.wlm.WorkloadGroupsStateAccessor;
import org.opensearch.wlm.WorkloadManagementSettings;
import org.opensearch.wlm.cancellation.TaskSelectionStrategy;
import org.opensearch.wlm.stats.WorkloadGroupState;
import org.opensearch.wlm.tracker.WorkloadGroupResourceUsageTrackerService;

public class WorkloadGroupTaskCancellationService {
    public static final double MIN_VALUE = 1.0E-9;
    private static final Logger log = LogManager.getLogger(WorkloadGroupTaskCancellationService.class);
    private final WorkloadManagementSettings workloadManagementSettings;
    private final TaskSelectionStrategy taskSelectionStrategy;
    private final WorkloadGroupResourceUsageTrackerService resourceUsageTrackerService;
    Map<String, WorkloadGroupLevelResourceUsageView> workloadGroupLevelResourceUsageViews;
    private final WorkloadGroupsStateAccessor workloadGroupStateAccessor;

    public WorkloadGroupTaskCancellationService(WorkloadManagementSettings workloadManagementSettings, TaskSelectionStrategy taskSelectionStrategy, WorkloadGroupResourceUsageTrackerService resourceUsageTrackerService, WorkloadGroupsStateAccessor workloadGroupStateAccessor) {
        this.workloadManagementSettings = workloadManagementSettings;
        this.taskSelectionStrategy = taskSelectionStrategy;
        this.resourceUsageTrackerService = resourceUsageTrackerService;
        this.workloadGroupStateAccessor = workloadGroupStateAccessor;
    }

    public void cancelTasks(BooleanSupplier isNodeInDuress, Collection<WorkloadGroup> activeWorkloadGroups, Collection<WorkloadGroup> deletedWorkloadGroups) {
        this.workloadGroupLevelResourceUsageViews = this.resourceUsageTrackerService.constructWorkloadGroupLevelUsageViews();
        this.cancelTasks(MutableWorkloadGroupFragment.ResiliencyMode.ENFORCED, activeWorkloadGroups);
        this.handleNodeDuress(isNodeInDuress, activeWorkloadGroups, deletedWorkloadGroups);
        this.updateResourceUsageInWorkloadGroupState(activeWorkloadGroups);
    }

    private void updateResourceUsageInWorkloadGroupState(Collection<WorkloadGroup> activeWorkloadGroups) {
        HashSet<String> isSearchWorkloadRunning = new HashSet<String>();
        for (Map.Entry<String, WorkloadGroupLevelResourceUsageView> workloadGroupLevelResourceUsageViewEntry : this.workloadGroupLevelResourceUsageViews.entrySet()) {
            isSearchWorkloadRunning.add(workloadGroupLevelResourceUsageViewEntry.getKey());
            WorkloadGroupState workloadGroupState = this.getWorkloadGroupState(workloadGroupLevelResourceUsageViewEntry.getKey());
            WorkloadGroupResourceUsageTrackerService.TRACKED_RESOURCES.forEach(resourceType -> {
                double currentUsage = ((WorkloadGroupLevelResourceUsageView)workloadGroupLevelResourceUsageViewEntry.getValue()).getResourceUsageData().get(resourceType);
                workloadGroupState.getResourceState().get(resourceType).setLastRecordedUsage(currentUsage);
            });
        }
        activeWorkloadGroups.forEach(workloadGroup -> {
            if (!isSearchWorkloadRunning.contains(workloadGroup.get_id())) {
                WorkloadGroupResourceUsageTrackerService.TRACKED_RESOURCES.forEach(resourceType -> this.getWorkloadGroupState(workloadGroup.get_id()).getResourceState().get(resourceType).setLastRecordedUsage(0.0));
            }
        });
    }

    private void handleNodeDuress(BooleanSupplier isNodeInDuress, Collection<WorkloadGroup> activeWorkloadGroups, Collection<WorkloadGroup> deletedWorkloadGroups) {
        if (!isNodeInDuress.getAsBoolean()) {
            return;
        }
        List<Consumer<Void>> duressActions = List.of(v -> this.cancelTasksFromDeletedWorkloadGroups(deletedWorkloadGroups), v -> this.cancelTasks(MutableWorkloadGroupFragment.ResiliencyMode.SOFT, activeWorkloadGroups));
        for (Consumer<Void> duressAction : duressActions) {
            if (!isNodeInDuress.getAsBoolean()) break;
            duressAction.accept(null);
        }
    }

    private void cancelTasksFromDeletedWorkloadGroups(Collection<WorkloadGroup> deletedWorkloadGroups) {
        this.cancelTasks(this.getAllCancellableTasks(deletedWorkloadGroups));
    }

    List<TaskCancellation> getAllCancellableTasks(MutableWorkloadGroupFragment.ResiliencyMode resiliencyMode, Collection<WorkloadGroup> workloadGroups) {
        return this.getAllCancellableTasks(workloadGroups.stream().filter(workloadGroup -> workloadGroup.getResiliencyMode() == resiliencyMode).collect(Collectors.toList()));
    }

    List<TaskCancellation> getAllCancellableTasks(Collection<WorkloadGroup> workloadGroups) {
        ArrayList<TaskCancellation> taskCancellations = new ArrayList<TaskCancellation>();
        ArrayList<Runnable> onCancelCallbacks = new ArrayList<Runnable>();
        for (WorkloadGroup workloadGroup : workloadGroups) {
            ArrayList<TaskCancellation.Reason> reasons = new ArrayList<TaskCancellation.Reason>();
            ArrayList<WorkloadGroupTask> selectedTasks = new ArrayList<WorkloadGroupTask>();
            for (ResourceType resourceType : WorkloadGroupResourceUsageTrackerService.TRACKED_RESOURCES) {
                double excessUsage = this.getExcessUsage(workloadGroup, resourceType) - resourceType.getResourceUsageCalculator().calculateResourceUsage(selectedTasks);
                if (!(excessUsage > 1.0E-9)) continue;
                reasons.add(new TaskCancellation.Reason(this.generateReasonString(workloadGroup, resourceType), 1));
                onCancelCallbacks.add(this.getResourceTypeOnCancelCallback(workloadGroup.get_id(), resourceType));
                selectedTasks.addAll(this.taskSelectionStrategy.selectTasksForCancellation(this.getTasksFor(workloadGroup), excessUsage, resourceType).stream().filter(x -> selectedTasks.stream().noneMatch(y -> x.getId() != y.getId())).collect(Collectors.toList()));
            }
            if (reasons.isEmpty()) continue;
            onCancelCallbacks.add(this.getWorkloadGroupState((String)workloadGroup.get_id()).totalCancellations::inc);
            taskCancellations.addAll(selectedTasks.stream().map(task -> new TaskCancellation((CancellableTask)task, (List<TaskCancellation.Reason>)reasons, (List<Runnable>)onCancelCallbacks)).collect(Collectors.toList()));
        }
        return taskCancellations;
    }

    private String generateReasonString(WorkloadGroup workloadGroup, ResourceType resourceType) {
        double currentUsage = this.getCurrentUsage(workloadGroup, resourceType);
        return "WorkloadGroup ID : " + workloadGroup.get_id() + " breached the resource limit: (" + currentUsage + " > " + String.valueOf(workloadGroup.getResourceLimits().get((Object)resourceType)) + ") for resource type : " + resourceType.getName();
    }

    private List<WorkloadGroupTask> getTasksFor(WorkloadGroup workloadGroup) {
        return this.workloadGroupLevelResourceUsageViews.get(workloadGroup.get_id()).getActiveTasks();
    }

    private void cancelTasks(MutableWorkloadGroupFragment.ResiliencyMode resiliencyMode, Collection<WorkloadGroup> workloadGroups) {
        this.cancelTasks(this.getAllCancellableTasks(resiliencyMode, workloadGroups));
    }

    private void cancelTasks(List<TaskCancellation> cancellableTasks) {
        Consumer<TaskCancellation> cancellationLoggingConsumer;
        Consumer<TaskCancellation> cancellationConsumer = cancellationLoggingConsumer = taskCancellation -> log.warn("Task {} is eligible for cancellation for reason {}", (Object)taskCancellation.getTask().getId(), (Object)taskCancellation.getReasonString());
        if (this.workloadManagementSettings.getWlmMode() == WlmMode.ENABLED) {
            cancellationConsumer = taskCancellation -> {
                cancellationLoggingConsumer.accept((TaskCancellation)taskCancellation);
                taskCancellation.cancel();
            };
        }
        cancellableTasks.forEach(cancellationConsumer);
    }

    private double getExcessUsage(WorkloadGroup workloadGroup, ResourceType resourceType) {
        if (workloadGroup.getResourceLimits().get((Object)resourceType) == null || !this.workloadGroupLevelResourceUsageViews.containsKey(workloadGroup.get_id())) {
            return 0.0;
        }
        return this.getCurrentUsage(workloadGroup, resourceType) - this.getNormalisedThreshold(workloadGroup, resourceType);
    }

    private double getCurrentUsage(WorkloadGroup workloadGroup, ResourceType resourceType) {
        WorkloadGroupLevelResourceUsageView workloadGroupResourceUsageView = this.workloadGroupLevelResourceUsageViews.get(workloadGroup.get_id());
        return workloadGroupResourceUsageView.getResourceUsageData().get((Object)resourceType);
    }

    private double getNormalisedThreshold(WorkloadGroup workloadGroup, ResourceType resourceType) {
        double nodeLevelCancellationThreshold = resourceType.getNodeLevelThreshold(this.workloadManagementSettings);
        return workloadGroup.getResourceLimits().get((Object)resourceType) * nodeLevelCancellationThreshold;
    }

    private Runnable getResourceTypeOnCancelCallback(String workloadGroupId, ResourceType resourceType) {
        WorkloadGroupState workloadGroupState = this.getWorkloadGroupState(workloadGroupId);
        return workloadGroupState.getResourceState().get((Object)((Object)resourceType)).cancellations::inc;
    }

    private WorkloadGroupState getWorkloadGroupState(String workloadGroupId) {
        assert (workloadGroupId != null) : "workloadGroupId should never be null at this point.";
        return this.workloadGroupStateAccessor.getWorkloadGroupState(workloadGroupId);
    }

    public void pruneDeletedWorkloadGroups(Collection<WorkloadGroup> deletedWorkloadGroups) {
        ArrayList<WorkloadGroup> currentDeletedWorkloadGroups = new ArrayList<WorkloadGroup>(deletedWorkloadGroups);
        for (WorkloadGroup workloadGroup : currentDeletedWorkloadGroups) {
            if (!this.workloadGroupLevelResourceUsageViews.get(workloadGroup.get_id()).getActiveTasks().isEmpty()) continue;
            deletedWorkloadGroups.remove(workloadGroup);
        }
    }
}

