/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpConnectionMetrics;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpStreamResetException;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.RequestNotExecutedException;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.impl.BasicEndpointDetails;
import org.apache.hc.core5.http.impl.BasicHttpConnectionMetrics;
import org.apache.hc.core5.http.impl.CharCodingSupport;
import org.apache.hc.core5.http.io.HttpTransportMetrics;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.AsyncPushProducer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.command.CommandSupport;
import org.apache.hc.core5.http.nio.command.RequestExecutionCommand;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.http.nio.command.StaleCheckCommand;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http2.H2ConnectionException;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.H2StreamResetException;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.config.H2Param;
import org.apache.hc.core5.http2.config.H2Setting;
import org.apache.hc.core5.http2.frame.FrameFactory;
import org.apache.hc.core5.http2.frame.FrameFlag;
import org.apache.hc.core5.http2.frame.FrameType;
import org.apache.hc.core5.http2.frame.RawFrame;
import org.apache.hc.core5.http2.frame.StreamIdGenerator;
import org.apache.hc.core5.http2.hpack.HPackDecoder;
import org.apache.hc.core5.http2.hpack.HPackEncoder;
import org.apache.hc.core5.http2.impl.BasicH2TransportMetrics;
import org.apache.hc.core5.http2.impl.nio.FrameInputBuffer;
import org.apache.hc.core5.http2.impl.nio.FrameOutputBuffer;
import org.apache.hc.core5.http2.impl.nio.H2Stream;
import org.apache.hc.core5.http2.impl.nio.H2StreamChannel;
import org.apache.hc.core5.http2.impl.nio.H2StreamHandler;
import org.apache.hc.core5.http2.impl.nio.H2StreamListener;
import org.apache.hc.core5.http2.impl.nio.H2Streams;
import org.apache.hc.core5.http2.impl.nio.NoopH2StreamHandler;
import org.apache.hc.core5.http2.nio.AsyncPingHandler;
import org.apache.hc.core5.http2.nio.command.PingCommand;
import org.apache.hc.core5.http2.nio.command.PushResponseCommand;
import org.apache.hc.core5.http2.priority.PriorityParamsParser;
import org.apache.hc.core5.http2.priority.PriorityValue;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.apache.hc.core5.util.Identifiable;
import org.apache.hc.core5.util.Timeout;

abstract class AbstractH2StreamMultiplexer
implements Identifiable,
HttpConnection {
    private static final long CONNECTION_WINDOW_LOW_MARK = 0xA00000L;
    private final ProtocolIOSession ioSession;
    private final FrameFactory frameFactory;
    private final HttpProcessor httpProcessor;
    private final H2Config localConfig;
    private final BasicH2TransportMetrics inputMetrics;
    private final BasicH2TransportMetrics outputMetrics;
    private final BasicHttpConnectionMetrics connMetrics;
    private final FrameInputBuffer inputBuffer;
    private final FrameOutputBuffer outputBuffer;
    private final Deque<RawFrame> outputQueue;
    private final HPackEncoder hPackEncoder;
    private final HPackDecoder hPackDecoder;
    private final H2Streams streams;
    private final Queue<AsyncPingHandler> pingHandlers;
    private final AtomicInteger connInputWindow;
    private final AtomicInteger connOutputWindow;
    private final AtomicInteger outputRequests;
    private final H2StreamListener streamListener;
    private ConnectionHandshake connState = ConnectionHandshake.READY;
    private SettingsHandshake localSettingState = SettingsHandshake.READY;
    private SettingsHandshake remoteSettingState = SettingsHandshake.READY;
    private int initInputWinSize;
    private int initOutputWinSize;
    private int lowMark;
    private volatile H2Config remoteConfig;
    private Continuation continuation;
    private EndpointDetails endpointDetails;
    private boolean goAwayReceived;
    private final Map<Integer, PriorityValue> priorities = new ConcurrentHashMap<Integer, PriorityValue>();
    private volatile boolean peerNoRfc7540Priorities;

    AbstractH2StreamMultiplexer(ProtocolIOSession ioSession, FrameFactory frameFactory, StreamIdGenerator idGenerator, HttpProcessor httpProcessor, CharCodingConfig charCodingConfig, H2Config h2Config, H2StreamListener streamListener) {
        this.ioSession = (ProtocolIOSession)Args.notNull((Object)ioSession, (String)"IO session");
        this.frameFactory = (FrameFactory)Args.notNull((Object)frameFactory, (String)"Frame factory");
        this.httpProcessor = (HttpProcessor)Args.notNull((Object)httpProcessor, (String)"HTTP processor");
        this.streams = new H2Streams(idGenerator);
        this.localConfig = h2Config != null ? h2Config : H2Config.DEFAULT;
        this.inputMetrics = new BasicH2TransportMetrics();
        this.outputMetrics = new BasicH2TransportMetrics();
        this.connMetrics = new BasicHttpConnectionMetrics((HttpTransportMetrics)this.inputMetrics, (HttpTransportMetrics)this.outputMetrics);
        this.inputBuffer = new FrameInputBuffer(this.inputMetrics, this.localConfig.getMaxFrameSize());
        this.outputBuffer = new FrameOutputBuffer(this.outputMetrics, this.localConfig.getMaxFrameSize());
        this.outputQueue = new ConcurrentLinkedDeque<RawFrame>();
        this.pingHandlers = new ConcurrentLinkedQueue<AsyncPingHandler>();
        this.outputRequests = new AtomicInteger(0);
        this.hPackEncoder = new HPackEncoder(H2Config.INIT.getHeaderTableSize(), CharCodingSupport.createEncoder((CharCodingConfig)charCodingConfig));
        this.hPackDecoder = new HPackDecoder(H2Config.INIT.getHeaderTableSize(), CharCodingSupport.createDecoder((CharCodingConfig)charCodingConfig));
        this.remoteConfig = H2Config.INIT;
        this.connInputWindow = new AtomicInteger(H2Config.INIT.getInitialWindowSize());
        this.connOutputWindow = new AtomicInteger(H2Config.INIT.getInitialWindowSize());
        this.initInputWinSize = H2Config.INIT.getInitialWindowSize();
        this.initOutputWinSize = H2Config.INIT.getInitialWindowSize();
        this.hPackDecoder.setMaxListSize(H2Config.INIT.getMaxHeaderListSize());
        this.lowMark = H2Config.INIT.getInitialWindowSize() / 2;
        this.streamListener = streamListener;
    }

    public String getId() {
        return this.ioSession.getId();
    }

    BasicHttpConnectionMetrics getConnMetrics() {
        return this.connMetrics;
    }

    HttpProcessor getHttpProcessor() {
        return this.httpProcessor;
    }

    void submitCommand(Command command) {
        this.ioSession.enqueue(command, Command.Priority.NORMAL);
    }

    abstract void validateSetting(H2Param var1, int var2) throws H2ConnectionException;

    abstract H2Setting[] generateSettings(H2Config var1);

    abstract void acceptHeaderFrame() throws H2ConnectionException;

    abstract void acceptPushRequest() throws H2ConnectionException;

    abstract void acceptPushFrame() throws H2ConnectionException;

    abstract H2StreamHandler incomingRequest(H2StreamChannel var1) throws IOException;

    abstract H2StreamHandler incomingPushPromise(H2StreamChannel var1, HandlerFactory<AsyncPushConsumer> var2) throws IOException;

    abstract H2StreamHandler outgoingRequest(H2StreamChannel var1, AsyncClientExchangeHandler var2, HandlerFactory<AsyncPushConsumer> var3, HttpContext var4) throws IOException;

    abstract H2StreamHandler outgoingPushPromise(H2StreamChannel var1, AsyncPushProducer var2) throws IOException;

    abstract boolean allowGracefulAbort(H2Stream var1);

    private int updateWindow(AtomicInteger window, int delta) throws ArithmeticException {
        long newValue;
        int current;
        do {
            if (Math.abs(newValue = (long)(current = window.get()) + (long)delta) <= Integer.MAX_VALUE) continue;
            throw new ArithmeticException("Update causes flow control window to exceed 2147483647");
        } while (!window.compareAndSet(current, (int)newValue));
        return (int)newValue;
    }

    private int updateWindowMax(AtomicInteger window) throws ArithmeticException {
        int current;
        while (!window.compareAndSet(current = window.get(), Integer.MAX_VALUE)) {
        }
        return Integer.MAX_VALUE - current;
    }

    private int updateInputWindow(int streamId, AtomicInteger window, int delta) throws ArithmeticException {
        int newSize = this.updateWindow(window, delta);
        if (this.streamListener != null) {
            this.streamListener.onInputFlowControl(this, streamId, delta, newSize);
        }
        return newSize;
    }

    private int updateOutputWindow(int streamId, AtomicInteger window, int delta) throws ArithmeticException {
        int newSize = this.updateWindow(window, delta);
        if (this.streamListener != null) {
            this.streamListener.onOutputFlowControl(this, streamId, delta, newSize);
        }
        return newSize;
    }

    private void commitFrameInternal(RawFrame frame) throws IOException {
        if (this.outputBuffer.isEmpty() && this.outputQueue.isEmpty()) {
            if (this.streamListener != null) {
                this.streamListener.onFrameOutput(this, frame.getStreamId(), frame);
            }
            this.outputBuffer.write(frame, (WritableByteChannel)this.ioSession);
        } else {
            this.outputQueue.addLast(frame);
        }
        this.ioSession.setEvent(4);
    }

    private void commitFrame(RawFrame frame) throws IOException {
        Args.notNull((Object)frame, (String)"Frame");
        this.ioSession.getLock().lock();
        try {
            this.commitFrameInternal(frame);
        }
        finally {
            this.ioSession.getLock().unlock();
        }
    }

    private void commitHeaders(int streamId, List<? extends Header> headers, boolean endStream) throws IOException {
        if (this.streamListener != null) {
            this.streamListener.onHeaderOutput(this, streamId, headers);
        }
        ByteArrayBuffer buf = new ByteArrayBuffer(512);
        this.hPackEncoder.encodeHeaders(buf, headers, this.localConfig.isCompressionEnabled());
        int off = 0;
        int remaining = buf.length();
        boolean continuation = false;
        while (remaining > 0) {
            RawFrame frame;
            boolean endHeaders;
            int chunk = Math.min(this.remoteConfig.getMaxFrameSize(), remaining);
            ByteBuffer payload = ByteBuffer.wrap(buf.array(), off, chunk);
            off += chunk;
            boolean bl = endHeaders = (remaining -= chunk) == 0;
            if (!continuation) {
                frame = this.frameFactory.createHeaders(streamId, payload, endHeaders, endStream);
                continuation = true;
            } else {
                frame = this.frameFactory.createContinuation(streamId, payload, endHeaders);
            }
            this.commitFrameInternal(frame);
        }
    }

    private void commitPushPromise(int streamId, int promisedStreamId, List<Header> headers) throws IOException {
        if (headers == null || headers.isEmpty()) {
            throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Message headers are missing");
        }
        if (this.streamListener != null) {
            this.streamListener.onHeaderOutput(this, streamId, headers);
        }
        ByteArrayBuffer buf = new ByteArrayBuffer(512);
        buf.append((int)((byte)(promisedStreamId >> 24)));
        buf.append((int)((byte)(promisedStreamId >> 16)));
        buf.append((int)((byte)(promisedStreamId >> 8)));
        buf.append((int)((byte)promisedStreamId));
        this.hPackEncoder.encodeHeaders(buf, headers, this.localConfig.isCompressionEnabled());
        int off = 0;
        int remaining = buf.length();
        boolean continuation = false;
        while (remaining > 0) {
            RawFrame frame;
            boolean endHeaders;
            int chunk = Math.min(this.remoteConfig.getMaxFrameSize(), remaining);
            ByteBuffer payload = ByteBuffer.wrap(buf.array(), off, chunk);
            off += chunk;
            boolean bl = endHeaders = (remaining -= chunk) == 0;
            if (!continuation) {
                frame = this.frameFactory.createPushPromise(streamId, payload, endHeaders);
                continuation = true;
            } else {
                frame = this.frameFactory.createContinuation(streamId, payload, endHeaders);
            }
            this.commitFrameInternal(frame);
        }
    }

    private void streamDataFrame(int streamId, AtomicInteger streamOutputWindow, ByteBuffer payload, int chunk) throws IOException {
        RawFrame dataFrame = this.frameFactory.createData(streamId, payload, false);
        if (this.streamListener != null) {
            this.streamListener.onFrameOutput(this, streamId, dataFrame);
        }
        this.updateOutputWindow(0, this.connOutputWindow, -chunk);
        this.updateOutputWindow(streamId, streamOutputWindow, -chunk);
        this.outputBuffer.write(dataFrame, (WritableByteChannel)this.ioSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int streamData(int streamId, AtomicInteger streamOutputWindow, ByteBuffer payload) throws IOException {
        if (this.outputBuffer.isEmpty() && this.outputQueue.isEmpty()) {
            int chunk;
            int capacity = Math.min(this.connOutputWindow.get(), streamOutputWindow.get());
            if (capacity <= 0) {
                return 0;
            }
            int maxPayloadSize = Math.min(capacity, this.outputBuffer.getMaxFramePayloadSize());
            if (payload.remaining() <= maxPayloadSize) {
                chunk = payload.remaining();
                this.streamDataFrame(streamId, streamOutputWindow, payload, chunk);
            } else {
                chunk = maxPayloadSize;
                int originalLimit = payload.limit();
                try {
                    payload.limit(payload.position() + chunk);
                    this.streamDataFrame(streamId, streamOutputWindow, payload, chunk);
                }
                finally {
                    payload.limit(originalLimit);
                }
            }
            payload.position(payload.position() + chunk);
            this.ioSession.setEvent(4);
            return chunk;
        }
        return 0;
    }

    private void incrementInputCapacity(int streamId, AtomicInteger inputWindow, int inputCapacity) throws IOException {
        int streamWinSize;
        int remainingCapacity;
        int chunk;
        if (inputCapacity > 0 && (chunk = Math.min(inputCapacity, remainingCapacity = Integer.MAX_VALUE - (streamWinSize = inputWindow.get()))) != 0) {
            this.updateInputWindow(streamId, inputWindow, chunk);
            RawFrame windowUpdateFrame = this.frameFactory.createWindowUpdate(streamId, chunk);
            this.commitFrame(windowUpdateFrame);
        }
    }

    void requestSessionOutput() {
        this.outputRequests.incrementAndGet();
        this.ioSession.setEvent(4);
    }

    public final void onConnect() throws HttpException, IOException {
        this.connState = ConnectionHandshake.ACTIVE;
        RawFrame settingsFrame = this.frameFactory.createSettings(this.generateSettings(this.localConfig));
        this.commitFrame(settingsFrame);
        this.localSettingState = SettingsHandshake.TRANSMITTED;
        this.maximizeWindow(0, this.connInputWindow);
        if (this.streamListener != null) {
            int initInputWindow = this.connInputWindow.get();
            this.streamListener.onInputFlowControl(this, 0, initInputWindow, initInputWindow);
            int initOutputWindow = this.connOutputWindow.get();
            this.streamListener.onOutputFlowControl(this, 0, initOutputWindow, initOutputWindow);
        }
    }

    public final void onInput(ByteBuffer src) throws HttpException, IOException {
        block4: {
            RawFrame frame;
            block3: {
                if (this.connState != ConnectionHandshake.SHUTDOWN) break block3;
                this.ioSession.clearEvent(1);
                break block4;
            }
            while ((frame = this.inputBuffer.read(src, (ReadableByteChannel)this.ioSession)) != null) {
                if (this.streamListener != null) {
                    this.streamListener.onFrameInput(this, frame.getStreamId(), frame);
                }
                this.consumeFrame(frame);
            }
            if (!this.inputBuffer.isEndOfStream()) break block4;
            if (this.connState == ConnectionHandshake.ACTIVE) {
                RawFrame goAway = this.frameFactory.createGoAway(this.streams.getLastRemoteId(), H2Error.NO_ERROR, "Unexpected end of stream");
                this.commitFrame(goAway);
            }
            this.connState = ConnectionHandshake.SHUTDOWN;
            this.requestSessionOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onOutput() throws HttpException, IOException {
        this.ioSession.getLock().lock();
        try {
            RawFrame frame;
            if (!this.outputBuffer.isEmpty()) {
                this.outputBuffer.flush((WritableByteChannel)this.ioSession);
            }
            while (this.outputBuffer.isEmpty() && (frame = this.outputQueue.poll()) != null) {
                if (this.streamListener != null) {
                    this.streamListener.onFrameOutput(this, frame.getStreamId(), frame);
                }
                this.outputBuffer.write(frame, (WritableByteChannel)this.ioSession);
            }
        }
        finally {
            this.ioSession.getLock().unlock();
        }
        if (this.connState.compareTo(ConnectionHandshake.SHUTDOWN) < 0) {
            if (this.connOutputWindow.get() > 0 && this.remoteSettingState == SettingsHandshake.ACKED) {
                this.produceOutput();
            }
            int pendingOutputRequests = this.outputRequests.get();
            boolean outputPending = false;
            if (!this.streams.isEmpty() && this.connOutputWindow.get() > 0) {
                Iterator<H2Stream> it = this.streams.iterator();
                while (it.hasNext()) {
                    H2Stream stream = it.next();
                    if (stream.isLocalClosed() || stream.getOutputWindow().get() <= 0 || !stream.isOutputReady()) continue;
                    outputPending = true;
                    break;
                }
            }
            this.ioSession.getLock().lock();
            try {
                if (!outputPending && this.outputBuffer.isEmpty() && this.outputQueue.isEmpty() && this.outputRequests.compareAndSet(pendingOutputRequests, 0)) {
                    this.ioSession.clearEvent(4);
                } else {
                    this.outputRequests.addAndGet(-pendingOutputRequests);
                }
            }
            finally {
                this.ioSession.getLock().unlock();
            }
        }
        if (this.connState.compareTo(ConnectionHandshake.ACTIVE) <= 0 && this.remoteSettingState == SettingsHandshake.ACKED) {
            Command command;
            while (this.streams.getLocalCount() < this.remoteConfig.getMaxConcurrentStreams() && (command = this.ioSession.poll()) != null) {
                if (command instanceof ShutdownCommand) {
                    this.executeShutdown((ShutdownCommand)command);
                } else if (command instanceof PingCommand) {
                    this.executePing((PingCommand)command);
                } else if (command instanceof RequestExecutionCommand) {
                    this.executeRequest((RequestExecutionCommand)command);
                } else if (command instanceof PushResponseCommand) {
                    this.executePush((PushResponseCommand)command);
                } else if (command instanceof StaleCheckCommand) {
                    this.executeStaleCheck((StaleCheckCommand)command);
                }
                if (this.outputQueue.isEmpty()) continue;
                return;
            }
        }
        if (this.connState.compareTo(ConnectionHandshake.GRACEFUL_SHUTDOWN) == 0) {
            int liveStreams = 0;
            Iterator<H2Stream> it = this.streams.iterator();
            while (it.hasNext()) {
                H2Stream stream = it.next();
                if (stream.isClosedPastLingerDeadline()) {
                    this.streams.dropStreamId(stream.getId());
                    it.remove();
                    continue;
                }
                if (!this.streams.isSameSide(stream.getId()) && stream.getId() > this.streams.getLastRemoteId()) continue;
                ++liveStreams;
            }
            if (liveStreams == 0) {
                this.connState = ConnectionHandshake.SHUTDOWN;
            }
        }
        if (this.connState.compareTo(ConnectionHandshake.GRACEFUL_SHUTDOWN) >= 0) {
            Command command;
            while ((command = this.ioSession.poll()) != null) {
                if (command instanceof ShutdownCommand) {
                    ShutdownCommand shutdownCommand = (ShutdownCommand)command;
                    if (shutdownCommand.getType() != CloseMode.IMMEDIATE) continue;
                    this.connState = ConnectionHandshake.SHUTDOWN;
                    continue;
                }
                command.cancel();
            }
        }
        if (this.connState.compareTo(ConnectionHandshake.SHUTDOWN) >= 0) {
            this.streams.shutdownAndReleaseAll();
            this.ioSession.getLock().lock();
            try {
                if (this.outputBuffer.isEmpty() && this.outputQueue.isEmpty()) {
                    this.ioSession.close();
                }
            }
            finally {
                this.ioSession.getLock().unlock();
            }
        }
    }

    public final void onTimeout(Timeout timeout) throws HttpException, IOException {
        this.connState = ConnectionHandshake.SHUTDOWN;
        RawFrame goAway = this.localSettingState != SettingsHandshake.ACKED ? this.frameFactory.createGoAway(this.streams.getLastRemoteId(), H2Error.SETTINGS_TIMEOUT, "Setting timeout (" + timeout + ")") : this.frameFactory.createGoAway(this.streams.getLastRemoteId(), H2Error.NO_ERROR, "Timeout due to inactivity (" + timeout + ")");
        this.commitFrame(goAway);
        Iterator<H2Stream> it = this.streams.iterator();
        while (it.hasNext()) {
            H2Stream stream = it.next();
            stream.fail((Exception)((Object)new H2StreamResetException(H2Error.NO_ERROR, "Timeout due to inactivity (" + timeout + ")")));
        }
        this.streams.shutdownAndReleaseAll();
    }

    public final void onDisconnect() {
        AsyncPingHandler pingHandler;
        while ((pingHandler = this.pingHandlers.poll()) != null) {
            pingHandler.cancel();
        }
        this.streams.shutdownAndReleaseAll();
        CommandSupport.cancelCommands((IOSession)this.ioSession);
    }

    private void executeShutdown(ShutdownCommand shutdownCommand) throws IOException {
        if (shutdownCommand.getType() == CloseMode.IMMEDIATE) {
            this.streams.shutdownAndReleaseAll();
            this.connState = ConnectionHandshake.SHUTDOWN;
        } else if (this.connState.compareTo(ConnectionHandshake.ACTIVE) <= 0) {
            RawFrame goAway = this.frameFactory.createGoAway(this.streams.getLastRemoteId(), H2Error.NO_ERROR, "Graceful shutdown");
            this.commitFrame(goAway);
            this.connState = this.streams.isEmpty() ? ConnectionHandshake.SHUTDOWN : ConnectionHandshake.GRACEFUL_SHUTDOWN;
        }
    }

    private void executePing(PingCommand pingCommand) throws IOException {
        AsyncPingHandler handler = pingCommand.getHandler();
        this.pingHandlers.add(handler);
        RawFrame ping = this.frameFactory.createPing(handler.getData());
        this.commitFrame(ping);
    }

    private void executeStaleCheck(StaleCheckCommand staleCheckCommand) {
        Consumer callback = staleCheckCommand.getCallback();
        callback.accept(this.ioSession.isOpen() && this.connState.compareTo(ConnectionHandshake.ACTIVE) == 0);
    }

    private void executeRequest(RequestExecutionCommand requestExecutionCommand) throws IOException, HttpException {
        CancellableDependency cancellableDependency;
        int streamId = this.streams.generateStreamId();
        H2StreamChannel channel = this.createChannel(streamId);
        H2Stream stream = this.streams.createActive(channel, this.outgoingRequest(channel, requestExecutionCommand.getExchangeHandler(), (HandlerFactory<AsyncPushConsumer>)requestExecutionCommand.getPushHandlerFactory(), requestExecutionCommand.getContext()));
        if (this.streamListener != null) {
            int initInputWindow = stream.getInputWindow().get();
            this.streamListener.onInputFlowControl(this, streamId, initInputWindow, initInputWindow);
            int initOutputWindow = stream.getOutputWindow().get();
            this.streamListener.onOutputFlowControl(this, streamId, initOutputWindow, initOutputWindow);
        }
        if (stream.isOutputReady()) {
            stream.produceOutput();
        }
        if ((cancellableDependency = requestExecutionCommand.getCancellableDependency()) != null) {
            cancellableDependency.setDependency(stream::abort);
        }
    }

    private void executePush(PushResponseCommand pushResponseCommand) throws IOException, HttpException {
        if (pushResponseCommand.isCancelled()) {
            return;
        }
        H2Stream stream = this.streams.lookupSeen(pushResponseCommand.getStreamId());
        if (stream != null && stream.isReserved()) {
            if (!stream.isLocalClosed()) {
                stream.activate();
                if (stream.isOutputReady()) {
                    stream.produceOutput();
                }
            } else {
                stream.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onException(Exception cause) {
        try {
            AsyncPingHandler pingHandler;
            while ((pingHandler = this.pingHandlers.poll()) != null) {
                pingHandler.failed(cause);
            }
            CommandSupport.cancelCommands((IOSession)this.ioSession);
            this.streams.shutdownAndReleaseAll();
            if (!(cause instanceof ConnectionClosedException) && this.connState.compareTo(ConnectionHandshake.GRACEFUL_SHUTDOWN) <= 0) {
                H2Error errorCode = cause instanceof H2ConnectionException ? H2Error.getByCode(((H2ConnectionException)cause).getCode()) : (cause instanceof ProtocolException ? H2Error.PROTOCOL_ERROR : H2Error.INTERNAL_ERROR);
                RawFrame goAway = this.frameFactory.createGoAway(this.streams.getLastRemoteId(), errorCode, cause.getMessage());
                this.commitFrame(goAway);
            }
        }
        catch (IOException closeMode) {
        }
        finally {
            this.connState = ConnectionHandshake.SHUTDOWN;
            CloseMode closeMode = cause instanceof ConnectionClosedException ? CloseMode.GRACEFUL : (cause instanceof SSLHandshakeException ? CloseMode.GRACEFUL : (cause instanceof IOException ? CloseMode.IMMEDIATE : CloseMode.GRACEFUL));
            this.ioSession.close(closeMode);
        }
    }

    private void consumeFrame(RawFrame frame) throws HttpException, IOException {
        FrameType frameType = FrameType.valueOf(frame.getType());
        int streamId = frame.getStreamId();
        if (this.continuation != null && frameType != FrameType.CONTINUATION) {
            throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "CONTINUATION frame expected");
        }
        switch (frameType) {
            case DATA: {
                if (streamId == 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id: " + streamId);
                }
                H2Stream stream = this.streams.lookupValid(streamId);
                try {
                    this.consumeDataFrame(frame, stream);
                }
                catch (H2StreamResetException ex) {
                    stream.localReset(ex);
                }
                catch (HttpStreamResetException ex) {
                    stream.localReset((Exception)((Object)ex), ex.getCause() != null ? H2Error.INTERNAL_ERROR : H2Error.CANCEL);
                }
                if (!stream.isClosed()) break;
                stream.releaseResources();
                this.requestSessionOutput();
                break;
            }
            case HEADERS: {
                if (streamId == 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id: " + streamId);
                }
                H2Stream stream = this.streams.lookupValidOrNull(streamId);
                if (stream == null) {
                    this.acceptHeaderFrame();
                    if (this.streams.isSameSide(streamId)) {
                        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id: " + streamId);
                    }
                    if (this.goAwayReceived) {
                        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "GOAWAY received");
                    }
                    H2StreamChannel channel = this.createChannel(streamId);
                    if (this.connState.compareTo(ConnectionHandshake.ACTIVE) <= 0) {
                        stream = this.streams.createActive(channel, this.incomingRequest(channel));
                        this.streams.resetIfExceedsMaxConcurrentLimit(stream, this.localConfig.getMaxConcurrentStreams());
                    } else {
                        channel.localReset(H2Error.REFUSED_STREAM);
                        stream = this.streams.createActive(channel, NoopH2StreamHandler.INSTANCE);
                    }
                } else {
                    if (stream.isLocalClosed() && stream.isRemoteClosed()) {
                        throw new H2ConnectionException(H2Error.STREAM_CLOSED, "Stream closed");
                    }
                    if (stream.isReserved()) {
                        stream.activate();
                        this.streams.resetIfExceedsMaxConcurrentLimit(stream, this.localConfig.getMaxConcurrentStreams());
                    }
                }
                try {
                    this.consumeHeaderFrame(frame, stream);
                    if (stream.isOutputReady()) {
                        stream.produceOutput();
                    }
                }
                catch (H2StreamResetException ex) {
                    stream.localReset(ex);
                }
                catch (HttpStreamResetException ex) {
                    stream.localReset((Exception)((Object)ex), ex.getCause() != null ? H2Error.INTERNAL_ERROR : H2Error.CANCEL);
                }
                catch (HttpException ex) {
                    stream.handle(ex);
                }
                if (!stream.isClosed()) break;
                stream.releaseResources();
                this.requestSessionOutput();
                break;
            }
            case CONTINUATION: {
                if (streamId == 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id: " + streamId);
                }
                if (this.continuation == null) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Unexpected CONTINUATION frame");
                }
                if (streamId != this.continuation.streamId) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Unexpected CONTINUATION stream id: " + streamId);
                }
                H2Stream stream = this.streams.lookupValid(streamId);
                try {
                    this.consumeContinuationFrame(frame, stream);
                }
                catch (H2StreamResetException ex) {
                    stream.localReset(ex);
                }
                catch (HttpStreamResetException ex) {
                    stream.localReset((Exception)((Object)ex), ex.getCause() != null ? H2Error.INTERNAL_ERROR : H2Error.CANCEL);
                }
                if (!stream.isClosed()) break;
                stream.releaseResources();
                this.requestSessionOutput();
                break;
            }
            case WINDOW_UPDATE: {
                ByteBuffer payload = frame.getPayload();
                if (payload == null || payload.remaining() != 4) {
                    throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Invalid WINDOW_UPDATE frame payload");
                }
                int delta = payload.getInt();
                if (delta <= 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Invalid WINDOW_UPDATE delta");
                }
                if (streamId == 0) {
                    try {
                        this.updateOutputWindow(0, this.connOutputWindow, delta);
                    }
                    catch (ArithmeticException ex) {
                        throw new H2ConnectionException(H2Error.FLOW_CONTROL_ERROR, ex.getMessage());
                    }
                }
                H2Stream stream = this.streams.lookup(streamId);
                if (stream != null) {
                    try {
                        this.updateOutputWindow(streamId, stream.getOutputWindow(), delta);
                    }
                    catch (ArithmeticException ex) {
                        throw new H2ConnectionException(H2Error.FLOW_CONTROL_ERROR, ex.getMessage());
                    }
                }
                this.ioSession.setEvent(4);
                break;
            }
            case RST_STREAM: {
                if (streamId == 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id: " + streamId);
                }
                H2Stream stream = this.streams.lookupSeen(streamId);
                if (stream == null) break;
                ByteBuffer payload = frame.getPayload();
                if (payload == null || payload.remaining() != 4) {
                    throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Invalid RST_STREAM frame payload");
                }
                int errorCode = payload.getInt();
                if (errorCode == H2Error.NO_ERROR.getCode() && this.allowGracefulAbort(stream)) {
                    stream.abortGracefully();
                    this.requestSessionOutput();
                    break;
                }
                stream.fail((Exception)((Object)new H2StreamResetException(errorCode, "Stream reset (" + errorCode + ")")));
                this.requestSessionOutput();
                break;
            }
            case PING: {
                if (streamId != 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id");
                }
                ByteBuffer ping = frame.getPayloadContent();
                if (ping == null || ping.remaining() != 8) {
                    throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Invalid PING frame payload");
                }
                if (frame.isFlagSet(FrameFlag.ACK)) {
                    AsyncPingHandler pingHandler = this.pingHandlers.poll();
                    if (pingHandler == null) break;
                    pingHandler.consumeResponse(ping);
                    break;
                }
                ByteBuffer pong = ByteBuffer.allocate(ping.remaining());
                pong.put(ping);
                pong.flip();
                RawFrame response = this.frameFactory.createPingAck(pong);
                this.commitFrame(response);
                break;
            }
            case SETTINGS: {
                if (streamId != 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id");
                }
                if (frame.isFlagSet(FrameFlag.ACK)) {
                    if (this.localSettingState != SettingsHandshake.TRANSMITTED) break;
                    this.localSettingState = SettingsHandshake.ACKED;
                    this.ioSession.setEvent(4);
                    this.applyLocalSettings();
                    break;
                }
                ByteBuffer payload = frame.getPayload();
                if (payload != null) {
                    if (payload.remaining() % 6 != 0) {
                        throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Invalid SETTINGS payload");
                    }
                    this.consumeSettingsFrame(payload);
                    this.remoteSettingState = SettingsHandshake.TRANSMITTED;
                }
                RawFrame response = this.frameFactory.createSettingsAck();
                this.commitFrame(response);
                this.remoteSettingState = SettingsHandshake.ACKED;
                break;
            }
            case PRIORITY: {
                break;
            }
            case PUSH_PROMISE: {
                H2Stream promisedStream;
                this.acceptPushFrame();
                if (streamId == 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id: " + streamId);
                }
                if (this.goAwayReceived) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "GOAWAY received");
                }
                if (!this.localConfig.isPushEnabled()) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Push is disabled");
                }
                H2Stream stream = this.streams.lookupValid(streamId);
                if (stream.isRemoteClosed()) {
                    stream.localReset(new H2StreamResetException(H2Error.STREAM_CLOSED, "Stream closed"));
                    break;
                }
                ByteBuffer payload = frame.getPayloadContent();
                if (payload == null || payload.remaining() < 4) {
                    throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Invalid PUSH_PROMISE payload");
                }
                int promisedStreamId = payload.getInt();
                if (promisedStreamId == 0 || this.streams.isSameSide(promisedStreamId)) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal promised stream id: " + promisedStreamId);
                }
                if (this.streams.lookupValidOrNull(promisedStreamId) != null) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Stream already open: " + promisedStreamId);
                }
                H2StreamChannel channel = this.createChannel(promisedStreamId);
                if (this.connState.compareTo(ConnectionHandshake.ACTIVE) <= 0) {
                    promisedStream = this.streams.createReserved(channel, this.incomingPushPromise(channel, stream.getPushHandlerFactory()));
                } else {
                    channel.localReset(H2Error.REFUSED_STREAM);
                    promisedStream = this.streams.createActive(channel, NoopH2StreamHandler.INSTANCE);
                }
                try {
                    this.consumePushPromiseFrame(frame, payload, promisedStream);
                }
                catch (H2StreamResetException ex) {
                    promisedStream.localReset(ex);
                }
                catch (HttpStreamResetException ex) {
                    promisedStream.localReset((Exception)((Object)ex), ex.getCause() != null ? H2Error.INTERNAL_ERROR : H2Error.NO_ERROR);
                }
                break;
            }
            case GOAWAY: {
                if (streamId != 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id");
                }
                ByteBuffer payload = frame.getPayload();
                if (payload == null || payload.remaining() < 8) {
                    throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Invalid GOAWAY payload");
                }
                int processedLocalStreamId = payload.getInt();
                int errorCode = payload.getInt();
                this.goAwayReceived = true;
                if (errorCode == H2Error.NO_ERROR.getCode()) {
                    if (this.connState.compareTo(ConnectionHandshake.ACTIVE) <= 0) {
                        Iterator<H2Stream> it = this.streams.iterator();
                        while (it.hasNext()) {
                            H2Stream stream = it.next();
                            int activeStreamId = stream.getId();
                            if (this.streams.isSameSide(activeStreamId) || activeStreamId <= processedLocalStreamId) continue;
                            stream.fail((Exception)new RequestNotExecutedException());
                            it.remove();
                        }
                    }
                    this.connState = this.streams.isEmpty() ? ConnectionHandshake.SHUTDOWN : ConnectionHandshake.GRACEFUL_SHUTDOWN;
                } else {
                    Iterator<H2Stream> it = this.streams.iterator();
                    while (it.hasNext()) {
                        H2Stream stream = it.next();
                        stream.fail((Exception)((Object)new H2StreamResetException(errorCode, "Connection terminated by the peer (" + errorCode + ")")));
                    }
                    this.streams.shutdownAndReleaseAll();
                    this.connState = ConnectionHandshake.SHUTDOWN;
                }
                this.ioSession.setEvent(4);
                break;
            }
            case PRIORITY_UPDATE: {
                String field;
                if (streamId != 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "PRIORITY_UPDATE must be on stream 0");
                }
                ByteBuffer payload = frame.getPayload();
                if (payload == null || payload.remaining() < 4) {
                    throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Invalid PRIORITY_UPDATE payload");
                }
                int prioritizedId = payload.getInt() & Integer.MAX_VALUE;
                int len = payload.remaining();
                if (len > 0) {
                    byte[] b = new byte[len];
                    payload.get(b);
                    field = new String(b, StandardCharsets.US_ASCII);
                } else {
                    field = "";
                }
                PriorityValue pv = PriorityParamsParser.parse(field).toValueWithDefaults();
                this.priorities.put(prioritizedId, pv);
                this.requestSessionOutput();
            }
        }
    }

    private void consumeDataFrame(RawFrame frame, H2Stream stream) throws HttpException, IOException {
        if (stream.isRemoteClosed()) {
            throw new H2StreamResetException(H2Error.STREAM_CLOSED, "Stream already closed");
        }
        int streamId = stream.getId();
        ByteBuffer payload = frame.getPayloadContent();
        if (payload != null) {
            int connWinSize;
            int frameLength = frame.getLength();
            int streamWinSize = this.updateInputWindow(streamId, stream.getInputWindow(), -frameLength);
            if (streamWinSize < this.lowMark && !stream.isRemoteClosed()) {
                stream.produceInputCapacityUpdate();
            }
            if ((long)(connWinSize = this.updateInputWindow(0, this.connInputWindow, -frameLength)) < 0xA00000L) {
                this.maximizeWindow(0, this.connInputWindow);
            }
        }
        stream.consumeData(payload, frame.isFlagSet(FrameFlag.END_STREAM));
    }

    private void maximizeWindow(int streamId, AtomicInteger window) throws IOException {
        int delta = this.updateWindowMax(window);
        if (delta > 0) {
            RawFrame windowUpdateFrame = this.frameFactory.createWindowUpdate(streamId, delta);
            this.commitFrame(windowUpdateFrame);
        }
    }

    private void consumePushPromiseFrame(RawFrame frame, ByteBuffer payload, H2Stream promisedStream) throws HttpException, IOException {
        int promisedStreamId = promisedStream.getId();
        if (!frame.isFlagSet(FrameFlag.END_HEADERS)) {
            this.continuation = new Continuation(promisedStreamId, frame.getType(), true, this.localConfig.getMaxContinuations());
        }
        if (this.continuation == null) {
            List<Header> headers = this.hPackDecoder.decodeHeaders(payload);
            if (this.streamListener != null) {
                this.streamListener.onHeaderInput(this, promisedStreamId, headers);
            }
            promisedStream.consumePromise(headers);
        } else {
            this.continuation.copyPayload(payload);
        }
    }

    List<Header> decodeHeaders(ByteBuffer payload) throws HttpException {
        return this.hPackDecoder.decodeHeaders(payload);
    }

    private void consumeHeaderFrame(RawFrame frame, H2Stream stream) throws HttpException, IOException {
        if (stream.isRemoteClosed()) {
            throw new H2StreamResetException(H2Error.STREAM_CLOSED, "Stream already closed");
        }
        int streamId = stream.getId();
        if (!frame.isFlagSet(FrameFlag.END_HEADERS)) {
            this.continuation = new Continuation(streamId, frame.getType(), frame.isFlagSet(FrameFlag.END_STREAM), this.localConfig.getMaxContinuations());
        }
        ByteBuffer payload = frame.getPayloadContent();
        if (frame.isFlagSet(FrameFlag.PRIORITY)) {
            payload.getInt();
            payload.get();
        }
        if (this.continuation == null) {
            List<Header> headers = this.decodeHeaders(payload);
            if (this.streamListener != null) {
                this.streamListener.onHeaderInput(this, streamId, headers);
            }
            this.recordPriorityFromHeaders(streamId, headers);
            stream.consumeHeader(headers, frame.isFlagSet(FrameFlag.END_STREAM));
        } else {
            this.continuation.copyPayload(payload);
        }
    }

    private void consumeContinuationFrame(RawFrame frame, H2Stream stream) throws HttpException, IOException {
        if (stream.isRemoteClosed()) {
            throw new H2StreamResetException(H2Error.STREAM_CLOSED, "Stream already closed");
        }
        int streamId = frame.getStreamId();
        ByteBuffer payload = frame.getPayload();
        this.continuation.copyPayload(payload);
        if (frame.isFlagSet(FrameFlag.END_HEADERS)) {
            List<Header> headers = this.decodeHeaders(this.continuation.getContent());
            if (this.streamListener != null) {
                this.streamListener.onHeaderInput(this, streamId, headers);
            }
            this.recordPriorityFromHeaders(streamId, headers);
            if (this.continuation.type == FrameType.PUSH_PROMISE.getValue()) {
                stream.consumePromise(headers);
            } else {
                stream.consumeHeader(headers, this.continuation.endStream);
            }
            this.continuation = null;
        }
    }

    private void consumeSettingsFrame(ByteBuffer payload) throws IOException {
        H2Config.Builder configBuilder = H2Config.initial();
        while (payload.hasRemaining()) {
            short code = payload.getShort();
            int value = payload.getInt();
            H2Param param = H2Param.valueOf(code);
            if (param == null) continue;
            this.validateSetting(param, value);
            switch (param) {
                case HEADER_TABLE_SIZE: {
                    try {
                        configBuilder.setHeaderTableSize(value);
                        break;
                    }
                    catch (IllegalArgumentException ex) {
                        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, ex.getMessage());
                    }
                }
                case MAX_CONCURRENT_STREAMS: {
                    try {
                        configBuilder.setMaxConcurrentStreams(value);
                        break;
                    }
                    catch (IllegalArgumentException ex) {
                        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, ex.getMessage());
                    }
                }
                case ENABLE_PUSH: {
                    configBuilder.setPushEnabled(value == 1);
                    break;
                }
                case INITIAL_WINDOW_SIZE: {
                    try {
                        configBuilder.setInitialWindowSize(value);
                        break;
                    }
                    catch (IllegalArgumentException ex) {
                        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, ex.getMessage());
                    }
                }
                case MAX_FRAME_SIZE: {
                    try {
                        configBuilder.setMaxFrameSize(value);
                        break;
                    }
                    catch (IllegalArgumentException ex) {
                        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, ex.getMessage());
                    }
                }
                case MAX_HEADER_LIST_SIZE: {
                    try {
                        configBuilder.setMaxHeaderListSize(value);
                        break;
                    }
                    catch (IllegalArgumentException ex) {
                        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, ex.getMessage());
                    }
                }
                case SETTINGS_NO_RFC7540_PRIORITIES: {
                    this.peerNoRfc7540Priorities = value == 1;
                }
            }
        }
        this.applyRemoteSettings(configBuilder.build());
    }

    private void produceOutput() throws HttpException, IOException {
        Iterator<H2Stream> it = this.streams.iterator();
        while (it.hasNext()) {
            H2Stream stream = it.next();
            if (!stream.isLocalClosed() && !stream.isReserved() && stream.getOutputWindow().get() > 0) {
                stream.produceOutput();
            }
            if (stream.isClosedPastLingerDeadline()) {
                this.streams.dropStreamId(stream.getId());
                stream.releaseResources();
                it.remove();
                this.requestSessionOutput();
            }
            if (this.outputQueue.isEmpty()) continue;
            break;
        }
    }

    private void applyRemoteSettings(H2Config config) throws H2ConnectionException {
        this.remoteConfig = config;
        this.hPackEncoder.setMaxTableSize(this.remoteConfig.getHeaderTableSize());
        int delta = this.remoteConfig.getInitialWindowSize() - this.initOutputWinSize;
        this.initOutputWinSize = this.remoteConfig.getInitialWindowSize();
        int maxFrameSize = this.remoteConfig.getMaxFrameSize();
        if (maxFrameSize < this.outputBuffer.getMaxFramePayloadSize()) {
            try {
                this.outputBuffer.resize(maxFrameSize);
            }
            catch (BufferOverflowException ex) {
                throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Failure resizing the frame output buffer");
            }
        }
        if (delta != 0 && !this.streams.isEmpty()) {
            Iterator<H2Stream> it = this.streams.iterator();
            while (it.hasNext()) {
                H2Stream stream = it.next();
                try {
                    this.updateOutputWindow(stream.getId(), stream.getOutputWindow(), delta);
                }
                catch (ArithmeticException ex) {
                    throw new H2ConnectionException(H2Error.FLOW_CONTROL_ERROR, ex.getMessage());
                }
            }
        }
    }

    private void applyLocalSettings() throws H2ConnectionException {
        this.hPackDecoder.setMaxTableSize(this.localConfig.getHeaderTableSize());
        this.hPackDecoder.setMaxListSize(this.localConfig.getMaxHeaderListSize());
        int delta = this.localConfig.getInitialWindowSize() - this.initInputWinSize;
        this.initInputWinSize = this.localConfig.getInitialWindowSize();
        if (delta != 0 && !this.streams.isEmpty()) {
            Iterator<H2Stream> it = this.streams.iterator();
            while (it.hasNext()) {
                H2Stream stream = it.next();
                try {
                    this.updateInputWindow(stream.getId(), stream.getInputWindow(), delta);
                }
                catch (ArithmeticException ex) {
                    throw new H2ConnectionException(H2Error.FLOW_CONTROL_ERROR, ex.getMessage());
                }
            }
        }
        this.lowMark = this.initInputWinSize / 2;
    }

    public void close() throws IOException {
        this.ioSession.enqueue((Command)ShutdownCommand.GRACEFUL, Command.Priority.IMMEDIATE);
    }

    public void close(CloseMode closeMode) {
        this.ioSession.close(closeMode);
    }

    public boolean isOpen() {
        return this.connState == ConnectionHandshake.ACTIVE;
    }

    public void setSocketTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        return tlsDetails != null ? tlsDetails.getSSLSession() : null;
    }

    public EndpointDetails getEndpointDetails() {
        if (this.endpointDetails == null) {
            this.endpointDetails = new BasicEndpointDetails(this.ioSession.getRemoteAddress(), this.ioSession.getLocalAddress(), (HttpConnectionMetrics)this.connMetrics, this.ioSession.getSocketTimeout());
        }
        return this.endpointDetails;
    }

    public Timeout getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    public ProtocolVersion getProtocolVersion() {
        return HttpVersion.HTTP_2;
    }

    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    void appendState(StringBuilder buf) {
        buf.append("connState=").append((Object)this.connState).append(", connInputWindow=").append(this.connInputWindow).append(", connOutputWindow=").append(this.connOutputWindow).append(", outputQueue=").append(this.outputQueue.size()).append(", streams.localCoubt=").append(this.streams.getLocalCount()).append(", streams.remoteCount=").append(this.streams.getRemoteCount()).append(", streams.lastLocal=").append(this.streams.getLastLocalId()).append(", streams.lastRemote=").append(this.streams.getLastRemoteId());
    }

    H2StreamChannel createChannel(int streamId) {
        return new H2StreamChannelImpl(streamId, this.initInputWinSize, this.initOutputWinSize);
    }

    H2Stream createStream(H2StreamChannel channel, H2StreamHandler streamHandler) throws H2ConnectionException {
        return this.streams.createActive(channel, streamHandler);
    }

    private void recordPriorityFromHeaders(int streamId, List<? extends Header> headers) {
        if (headers == null || headers.isEmpty()) {
            return;
        }
        for (Header header : headers) {
            if (!"Priority".equalsIgnoreCase(header.getName())) continue;
            PriorityValue pv = PriorityParamsParser.parse(header.getValue()).toValueWithDefaults();
            this.priorities.put(streamId, pv);
            break;
        }
    }

    class H2StreamChannelImpl
    implements H2StreamChannel {
        private final int id;
        private final AtomicInteger inputWindow;
        private final AtomicInteger outputWindow;
        private volatile boolean localClosed;
        private volatile long localResetTime;

        H2StreamChannelImpl(int id, int initialInputWindowSize, int initialOutputWindowSize) {
            this.id = id;
            this.inputWindow = new AtomicInteger(initialInputWindowSize);
            this.outputWindow = new AtomicInteger(initialOutputWindowSize);
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public AtomicInteger getOutputWindow() {
            return this.outputWindow;
        }

        @Override
        public AtomicInteger getInputWindow() {
            return this.inputWindow;
        }

        void ensureNotClosed() throws H2ConnectionException {
            if (this.localClosed) {
                throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Stream already closed locally");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void submit(List<Header> headers, boolean endStream) throws IOException {
            AbstractH2StreamMultiplexer.this.ioSession.getLock().lock();
            try {
                if (headers == null || headers.isEmpty()) {
                    throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Message headers are missing");
                }
                if (this.isLocalReset()) {
                    return;
                }
                this.ensureNotClosed();
                if (AbstractH2StreamMultiplexer.this.peerNoRfc7540Priorities && AbstractH2StreamMultiplexer.this.streams.isSameSide(this.id)) {
                    for (Header h : headers) {
                        if (!"Priority".equalsIgnoreCase(h.getName())) continue;
                        byte[] ascii = h.getValue() != null ? h.getValue().getBytes(StandardCharsets.US_ASCII) : new byte[]{};
                        ByteArrayBuffer b = new ByteArrayBuffer(4 + ascii.length);
                        b.append((int)((byte)(this.id >> 24)));
                        b.append((int)((byte)(this.id >> 16)));
                        b.append((int)((byte)(this.id >> 8)));
                        b.append((int)((byte)this.id));
                        b.append(ascii, 0, ascii.length);
                        ByteBuffer pl = ByteBuffer.wrap(b.array(), 0, b.length());
                        RawFrame priUpd = new RawFrame(FrameType.PRIORITY_UPDATE.getValue(), 0, 0, pl);
                        AbstractH2StreamMultiplexer.this.commitFrameInternal(priUpd);
                        break;
                    }
                }
                AbstractH2StreamMultiplexer.this.commitHeaders(this.id, headers, endStream);
                if (endStream) {
                    this.localClosed = true;
                }
            }
            finally {
                AbstractH2StreamMultiplexer.this.ioSession.getLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void push(List<Header> headers, AsyncPushProducer pushProducer) throws HttpException, IOException {
            AbstractH2StreamMultiplexer.this.acceptPushRequest();
            AbstractH2StreamMultiplexer.this.ioSession.getLock().lock();
            try {
                if (this.isLocalReset()) {
                    return;
                }
                this.ensureNotClosed();
                int promisedStreamId = AbstractH2StreamMultiplexer.this.streams.generateStreamId();
                H2StreamChannel channel = AbstractH2StreamMultiplexer.this.createChannel(promisedStreamId);
                H2Stream stream = AbstractH2StreamMultiplexer.this.streams.createReserved(channel, AbstractH2StreamMultiplexer.this.outgoingPushPromise(channel, pushProducer));
                AbstractH2StreamMultiplexer.this.commitPushPromise(this.id, promisedStreamId, headers);
                stream.markRemoteClosed();
                AbstractH2StreamMultiplexer.this.submitCommand(new PushResponseCommand(promisedStreamId));
            }
            finally {
                AbstractH2StreamMultiplexer.this.ioSession.getLock().unlock();
            }
        }

        public void update(int increment) throws IOException {
            AbstractH2StreamMultiplexer.this.incrementInputCapacity(0, AbstractH2StreamMultiplexer.this.connInputWindow, increment);
            AbstractH2StreamMultiplexer.this.incrementInputCapacity(this.id, this.inputWindow, increment);
        }

        public int write(ByteBuffer payload) throws IOException {
            AbstractH2StreamMultiplexer.this.ioSession.getLock().lock();
            try {
                if (this.isLocalReset()) {
                    int n = 0;
                    return n;
                }
                this.ensureNotClosed();
                int n = AbstractH2StreamMultiplexer.this.streamData(this.id, this.outputWindow, payload);
                return n;
            }
            finally {
                AbstractH2StreamMultiplexer.this.ioSession.getLock().unlock();
            }
        }

        public void endStream(List<? extends Header> trailers) throws IOException {
            AbstractH2StreamMultiplexer.this.ioSession.getLock().lock();
            try {
                if (this.isLocalReset()) {
                    return;
                }
                this.ensureNotClosed();
                this.localClosed = true;
                if (trailers != null && !trailers.isEmpty()) {
                    AbstractH2StreamMultiplexer.this.commitHeaders(this.id, trailers, true);
                } else {
                    RawFrame frame = AbstractH2StreamMultiplexer.this.frameFactory.createData(this.id, null, true);
                    AbstractH2StreamMultiplexer.this.commitFrameInternal(frame);
                }
            }
            finally {
                AbstractH2StreamMultiplexer.this.ioSession.getLock().unlock();
            }
        }

        public void endStream() throws IOException {
            this.endStream(null);
        }

        public void requestOutput() {
            AbstractH2StreamMultiplexer.this.requestSessionOutput();
        }

        @Override
        public boolean isLocalClosed() {
            return this.localClosed;
        }

        @Override
        public void markLocalClosed() {
            this.localClosed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean localReset(int code) throws IOException {
            AbstractH2StreamMultiplexer.this.ioSession.getLock().lock();
            try {
                if (this.isLocalReset()) {
                    boolean bl = false;
                    return bl;
                }
                this.localClosed = true;
                this.localResetTime = System.currentTimeMillis();
                RawFrame resetStream = AbstractH2StreamMultiplexer.this.frameFactory.createResetStream(this.id, code);
                AbstractH2StreamMultiplexer.this.commitFrameInternal(resetStream);
                boolean bl = true;
                return bl;
            }
            finally {
                AbstractH2StreamMultiplexer.this.ioSession.getLock().unlock();
            }
        }

        @Override
        public long getLocalResetTime() {
            return this.localResetTime;
        }

        public boolean cancel() {
            try {
                return this.localReset(H2Error.CANCEL);
            }
            catch (IOException ignore) {
                return false;
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("[").append("id=").append(this.id).append(", connState=").append((Object)AbstractH2StreamMultiplexer.this.connState).append(", inputWindow=").append(this.inputWindow).append(", outputWindow=").append(this.outputWindow).append(", localClosed=").append(this.localClosed).append("]");
            return buf.toString();
        }
    }

    private static class Continuation {
        final int streamId;
        final int type;
        final boolean endStream;
        final ByteArrayBuffer headerBuffer;
        final int maxContinuation;
        final boolean enforceMacContinuations;
        private int count;

        private Continuation(int streamId, int type, boolean endStream, int maxContinuation) {
            this.streamId = streamId;
            this.type = type;
            this.endStream = endStream;
            this.maxContinuation = maxContinuation;
            this.enforceMacContinuations = maxContinuation < Integer.MAX_VALUE;
            this.headerBuffer = new ByteArrayBuffer(1024);
        }

        void copyPayload(ByteBuffer payload) throws H2ConnectionException {
            if (payload == null) {
                return;
            }
            if (this.enforceMacContinuations && this.count > this.maxContinuation) {
                throw new H2ConnectionException(H2Error.ENHANCE_YOUR_CALM, "Excessive number of continuation frames");
            }
            ++this.count;
            int originalLength = this.headerBuffer.length();
            int toCopy = payload.remaining();
            this.headerBuffer.ensureCapacity(toCopy);
            payload.get(this.headerBuffer.array(), originalLength, toCopy);
            this.headerBuffer.setLength(originalLength + toCopy);
        }

        ByteBuffer getContent() {
            return ByteBuffer.wrap(this.headerBuffer.array(), 0, this.headerBuffer.length());
        }
    }

    static enum SettingsHandshake {
        READY,
        TRANSMITTED,
        ACKED;

    }

    static enum ConnectionHandshake {
        READY,
        ACTIVE,
        GRACEFUL_SHUTDOWN,
        SHUTDOWN;

    }
}

