"use strict";
// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.sha512 = void 0;
const crypto_1 = require("crypto");
const sha512 = async (...data) => data
    .map((item) => (typeof item === 'string' ? Buffer.from(item) : item))
    .reduce((hash, item) => hash.update(item), (0, crypto_1.createHash)('sha512'))
    .digest();
exports.sha512 = sha512;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2hhNTEyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3NoYTUxMi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsb0VBQW9FO0FBQ3BFLHNDQUFzQzs7O0FBRXRDLG1DQUFtQztBQUU1QixNQUFNLE1BQU0sR0FBRyxLQUFLLEVBQUUsR0FBRyxJQUE2QixFQUFFLEVBQUUsQ0FDL0QsSUFBSTtLQUNELEdBQUcsQ0FBQyxDQUFDLElBQUksRUFBRSxFQUFFLENBQUMsQ0FBQyxPQUFPLElBQUksS0FBSyxRQUFRLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDO0tBQ3BFLE1BQU0sQ0FBQyxDQUFDLElBQUksRUFBRSxJQUFJLEVBQUUsRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLEVBQUUsSUFBQSxtQkFBVSxFQUFDLFFBQVEsQ0FBQyxDQUFDO0tBQy9ELE1BQU0sRUFBRSxDQUFBO0FBSkEsUUFBQSxNQUFNLFVBSU4ifQ==