/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources;

import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.security.resources.ResourcePluginInfo;
import org.opensearch.security.securityconf.FlattenedActionGroups;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.ActionGroupsV7;
import org.opensearch.security.spi.resources.ResourceProvider;
import org.opensearch.security.spi.resources.ResourceSharingExtension;
import org.yaml.snakeyaml.Yaml;

public class ResourceActionGroupsHelper {
    public static final Logger log = LogManager.getLogger(ResourceActionGroupsHelper.class);

    public static void loadActionGroupsConfig(ResourcePluginInfo resourcePluginInfo) {
        Set<ResourceSharingExtension> exts = resourcePluginInfo.getResourceSharingExtensions();
        for (ResourceSharingExtension ext : exts) {
            URL url = ext.getClass().getClassLoader().getResource("resource-action-groups.yml");
            if (url == null) {
                log.info("resource-action-groups.yml not found for {}", (Object)ext.getClass().getName());
                continue;
            }
            try {
                InputStream in = url.openStream();
                try {
                    String yaml = new String(in.readAllBytes(), StandardCharsets.UTF_8);
                    Map root = (Map)new Yaml().load(yaml);
                    if (root == null) {
                        log.info("Empty resource-action-groups.yml for {}", (Object)ext.getClass().getName());
                        continue;
                    }
                    Object rtNode = root.get("resource_types");
                    if (!(rtNode instanceof Map)) {
                        log.warn("'resource_types' missing or invalid in {}", (Object)ext.getClass().getName());
                        continue;
                    }
                    Map byType = (Map)rtNode;
                    for (ResourceProvider rp : ext.getResourceProviders()) {
                        String resType = rp.resourceType();
                        Object typeCfgNode = byType.get(resType);
                        if (!(typeCfgNode instanceof Map)) {
                            log.info("No per-type block for {} in {}", (Object)resType, (Object)ext.getClass().getName());
                            continue;
                        }
                        Map typeMapRaw = (Map)typeCfgNode;
                        SecurityDynamicConfiguration<ActionGroupsV7> cfg = SecurityDynamicConfiguration.fromMap(typeMapRaw, CType.ACTIONGROUPS);
                        cfg.getCEntries().entrySet().removeIf(e -> e.getValue() == null || ((ActionGroupsV7)e.getValue()).getAllowed_actions() == null || ((ActionGroupsV7)e.getValue()).getAllowed_actions().isEmpty());
                        FlattenedActionGroups flattened = new FlattenedActionGroups(cfg);
                        resourcePluginInfo.registerActionGroupNames(resType, cfg.getCEntries().keySet());
                        resourcePluginInfo.registerFlattened(resType, flattened);
                        log.info("Registered {} action-groups for {}", (Object)cfg.getCEntries().size(), (Object)resType);
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (Exception e2) {
                log.warn("Failed loading/parsing resource-action-groups.yml for {}: {}", (Object)ext.getClass().getName(), (Object)e2.toString());
            }
        }
    }
}

