/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.client.soap11.encoder.http.impl;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.SerializeSupport;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.messaging.encoder.httpclient.BaseHttpClientRequestXMLMessageEncoder;
import org.opensaml.soap.common.SOAPObjectBuilder;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Header;
import org.opensaml.soap.wsaddressing.Action;
import org.slf4j.Logger;

public class HttpClientRequestSOAP11Encoder
extends BaseHttpClientRequestXMLMessageEncoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HttpClientRequestSOAP11Encoder.class);
    @Nonnull
    private SOAPObjectBuilder<Envelope> envBuilder;
    @Nonnull
    private SOAPObjectBuilder<Body> bodyBuilder;

    public HttpClientRequestSOAP11Encoder() {
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        this.envBuilder = (SOAPObjectBuilder)builderFactory.ensureBuilder(Envelope.DEFAULT_ELEMENT_NAME);
        this.bodyBuilder = (SOAPObjectBuilder)builderFactory.ensureBuilder(Body.DEFAULT_ELEMENT_NAME);
        this.setProtocolMessageLoggerSubCategory("SOAP");
    }

    @NonnullAfterInit
    public HttpPost getHttpRequest() {
        return (HttpPost)super.getHttpRequest();
    }

    @Override
    public synchronized void setHttpRequest(@Nullable ClassicHttpRequest httpRequest) {
        if (!(httpRequest instanceof HttpPost)) {
            throw new IllegalArgumentException("HttpClient SOAP message encoder only operates on HttpPost");
        }
        super.setHttpRequest(httpRequest);
    }

    @Override
    public void prepareContext() throws MessageEncodingException {
        MessageContext messageContext = this.getMessageContext();
        Object message = messageContext.getMessage();
        if (message == null || !(message instanceof XMLObject)) {
            throw new MessageEncodingException("No outbound XML message contained in message context");
        }
        if (message instanceof Envelope) {
            this.storeSOAPEnvelope((Envelope)message);
        } else {
            this.buildAndStoreSOAPMessage((XMLObject)message);
        }
    }

    @Override
    protected void doEncode() throws MessageEncodingException {
        Envelope envelope = this.getSOAPEnvelope();
        if (envelope == null) {
            throw new MessageEncodingException("SOAP envelope was null");
        }
        this.prepareHttpRequest();
        this.getHttpRequest().setEntity(this.createRequestEntity(envelope, Charset.forName("UTF-8")));
    }

    protected HttpEntity createRequestEntity(@Nonnull Envelope message, @Nonnull Charset charset) throws MessageEncodingException {
        try {
            ByteArrayOutputStream arrayOut = new ByteArrayOutputStream();
            SerializeSupport.writeNode(XMLObjectSupport.marshall(message), arrayOut);
            return new ByteArrayEntity(arrayOut.toByteArray(), ContentType.TEXT_XML, charset.name());
        }
        catch (MarshallingException e) {
            throw new MessageEncodingException("Unable to marshall SOAP envelope", e);
        }
    }

    protected void storeSOAPEnvelope(@Nullable Envelope envelope) {
        this.getMessageContext().ensureSubcontext(SOAP11Context.class).setEnvelope(envelope);
    }

    @Nullable
    protected Envelope getSOAPEnvelope() {
        return this.getMessageContext().ensureSubcontext(SOAP11Context.class).getEnvelope();
    }

    protected void buildAndStoreSOAPMessage(@Nonnull XMLObject payload) {
        Body body;
        Envelope envelope = this.getSOAPEnvelope();
        if (envelope == null) {
            envelope = this.envBuilder.buildObject();
            this.storeSOAPEnvelope(envelope);
        }
        if ((body = envelope.getBody()) == null) {
            body = this.bodyBuilder.buildObject();
            envelope.setBody(body);
        }
        if (!body.getUnknownXMLObjects().isEmpty()) {
            this.log.warn("Existing SOAP Envelope Body already contained children");
        }
        body.getUnknownXMLObjects().add(payload);
    }

    protected void prepareHttpRequest() throws MessageEncodingException {
        String soapAction = this.getSOAPAction();
        if (soapAction != null) {
            this.getHttpRequest().setHeader("SOAPAction", (Object)soapAction);
        } else {
            this.getHttpRequest().setHeader("SOAPAction", (Object)"");
        }
    }

    @Nullable
    protected String getSOAPAction() {
        Envelope env = this.getSOAPEnvelope();
        if (env == null) {
            return null;
        }
        Header header = env.getHeader();
        if (header == null) {
            return null;
        }
        List<XMLObject> objList = header.getUnknownXMLObjects(Action.ELEMENT_NAME);
        if (objList == null || objList.isEmpty()) {
            return null;
        }
        return ((Action)objList.get(0)).getURI();
    }

    @Override
    @Nullable
    protected XMLObject getMessageToLog() {
        return this.getMessageContext().ensureSubcontext(SOAP11Context.class).getEnvelope();
    }
}

