/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.rules.ImmutableSortMergeRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.immutables.value.Value;

@Value.Enclosing
public class SortMergeRule
extends RelRule<Config>
implements TransformationRule {
    protected SortMergeRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        ((Config)this.config).matchHandler().accept(this, call);
    }

    private static void limitMerge(SortMergeRule rule, RelOptRuleCall call) {
        Number bottomFetch;
        Sort topSort = (Sort)call.rel(0);
        Sort bottomSort = (Sort)call.rel(1);
        if (bottomSort.offset != null || bottomSort.fetch == null) {
            return;
        }
        RelBuilder builder = call.builder();
        Number topFetch = topSort.fetch instanceof RexLiteral ? (Number)RexLiteral.numberValue(topSort.fetch) : (Number)null;
        Number number = bottomFetch = bottomSort.fetch instanceof RexLiteral ? (Number)RexLiteral.numberValue(bottomSort.fetch) : (Number)null;
        if (topFetch == null || bottomFetch == null) {
            return;
        }
        BigDecimal minFetch = ((BigDecimal)topFetch).min((BigDecimal)bottomFetch);
        builder.push(bottomSort.getInput());
        ImmutableList<RexNode> fields = builder.fields(bottomSort.getCollation());
        builder.sortLimit((Number)-1, minFetch, (Iterable<? extends RexNode>)fields);
        call.transformTo(builder.build());
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RelRule.Config {
        public static final Config LIMIT_MERGE = ImmutableSortMergeRule.Config.builder().withMatchHandler((x$0, x$1) -> SortMergeRule.access$000(x$0, x$1)).build().withOperandSupplier(b -> b.operand(Sort.class).predicate(p -> RelOptUtil.isPureLimit(p) && !RelOptUtil.isOffset(p)).oneInput(b1 -> b1.operand(Sort.class).anyInputs())).withDescription("SortMergeRule:LIMIT_MERGE");

        @Override
        default public SortMergeRule toRule() {
            return new SortMergeRule(this);
        }

        public RelRule.MatchHandler<SortMergeRule> matchHandler();

        public Config withMatchHandler(RelRule.MatchHandler<SortMergeRule> var1);
    }
}

