/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.extraction;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.extraction.ExtractionBackend;
import org.apache.solr.handler.extraction.ExtractionMetadata;
import org.apache.solr.handler.extraction.ExtractionPasswordProvider;
import org.apache.solr.handler.extraction.ExtractionRequest;
import org.apache.solr.handler.extraction.ExtractionResult;
import org.apache.solr.handler.extraction.ParseContextConfig;
import org.apache.solr.handler.extraction.RegexRulesPasswordProvider;
import org.apache.solr.logging.DeprecationLog;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.DefaultParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.html.HtmlMapper;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

@Deprecated(since="9.10.0", forRemoval=true)
public class LocalTikaExtractionBackend
implements ExtractionBackend {
    private final TikaConfig tikaConfig;
    private final ParseContextConfig parseContextConfig;
    private final AutoDetectParser autoDetectParser;
    public static final String NAME = "local";

    public LocalTikaExtractionBackend(TikaConfig config, ParseContextConfig parseContextConfig) {
        this.tikaConfig = config;
        this.parseContextConfig = parseContextConfig;
        this.autoDetectParser = new AutoDetectParser(config);
    }

    public LocalTikaExtractionBackend(SolrCore core, String tikaConfigLoc, ParseContextConfig parseContextConfig) throws Exception {
        TikaConfig cfg;
        if (tikaConfigLoc == null) {
            ClassLoader classLoader = core.getResourceLoader().getClassLoader();
            try (InputStream is = classLoader.getResourceAsStream("solr-default-tika-config.xml");){
                cfg = new TikaConfig(is);
            }
        }
        Path configFile = Path.of(tikaConfigLoc, new String[0]);
        core.getCoreContainer().assertPathAllowed(configFile);
        if (configFile.isAbsolute()) {
            cfg = new TikaConfig(configFile);
        } else {
            try (InputStream is = core.getResourceLoader().openResource(tikaConfigLoc);){
                cfg = new TikaConfig(is);
            }
        }
        this.tikaConfig = cfg;
        this.parseContextConfig = parseContextConfig;
        this.autoDetectParser = new AutoDetectParser(cfg);
        DeprecationLog.log((String)"Local Tika", (String)"The 'local' extraction backend is deprecated");
    }

    @Override
    public String name() {
        return NAME;
    }

    private Parser selectParser(ExtractionRequest request) {
        if (request.streamType != null) {
            MediaType mt = MediaType.parse((String)request.streamType.trim().toLowerCase(Locale.ROOT));
            return (Parser)new DefaultParser(this.tikaConfig.getMediaTypeRegistry()).getParsers().get(mt);
        }
        return this.autoDetectParser;
    }

    private Metadata buildMetadata(ExtractionRequest request) {
        ExtractionMetadata extractionMetadata = this.buildMetadataFromRequest(request);
        Metadata md = new Metadata();
        for (String name : extractionMetadata.keySet()) {
            List<String> vals = extractionMetadata.get(name);
            if (vals == null) continue;
            for (String v : vals) {
                md.add(name, v);
            }
        }
        return md;
    }

    private ParseContext buildContext(Parser parser, ExtractionRequest request) {
        ParseContext context = this.parseContextConfig.create();
        context.set(Parser.class, (Object)parser);
        context.set(HtmlMapper.class, (Object)MostlyPassthroughHtmlMapper.INSTANCE);
        RegexRulesPasswordProvider pwd = new RegexRulesPasswordProvider();
        if (request.resourcePassword != null) {
            pwd.setExplicitPassword(request.resourcePassword);
        }
        if (request.passwordsMap != null) {
            pwd.setPasswordMap(request.passwordsMap);
        }
        context.set(PasswordProvider.class, (Object)new PasswordProviderAdapter(pwd));
        return context;
    }

    private static ExtractionMetadata tikaMetadataToExtractionMetadata(Metadata md) {
        ExtractionMetadata out = new ExtractionMetadata();
        for (String name : md.names()) {
            String[] vals = md.getValues(name);
            if (vals == null) continue;
            for (String v : vals) {
                out.add(name, v);
            }
        }
        return out;
    }

    @Override
    public ExtractionResult extract(InputStream inputStream, ExtractionRequest request) throws Exception {
        Parser parser = this.selectParser(request);
        if (parser == null) {
            throw new IllegalArgumentException("No Tika parser for stream type: " + request.streamType);
        }
        ParseContext context = this.buildContext(parser, request);
        Metadata md = this.buildMetadata(request);
        BodyContentHandler textHandler = new BodyContentHandler(-1);
        parser.parse(inputStream, (ContentHandler)textHandler, md, context);
        return new ExtractionResult(textHandler.toString(), LocalTikaExtractionBackend.tikaMetadataToExtractionMetadata(md));
    }

    @Override
    public void extractWithSaxHandler(InputStream inputStream, ExtractionRequest request, ExtractionMetadata md, DefaultHandler saxContentHandler) throws Exception {
        Parser parser = this.selectParser(request);
        if (parser == null) {
            throw new IllegalArgumentException("No Tika parser for stream type: " + request.streamType);
        }
        ParseContext context = this.buildContext(parser, request);
        Metadata tikaMetadata = this.buildMetadata(request);
        parser.parse(inputStream, (ContentHandler)saxContentHandler, tikaMetadata, context);
        for (String name : tikaMetadata.names()) {
            String[] vals = tikaMetadata.getValues(name);
            if (vals == null) continue;
            for (String v : vals) {
                md.add(name, v);
            }
        }
    }

    private static class PasswordProviderAdapter
    implements PasswordProvider {
        private final ExtractionPasswordProvider delegate;

        public PasswordProviderAdapter(ExtractionPasswordProvider delegate) {
            this.delegate = delegate;
        }

        public String getPassword(Metadata metadata) {
            return this.delegate.getPassword(LocalTikaExtractionBackend.tikaMetadataToExtractionMetadata(metadata));
        }
    }

    private static class MostlyPassthroughHtmlMapper
    implements HtmlMapper {
        static final HtmlMapper INSTANCE = new MostlyPassthroughHtmlMapper();

        private MostlyPassthroughHtmlMapper() {
        }

        public boolean isDiscardElement(String name) {
            return false;
        }

        public String mapSafeAttribute(String elementName, String attributeName) {
            return attributeName.toLowerCase(Locale.ENGLISH);
        }

        public String mapSafeElement(String name) {
            String lowerName = name.toLowerCase(Locale.ROOT);
            return lowerName.equals("br") || lowerName.equals("body") ? null : lowerName;
        }
    }
}

