/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Category;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.core.scanner.PluginFactory;

public class AllCategoryTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private Map<String, String> i18nToStr = null;
    private static final String[] columnNames = new String[]{Constant.messages.getString("ascan.policy.table.category"), Constant.messages.getString("ascan.policy.table.threshold"), Constant.messages.getString("ascan.policy.table.strength")};
    private PluginFactory pluginFactory;

    public AllCategoryTableModel(PluginFactory pluginFactory) {
        this.pluginFactory = pluginFactory;
    }

    public void setPluginFactory(PluginFactory pluginFactory) {
        this.pluginFactory = pluginFactory;
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 0: {
                break;
            }
            case 1: {
                if (value.toString().isEmpty()) break;
                this.setPluginCategoryThreshold(row, Plugin.AlertThreshold.valueOf(this.i18nToStr((String)value)));
                this.fireTableCellUpdated(row, col);
                break;
            }
            case 2: {
                if (value.toString().isEmpty()) break;
                this.setPluginCategoryStrength(row, Plugin.AttackStrength.valueOf(this.i18nToStr((String)value)));
                this.fireTableCellUpdated(row, col);
            }
        }
    }

    private String strToI18n(String str) {
        return Constant.messages.getString("ascan.policy.level." + str.toLowerCase(Locale.ROOT));
    }

    private String i18nToStr(String str) {
        if (this.i18nToStr == null) {
            this.i18nToStr = new HashMap<String, String>();
            for (Plugin.AlertThreshold alertThreshold : Plugin.AlertThreshold.values()) {
                this.i18nToStr.put(this.strToI18n(alertThreshold.name()), alertThreshold.name());
            }
            for (Enum enum_ : Plugin.AttackStrength.values()) {
                this.i18nToStr.put(this.strToI18n(enum_.name()), enum_.name());
            }
        }
        return this.i18nToStr.get(str);
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        return Category.length();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return switch (col) {
            case 0 -> Category.getName(row);
            case 1 -> this.getPluginCategoryThreshold(row);
            case 2 -> this.getPluginCategoryStrength(row);
            default -> "";
        };
    }

    private String getPluginCategoryThreshold(int category) {
        Enum at = null;
        for (int i = 0; i < this.pluginFactory.getAllPlugin().size(); ++i) {
            Plugin plugin = this.pluginFactory.getAllPlugin().get(i);
            if (plugin.getCategory() != category) continue;
            if (at == null) {
                at = AllCategoryTableModel.getAlertThreshold(plugin);
                continue;
            }
            if (at.equals((Object)AllCategoryTableModel.getAlertThreshold(plugin))) continue;
            return "";
        }
        if (at == null) {
            return "";
        }
        return this.strToI18n(at.name());
    }

    private static Plugin.AlertThreshold getAlertThreshold(Plugin plugin) {
        if (!plugin.isEnabled()) {
            return Plugin.AlertThreshold.OFF;
        }
        return plugin.getAlertThreshold(true);
    }

    private String getPluginCategoryStrength(int category) {
        Enum at = null;
        for (int i = 0; i < this.pluginFactory.getAllPlugin().size(); ++i) {
            Plugin plugin = this.pluginFactory.getAllPlugin().get(i);
            if (plugin.getCategory() != category) continue;
            if (at == null) {
                at = plugin.getAttackStrength(true);
                continue;
            }
            if (at.equals((Object)plugin.getAttackStrength(true))) continue;
            return "";
        }
        if (at == null) {
            return "";
        }
        return this.strToI18n(at.name());
    }

    private void setPluginCategoryThreshold(int category, Plugin.AlertThreshold at) {
        boolean enable = !Plugin.AlertThreshold.OFF.equals((Object)at);
        for (int i = 0; i < this.pluginFactory.getAllPlugin().size(); ++i) {
            String[] dependencies;
            Plugin plugin = this.pluginFactory.getAllPlugin().get(i);
            if (plugin.getCategory() != category || enable && (dependencies = plugin.getDependency()) != null && dependencies.length != 0 && !this.pluginFactory.hasAllDependenciesAvailable(plugin)) continue;
            plugin.setAlertThreshold(at);
            plugin.setEnabled(enable);
        }
    }

    private void setPluginCategoryStrength(int category, Plugin.AttackStrength at) {
        for (int i = 0; i < this.pluginFactory.getAllPlugin().size(); ++i) {
            Plugin plugin = this.pluginFactory.getAllPlugin().get(i);
            if (plugin.getCategory() != category) continue;
            plugin.setAttackStrength(at);
        }
    }

    void setAllCategoryEnabled(boolean enabled) {
        for (int i = 0; i < this.pluginFactory.getAllPlugin().size(); ++i) {
            Plugin plugin = this.pluginFactory.getAllPlugin().get(i);
            plugin.setEnabled(enabled);
        }
        this.fireTableDataChanged();
    }

    boolean isAllCategoryEnabled() {
        for (int i = 0; i < this.pluginFactory.getAllPlugin().size(); ++i) {
            Plugin plugin = this.pluginFactory.getAllPlugin().get(i);
            if (plugin.isEnabled()) continue;
            return false;
        }
        return true;
    }
}

