      SUBROUTINE FETCH(ZLIST,FILE,RECNUM,IWRDOFF,NWORDS)
C
C THIS ROUTINE RETRIEVES LOGICAL RECORDS FROM LIST FILES.  IT IS
C  A PRIMITIVE ROUTINE CALLED BY PUTLST WHICH SHOULD NOT BE CALLED
C  DIRECTLY.
C
CEND
C
C SG 6/5/96 If a full record is being written, do not copy it to the cache.
C
      IMPLICIT INTEGER (A-Z)
      DIMENSION ZLIST(1)
      COMMON // ICORE(1)
      COMMON /CACHEINF/ CACHNUM,CACHNMP1,CACHDIR(100),CACHPOS(100),
     &                  CACHFILE(100),CACHMOD(100),OLDEST
      COMMON /MACHSP/ IINTLN,IFLTLN,IINTFP,IALONE,IBITWD
      COMMON /MACHSP2/MASK1,MASK2 ,ISHFSZ
      COMMON /FILSPC/ ILNBUF,IPRCLN,IPRCWD
      COMMON /IOPOS/ ICRSIZ,ICHCSZ,IOFF(2),LENREC
C
      IPACK(I,J)=IOR(J,ISHFT(I-49,ISHFSZ))
      UPACKR(I) =IAND(I,MASK1)
      UPACKF(I) =IAND(ISHFT(I,-ISHFSZ),MASK2)+49
C
C CHECK TO SEE IF THE RECORD IS IN THE CACHE.  IF IT IS, IIEQ WILL
C  RETURN A VALUE IN THE RANGE 1-CACHNUM.  
C
      ITEST=IPACK(FILE,RECNUM)
      ILOC=IIEQ(CACHNUM,CACHDIR,1,ITEST)
C
C IF THE CORRECT RECORD (FILE MUST MATCH AS WELL) IS IN THE CACHE,
C  THE JUST COPY IT TO ZLIST
C
      IF(ILOC.NE.0)THEN
       IADR=CACHPOS(ILOC)
       IPOS=IADR+IWRDOFF-1
C
c YAU : old
cC       CALL ICOPY(NWORDS,ICORE(IPOS),1,ZLIST,1)
c       CALL SCOPY(NWORDS/IINTFP,ICORE(IPOS),1,ZLIST,1)
c YAU : new
c Someone probably thought that by calling scopy/dcopy, it would be "faster"
c because there are fewer separate memory look-ups; however, what if NWORDS
c is not a multiple of IINTFP? Additionally, how much faster is it once
c you throw in a variable integer divide (it probably doesn't know that
c IINTFP is 1 or 2)?
       CALL ICOPY(NWORDS,ICORE(IPOS),1,ZLIST,1)
c YAU : end
C
       RETURN
      ELSEIF (NWORDS .EQ. LENREC) THEN
        CALL ACES_IO_READ(FILE,RECNUM,ZLIST,LENREC)
      ELSE
C
C THE RECORD MUST BE PICKED UP FROM DISK.  DUMP OLDEST SURVIVING RECORD
C  TO DISK IF IT HAS BEEN MODIFIED.  OTHERWISE, COPY OVER IT.
C
       IF(CACHMOD(OLDEST).NE.0)THEN
        IADR=CACHPOS(OLDEST)
        FILEOUT=UPACKF(CACHDIR(OLDEST))
        RECOUT =UPACKR(CACHDIR(OLDEST)) 
        CALL ACES_IO_WRITE(FILEOUT,RECOUT,ICORE(CACHPOS(OLDEST)),LENREC)
        CACHMOD(OLDEST)=0
       ENDIF
       CALL ACES_IO_READ(FILE,RECNUM,ICORE(CACHPOS(OLDEST)),LENREC)
       CACHMOD(OLDEST)=0
       CACHFILE(OLDEST)=FILE
       CACHDIR (OLDEST)=IPACK(FILE,RECNUM)
       IPOS=CACHPOS(OLDEST)+IWRDOFF-1
       CALL ICOPY(NWORDS,ICORE(IPOS),1,ZLIST,1)
       OLDEST=OLDEST+1
       IF(OLDEST.GT.CACHNUM)OLDEST=1
       RETURN
      ENDIF
C
      END
