/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.expr.VersionProvider;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;

public abstract class Expr
implements VersionProvider {
    public static final int NO_ID = -1;
    protected List<Expr> mChildren = new ArrayList<Expr>();
    private List<Expr> mParents = new ArrayList<Expr>();
    private Boolean mIsDynamic;
    private ModelClass mResolvedType;
    private String mUniqueKey;
    private List<Dependency> mDependencies;
    private List<Dependency> mDependants = Lists.newArrayList();
    private int mId = -1;
    private int mRequirementId = -1;
    private int mVersion = 0;
    private boolean mCanBeInvalidated = false;
    private BitSet mInvalidFlags;
    private ExprModel mModel;
    BitSet mShouldReadFlags;
    BitSet mReadSoFar = new BitSet();
    BitSet mShouldReadWithConditionals;
    private boolean mIsBindingExpression;
    private boolean mRead;
    private boolean mIsUsed = false;
    Predicate<Dependency> unreadElevatedCheck = new Predicate<Dependency>(){

        @Override
        public boolean apply(Dependency input) {
            return input.isElevated() && !input.getDependant().isRead();
        }
    };
    protected static final String KEY_JOIN = "~";
    protected static final Joiner sUniqueKeyJoiner = Joiner.on("~");
    Predicate<Dependency> hasNestedCannotRead = new Predicate<Dependency>(){

        @Override
        public boolean apply(Dependency input) {
            return input.isConditional() || input.getOther().hasNestedCannotRead();
        }
    };
    BitSet mConditionalFlags;
    private Node mCalculationPaths = null;

    Expr(Iterable<Expr> children) {
        for (Expr expr : children) {
            this.mChildren.add(expr);
        }
        this.addParents();
    }

    Expr(Expr ... children) {
        Collections.addAll(this.mChildren, children);
        this.addParents();
    }

    public int getId() {
        Preconditions.checkState(this.mId != -1, "if getId is called on an expression, it should have and id");
        return this.mId;
    }

    public void setId(int id) {
        Preconditions.checkState(this.mId == -1, "ID is already set on " + this);
        this.mId = id;
    }

    public ExprModel getModel() {
        return this.mModel;
    }

    public BitSet getInvalidFlags() {
        if (this.mInvalidFlags == null) {
            this.mInvalidFlags = this.resolveInvalidFlags();
        }
        return this.mInvalidFlags;
    }

    private BitSet resolveInvalidFlags() {
        BitSet bitSet = (BitSet)this.mModel.getInvalidateAnyBitSet().clone();
        if (this.mCanBeInvalidated) {
            bitSet.set(this.getId(), true);
        }
        for (Dependency dependency : this.getDependencies()) {
            bitSet.or(dependency.getOther().getInvalidFlags());
        }
        return bitSet;
    }

    public void setBindingExpression(boolean isBindingExpression) {
        this.mIsBindingExpression = isBindingExpression;
    }

    public boolean isBindingExpression() {
        return this.mIsBindingExpression;
    }

    public boolean canBeEvaluatedToAVariable() {
        return true;
    }

    public boolean isObservable() {
        return this.getResolvedType().isObservable();
    }

    public BitSet getShouldReadFlags() {
        if (this.mShouldReadFlags == null) {
            this.getShouldReadFlagsWithConditionals();
            this.mShouldReadFlags = this.resolveShouldReadFlags();
        }
        return this.mShouldReadFlags;
    }

    public BitSet getShouldReadFlagsWithConditionals() {
        if (this.mShouldReadWithConditionals == null) {
            this.mShouldReadWithConditionals = this.resolveShouldReadWithConditionals();
        }
        return this.mShouldReadWithConditionals;
    }

    public void setModel(ExprModel model) {
        this.mModel = model;
    }

    private BitSet resolveShouldReadWithConditionals() {
        BitSet bitSet = new BitSet();
        if (this.mIsBindingExpression) {
            bitSet.or(this.getInvalidFlags());
        }
        for (Dependency dependency : this.getDependants()) {
            if (dependency.getCondition() == null) {
                bitSet.or(dependency.getDependant().getShouldReadFlagsWithConditionals());
                continue;
            }
            bitSet.set(dependency.getDependant().getRequirementFlagIndex(dependency.getExpectedOutput()));
        }
        return bitSet;
    }

    private BitSet resolveShouldReadFlags() {
        BitSet bitSet = new BitSet();
        if (this.isRead()) {
            return bitSet;
        }
        if (this.mIsBindingExpression) {
            bitSet.or(this.getInvalidFlags());
        }
        for (Dependency dependency : this.getDependants()) {
            boolean isUnreadElevated = this.unreadElevatedCheck.apply(dependency);
            if (dependency.isConditional()) continue;
            if (isUnreadElevated) {
                bitSet.set(dependency.getDependant().getRequirementFlagIndex(dependency.getExpectedOutput()));
                continue;
            }
            bitSet.or(dependency.getDependant().getShouldReadFlags());
        }
        bitSet.and(this.mShouldReadWithConditionals);
        bitSet.andNot(this.mReadSoFar);
        return bitSet;
    }

    private void addParents() {
        for (Expr expr : this.mChildren) {
            expr.mParents.add(this);
        }
    }

    public void onSwappedWith(Expr existing) {
        for (Expr child : this.mChildren) {
            child.onParentSwapped(this, existing);
        }
    }

    private void onParentSwapped(Expr oldParent, Expr newParent) {
        Preconditions.checkState(this.mParents.remove(oldParent));
        this.mParents.add(newParent);
    }

    public List<Expr> getChildren() {
        return this.mChildren;
    }

    public List<Expr> getParents() {
        return this.mParents;
    }

    public boolean isDynamic() {
        if (this.mIsDynamic == null) {
            this.mIsDynamic = this.isAnyChildDynamic();
        }
        return this.mIsDynamic;
    }

    private boolean isAnyChildDynamic() {
        return Iterables.any(this.mChildren, new Predicate<Expr>(){

            @Override
            public boolean apply(Expr input) {
                return input.isDynamic();
            }
        });
    }

    public ModelClass getResolvedType() {
        if (this.mResolvedType == null) {
            this.mResolvedType = this.resolveType(ModelAnalyzer.getInstance());
        }
        return this.mResolvedType;
    }

    protected abstract ModelClass resolveType(ModelAnalyzer var1);

    protected abstract List<Dependency> constructDependencies();

    protected List<Dependency> constructDynamicChildrenDependencies() {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (Expr node : this.mChildren) {
            if (!node.isDynamic()) continue;
            dependencies.add(new Dependency(this, node));
        }
        return dependencies;
    }

    public final List<Dependency> getDependencies() {
        if (this.mDependencies == null) {
            this.mDependencies = this.constructDependencies();
        }
        return this.mDependencies;
    }

    void addDependant(Dependency dependency) {
        this.mDependants.add(dependency);
    }

    public List<Dependency> getDependants() {
        return this.mDependants;
    }

    public final String getUniqueKey() {
        if (this.mUniqueKey == null) {
            this.mUniqueKey = this.computeUniqueKey();
            Preconditions.checkNotNull(this.mUniqueKey, "if there are no children, you must override computeUniqueKey");
            Preconditions.checkState(!this.mUniqueKey.trim().equals(""), "if there are no children, you must override computeUniqueKey");
        }
        return this.mUniqueKey;
    }

    protected String computeUniqueKey() {
        return this.computeChildrenKey();
    }

    protected final String computeChildrenKey() {
        return sUniqueKeyJoiner.join(Iterables.transform(this.mChildren, new Function<Expr, String>(){

            @Override
            public String apply(Expr input) {
                return input.getUniqueKey();
            }
        }));
    }

    public void enableDirectInvalidation() {
        this.mCanBeInvalidated = true;
    }

    public boolean canBeInvalidated() {
        return this.mCanBeInvalidated;
    }

    public void trimShouldReadFlags(BitSet bitSet) {
        this.mShouldReadFlags.andNot(bitSet);
    }

    public boolean isConditional() {
        return false;
    }

    public int getRequirementId() {
        return this.mRequirementId;
    }

    public void setRequirementId(int requirementId) {
        this.mRequirementId = requirementId;
    }

    public int getRequirementFlagIndex(boolean expectedOutput) {
        Preconditions.checkState(this.mRequirementId != -1, "If this is an expression w/ conditional dependencies, it must be assigned a requirement ID");
        return expectedOutput ? this.mRequirementId + 1 : this.mRequirementId;
    }

    public boolean hasId() {
        return this.mId != -1;
    }

    public void markFlagsAsRead(BitSet flags) {
        this.mReadSoFar.or(flags);
    }

    public boolean isRead() {
        return this.mRead;
    }

    public boolean considerElevatingConditionals(Expr justRead) {
        boolean elevated = false;
        for (Dependency dependency : this.mDependencies) {
            if (!dependency.isConditional() || dependency.getCondition() != justRead) continue;
            dependency.elevate();
            elevated = true;
        }
        return elevated;
    }

    public void invalidateReadFlags() {
        this.mShouldReadFlags = null;
        ++this.mVersion;
    }

    @Override
    public int getVersion() {
        return this.mVersion;
    }

    public boolean hasNestedCannotRead() {
        if (this.isRead()) {
            return false;
        }
        if (this.getShouldReadFlags().isEmpty()) {
            return true;
        }
        return Iterables.any(this.getDependencies(), this.hasNestedCannotRead);
    }

    public boolean markAsReadIfDone() {
        if (this.mRead) {
            return false;
        }
        BitSet clone = (BitSet)this.mShouldReadWithConditionals.clone();
        clone.andNot(this.mReadSoFar);
        this.mRead = clone.isEmpty();
        if (!this.mRead && !this.mReadSoFar.isEmpty()) {
            int i = clone.nextSetBit(0);
            while (i != -1) {
                Expr expr = this.mModel.findFlagExpression(i);
                if (expr != null && expr.isConditional()) {
                    BitSet readForConditional = expr.findConditionalFlags();
                    clone.andNot(readForConditional);
                    BitSet invalidFlags = (BitSet)this.getInvalidFlags().clone();
                    invalidFlags.andNot(readForConditional);
                    boolean bl = this.mRead = invalidFlags.isEmpty() || clone.isEmpty();
                    if (this.mRead) break;
                }
                i = clone.nextSetBit(i + 1);
            }
        }
        if (this.mRead) {
            this.mShouldReadFlags = null;
        }
        return this.mRead;
    }

    private BitSet findConditionalFlags() {
        Preconditions.checkState(this.isConditional(), "should not call this on a non-conditional expr");
        if (this.mConditionalFlags == null) {
            this.mConditionalFlags = new BitSet();
            this.resolveConditionalFlags(this.mConditionalFlags);
        }
        return this.mConditionalFlags;
    }

    private void resolveConditionalFlags(BitSet flags) {
        Dependency dependency;
        flags.or(this.getPredicateInvalidFlags());
        if (this.getDependants().size() == 1 && (dependency = this.getDependants().get(0)).getCondition() != null) {
            flags.or(dependency.getDependant().findConditionalFlags());
            flags.set(dependency.getDependant().getRequirementFlagIndex(dependency.getExpectedOutput()));
        }
    }

    public String toString() {
        return this.getUniqueKey();
    }

    public BitSet getReadSoFar() {
        return this.mReadSoFar;
    }

    protected Node getAllCalculationPaths() {
        if (this.mCalculationPaths == null) {
            Node node = new Node();
            if (this.isConditional()) {
                node.mBitSet.or(this.getPredicateInvalidFlags());
            } else {
                node.mBitSet.or(this.getInvalidFlags());
            }
            for (Dependency dependency : this.getDependants()) {
                Expr dependant = dependency.getDependant();
                if (dependency.getCondition() != null) {
                    Node cond = new Node();
                    cond.setConditionFlag(dependant.getRequirementFlagIndex(dependency.getExpectedOutput()));
                    cond.mParents.add(dependant.getAllCalculationPaths());
                    continue;
                }
                node.mParents.add(dependant.getAllCalculationPaths());
            }
            this.mCalculationPaths = node;
        }
        return this.mCalculationPaths;
    }

    public String getDefaultValue() {
        return ModelAnalyzer.getInstance().getDefaultValue(this.getResolvedType().toJavaCode());
    }

    protected BitSet getPredicateInvalidFlags() {
        throw new IllegalStateException("must override getPredicateInvalidFlags in " + this.getClass().getSimpleName());
    }

    public boolean shouldReadNow(final Iterable<Expr> justRead) {
        return !this.getShouldReadFlags().isEmpty() && !Iterables.any(this.getDependencies(), new Predicate<Dependency>(){

            @Override
            public boolean apply(Dependency input) {
                return !input.getOther().isRead() && (justRead == null || !Iterables.contains(justRead, input.getOther()));
            }
        });
    }

    public boolean isEqualityCheck() {
        return false;
    }

    public void setIsUsed(boolean isUsed) {
        this.mIsUsed = isUsed;
    }

    public boolean isUsed() {
        return this.mIsUsed;
    }

    public void updateExpr(ModelAnalyzer modelAnalyzer) {
        for (Expr child : this.mChildren) {
            child.updateExpr(modelAnalyzer);
        }
    }

    protected String asPackage() {
        return null;
    }

    static class Node {
        BitSet mBitSet = new BitSet();
        List<Node> mParents = new ArrayList<Node>();
        int mConditionFlag = -1;

        Node() {
        }

        public boolean areAllPathsSatisfied(BitSet readSoFar) {
            if (this.mConditionFlag != -1) {
                return readSoFar.get(this.mConditionFlag) || this.mParents.get(0).areAllPathsSatisfied(readSoFar);
            }
            BitSet clone = (BitSet)readSoFar.clone();
            clone.and(this.mBitSet);
            if (!clone.isEmpty()) {
                return true;
            }
            if (this.mParents.isEmpty()) {
                return false;
            }
            for (Node parent : this.mParents) {
                if (parent.areAllPathsSatisfied(clone)) continue;
                return false;
            }
            return true;
        }

        public void setConditionFlag(int requirementFlagIndex) {
            this.mConditionFlag = requirementFlagIndex;
        }
    }
}

