/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.schema.PgRelation;

public class PgRule
extends PgRelation {
    private String query;
    private String relationName;
    private String event;

    public PgRule(String string) {
        this.setName(string);
    }

    public String getCreationSQL() {
        StringBuilder stringBuilder = new StringBuilder(this.query.length() * 2);
        stringBuilder.append("CREATE ");
        stringBuilder.append(this.getRelationKind());
        stringBuilder.append(' ');
        stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
        stringBuilder.append(" AS");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(" ON ");
        stringBuilder.append(this.event);
        stringBuilder.append(" TO ");
        stringBuilder.append(this.relationName);
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(" ");
        stringBuilder.append(this.query);
        stringBuilder.append(";");
        stringBuilder.append(this.getCommentDefinitionSQL());
        return stringBuilder.toString();
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public String getQuery() {
        return this.query;
    }

    public void setRelationName(String string) {
        this.relationName = string;
    }

    public String getRelationName() {
        return this.relationName;
    }

    public void setEvent(String string) {
        this.event = string;
    }

    public String getEvent() {
        return this.event;
    }

    @Override
    public String getRelationKind() {
        return "RULE";
    }

    @Override
    public String getDropSQL() {
        return "DROP RULE " + PgDiffUtils.getDropIfExists() + PgDiffUtils.getQuotedName(this.getName()) + " ON " + PgDiffUtils.getQuotedName(this.getRelationName()) + ";";
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof PgRule) {
            PgRule pgRule = (PgRule)object;
            bl = this.event == pgRule.getEvent() && this.relationName.equals(pgRule.getRelationName()) && this.name.equals(pgRule.getName()) && this.query.equals(pgRule.getQuery());
        }
        return bl;
    }
}

