/*
 * Copyright (c) 2019, Xilinx, Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/* Versal PM nodes enums and defines */

#ifndef PM_NODE_H
#define PM_NODE_H

/*********************************************************************
 * Macro definitions
 ********************************************************************/

#define NODE_CLASS_SHIFT	26U
#define NODE_SUBCLASS_SHIFT	20U
#define NODE_TYPE_SHIFT		14U
#define NODE_INDEX_SHIFT	0U
#define NODE_CLASS_MASK_BITS    0x3F
#define NODE_SUBCLASS_MASK_BITS 0x3F
#define NODE_TYPE_MASK_BITS     0x3F
#define NODE_INDEX_MASK_BITS    0x3FFF
#define NODE_CLASS_MASK         (NODE_CLASS_MASK_BITS << NODE_CLASS_SHIFT)
#define NODE_SUBCLASS_MASK      (NODE_SUBCLASS_MASK_BITS << NODE_SUBCLASS_SHIFT)
#define NODE_TYPE_MASK          (NODE_TYPE_MASK_BITS << NODE_TYPE_SHIFT)
#define NODE_INDEX_MASK         (NODE_INDEX_MASK_BITS << NODE_INDEX_SHIFT)

#define NODEID(CLASS, SUBCLASS, TYPE, INDEX)	\
	     ((((CLASS) & NODE_CLASS_MASK_BITS) << NODE_CLASS_SHIFT) | \
	     (((SUBCLASS) & NODE_SUBCLASS_MASK_BITS) << NODE_SUBCLASS_SHIFT) | \
	     (((TYPE) & NODE_TYPE_MASK_BITS) << NODE_TYPE_SHIFT) | \
	     (((INDEX) & NODE_INDEX_MASK_BITS) << NODE_INDEX_SHIFT))

#define NODECLASS(ID)		(((ID) & NODE_CLASS_MASK) >> NODE_CLASS_SHIFT)
#define NODESUBCLASS(ID)	(((ID) & NODE_SUBCLASS_MASK) >> \
				NODE_SUBCLASS_SHIFT)
#define NODETYPE(ID)		(((ID) & NODE_TYPE_MASK) >> NODE_TYPE_SHIFT)
#define NODEINDEX(ID)		(((ID) & NODE_INDEX_MASK) >> NODE_INDEX_SHIFT)

/*********************************************************************
 * Enum definitions
 ********************************************************************/

/* Node class types */
enum pm_node_class {
	XPM_NODECLASS_MIN,

	XPM_NODECLASS_POWER,
	XPM_NODECLASS_CLOCK,
	XPM_NODECLASS_RESET,
	XPM_NODECLASS_MEMIC,
	XPM_NODECLASS_STMIC,
	XPM_NODECLASS_DEVICE,

	XPM_NODECLASS_MAX
};

enum pm_device_node_subclass {
	/* Device types */
	XPM_NODESUBCL_DEV_CORE = 1,
	XPM_NODESUBCL_DEV_PERIPH,
	XPM_NODESUBCL_DEV_MEM,
	XPM_NODESUBCL_DEV_SOC,
	XPM_NODESUBCL_DEV_MEM_CTRLR,
	XPM_NODESUBCL_DEV_PHY,
};

enum pm_device_node_type {
	/* Device types */
	XPM_NODETYPE_DEV_CORE_PMC = 1,
	XPM_NODETYPE_DEV_CORE_PSM,
	XPM_NODETYPE_DEV_CORE_APU,
	XPM_NODETYPE_DEV_CORE_RPU,
	XPM_NODETYPE_DEV_OCM,
	XPM_NODETYPE_DEV_TCM,
	XPM_NODETYPE_DEV_L2CACHE,
	XPM_NODETYPE_DEV_DDR,
	XPM_NODETYPE_DEV_PERIPH,
	XPM_NODETYPE_DEV_SOC,
	XPM_NODETYPE_DEV_GT,
};

/* Device node Indexes */
enum pm_device_node_idx {
	/* Device nodes */
	XPM_NODEIDX_DEV_MIN,

	/* Processor devices */
	XPM_NODEIDX_DEV_PMC_PROC,
	XPM_NODEIDX_DEV_PSM_PROC,
	XPM_NODEIDX_DEV_ACPU_0,
	XPM_NODEIDX_DEV_ACPU_1,
	XPM_NODEIDX_DEV_RPU0_0,
	XPM_NODEIDX_DEV_RPU0_1,

	/* Memory devices */
	XPM_NODEIDX_DEV_OCM_0,
	XPM_NODEIDX_DEV_OCM_1,
	XPM_NODEIDX_DEV_OCM_2,
	XPM_NODEIDX_DEV_OCM_3,
	XPM_NODEIDX_DEV_TCM_0_A,
	XPM_NODEIDX_DEV_TCM_0_B,
	XPM_NODEIDX_DEV_TCM_1_A,
	XPM_NODEIDX_DEV_TCM_1_B,
	XPM_NODEIDX_DEV_L2_BANK_0,
	XPM_NODEIDX_DEV_DDR_0,
	XPM_NODEIDX_DEV_DDR_1,
	XPM_NODEIDX_DEV_DDR_2,
	XPM_NODEIDX_DEV_DDR_3,
	XPM_NODEIDX_DEV_DDR_4,
	XPM_NODEIDX_DEV_DDR_5,
	XPM_NODEIDX_DEV_DDR_6,
	XPM_NODEIDX_DEV_DDR_7,

	/* LPD Peripheral devices */
	XPM_NODEIDX_DEV_USB_0,
	XPM_NODEIDX_DEV_GEM_0,
	XPM_NODEIDX_DEV_GEM_1,
	XPM_NODEIDX_DEV_SPI_0,
	XPM_NODEIDX_DEV_SPI_1,
	XPM_NODEIDX_DEV_I2C_0,
	XPM_NODEIDX_DEV_I2C_1,
	XPM_NODEIDX_DEV_CAN_FD_0,
	XPM_NODEIDX_DEV_CAN_FD_1,
	XPM_NODEIDX_DEV_UART_0,
	XPM_NODEIDX_DEV_UART_1,
	XPM_NODEIDX_DEV_GPIO,
	XPM_NODEIDX_DEV_TTC_0,
	XPM_NODEIDX_DEV_TTC_1,
	XPM_NODEIDX_DEV_TTC_2,
	XPM_NODEIDX_DEV_TTC_3,
	XPM_NODEIDX_DEV_SWDT_LPD,

	/* FPD Peripheral devices */
	XPM_NODEIDX_DEV_SWDT_FPD,

	/* PMC Peripheral devices */
	XPM_NODEIDX_DEV_OSPI,
	XPM_NODEIDX_DEV_QSPI,
	XPM_NODEIDX_DEV_GPIO_PMC,
	XPM_NODEIDX_DEV_I2C_PMC,
	XPM_NODEIDX_DEV_SDIO_0,
	XPM_NODEIDX_DEV_SDIO_1,

	XPM_NODEIDX_DEV_PL_0,
	XPM_NODEIDX_DEV_PL_1,
	XPM_NODEIDX_DEV_PL_2,
	XPM_NODEIDX_DEV_PL_3,
	XPM_NODEIDX_DEV_RTC,
	XPM_NODEIDX_DEV_ADMA_0,
	XPM_NODEIDX_DEV_ADMA_1,
	XPM_NODEIDX_DEV_ADMA_2,
	XPM_NODEIDX_DEV_ADMA_3,
	XPM_NODEIDX_DEV_ADMA_4,
	XPM_NODEIDX_DEV_ADMA_5,
	XPM_NODEIDX_DEV_ADMA_6,
	XPM_NODEIDX_DEV_ADMA_7,
	XPM_NODEIDX_DEV_IPI_0,
	XPM_NODEIDX_DEV_IPI_1,
	XPM_NODEIDX_DEV_IPI_2,
	XPM_NODEIDX_DEV_IPI_3,
	XPM_NODEIDX_DEV_IPI_4,
	XPM_NODEIDX_DEV_IPI_5,
	XPM_NODEIDX_DEV_IPI_6,

	/* Entire SoC */
	XPM_NODEIDX_DEV_SOC,

	/* DDR memory controllers */
	XPM_NODEIDX_DEV_DDRMC_0,
	XPM_NODEIDX_DEV_DDRMC_1,
	XPM_NODEIDX_DEV_DDRMC_2,
	XPM_NODEIDX_DEV_DDRMC_3,

	/* GT devices */
	XPM_NODEIDX_DEV_GT_0,
	XPM_NODEIDX_DEV_GT_1,
	XPM_NODEIDX_DEV_GT_2,
	XPM_NODEIDX_DEV_GT_3,
	XPM_NODEIDX_DEV_GT_4,
	XPM_NODEIDX_DEV_GT_5,
	XPM_NODEIDX_DEV_GT_6,
	XPM_NODEIDX_DEV_GT_7,
	XPM_NODEIDX_DEV_GT_8,
	XPM_NODEIDX_DEV_GT_9,
	XPM_NODEIDX_DEV_GT_10,

	XPM_NODEIDX_DEV_MAX
};

#endif /* PM_NODE_H */
