/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 13:38:29 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.BlastDocumentEntry;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.ReadListener;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.StreamSequence;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class BlastDocumentEntry_ESTest extends BlastDocumentEntry_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn("BASE COUNT", (String) null).when(linePushBackReader0).readLine();
      Document document0 = mock(Document.class, new ViolatedAssumptionAnswer());
      doReturn(linePushBackReader0).when(document0).getLinePushBackReader();
      ReadListener readListener0 = mock(ReadListener.class, new ViolatedAssumptionAnswer());
      BlastDocumentEntry blastDocumentEntry0 = null;
      try {
        blastDocumentEntry0 = new BlastDocumentEntry(document0, readListener0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequenceFactory", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn("^Sh3JbWz", (String) null).when(linePushBackReader0).readLine();
      Document document0 = mock(Document.class, new ViolatedAssumptionAnswer());
      doReturn(linePushBackReader0).when(document0).getLinePushBackReader();
      ReadListener readListener0 = mock(ReadListener.class, new ViolatedAssumptionAnswer());
      BlastDocumentEntry blastDocumentEntry0 = null;
      try {
        blastDocumentEntry0 = new BlastDocumentEntry(document0, readListener0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequenceFactory", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn("Zy9<").when(linePushBackReader0).readLine();
      Document document0 = mock(Document.class, new ViolatedAssumptionAnswer());
      doReturn(linePushBackReader0).when(document0).getLinePushBackReader();
      ReadListener readListener0 = mock(ReadListener.class, new ViolatedAssumptionAnswer());
      BlastDocumentEntry blastDocumentEntry0 = null;
      try {
        blastDocumentEntry0 = new BlastDocumentEntry(document0, readListener0);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      EntryInformation entryInformation0 = mock(EntryInformation.class, new ViolatedAssumptionAnswer());
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(entryInformation0);
      BlastDocumentEntry blastDocumentEntry1 = new BlastDocumentEntry(blastDocumentEntry0, false);
      assertTrue(blastDocumentEntry1.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry((EntryInformation) null);
      // Undeclared exception!
      try { 
        blastDocumentEntry0.makeNativeFeature((Feature) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.BlastStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry((EntryInformation) null);
      boolean boolean0 = blastDocumentEntry0.isReadOnly();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      EntryInformation entryInformation0 = mock(EntryInformation.class, new ViolatedAssumptionAnswer());
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(entryInformation0);
      // Undeclared exception!
      try { 
        blastDocumentEntry0.makeNativeFeature((Feature) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.BlastStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(linePushBackReader0).readLine();
      Document document0 = mock(Document.class, new ViolatedAssumptionAnswer());
      doReturn(linePushBackReader0).when(document0).getLinePushBackReader();
      ReadListener readListener0 = mock(ReadListener.class, new ViolatedAssumptionAnswer());
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(document0, readListener0);
      // Undeclared exception!
      try { 
        blastDocumentEntry0.makeNativeSequence((Sequence) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test8()  throws Throwable  {
      BlastDocumentEntry blastDocumentEntry0 = null;
      try {
        blastDocumentEntry0 = new BlastDocumentEntry((Entry) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }
}
