#!/bin/sh
echo ";; Recreating audacity.pot using .h, .cpp and .mm files"
for path in ../modules/mod-script* ../modules/mod-nyq* ../include ../src ; do find $path -name \*.h -o -name \*.cpp -o -name \*.mm ; done | LANG=c sort | \
sed -E 's/\.\.\///g' |\
xargs xgettext \
--default-domain=audacity \
--directory=.. \
--keyword=_ --keyword=XO --keyword=XC:1,2c --keyword=XXO --keyword=XXC:1,2c --keyword=XP:1,2 --keyword=XPC:1,2,4c \
--add-comments=" i18n" \
--add-location=file  \
--copyright-holder='Audacity Team' \
--package-name="audacity" \
--package-version='2.4.2' \
--msgid-bugs-address="audacity-translation@lists.sourceforge.net" \
--add-location=file -L C -o audacity.pot 
echo ";; Adding nyquist files to audacity.pot"
for path in ../plug-ins ; do find $path -name \*.ny -not -name rms.ny; done | LANG=c sort | \
sed -E 's/\.\.\///g' |\
xargs xgettext \
--default-domain=audacity \
--directory=.. \
--keyword=_ --keyword=_C:1,2c --keyword=ngettext:1,2 --keyword=ngettextc:1,2,4c \
--add-comments=" i18n" \
--add-location=file  \
--copyright-holder='Audacity Team' \
--package-name="audacity" \
--package-version='2.4.2' \
--msgid-bugs-address="audacity-translation@lists.sourceforge.net" \
--add-location=file -L Lisp -j -o audacity.pot 
echo ";; Updating the .po files - Updating Project-Id-Version"
for i in *.po; do
    sed -i '/^"Project-Id-Version:/c\"Project-Id-Version: audacity 2.4.2\\n"' $i
done
echo ";; Updating the .po files"
sed 's/.*/echo "msgmerge --lang=& &.po audacity.pot -o &.po";\
msgmerge --lang=& &.po audacity.pot -o &.po;/g' LINGUAS | bash
echo ";; Removing '#~|' (which confuse Windows version of msgcat)"
for i in *.po; do
    sed -i '/^#~|/d' $i
done
echo ""
echo ";;Translation updated"
echo ""
head -n 11 audacity.pot | tail -n 3
wc -l audacity.pot
